/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.beauty.gpufilters;

import android.opengl.GLES20;
import com.tencent.ugc.videobase.filter.TXCGPUThreeInputFilter;
import com.tencent.ugc.videobase.frame.GLTexturePool;

public class TXCGPUColorScreenFilter
extends TXCGPUThreeInputFilter {
    private int screenModeLocation = -1;
    private int screenColorLocation = -1;
    private int screenMirrorXLocation = -1;
    private int screenMirrorYLocation = -1;
    private float[] screenReplaceColor = new float[]{0.0f, 1.0f, 0.0f};
    public static final String COLORSCREEN_FILTER_FRAGMENT_SHADER = "precision mediump float;\nvarying highp vec2 textureCoordinate;\nvarying highp vec2 textureCoordinate2;\nvarying highp vec2 textureCoordinate3;\nuniform sampler2D inputImageTexture;\nuniform sampler2D inputImageTexture2;\nuniform sampler2D inputImageTexture3;\nuniform mediump vec3 screenReplaceColor; //YUV\u6570\u636e\nuniform float screenMirrorX;\nuniform float screenMirrorY;\n\nvoid main()\n{\n    highp vec4 _smooth = texture2D(inputImageTexture,textureCoordinate);\n    highp vec4 origin = texture2D(inputImageTexture2,textureCoordinate2);\n    \n    lowp float r = origin.r;\n    lowp float g = origin.g;\n    lowp float b = origin.b;\n    float Cr = 128.0 - 37.797 * r - 74.203 * g + 112.0 * b;\n    float Cb = 128.0 + 112.0 * r - 93.768 * g - 18.214 * b;\n    \n    highp vec2 screenPos = textureCoordinate3;\n    if(screenMirrorX != 0.0)screenPos.x = 1.0 - screenPos.x;\n    if(screenMirrorY != 0.0)screenPos.y = 1.0 - screenPos.y;\n    highp vec4 screen = texture2D(inputImageTexture3, screenPos);\n    float Y = 0.2989 * r + 0.5866 * g + 0.1145 * b;\n    Cr = 0.7132 * (r - Y);\n    Cb = 0.5647 * (b - Y);\n    float blendValue = 1.0 - smoothstep(0.4, 0.4 + 0.1, distance(vec2(Cr, Cb), vec2(screenReplaceColor.g, screenReplaceColor.b)));\n    vec3 diff = screen.rgb - _smooth.rgb;\n    _smooth.rgb = _smooth.rgb + blendValue * diff;\n    gl_FragColor = _smooth;\n}\n";

    TXCGPUColorScreenFilter() {
        super(COLORSCREEN_FILTER_FRAGMENT_SHADER);
    }

    @Override
    public void onInit(GLTexturePool glTexturePool) {
        super.onInit(glTexturePool);
        this.screenModeLocation = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"screenMode");
        this.screenColorLocation = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"screenReplaceColor");
        this.screenMirrorXLocation = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"screenMirrorX");
        this.screenMirrorYLocation = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"screenMirrorY");
        TXCGPUColorScreenFilter tXCGPUColorScreenFilter = this;
        tXCGPUColorScreenFilter.setScreenColor(tXCGPUColorScreenFilter.screenReplaceColor);
    }

    public void enableScreenMode(boolean enable) {
        TXCGPUColorScreenFilter tXCGPUColorScreenFilter = this;
        tXCGPUColorScreenFilter.setFloatOnDraw(tXCGPUColorScreenFilter.screenModeLocation, enable ? 1.0f : 0.0f);
    }

    public void setScreenMirrorX(boolean fFlip) {
        TXCGPUColorScreenFilter tXCGPUColorScreenFilter = this;
        tXCGPUColorScreenFilter.setFloatOnDraw(tXCGPUColorScreenFilter.screenMirrorXLocation, fFlip ? 1.0f : 0.0f);
    }

    public void setScreenMirrorY(boolean fFlip) {
        TXCGPUColorScreenFilter tXCGPUColorScreenFilter = this;
        tXCGPUColorScreenFilter.setFloatOnDraw(tXCGPUColorScreenFilter.screenMirrorYLocation, fFlip ? 1.0f : 0.0f);
    }

    public void setScreenColor(float[] colors) {
        float[] fArray = new float[3];
        float[] fArray2 = fArray;
        fArray[0] = (float)(0.2989 * (double)colors[0] + 0.5866 * (double)colors[1] + 0.1145 * (double)colors[2]);
        fArray2[1] = (float)(0.7132 * (double)(colors[0] - fArray2[0]));
        fArray2[2] = (float)(0.5647 * (double)(colors[2] - fArray2[0]));
        TXCGPUColorScreenFilter tXCGPUColorScreenFilter = this;
        tXCGPUColorScreenFilter.setFloatVec3OnDraw(tXCGPUColorScreenFilter.screenColorLocation, fArray2);
    }
}

