/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.beauty.decoder;

import android.content.res.AssetFileDescriptor;
import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.ugc.beauty.decoder.ExtractorAdvancer;
import com.tencent.ugc.beauty.decoder.SetupException;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Extractor {
    private static final String TAG = "Extractor";
    private final boolean mIsVideo;
    private final ExtractorAdvancer mAdvancer;
    private final String mFileName;
    private AssetFileDescriptor mFileDescripter;
    private MediaExtractor mMediaExtractor;
    private MediaFormat mMediaFormat;
    private int mTrackIndex;

    public Extractor(boolean isVideo, String filename, ExtractorAdvancer advancer) {
        this.mIsVideo = isVideo;
        this.mAdvancer = advancer;
        this.mFileName = filename;
        this.mFileDescripter = null;
    }

    public Extractor(boolean isVideo, AssetFileDescriptor fileDescriptor, ExtractorAdvancer advancer) {
        this.mIsVideo = isVideo;
        this.mFileDescripter = fileDescriptor;
        this.mAdvancer = advancer;
        this.mFileName = null;
    }

    public void setup() throws SetupException {
        this.initMediaExtractor();
        this.mAdvancer.updateExtractor(this.mMediaExtractor);
    }

    public void restart() throws SetupException {
        this.releaseMediaExtractor();
        this.initMediaExtractor();
        this.mAdvancer.updateExtractor(this.mMediaExtractor);
    }

    public MediaCodec.BufferInfo readSampleData(ByteBuffer buffer) {
        MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
        this.mAdvancer.readSampleData(bufferInfo, buffer, 0);
        if (bufferInfo.size < 0) {
            bufferInfo.size = 0;
            bufferInfo.flags |= 4;
            LiteavLog.i(TAG, "[%s] meet end of stream", this.mIsVideo ? "video" : "audio");
        }
        this.mAdvancer.advance();
        return bufferInfo;
    }

    public MediaFormat getMediaFormat() {
        return this.mMediaFormat;
    }

    public void release() {
        this.releaseMediaExtractor();
        if (this.mFileDescripter != null) {
            try {
                this.mFileDescripter.close();
            }
            catch (IOException iOException) {
                LiteavLog.e(TAG, "close file descriptor failed.", iOException);
            }
            this.mFileDescripter = null;
        }
    }

    public int getTraceIndex() {
        return this.mTrackIndex;
    }

    private void initMediaExtractor() throws SetupException {
        this.releaseMediaExtractor();
        try {
            this.mMediaExtractor = new MediaExtractor();
            if (this.mFileDescripter != null) {
                this.mMediaExtractor.setDataSource(this.mFileDescripter.getFileDescriptor(), this.mFileDescripter.getStartOffset(), this.mFileDescripter.getLength());
            } else {
                this.mMediaExtractor.setDataSource(this.mFileName);
            }
            this.mTrackIndex = this.selectTrack(this.mMediaExtractor);
            if (this.mTrackIndex < 0) {
                throw new SetupException("No wanted track found");
            }
            this.mMediaExtractor.selectTrack(this.mTrackIndex);
            this.mMediaFormat = this.mMediaExtractor.getTrackFormat(this.mTrackIndex);
            return;
        }
        catch (IOException iOException) {
            throw new SetupException("updateExtractor extractor failed.", iOException);
        }
    }

    private void releaseMediaExtractor() {
        if (this.mMediaExtractor != null) {
            this.mMediaExtractor.release();
            this.mMediaExtractor = null;
        }
    }

    private boolean isWantedMime(String mime) {
        if (this.mIsVideo) {
            return mime.startsWith("video/");
        }
        return mime.startsWith("audio/");
    }

    private int selectTrack(MediaExtractor extractor) {
        int n2 = extractor.getTrackCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = extractor.getTrackFormat(i2).getString("mime");
            if (!this.isWantedMime(string)) continue;
            return i2;
        }
        return -1;
    }
}

