/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.ugc.TXVideoEditConstants;
import com.tencent.ugc.UGCCombineFrameFilter;
import com.tencent.ugc.UGCTransitionRules;
import com.tencent.ugc.videobase.frame.GLTexture;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import com.tencent.ugc.videobase.frame.PixelFrame;
import java.util.ArrayList;
import java.util.List;

public class UGCTransitionProcessor {
    private final String TAG = "UGCTransitionProcessor";
    private final UGCCombineFrameFilter mCombineFrameFilter;
    private final int mOutputPixelWidth;
    private final int mOutputPixelHeight;

    public UGCTransitionProcessor(int outputPixelWidth, int outputPixelHeight, GLTexturePool glTexturePool) {
        LiteavLog.i("UGCTransitionProcessor", "UGCTransitionProcessor pixelWidth = " + outputPixelWidth + " pixelHeight = " + outputPixelHeight);
        this.mOutputPixelWidth = outputPixelWidth;
        this.mOutputPixelHeight = outputPixelHeight;
        this.mCombineFrameFilter = new UGCCombineFrameFilter(glTexturePool);
    }

    public void release() {
        this.mCombineFrameFilter.release();
    }

    public PixelFrame processFrame(List<PixelFrame> frameList, int transitionType) {
        if (frameList == null || frameList.size() == 0) {
            LiteavLog.e("UGCTransitionProcessor", "frameList is empty");
            return null;
        }
        this.Retain(frameList);
        ArrayList<TXCCombineFrame> arrayList = new ArrayList<TXCCombineFrame>();
        TXCCombineFrame tXCCombineFrame = new TXCCombineFrame();
        new TXCCombineFrame().drawInputFrame = frameList.get(0);
        tXCCombineFrame.drawRect = this.getFirstDrawRect(tXCCombineFrame.drawInputFrame.getWidth(), tXCCombineFrame.drawInputFrame.getHeight());
        arrayList.add(tXCCombineFrame);
        if (frameList.size() > 1) {
            tXCCombineFrame = new TXCCombineFrame();
            new TXCCombineFrame().drawInputFrame = frameList.get(1);
            tXCCombineFrame.drawRect = this.getSecondDrawRect(tXCCombineFrame.drawInputFrame.getWidth(), tXCCombineFrame.drawInputFrame.getHeight(), transitionType);
            arrayList.add(tXCCombineFrame);
        }
        long l2 = frameList.get(0).getTimestamp();
        GLTexture gLTexture = this.combineFramesWithTransitionType(arrayList, l2, transitionType);
        this.releaseFrameList(arrayList);
        if (gLTexture == null) {
            return null;
        }
        PixelFrame pixelFrame = gLTexture.wrap(frameList.get(0).getGLContext());
        pixelFrame.setTimestamp(l2);
        gLTexture.release();
        return pixelFrame;
    }

    private void Retain(List<PixelFrame> frameList) {
        for (PixelFrame pixelFrame : frameList) {
            if (pixelFrame == null) continue;
            pixelFrame.retain();
        }
    }

    private void releaseFrameList(List<TXCCombineFrame> combineFrameList) {
        for (TXCCombineFrame tXCCombineFrame : combineFrameList) {
            if (tXCCombineFrame.drawInputFrame == null) continue;
            tXCCombineFrame.drawInputFrame.release();
        }
    }

    private GLTexture combineFramesWithTransitionType(List<TXCCombineFrame> combineFrameList, long pts, int transitionType) {
        switch (transitionType) {
            case 1: {
                return this.processTwoPicLeftRightCombine(combineFrameList, pts);
            }
            case 2: {
                return this.processTwoPicUpDownCombine(combineFrameList, pts);
            }
            case 3: {
                return this.processTwoPicRotation(combineFrameList, pts);
            }
            case 6: {
                return this.processTwoPicFaceInOut(combineFrameList, pts);
            }
            case 4: 
            case 5: {
                return this.processTwoPicZoom(combineFrameList, pts, transitionType);
            }
        }
        return null;
    }

    private TXVideoEditConstants.TXAbsoluteRect getFirstDrawRect(int width, int height) {
        TXVideoEditConstants.TXAbsoluteRect tXAbsoluteRect = new TXVideoEditConstants.TXAbsoluteRect();
        new TXVideoEditConstants.TXAbsoluteRect().width = this.mOutputPixelWidth;
        tXAbsoluteRect.height = this.mOutputPixelHeight;
        if ((float)width / (float)height >= (float)this.mOutputPixelWidth / (float)this.mOutputPixelHeight) {
            float f2 = (float)(this.mOutputPixelWidth * height) / (float)width;
            tXAbsoluteRect.x = 0;
            tXAbsoluteRect.y = (int)((float)this.mOutputPixelHeight - f2) / 2;
            tXAbsoluteRect.height = (int)f2;
        } else {
            float f3 = (float)(this.mOutputPixelHeight * width) / (float)height;
            tXAbsoluteRect.x = (int)((float)this.mOutputPixelWidth - f3) / 2;
            tXAbsoluteRect.y = 0;
            tXAbsoluteRect.width = (int)f3;
        }
        return tXAbsoluteRect;
    }

    private TXVideoEditConstants.TXAbsoluteRect getSecondDrawRect(int width, int height, int transitionType) {
        TXVideoEditConstants.TXAbsoluteRect tXAbsoluteRect = new TXVideoEditConstants.TXAbsoluteRect();
        new TXVideoEditConstants.TXAbsoluteRect().width = this.mOutputPixelWidth;
        tXAbsoluteRect.height = this.mOutputPixelHeight;
        if ((float)width / (float)height >= (float)this.mOutputPixelWidth / (float)this.mOutputPixelHeight) {
            float f2 = (float)(this.mOutputPixelWidth * height) / (float)width;
            tXAbsoluteRect.x = transitionType == 1 ? this.mOutputPixelWidth : 0;
            tXAbsoluteRect.y = transitionType == 2 ? this.mOutputPixelHeight + (int)((float)this.mOutputPixelHeight - f2) / 2 : (int)((float)this.mOutputPixelHeight - f2) / 2;
            tXAbsoluteRect.height = (int)f2;
        } else {
            float f3 = (float)(this.mOutputPixelHeight * width) / (float)height;
            tXAbsoluteRect.x = transitionType == 1 ? this.mOutputPixelWidth + (int)((float)this.mOutputPixelWidth - f3) / 2 : (int)((float)this.mOutputPixelWidth - f3) / 2;
            tXAbsoluteRect.y = transitionType == 2 ? this.mOutputPixelHeight : 0;
            tXAbsoluteRect.width = (int)f3;
        }
        return tXAbsoluteRect;
    }

    private GLTexture processTwoPicLeftRightCombine(List<TXCCombineFrame> combineFrameList, long pts) {
        int n2 = (int)(UGCTransitionProcessor.getCropOffset(1, pts) * (float)this.mOutputPixelWidth);
        TXVideoEditConstants.TXAbsoluteRect tXAbsoluteRect = new TXVideoEditConstants.TXAbsoluteRect();
        new TXVideoEditConstants.TXAbsoluteRect().x = n2;
        tXAbsoluteRect.width = this.mOutputPixelWidth;
        tXAbsoluteRect.height = this.mOutputPixelHeight;
        this.mCombineFrameFilter.setCanvasSize(this.mOutputPixelWidth * 2, this.mOutputPixelHeight);
        this.mCombineFrameFilter.setCropRect(tXAbsoluteRect);
        return this.mCombineFrameFilter.combineFrame(combineFrameList);
    }

    private GLTexture processTwoPicUpDownCombine(List<TXCCombineFrame> combineFrameList, long pts) {
        int n2 = (int)(UGCTransitionProcessor.getCropOffset(2, pts) * (float)this.mOutputPixelHeight);
        TXVideoEditConstants.TXAbsoluteRect tXAbsoluteRect = new TXVideoEditConstants.TXAbsoluteRect();
        new TXVideoEditConstants.TXAbsoluteRect().y = n2;
        tXAbsoluteRect.width = this.mOutputPixelWidth;
        tXAbsoluteRect.height = this.mOutputPixelHeight;
        this.mCombineFrameFilter.setCanvasSize(this.mOutputPixelWidth, this.mOutputPixelHeight * 2);
        this.mCombineFrameFilter.setCropRect(tXAbsoluteRect);
        return this.mCombineFrameFilter.combineFrame(combineFrameList);
    }

    private GLTexture processTwoPicZoom(List<TXCCombineFrame> combineFrameList, long pts, int transitionType) {
        float f2 = UGCTransitionProcessor.getScale(transitionType, pts);
        float f3 = UGCTransitionProcessor.getAlpha(transitionType, pts);
        TXCCombineFrame tXCCombineFrame = combineFrameList.get(0);
        combineFrameList.get(0).transformParams = new TransformParams();
        tXCCombineFrame.transformParams.scale = f2;
        tXCCombineFrame.transformParams.alpha = f3;
        if (combineFrameList.size() > 1) {
            tXCCombineFrame = combineFrameList.get(1);
            combineFrameList.get(1).transformParams = new TransformParams();
            if (transitionType == 5) {
                tXCCombineFrame.transformParams.scale = 1.1f;
            }
            tXCCombineFrame.transformParams.alpha = 1.0f - f3;
        }
        this.mCombineFrameFilter.setCanvasSize(this.mOutputPixelWidth, this.mOutputPixelHeight);
        this.mCombineFrameFilter.setCropRect(null);
        return this.mCombineFrameFilter.combineFrame(combineFrameList);
    }

    private GLTexture processTwoPicFaceInOut(List<TXCCombineFrame> combineFrameList, long pts) {
        float f2 = UGCTransitionProcessor.getAlpha(6, pts);
        TXCCombineFrame tXCCombineFrame = combineFrameList.get(0);
        combineFrameList.get(0).transformParams = new TransformParams();
        tXCCombineFrame.transformParams.alpha = f2;
        if (combineFrameList.size() > 1) {
            tXCCombineFrame = combineFrameList.get(1);
            combineFrameList.get(1).transformParams = new TransformParams();
            tXCCombineFrame.transformParams.alpha = 1.0f - f2;
        }
        this.mCombineFrameFilter.setCanvasSize(this.mOutputPixelWidth, this.mOutputPixelHeight);
        this.mCombineFrameFilter.setCropRect(null);
        return this.mCombineFrameFilter.combineFrame(combineFrameList);
    }

    private GLTexture processTwoPicRotation(List<TXCCombineFrame> combineFrameList, long pts) {
        int n2 = UGCTransitionProcessor.getRotation(3, pts);
        float f2 = UGCTransitionProcessor.getScale(3, pts);
        TXCCombineFrame tXCCombineFrame = combineFrameList.get(0);
        combineFrameList.get(0).transformParams = new TransformParams();
        tXCCombineFrame.transformParams.rotate = n2;
        tXCCombineFrame.transformParams.scale = f2;
        tXCCombineFrame.transformParams.isBackgroundTransparent = true;
        TXCCombineFrame tXCCombineFrame2 = null;
        if (combineFrameList.size() > 1) {
            tXCCombineFrame2 = combineFrameList.get(1);
            combineFrameList.get(1).transformParams = new TransformParams();
        }
        if (n2 != 0) {
            tXCCombineFrame.transformParams.isBackgroundTransparent = true;
            if (tXCCombineFrame2 != null) {
                tXCCombineFrame2.transformParams.isBackgroundTransparent = true;
            }
        } else {
            tXCCombineFrame.transformParams.alpha = 1.0f;
            if (tXCCombineFrame2 != null) {
                tXCCombineFrame2.transformParams.alpha = 0.0f;
            }
        }
        this.mCombineFrameFilter.setCanvasSize(this.mOutputPixelWidth, this.mOutputPixelHeight);
        this.mCombineFrameFilter.setCropRect(null);
        return this.mCombineFrameFilter.combineFrame(combineFrameList);
    }

    private static float getCropOffset(int transitionType, long ptsMs) {
        long l2 = UGCTransitionRules.getStayDurationMs(transitionType);
        long l3 = UGCTransitionRules.getMotionDurationMs(transitionType);
        long l4 = l2 + l3;
        long l5 = ptsMs;
        long l6 = l5 - l5 / l4 * l4;
        float f2 = l6 >= 0L && l6 <= l2 ? 0.0f : (float)(l6 - l2) / (float)l3;
        return f2;
    }

    private static float getScale(int transitionType, long ptsMs) {
        float f2 = 1.0f;
        long l2 = UGCTransitionRules.getStayDurationMs(transitionType);
        long l3 = UGCTransitionRules.getMotionDurationMs(transitionType);
        long l4 = l2 + l3;
        long l5 = ptsMs;
        long l6 = l5 - l5 / l4 * l4;
        switch (transitionType) {
            case 4: {
                if (l6 <= l2 || l6 >= l4) break;
                f2 = 1.0f + 0.1f * (float)(l6 - l2) / (float)l3;
                break;
            }
            case 5: {
                if (l6 >= 0L && l6 <= l2) {
                    f2 = 1.1f;
                    break;
                }
                if (l6 <= l2 || l6 > l4) break;
                f2 = 1.1f - 0.1f * (float)(l6 - l2) / (float)l3;
                break;
            }
            case 3: {
                if (l6 <= l2 || l6 > l4) break;
                f2 = 1.0f - (float)(l6 - l2) / (float)l3;
            }
        }
        return f2;
    }

    private static float getAlpha(int transitionType, long ptsMs) {
        float f2 = 1.0f;
        long l2 = UGCTransitionRules.getStayDurationMs(transitionType);
        long l3 = UGCTransitionRules.getMotionDurationMs(transitionType);
        long l4 = l2 + l3;
        long l5 = ptsMs;
        long l6 = l5 - l5 / l4 * l4;
        switch (transitionType) {
            case 6: {
                if (l6 <= l2 || l6 > l4) break;
                f2 = 1.0f - (float)(l6 - l2) / (float)l3;
                break;
            }
            case 4: 
            case 5: {
                float f3 = (float)l2 + (float)l3 * 0.8f;
                if (!((float)l6 > f3) || l6 > l4) break;
                f2 = 1.0f - ((float)l6 - f3) / ((float)l3 * 0.2f);
            }
        }
        return f2;
    }

    private static int getRotation(int transitionType, long ptsMs) {
        if (transitionType != 3) {
            return 0;
        }
        int n2 = 0;
        long l2 = UGCTransitionRules.getStayDurationMs(transitionType);
        long l3 = UGCTransitionRules.getMotionDurationMs(transitionType);
        long l4 = l2 + l3;
        long l5 = ptsMs;
        long l6 = l5 - l5 / l4 * l4;
        if (l6 > l2 && l6 <= l4) {
            n2 = (int)((float)(l6 - l2) / (float)l3 * 360.0f);
        }
        return n2;
    }

    public static class TXCCombineFrame {
        public PixelFrame drawInputFrame;
        public TransformParams transformParams;
        public TXVideoEditConstants.TXAbsoluteRect drawRect;
    }

    public static class TransformParams {
        public float scale = 1.0f;
        public int rotate = 0;
        public float alpha = 1.0f;
        public boolean isBackgroundTransparent = false;
    }
}

