/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import android.graphics.Bitmap;
import android.os.HandlerThread;
import com.tencent.liteav.base.b.b;
import com.tencent.liteav.base.util.CommonUtil;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.ugc.TXVideoEditer;
import com.tencent.ugc.UGCMediaListSource;
import com.tencent.ugc.gh;
import com.tencent.ugc.gi;
import com.tencent.ugc.gj;
import com.tencent.ugc.gk;
import com.tencent.ugc.gl;
import com.tencent.ugc.gm;
import com.tencent.ugc.gn;
import com.tencent.ugc.videobase.egl.EGLCore;
import com.tencent.ugc.videobase.egl.EGLException;
import com.tencent.ugc.videobase.frame.GLFrameBuffer;
import com.tencent.ugc.videobase.frame.GLTexture;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import com.tencent.ugc.videobase.frame.PixelFrame;
import com.tencent.ugc.videobase.frame.PixelFrameRenderer;
import com.tencent.ugc.videobase.utils.CollectionUtils;
import com.tencent.ugc.videobase.utils.OpenGlUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class UGCThumbnailGenerator {
    private final b mThrottlers = new b();
    private final UGCMediaListSource mMediaListSource;
    private String mTag = "ThumbnailGenerator_";
    private UGCThumbnailGenerateParams mThumbnailGenerateInfo;
    private TXVideoEditer.TXThumbnailListener mThumbnailListener;
    private boolean mIsInitialized;
    private CustomHandler mHandler;
    private int mGenerateIndex = 0;
    private EGLCore mEGLCore = null;
    private GLTexturePool mGLTexturePool;
    private PixelFrameRenderer mPixelFrameRender;
    private final GLFrameBuffer mGLFrameBuffer = new GLFrameBuffer();
    private Object mSharedContext = null;
    private String mSourcePath;

    public UGCThumbnailGenerator() {
        this.mMediaListSource = new UGCMediaListSource();
        this.mMediaListSource.setNeedAudioSource(false);
        this.mMediaListSource.setMaxFrameSize(1);
        this.mTag = this.mTag + this.hashCode();
    }

    private void initOpenGLComponents(Object sharedContext, int width, int height) {
        LiteavLog.i(this.mThrottlers.a("initGL"), this.mTag, "initOpenGLComponents ".concat(String.valueOf(sharedContext)), new Object[0]);
        if (this.mEGLCore != null) {
            return;
        }
        this.mEGLCore = new EGLCore();
        try {
            this.mEGLCore.initialize(sharedContext, null, 128, 128);
        }
        catch (EGLException eGLException) {
            this.mEGLCore = null;
            LiteavLog.e(this.mThrottlers.a("initGLError"), this.mTag, "EGLCore create failed.", eGLException);
            return;
        }
        this.mGLTexturePool = new GLTexturePool();
        this.mPixelFrameRender = new PixelFrameRenderer(width, height);
        this.mGLFrameBuffer.initialize();
        this.mSharedContext = sharedContext;
    }

    private void uninitOpenGLComponents() {
        LiteavLog.i(this.mThrottlers.a("uninitGL"), this.mTag, "uninitOpenGLComponents", new Object[0]);
        if (EGLCore.makeCurrent(this.mEGLCore)) {
            if (this.mGLTexturePool != null) {
                this.mGLTexturePool.destroy();
            }
            if (this.mPixelFrameRender != null) {
                this.mPixelFrameRender.uninitialize();
            }
            this.mGLFrameBuffer.uninitialize();
        }
        this.mGLTexturePool = null;
        this.mPixelFrameRender = null;
        EGLCore.destroy(this.mEGLCore);
        this.mEGLCore = null;
    }

    private boolean runOnThumbnailThread(Runnable task) {
        CustomHandler customHandler = this.mHandler;
        if (!this.mIsInitialized || customHandler == null) {
            return false;
        }
        return customHandler.runOrPost(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        LiteavLog.i(this.mTag, "initialize");
        UGCThumbnailGenerator uGCThumbnailGenerator = this;
        synchronized (uGCThumbnailGenerator) {
            if (this.mIsInitialized) {
                LiteavLog.w(this.mTag, "already initialized.");
                return;
            }
            HandlerThread handlerThread = new HandlerThread("thumbnailG_" + this.hashCode());
            handlerThread.start();
            this.mHandler = new CustomHandler(handlerThread.getLooper());
            this.mIsInitialized = true;
        }
        UGCThumbnailGenerator uGCThumbnailGenerator2 = this;
        UGCMediaListSource uGCMediaListSource = uGCThumbnailGenerator2.mMediaListSource;
        uGCMediaListSource.getClass();
        uGCThumbnailGenerator2.runOnThumbnailThread(gh.a(uGCMediaListSource));
    }

    public void uninitialize() {
        UGCThumbnailGenerator uGCThumbnailGenerator = this;
        uGCThumbnailGenerator.runOnThumbnailThread(gi.a(uGCThumbnailGenerator));
    }

    public void setVideoSourceList(List<String> sourceList) {
        UGCThumbnailGenerator uGCThumbnailGenerator = this;
        uGCThumbnailGenerator.runOnThumbnailThread(gj.a(uGCThumbnailGenerator, sourceList));
    }

    public void setVideoSourceRange(long startTime, long endTime) {
        UGCThumbnailGenerator uGCThumbnailGenerator = this;
        uGCThumbnailGenerator.runOnThumbnailThread(gk.a(uGCThumbnailGenerator, startTime, endTime));
    }

    public void start(UGCThumbnailGenerateParams thumbnailInfo, TXVideoEditer.TXThumbnailListener listener) {
        UGCThumbnailGenerator uGCThumbnailGenerator = this;
        uGCThumbnailGenerator.runOnThumbnailThread(gl.a(uGCThumbnailGenerator, thumbnailInfo, listener));
    }

    private void getNextThumbnail() {
        if (this.mThumbnailGenerateInfo == null || this.mThumbnailGenerateInfo.thumbnailPtsList == null || this.mThumbnailGenerateInfo.thumbnailPtsList.size() <= this.mGenerateIndex) {
            LiteavLog.i(this.mTag, "generate runnable: mThumbnailGenerateInfo= " + this.mThumbnailGenerateInfo + " mGenerateIndex = " + this.mGenerateIndex);
            return;
        }
        List<Long> list = this.mThumbnailGenerateInfo.thumbnailPtsList;
        long l2 = list.get(this.mGenerateIndex++);
        System.currentTimeMillis();
        if (this.mThumbnailGenerateInfo.fast) {
            this.mMediaListSource.impreciseSeekTo(l2);
        } else {
            this.mMediaListSource.seekTo(l2);
        }
        List<PixelFrame> list2 = this.mMediaListSource.readNextVideoFrame();
        if (CollectionUtils.isEmpty(list2) || list2.get(0) == null) {
            LiteavLog.i(this.mTag, "readNextVideoFrame return null.");
            return;
        }
        PixelFrame pixelFrame = list2.get(0);
        if (this.mEGLCore == null || !CommonUtil.equals(this.mSharedContext, pixelFrame.getGLContext())) {
            this.uninitOpenGLComponents();
            this.initOpenGLComponents(pixelFrame.getGLContext(), this.mThumbnailGenerateInfo.width, this.mThumbnailGenerateInfo.height);
        }
        if (this.mEGLCore == null || this.mGLTexturePool == null) {
            LiteavLog.e(this.mThrottlers.a("NoEGLCore"), this.mTag, "EGLCore or GLTexturePool is null", new Object[0]);
            pixelFrame.release();
            return;
        }
        GLTexture gLTexture = this.mGLTexturePool.obtain(this.mThumbnailGenerateInfo.width, this.mThumbnailGenerateInfo.height);
        gLTexture.setColorFormat(pixelFrame.getColorRange(), pixelFrame.getColorSpace());
        this.mPixelFrameRender.renderFrame(pixelFrame, GLConstants.GLScaleType.a, gLTexture);
        Bitmap bitmap = this.getBitmapFromTexture(gLTexture);
        if (this.mThumbnailListener != null) {
            this.mThumbnailListener.onThumbnail(this.mGenerateIndex, l2, bitmap);
        }
        gLTexture.release();
        pixelFrame.release();
        if (list.size() > this.mGenerateIndex) {
            this.mHandler.post(gm.a(this));
        }
    }

    public void stop() {
        UGCThumbnailGenerator uGCThumbnailGenerator = this;
        uGCThumbnailGenerator.runOnThumbnailThread(gn.a(uGCThumbnailGenerator));
    }

    private Bitmap getBitmapFromTexture(GLTexture glTexture) {
        this.mGLFrameBuffer.attachTexture(glTexture.getId());
        this.mGLFrameBuffer.bindToContext();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.mThumbnailGenerateInfo.width * this.mThumbnailGenerateInfo.height * 4).order(ByteOrder.nativeOrder());
        byteBuffer.position(0);
        OpenGlUtils.readPixels(0, 0, this.mThumbnailGenerateInfo.width, this.mThumbnailGenerateInfo.height, byteBuffer);
        byteBuffer.position(0);
        Bitmap bitmap = Bitmap.createBitmap((int)this.mThumbnailGenerateInfo.width, (int)this.mThumbnailGenerateInfo.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.copyPixelsFromBuffer((Buffer)byteBuffer);
        this.mGLFrameBuffer.unbindFromContext();
        this.mGLFrameBuffer.detachTexture();
        return bitmap;
    }

    public static List<Long> calculateThumbnailList(int count, long startTimeMs, long endTimeMs, long duration) {
        if (duration < 0L || count == 0) {
            LiteavLog.w("calculateThumbnailList", "param error: duration= " + duration + ",count= " + count);
            return null;
        }
        LiteavLog.i("calculateThumbnailList", "calculateThumbnailList startTimeMs : " + startTimeMs + ", endTimeMs : " + endTimeMs + "  duration:" + duration);
        endTimeMs = Math.min(endTimeMs, duration);
        ArrayList<Long> arrayList = new ArrayList<Long>();
        long l2 = endTimeMs - startTimeMs > 0L ? endTimeMs - startTimeMs : duration;
        long l3 = l2 / (long)count;
        for (int i2 = 0; i2 < count; ++i2) {
            long l4 = l3 * (long)i2 + startTimeMs;
            if (endTimeMs > 0L) {
                l4 = Math.min(l4, endTimeMs);
            }
            arrayList.add(l4);
        }
        return arrayList;
    }

    static /* synthetic */ void lambda$stop$4(UGCThumbnailGenerator this_) {
        LiteavLog.i(this_.mTag, "stop");
        this_.mThumbnailGenerateInfo = null;
        this_.mThumbnailListener = null;
    }

    static /* synthetic */ void lambda$start$3(UGCThumbnailGenerator this_, UGCThumbnailGenerateParams thumbnailInfo, TXVideoEditer.TXThumbnailListener listener) {
        if (thumbnailInfo == null || CollectionUtils.isEmpty(thumbnailInfo.thumbnailPtsList)) {
            LiteavLog.w(this_.mTag, "start param error!");
            return;
        }
        LiteavLog.i(this_.mTag, "start width = " + thumbnailInfo.width + " height = " + thumbnailInfo.height);
        this_.mGenerateIndex = 0;
        this_.mThumbnailGenerateInfo = thumbnailInfo;
        this_.mThumbnailListener = listener;
        this_.getNextThumbnail();
    }

    static /* synthetic */ void lambda$setVideoSourceRange$2(UGCThumbnailGenerator this_, long startTime, long endTime) {
        this_.mMediaListSource.setVideoSourceRange(startTime, endTime);
    }

    static /* synthetic */ void lambda$setVideoSourceList$1(UGCThumbnailGenerator this_, List sourceList) {
        for (String string : sourceList) {
            LiteavLog.i(this_.mTag, "setVideoSourceList ".concat(String.valueOf(string)));
        }
        this_.mMediaListSource.setVideoSources(sourceList);
        this_.mSourcePath = (String)sourceList.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void lambda$uninitialize$0(UGCThumbnailGenerator this_) {
        CustomHandler customHandler;
        LiteavLog.i(this_.mTag, "unInitialize");
        this_.uninitOpenGLComponents();
        UGCThumbnailGenerator uGCThumbnailGenerator = this_;
        synchronized (uGCThumbnailGenerator) {
            if (!this_.mIsInitialized) {
                LiteavLog.w(this_.mTag, "already uninitialize.");
                return;
            }
            customHandler = this_.mHandler;
            this_.mHandler = null;
            this_.mIsInitialized = false;
        }
        this_.mMediaListSource.uninitialize();
        if (customHandler != null) {
            customHandler.quitLooper();
        }
    }

    static /* synthetic */ void access$lambda$0(UGCThumbnailGenerator uGCThumbnailGenerator) {
        uGCThumbnailGenerator.getNextThumbnail();
    }

    public static class UGCThumbnailGenerateParams {
        List<Long> thumbnailPtsList;
        int width;
        int height;
        boolean fast;
        int thumbnailCount;
    }
}

