/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import android.opengl.GLES20;
import com.tencent.liteav.base.b.b;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.h;
import com.tencent.liteav.base.util.l;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.ugc.Clip;
import com.tencent.ugc.GlobalContextManager;
import com.tencent.ugc.TXVideoEditConstants;
import com.tencent.ugc.UGCFrameQueue;
import com.tencent.ugc.UGCMediaListSource;
import com.tencent.ugc.UGCPixelFrameProvider;
import com.tencent.ugc.VideoDemuxer;
import com.tencent.ugc.VideoDemuxerFFmpeg;
import com.tencent.ugc.VideoDemuxerSystem;
import com.tencent.ugc.decoder.UGCVideoDecodeController;
import com.tencent.ugc.decoder.UGCVideoDecodeControllerListener;
import com.tencent.ugc.fp;
import com.tencent.ugc.fq;
import com.tencent.ugc.fr;
import com.tencent.ugc.fs;
import com.tencent.ugc.ft;
import com.tencent.ugc.fu;
import com.tencent.ugc.fv;
import com.tencent.ugc.fw;
import com.tencent.ugc.fx;
import com.tencent.ugc.fy;
import com.tencent.ugc.fz;
import com.tencent.ugc.ga;
import com.tencent.ugc.gb;
import com.tencent.ugc.gc;
import com.tencent.ugc.gd;
import com.tencent.ugc.ge;
import com.tencent.ugc.gf;
import com.tencent.ugc.gg;
import com.tencent.ugc.videobase.common.EncodedVideoFrame;
import com.tencent.ugc.videobase.egl.EGLCore;
import com.tencent.ugc.videobase.egl.EGLException;
import com.tencent.ugc.videobase.frame.GLTexture;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import com.tencent.ugc.videobase.frame.PixelFrame;
import com.tencent.ugc.videobase.frame.PixelFrameRenderer;
import com.tencent.ugc.videobase.utils.OpenGlUtils;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class UGCSingleFilePixelFrameProvider
implements UGCPixelFrameProvider {
    private static final int REVERSE_STEP_TIME = 500;
    private static final int DELAY_TIME_OF_TRY_DECODE = 10;
    private final String mTag = "UGCSingleFilePixelFrameProvider_" + this.hashCode();
    private final CustomHandler mWorkHandler;
    private final Clip mClip;
    private final UGCFrameQueue<List<PixelFrame>> mPixFrameQueue;
    private final Deque<PixelFrame> mPixFrameCacheForReverse;
    private final b mThrottlers = new b();
    private UGCVideoDecodeController mVideoDecodeController;
    private VideoDemuxer mDemuxer;
    private boolean mIsAbandoningDecodingFrame = false;
    private long mSeekingTimeMs = -1L;
    private boolean mIsInPreciseSeeking = true;
    private boolean mHasReadEOF = false;
    private boolean mIsDecodeCompleted = false;
    private boolean mIsFrameSendingDecoder = false;
    private int mMaxFrameCount = 3;
    private boolean mIsReverse = false;
    private long mReversePlayCurrentPts;
    private int mFrameCacheCapacityForReverse = 0;
    private EGLCore mEGLCore;
    private PixelFrameRenderer mPixelFrameRenderer;
    private GLTexturePool mGLTexturePool;
    private int mVideoWidth = 0;
    private int mVideoHeight = 0;
    private l mVideoRotation = l.a;
    private long mPlayEndPts = Long.MAX_VALUE;
    private final UGCVideoDecodeControllerListener mUGCDecodeControllerListener = new UGCVideoDecodeControllerListener(){

        @Override
        public final void onFrameDecoded(PixelFrame pixelFrame) {
            if (pixelFrame == null) {
                return;
            }
            pixelFrame.retain();
            UGCSingleFilePixelFrameProvider.this.mWorkHandler.runOrPost(ga.a(this, pixelFrame));
        }

        @Override
        public final void onFrameEnqueuedToDecoder() {
            UGCSingleFilePixelFrameProvider.this.mWorkHandler.runOrPost(gb.a(this));
        }

        @Override
        public final void onDecodeCompleted() {
            UGCSingleFilePixelFrameProvider.this.mWorkHandler.runOrPost(gc.a(this));
        }

        @Override
        public final void onAbandonDecodingFramesCompleted() {
            LiteavLog.i(UGCSingleFilePixelFrameProvider.this.mTag, "onAbandonDecodingFramesCompleted");
            UGCSingleFilePixelFrameProvider.this.mWorkHandler.runOrPost(gd.a(this));
        }

        @Override
        public final void onRequestSeekToLastKeyFrame(long pts) {
            LiteavLog.i(UGCSingleFilePixelFrameProvider.this.mTag, "onRequestSeekToLastKeyFrame pts = ".concat(String.valueOf(pts)));
            UGCSingleFilePixelFrameProvider.this.mWorkHandler.runOrPost(ge.a(this, pts));
        }

        @Override
        public final void onDecodeFailed() {
            LiteavLog.i(UGCSingleFilePixelFrameProvider.this.mTag, "on decode fail");
            UGCSingleFilePixelFrameProvider.this.mWorkHandler.runOrPost(gf.a(this));
        }

        static /* synthetic */ void a(1 var0) {
            if (var0.UGCSingleFilePixelFrameProvider.this.mVideoDecodeController == null) {
                return;
            }
            var0.UGCSingleFilePixelFrameProvider.this.mPixFrameQueue.queue(UGCPixelFrameProvider.END_OF_STREAM);
        }

        static /* synthetic */ void a(1 var0, long l2) {
            var0.UGCSingleFilePixelFrameProvider.this.seekToInFileTime(l2, false);
        }

        static /* synthetic */ void b(1 var0) {
            if (var0.UGCSingleFilePixelFrameProvider.this.mVideoDecodeController == null) {
                return;
            }
            var0.UGCSingleFilePixelFrameProvider.this.mIsAbandoningDecodingFrame = false;
            var0.UGCSingleFilePixelFrameProvider.this.decodeInternal();
        }

        static /* synthetic */ void c(1 var0) {
            var0.UGCSingleFilePixelFrameProvider.this.onDecodeCompletedInternal();
        }

        static /* synthetic */ void d(1 var0) {
            var0.UGCSingleFilePixelFrameProvider.this.decodeInternal();
        }

        static /* synthetic */ void a(1 var0, PixelFrame pixelFrame) {
            var0.UGCSingleFilePixelFrameProvider.this.onDecodeFrameInternal(pixelFrame);
        }
    };
    private final UGCFrameQueue.UGCFrameQueueListener mUGCFrameQueueListener = new UGCFrameQueue.UGCFrameQueueListener(){

        @Override
        public final void onFrameDequeued() {
            UGCSingleFilePixelFrameProvider.this.mWorkHandler.runOrPost(gg.a(this));
        }

        static /* synthetic */ void a(2 var0) {
            if (!var0.UGCSingleFilePixelFrameProvider.this.mIsFrameSendingDecoder) {
                var0.UGCSingleFilePixelFrameProvider.this.decodeInternal();
            }
        }
    };

    public UGCSingleFilePixelFrameProvider(Clip clip, CustomHandler handler) {
        this.mClip = new Clip(clip);
        this.mPixFrameQueue = new UGCFrameQueue();
        this.mPixFrameCacheForReverse = new LinkedList<PixelFrame>();
        this.mWorkHandler = handler;
    }

    @Override
    public void initialize() {
        LiteavLog.i(this.mTag, "initialize");
    }

    @Override
    public void uninitialize() {
        LiteavLog.i(this.mTag, "unInitialize");
        this.mWorkHandler.runOrPost(fp.a(this));
    }

    @Override
    public void start() {
        this.mWorkHandler.runOrPost(fs.a(this));
    }

    @Override
    public void stop() {
        this.mWorkHandler.runOrPost(ft.a(this));
    }

    @Override
    public void seekTo(long lineTime, boolean isPreciseSeek) {
        LiteavLog.i(this.mTag, "seekTo lineTime = " + lineTime + " isPreciseSeek = " + isPreciseSeek);
        this.mWorkHandler.runAndWaitDone(fu.a(this, lineTime, isPreciseSeek), 1000L);
    }

    @Override
    public UGCFrameQueue<List<PixelFrame>> getFrameQueue() {
        return this.mPixFrameQueue;
    }

    @Override
    public void setReverse(boolean isReverse) {
        LiteavLog.i(this.mTag, "isReverse = ".concat(String.valueOf(isReverse)));
        this.mWorkHandler.runOrPost(fv.a(this, isReverse));
    }

    private void uninitializeInternal() {
        this.unInitializeGLComponents();
        if (this.mVideoDecodeController != null) {
            this.mVideoDecodeController.stop();
            this.mVideoDecodeController = null;
        }
        this.clearPixelFrameQueue();
        PixelFrame.releasePixelFrames(this.mPixFrameCacheForReverse);
    }

    private boolean createDemuxerAndOpenFile() {
        this.mDemuxer = this.mClip.videoMimeType == null || "video/hevc".equals(this.mClip.videoMimeType) || "video/avc".equals(this.mClip.videoMimeType) ? new VideoDemuxerFFmpeg() : new VideoDemuxerSystem();
        if (!this.mDemuxer.open(this.mClip.path)) {
            this.mDemuxer.close();
            this.mDemuxer = null;
            return false;
        }
        return true;
    }

    private void startInternal() {
        if (!this.createDemuxerAndOpenFile()) {
            LiteavLog.e(this.mTag, this.mClip.path + " open fail or there is not video stream");
            this.mPixFrameQueue.queue(END_OF_STREAM);
            return;
        }
        LiteavLog.i(this.mTag, this.mClip.path + " open success");
        this.mPixFrameQueue.setUGCFrameQueueListener(this.mUGCFrameQueueListener);
        this.mPixFrameQueue.clear();
        if (this.mIsReverse) {
            this.mReversePlayCurrentPts = this.mClip.endInFileTime;
            this.mDemuxer.seek(this.mReversePlayCurrentPts - 500L);
        } else if (this.mClip.startInFileTime != 0L) {
            this.mDemuxer.seek(this.mClip.startInFileTime);
        }
        this.initializeDecodeController();
        this.initializeGLComponents();
        this.decodeInternal();
    }

    private void stopInternal() {
        this.mPixFrameQueue.setUGCFrameQueueListener(null);
        if (this.mDemuxer != null) {
            this.mDemuxer.close();
            this.mDemuxer = null;
        }
        if (this.mVideoDecodeController != null) {
            this.mVideoDecodeController.stop();
            this.mVideoDecodeController = null;
        }
        this.clearPixelFrameQueue();
        PixelFrame.releasePixelFrames(this.mPixFrameCacheForReverse);
        this.mPixFrameQueue.queue(END_OF_STREAM);
        this.mIsAbandoningDecodingFrame = false;
        this.mIsInPreciseSeeking = true;
        this.mIsReverse = false;
        this.mIsFrameSendingDecoder = false;
        this.mSeekingTimeMs = -1L;
        this.mReversePlayCurrentPts = this.mClip.startInFileTime;
    }

    private void setReverseInternal(boolean isReverse) {
        if (this.mIsReverse == isReverse) {
            return;
        }
        this.mIsReverse = isReverse;
        if (this.mIsReverse) {
            this.mReversePlayCurrentPts = this.mClip.endInFileTime;
            UGCSingleFilePixelFrameProvider uGCSingleFilePixelFrameProvider = this;
            uGCSingleFilePixelFrameProvider.seekToInFileTime(uGCSingleFilePixelFrameProvider.mClip.endInFileTime - 500L, false);
        } else {
            UGCSingleFilePixelFrameProvider uGCSingleFilePixelFrameProvider = this;
            uGCSingleFilePixelFrameProvider.seekToInFileTime(uGCSingleFilePixelFrameProvider.mClip.startInFileTime, true);
        }
        this.clearPixelFrameQueue();
    }

    @Override
    public void setPlayEndPts(long playEndPts) {
        this.mPlayEndPts = playEndPts;
    }

    @Override
    public void setMaxBufferFrameCount(int count) {
        this.mMaxFrameCount = count;
    }

    private void decodeInternal() {
        if (this.mVideoDecodeController == null || !this.isNeedDecode()) {
            this.mIsFrameSendingDecoder = false;
            return;
        }
        if (this.mVideoDecodeController.isInputQueueFull()) {
            this.mWorkHandler.postDelayed(fw.a(this), 10L);
            return;
        }
        EncodedVideoFrame encodedVideoFrame = this.mDemuxer.getNextEncodeVideoFrame();
        if (encodedVideoFrame == null) {
            return;
        }
        if (encodedVideoFrame == VideoDemuxerFFmpeg.END_OF_STREAM) {
            LiteavLog.i(this.mTag, "demuxer read completed");
            this.mHasReadEOF = true;
            this.mVideoDecodeController.signalEndOfStream();
            this.mWorkHandler.removeCallbacks(fx.a(this));
            this.mWorkHandler.runOrPost(fy.a(this), 1000);
        } else {
            this.mIsFrameSendingDecoder = true;
            this.mIsDecodeCompleted = false;
            this.mVideoRotation = l.a(encodedVideoFrame.rotation);
            this.mVideoDecodeController.decode(encodedVideoFrame);
        }
        if (this.mSeekingTimeMs < 0L) {
            this.mWorkHandler.post(fz.a(this));
            return;
        }
        if (encodedVideoFrame.pts > this.mSeekingTimeMs) {
            this.mWorkHandler.postDelayed(fq.a(this), 10L);
            return;
        }
        this.mWorkHandler.post(fr.a(this));
    }

    private boolean isNeedDecode() {
        boolean bl2;
        boolean bl3;
        boolean bl4 = bl3 = this.mVideoDecodeController != null && this.mDemuxer != null && !this.mIsAbandoningDecodingFrame && !this.mHasReadEOF;
        if (this.mIsReverse) {
            bl2 = this.mPixFrameQueue.size() >= this.mMaxFrameCount && this.mPixFrameQueue.size() + this.mPixFrameCacheForReverse.size() >= this.mFrameCacheCapacityForReverse + this.mMaxFrameCount;
        } else {
            boolean bl5 = bl2 = this.mPixFrameQueue.size() >= this.mMaxFrameCount;
        }
        return bl3 && !bl2;
    }

    private void seekToInFileTime(long fileTime, boolean isPreciseSeek) {
        if (this.mDemuxer == null) {
            return;
        }
        long l2 = h.a(fileTime, this.mClip.startInFileTime, this.mClip.endInFileTime);
        LiteavLog.i(this.mTag, "seekToInFileTime file time = ".concat(String.valueOf(l2)));
        this.mSeekingTimeMs = l2;
        this.mIsInPreciseSeeking = isPreciseSeek;
        this.mDemuxer.seek(this.mSeekingTimeMs);
        if (!this.mIsAbandoningDecodingFrame) {
            this.mIsAbandoningDecodingFrame = true;
            this.mVideoDecodeController.abandonDecodingFrames();
        }
        this.mHasReadEOF = false;
        PixelFrame.releasePixelFrames(this.mPixFrameCacheForReverse);
    }

    private void onDecodeFrameInternal(PixelFrame pixelFrame) {
        if (this.mVideoDecodeController == null) {
            pixelFrame.release();
            return;
        }
        long l2 = pixelFrame.getTimestamp();
        if (this.mIsAbandoningDecodingFrame || !this.mIsReverse && this.mIsInPreciseSeeking && l2 < this.mSeekingTimeMs && this.mSeekingTimeMs != -1L) {
            pixelFrame.release();
            return;
        }
        this.mSeekingTimeMs = -1L;
        pixelFrame = this.processFrame(pixelFrame);
        if (this.mIsReverse) {
            this.addFrameToQueueForReverse(pixelFrame);
            return;
        }
        this.addFrameToQueue(pixelFrame);
    }

    private PixelFrame processFrame(PixelFrame pixelFrame) {
        if (this.mEGLCore == null) {
            pixelFrame.release();
            return null;
        }
        try {
            this.mEGLCore.makeCurrent();
        }
        catch (EGLException eGLException) {
            pixelFrame.release();
            return null;
        }
        pixelFrame.setRotation(this.mVideoRotation);
        if (pixelFrame.getRotation() != l.a && pixelFrame.getRotation() != l.c) {
            pixelFrame.swapWidthHeight();
        }
        int n2 = pixelFrame.getWidth();
        int n3 = pixelFrame.getHeight();
        if ((n2 != this.mVideoWidth || n3 != this.mVideoHeight) && this.mPixelFrameRenderer != null) {
            this.mPixelFrameRenderer.uninitialize();
            this.mPixelFrameRenderer = null;
        }
        if (this.mPixelFrameRenderer == null) {
            this.mPixelFrameRenderer = new PixelFrameRenderer(n2, n3);
            this.mVideoWidth = n2;
            this.mVideoHeight = n3;
        }
        OpenGlUtils.glViewport(0, 0, n2, n3);
        GLTexture gLTexture = this.mGLTexturePool.obtain(n2, n3);
        gLTexture.setColorFormat(pixelFrame.getColorRange(), pixelFrame.getColorSpace());
        this.mPixelFrameRenderer.renderFrame(pixelFrame, GLConstants.GLScaleType.a, gLTexture);
        PixelFrame pixelFrame2 = gLTexture.wrap(this.mEGLCore.getEglContext());
        pixelFrame2.setTimestamp(pixelFrame.getTimestamp());
        pixelFrame2.setGLContext(GlobalContextManager.getInstance().getGLContext());
        GLES20.glFinish();
        gLTexture.release();
        pixelFrame.release();
        return pixelFrame2;
    }

    private void initializeDecodeController() {
        if (this.mVideoDecodeController != null) {
            LiteavLog.w(this.mTag, "UGCVideoFileProvider is initialized");
            return;
        }
        LiteavLog.i(this.mTag, "initializeDecodeController");
        this.mVideoDecodeController = new UGCVideoDecodeController();
        this.mVideoDecodeController.start(this.mUGCDecodeControllerListener);
    }

    private void initializeGLComponents() {
        if (this.mEGLCore != null) {
            return;
        }
        LiteavLog.i(this.mThrottlers.a("initGL"), this.mTag, "initializeGLComponents", new Object[0]);
        this.mEGLCore = new EGLCore();
        try {
            this.mEGLCore.initialize(GlobalContextManager.getInstance().getGLContext(), null, 128, 128);
            this.mEGLCore.makeCurrent();
        }
        catch (EGLException eGLException) {
            LiteavLog.e(this.mThrottlers.a("initGLError"), this.mTag, "initializeGLComponents failed.", eGLException);
            this.mEGLCore = null;
            return;
        }
        this.mGLTexturePool = new GLTexturePool();
    }

    private void unInitializeGLComponents() {
        if (this.mGLTexturePool != null) {
            this.mGLTexturePool.evictAll();
            this.mGLTexturePool.destroy();
            this.mGLTexturePool = null;
        }
        if (this.mPixelFrameRenderer != null) {
            this.mPixelFrameRenderer.uninitialize();
            this.mPixelFrameRenderer = null;
        }
        EGLCore.destroy(this.mEGLCore);
        this.mEGLCore = null;
    }

    private void addFrameToQueue(PixelFrame pixelFrame) {
        if (pixelFrame == null) {
            this.mPixFrameQueue.queue(END_OF_STREAM);
            return;
        }
        if (pixelFrame.getTimestamp() < this.mClip.startInFileTime) {
            pixelFrame.release();
            return;
        }
        if (pixelFrame.getTimestamp() > this.mClip.endInFileTime || pixelFrame.getTimestamp() > this.mPlayEndPts) {
            LiteavLog.i(this.mTag, "addFrameToQueue Timestamp = " + pixelFrame.getTimestamp() + " endInnerFileTime = " + this.mClip.endInFileTime);
            this.mPixFrameQueue.queue(END_OF_STREAM);
            pixelFrame.release();
            return;
        }
        pixelFrame.setTimestamp(this.fileTimeToTimeline(pixelFrame.getTimestamp()));
        LinkedList<PixelFrame> linkedList = new LinkedList<PixelFrame>();
        linkedList.add(pixelFrame);
        this.mPixFrameQueue.queue(linkedList);
    }

    private void addFrameToQueueForReverse(PixelFrame pixelFrame) {
        if (pixelFrame != null && pixelFrame.getTimestamp() <= this.mReversePlayCurrentPts) {
            this.mPixFrameCacheForReverse.addLast(pixelFrame);
            return;
        }
        if (pixelFrame != null) {
            pixelFrame.release();
        }
        if (this.mPixFrameCacheForReverse.isEmpty()) {
            LiteavLog.i(this.mTag, "mGopVideoFrameList isEmpty so put END_OF_STREAM");
            this.mPixFrameQueue.queue(END_OF_STREAM);
            return;
        }
        this.mFrameCacheCapacityForReverse = this.mPixFrameCacheForReverse.size();
        while (!this.mPixFrameCacheForReverse.isEmpty()) {
            PixelFrame pixelFrame2 = this.mPixFrameCacheForReverse.pollLast();
            this.mReversePlayCurrentPts = pixelFrame2.getTimestamp();
            if (this.mReversePlayCurrentPts > this.mClip.endInFileTime || this.mReversePlayCurrentPts < this.mClip.startInFileTime) {
                pixelFrame2.release();
                continue;
            }
            UGCSingleFilePixelFrameProvider uGCSingleFilePixelFrameProvider = this;
            pixelFrame2.setTimestamp(uGCSingleFilePixelFrameProvider.fileTimeToTimelineForReverse(uGCSingleFilePixelFrameProvider.mReversePlayCurrentPts));
            LinkedList<PixelFrame> linkedList = new LinkedList<PixelFrame>();
            linkedList.add(pixelFrame2);
            this.mPixFrameQueue.queue(linkedList);
        }
        if (this.mReversePlayCurrentPts <= this.mClip.startInFileTime) {
            LiteavLog.i(this.mTag, "mLastGopFinishPts is smaller start time so put END_OF_STREAM");
            this.mPixFrameQueue.queue(END_OF_STREAM);
            return;
        }
        --this.mReversePlayCurrentPts;
        UGCSingleFilePixelFrameProvider uGCSingleFilePixelFrameProvider = this;
        uGCSingleFilePixelFrameProvider.seekToInFileTime(uGCSingleFilePixelFrameProvider.mReversePlayCurrentPts - 500L, false);
    }

    private long timelineToFileTime(long timeline) {
        if (this.mClip.speedList == null) {
            return timeline + this.mClip.startInFileTime;
        }
        long l2 = 0L;
        for (TXVideoEditConstants.TXSpeed tXSpeed : this.mClip.speedList) {
            float f2 = 1.0f / this.getTimeMultipleInSpeed(tXSpeed.speedLevel);
            long l3 = (long)((float)(tXSpeed.endTime - tXSpeed.startTime) * f2);
            l2 = (long)((float)timeline / f2) + tXSpeed.startTime;
            if (timeline < l3) break;
            timeline -= l3;
        }
        return l2;
    }

    private long fileTimeToTimeline(long fileTime) {
        long l2 = this.mClip.startInClipsTimeline;
        if (this.mClip.speedList == null) {
            return l2 + (fileTime - this.mClip.startInFileTime);
        }
        for (TXVideoEditConstants.TXSpeed tXSpeed : this.mClip.speedList) {
            float f2 = 1.0f / this.getTimeMultipleInSpeed(tXSpeed.speedLevel);
            if (fileTime < tXSpeed.endTime) {
                l2 += (long)((float)(fileTime - tXSpeed.startTime) * f2);
                break;
            }
            l2 += (long)((float)(tXSpeed.endTime - tXSpeed.startTime) * f2);
        }
        return l2;
    }

    private float getTimeMultipleInSpeed(int speedLevel) {
        return UGCMediaListSource.getSpeed(speedLevel);
    }

    private long fileTimeToTimelineForReverse(long fileTime) {
        if (this.mClip.speedList == null) {
            return this.mClip.endInFileTime - fileTime;
        }
        long l2 = this.mClip.startInClipsTimeline;
        for (int i2 = this.mClip.speedList.size() - 1; i2 >= 0; --i2) {
            TXVideoEditConstants.TXSpeed tXSpeed = this.mClip.speedList.get(i2);
            float f2 = 1.0f / this.getTimeMultipleInSpeed(tXSpeed.speedLevel);
            if (fileTime > tXSpeed.startTime) {
                l2 += (long)((float)(tXSpeed.endTime - fileTime) * f2);
                break;
            }
            l2 += (long)((float)(tXSpeed.endTime - tXSpeed.startTime) * f2);
        }
        return l2;
    }

    private void onDecodeCompletedInternal() {
        LiteavLog.i(this.mTag, "onDecodeCompletedInteral");
        if (this.mVideoDecodeController == null || this.mIsAbandoningDecodingFrame || this.mIsDecodeCompleted || !this.mHasReadEOF) {
            return;
        }
        if (this.mIsReverse) {
            this.addFrameToQueueForReverse(null);
        } else {
            this.addFrameToQueue(null);
        }
        this.mIsDecodeCompleted = true;
    }

    private void clearPixelFrameQueue() {
        if (this.mEGLCore != null) {
            try {
                this.mEGLCore.makeCurrent();
            }
            catch (EGLException eGLException) {
                LiteavLog.e(this.mTag, "make current exception when clear pixel frame queue. exception msg is ", eGLException);
                return;
            }
        }
        Iterator<List<PixelFrame>> iterator = this.mPixFrameQueue.dequeueAll().iterator();
        while (iterator.hasNext()) {
            PixelFrame.releasePixelFrames(iterator.next());
        }
    }

    static /* synthetic */ void lambda$setReverse$1(UGCSingleFilePixelFrameProvider this_, boolean isReverse) {
        this_.setReverseInternal(isReverse);
    }

    static /* synthetic */ void lambda$seekTo$0(UGCSingleFilePixelFrameProvider this_, long lineTime, boolean isPreciseSeek) {
        long l2;
        if (this_.mVideoDecodeController == null || this_.mDemuxer == null) {
            return;
        }
        this_.clearPixelFrameQueue();
        this_.mReversePlayCurrentPts = l2 = this_.timelineToFileTime(lineTime);
        this_.seekToInFileTime(l2, isPreciseSeek);
    }

    static /* synthetic */ void access$lambda$0(UGCSingleFilePixelFrameProvider uGCSingleFilePixelFrameProvider) {
        uGCSingleFilePixelFrameProvider.uninitializeInternal();
    }

    static /* synthetic */ void access$lambda$1(UGCSingleFilePixelFrameProvider uGCSingleFilePixelFrameProvider) {
        uGCSingleFilePixelFrameProvider.startInternal();
    }

    static /* synthetic */ void access$lambda$2(UGCSingleFilePixelFrameProvider uGCSingleFilePixelFrameProvider) {
        uGCSingleFilePixelFrameProvider.stopInternal();
    }

    static /* synthetic */ void access$lambda$3(UGCSingleFilePixelFrameProvider uGCSingleFilePixelFrameProvider) {
        uGCSingleFilePixelFrameProvider.decodeInternal();
    }

    static /* synthetic */ void access$lambda$4(UGCSingleFilePixelFrameProvider uGCSingleFilePixelFrameProvider) {
        uGCSingleFilePixelFrameProvider.onDecodeCompletedInternal();
    }

    static /* synthetic */ void access$lambda$5(UGCSingleFilePixelFrameProvider uGCSingleFilePixelFrameProvider) {
        uGCSingleFilePixelFrameProvider.onDecodeCompletedInternal();
    }

    static /* synthetic */ void access$lambda$6(UGCSingleFilePixelFrameProvider uGCSingleFilePixelFrameProvider) {
        uGCSingleFilePixelFrameProvider.decodeInternal();
    }

    static /* synthetic */ void access$lambda$7(UGCSingleFilePixelFrameProvider uGCSingleFilePixelFrameProvider) {
        uGCSingleFilePixelFrameProvider.decodeInternal();
    }

    static /* synthetic */ void access$lambda$8(UGCSingleFilePixelFrameProvider uGCSingleFilePixelFrameProvider) {
        uGCSingleFilePixelFrameProvider.decodeInternal();
    }
}

