/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.h;
import com.tencent.ugc.AudioFrame;
import com.tencent.ugc.Clip;
import com.tencent.ugc.TXVideoEditConstants;
import com.tencent.ugc.UGCAudioFrameProvider;
import com.tencent.ugc.UGCFrameQueue;
import com.tencent.ugc.UGCMediaListSource;
import com.tencent.ugc.VideoDemuxerFFmpeg;
import com.tencent.ugc.ff;
import com.tencent.ugc.fg;
import com.tencent.ugc.fh;
import com.tencent.ugc.fi;
import com.tencent.ugc.fj;
import com.tencent.ugc.fk;
import com.tencent.ugc.fl;
import com.tencent.ugc.fm;
import com.tencent.ugc.fn;
import com.tencent.ugc.fo;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@JNINamespace(value="liteav::ugc")
public class UGCSingleFileAudioFrameProvider
implements UGCAudioFrameProvider,
UGCFrameQueue.UGCFrameQueueListener {
    public static final String MUTE_VIRTUAL_FILE_PATH = "mute_virtual_file_path";
    private static final int MAX_FRAME_SIZE = 5;
    private static final int DEFAULT_FRAME_DURATION = 20;
    private static final int DEFAULT_SAMPLE_RATE = 48000;
    private static final int DEFAULT_CHANNEL_COUNT = 2;
    private final String TAG = "UGCAudioFileProvider_" + this.hashCode();
    private final Clip mClip;
    private final UGCFrameQueue<List<AudioFrame>> mAudioFrameQueue;
    private final CustomHandler mWorkHandler;
    private long mNativeHandle;
    private long mCurrentMuteFramePts = 0L;
    private long mEndPlayPts = Long.MAX_VALUE;
    private long mFirstFramePtsOfAllStream = 0L;
    private Long mSeekFileTime = 0L;
    private AudioFrame mLastFrame;

    public UGCSingleFileAudioFrameProvider(Clip clip, CustomHandler handler) {
        this.mClip = new Clip(clip);
        this.mAudioFrameQueue = new UGCFrameQueue();
        this.mWorkHandler = handler;
    }

    @Override
    public void initialize() {
        LiteavLog.i(this.TAG, "initialize");
        this.mWorkHandler.runOrPost(ff.a(this));
    }

    @Override
    public void uninitialize() {
        this.mWorkHandler.runOrPost(fh.a(this));
    }

    @Override
    public void start() {
        this.mWorkHandler.runOrPost(fi.a(this));
    }

    private void startInternal() {
        VideoDemuxerFFmpeg videoDemuxerFFmpeg;
        if (this.mNativeHandle != 0L && UGCSingleFileAudioFrameProvider.nativeOpen(this.mNativeHandle, this.mClip.path) != 0) {
            LiteavLog.e(this.TAG, "native MusicResourceDecoderFFmpeg open failed.");
            UGCSingleFileAudioFrameProvider.nativeClose(this.mNativeHandle);
            UGCSingleFileAudioFrameProvider.nativeDestroy(this.mNativeHandle);
            this.mNativeHandle = 0L;
        }
        if ((videoDemuxerFFmpeg = new VideoDemuxerFFmpeg()).open(this.mClip.path)) {
            this.mFirstFramePtsOfAllStream = videoDemuxerFFmpeg.getFirstFramePtsOfAllStream();
        }
        videoDemuxerFFmpeg.close();
        this.mCurrentMuteFramePts = this.mClip.startInClipsTimeline;
        this.mAudioFrameQueue.setUGCFrameQueueListener(this);
        this.mAudioFrameQueue.clear();
        this.mSeekFileTime = 0L;
        if (this.mClip.startInFileTime != 0L) {
            UGCSingleFileAudioFrameProvider uGCSingleFileAudioFrameProvider = this;
            uGCSingleFileAudioFrameProvider.seekToInFileTime(uGCSingleFileAudioFrameProvider.mClip.startInFileTime);
        }
        this.DecodeOrAppendMuteFrame();
    }

    @Override
    public void stop() {
        this.mWorkHandler.runOrPost(fj.a(this));
    }

    private void stopInternal() {
        if (this.mNativeHandle != 0L) {
            UGCSingleFileAudioFrameProvider.nativeClose(this.mNativeHandle);
        }
        this.mAudioFrameQueue.setUGCFrameQueueListener(null);
        this.mWorkHandler.removeCallbacks(fk.a(this));
        this.mAudioFrameQueue.clear();
        this.putEndOfStreamFrameToQueue();
    }

    @Override
    public void setPlayEndPts(long playEndPts) {
        this.mEndPlayPts = playEndPts;
    }

    @Override
    public void seekTo(long lineTime) {
        this.mWorkHandler.runAndWaitDone(fl.a(this, lineTime), 1000L);
    }

    private void seekToInFileTime(long fileTime) {
        this.mSeekFileTime = h.a(fileTime, this.mClip.startInFileTime, this.mClip.endInFileTime);
        LiteavLog.i(this.TAG, "seekTo fileTime " + this.mSeekFileTime);
        this.mCurrentMuteFramePts = this.fileTimeToTimelineNoSpeed(this.mSeekFileTime);
        if (this.mNativeHandle != 0L && UGCSingleFileAudioFrameProvider.nativeSeekTo(this.mNativeHandle, this.mSeekFileTime) != 0) {
            LiteavLog.w(this.TAG, "nativeSeekTo fail");
        }
        this.mAudioFrameQueue.clear();
        this.mWorkHandler.runOrPost(fm.a(this));
    }

    private long timelineToFileTime(long timeline) {
        long l2 = 0L;
        if (this.mClip.speedList == null) {
            return this.timelineToFileTimeNoSpeed(timeline);
        }
        for (TXVideoEditConstants.TXSpeed tXSpeed : this.mClip.speedList) {
            float f2 = 1.0f / this.getTimeMultipleInSpeed(tXSpeed.speedLevel);
            long l3 = (long)((float)(tXSpeed.endTime - tXSpeed.startTime) * f2);
            l2 = (long)((float)timeline / f2) + tXSpeed.startTime;
            if (timeline < l3) break;
            timeline -= l3;
        }
        return l2;
    }

    private long fileTimeToTimelineNoSpeed(long fileTime) {
        return this.mClip.startTimelineNoSpeed + (fileTime - this.mClip.startInFileTime);
    }

    private long timelineToFileTimeNoSpeed(long timeLine) {
        return timeLine + this.mClip.startInFileTime - this.mClip.startTimelineNoSpeed;
    }

    @Override
    public UGCFrameQueue<List<AudioFrame>> getFrameQueue() {
        return this.mAudioFrameQueue;
    }

    private void DecodeOrAppendMuteFrame() {
        if (this.mAudioFrameQueue.size() >= 5) {
            return;
        }
        if (this.mNativeHandle != 0L) {
            UGCSingleFileAudioFrameProvider.nativeDecode(this.mNativeHandle);
        } else {
            UGCSingleFileAudioFrameProvider uGCSingleFileAudioFrameProvider = this;
            uGCSingleFileAudioFrameProvider.appendOneMuteFrame(uGCSingleFileAudioFrameProvider.mCurrentMuteFramePts, 20, 48000, 2);
            this.mCurrentMuteFramePts += 20L;
        }
        this.mWorkHandler.removeCallbacks(fn.a(this));
        this.mWorkHandler.post(fo.a(this));
    }

    private void appendOneMuteFrame(long timeStamp, int duration, int sampleRate, int channel) {
        if (duration <= 0 || sampleRate <= 0 || channel <= 0) {
            return;
        }
        long l2 = this.mClip.startInClipsTimeline + (this.mClip.endInFileTime - this.mClip.startInFileTime);
        if (timeStamp >= l2) {
            this.putEndOfStreamFrameToQueue();
            return;
        }
        AudioFrame audioFrame = new AudioFrame();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(2 * channel * sampleRate * duration / 1000);
        Arrays.fill(byteBuffer.array(), (byte)0);
        audioFrame.setData(byteBuffer);
        audioFrame.setChannelCount(channel);
        audioFrame.setSampleRate(sampleRate);
        audioFrame.setCodecFormat(AudioFrame.AudioCodecFormat.PCM);
        audioFrame.setTimestamp(timeStamp);
        this.mLastFrame = audioFrame;
        this.mAudioFrameQueue.queue(Collections.singletonList(audioFrame));
    }

    private void appendMultipleMuteFrame(long startTime, int duration, int sampleRate, int channel) {
        int n2;
        if (duration <= 0 || sampleRate <= 0 || channel <= 0) {
            return;
        }
        int n3 = duration / 20;
        for (n2 = 0; n2 < n3; ++n2) {
            this.appendOneMuteFrame(startTime, 20, sampleRate, channel);
            startTime += 20L;
        }
        n2 = duration - n3 * 20;
        if (n2 != 0) {
            this.appendOneMuteFrame(startTime, n2, sampleRate, channel);
        }
    }

    @Override
    public void onFrameDequeued() {
        this.mWorkHandler.runOrPost(fg.a(this));
    }

    private float getTimeMultipleInSpeed(int speedLevel) {
        return UGCMediaListSource.getSpeed(speedLevel);
    }

    private AudioFrame obtainAudioFrame(int sampleRate, int channelCount, long timestamp, int size) {
        AudioFrame audioFrame = new AudioFrame();
        audioFrame.setSampleRate(sampleRate);
        audioFrame.setChannelCount(channelCount);
        audioFrame.setTimestamp(timestamp);
        audioFrame.setCodecFormat(AudioFrame.AudioCodecFormat.PCM);
        audioFrame.setData(ByteBuffer.allocateDirect(size));
        return audioFrame;
    }

    private ByteBuffer getByteBufferFromAudioFrame(AudioFrame frame) {
        return frame.getData();
    }

    private void onDecodeFrame(AudioFrame audioFrame) {
        if (audioFrame == null) {
            return;
        }
        long l2 = Math.min(audioFrame.getTimestamp() - this.mFirstFramePtsOfAllStream, this.mClip.endInFileTime);
        if (l2 < this.mClip.startInFileTime) {
            return;
        }
        if (this.mSeekFileTime != null) {
            if (l2 < this.mSeekFileTime) {
                return;
            }
            UGCSingleFileAudioFrameProvider uGCSingleFileAudioFrameProvider = this;
            long l3 = uGCSingleFileAudioFrameProvider.fileTimeToTimelineNoSpeed(uGCSingleFileAudioFrameProvider.mSeekFileTime);
            this.appendMultipleMuteFrame(l3, (int)(l2 - this.mSeekFileTime), audioFrame.getSampleRate(), audioFrame.getChannelCount());
        }
        this.mSeekFileTime = null;
        if (l2 >= this.mClip.endInFileTime || l2 >= this.mEndPlayPts) {
            LiteavLog.i(this.TAG, "decode frame pts is bigger than end time");
            this.putEndOfStreamFrameToQueue();
            return;
        }
        this.mLastFrame = audioFrame;
        audioFrame.setTimestamp(this.fileTimeToTimelineNoSpeed(l2));
        this.mAudioFrameQueue.queue(Collections.singletonList(audioFrame));
    }

    private void onDecodeError(String reason) {
        LiteavLog.i(this.TAG, "onDecodeError reason = ".concat(String.valueOf(reason)));
        this.appendMuteFrameWhenDecodeFinish();
        this.putEndOfStreamFrameToQueue();
    }

    private void onDecodeEndOfFile() {
        LiteavLog.i(this.TAG, "onDecodeEndOfFile");
        this.appendMuteFrameWhenDecodeFinish();
        this.putEndOfStreamFrameToQueue();
    }

    private void putEndOfStreamFrameToQueue() {
        this.mLastFrame = null;
        this.mAudioFrameQueue.queue(END_OF_STREAM);
    }

    private void appendMuteFrameWhenDecodeFinish() {
        if (this.mLastFrame == null) {
            return;
        }
        UGCSingleFileAudioFrameProvider uGCSingleFileAudioFrameProvider = this;
        UGCSingleFileAudioFrameProvider uGCSingleFileAudioFrameProvider2 = this;
        long l2 = uGCSingleFileAudioFrameProvider.calculateAudioFrameDuration(uGCSingleFileAudioFrameProvider.mLastFrame) + uGCSingleFileAudioFrameProvider2.timelineToFileTimeNoSpeed(uGCSingleFileAudioFrameProvider2.mLastFrame.getTimestamp());
        if (l2 < this.mClip.endInFileTime && l2 > 0L) {
            long l3 = this.fileTimeToTimelineNoSpeed(l2);
            this.appendMultipleMuteFrame(l3, (int)(this.mClip.endInFileTime - l2), this.mLastFrame.getSampleRate(), this.mLastFrame.getChannelCount());
        }
    }

    private long calculateAudioFrameDuration(AudioFrame audioFrame) {
        if (audioFrame == null || !audioFrame.isValidFrame()) {
            return 0L;
        }
        if (audioFrame.getCodecFormat() != AudioFrame.AudioCodecFormat.PCM) {
            return 0L;
        }
        return (long)audioFrame.getData().remaining() * 1000L / (2L * (long)audioFrame.getChannelCount() * (long)audioFrame.getSampleRate());
    }

    private static native long nativeCreate(UGCSingleFileAudioFrameProvider var0);

    private static native void nativeDestroy(long var0);

    private static native int nativeOpen(long var0, String var2);

    private static native void nativeClose(long var0);

    private static native void nativeDecode(long var0);

    private static native int nativeSeekTo(long var0, long var2);

    private static native long nativeGetDuration(long var0);

    static /* synthetic */ void lambda$seekTo$2(UGCSingleFileAudioFrameProvider this_, long lineTime) {
        long l2 = this_.timelineToFileTime(lineTime);
        this_.seekToInFileTime(l2);
    }

    static /* synthetic */ void lambda$uninitialize$1(UGCSingleFileAudioFrameProvider this_) {
        if (this_.mNativeHandle != 0L) {
            UGCSingleFileAudioFrameProvider.nativeClose(this_.mNativeHandle);
            UGCSingleFileAudioFrameProvider.nativeDestroy(this_.mNativeHandle);
            this_.mNativeHandle = 0L;
        }
        this_.mAudioFrameQueue.clear();
    }

    static /* synthetic */ void lambda$initialize$0(UGCSingleFileAudioFrameProvider this_) {
        if (this_.mClip.path.equals(MUTE_VIRTUAL_FILE_PATH)) {
            this_.mNativeHandle = 0L;
            return;
        }
        this_.mNativeHandle = UGCSingleFileAudioFrameProvider.nativeCreate(this_);
        if (this_.mNativeHandle == 0L) {
            LiteavLog.e(this_.TAG, "create native instance failed.");
        }
    }

    static /* synthetic */ void access$lambda$0(UGCSingleFileAudioFrameProvider uGCSingleFileAudioFrameProvider) {
        uGCSingleFileAudioFrameProvider.startInternal();
    }

    static /* synthetic */ void access$lambda$1(UGCSingleFileAudioFrameProvider uGCSingleFileAudioFrameProvider) {
        uGCSingleFileAudioFrameProvider.stopInternal();
    }

    static /* synthetic */ void access$lambda$2(UGCSingleFileAudioFrameProvider uGCSingleFileAudioFrameProvider) {
        uGCSingleFileAudioFrameProvider.DecodeOrAppendMuteFrame();
    }

    static /* synthetic */ void access$lambda$3(UGCSingleFileAudioFrameProvider uGCSingleFileAudioFrameProvider) {
        uGCSingleFileAudioFrameProvider.DecodeOrAppendMuteFrame();
    }

    static /* synthetic */ void access$lambda$4(UGCSingleFileAudioFrameProvider uGCSingleFileAudioFrameProvider) {
        uGCSingleFileAudioFrameProvider.DecodeOrAppendMuteFrame();
    }

    static /* synthetic */ void access$lambda$5(UGCSingleFileAudioFrameProvider uGCSingleFileAudioFrameProvider) {
        uGCSingleFileAudioFrameProvider.DecodeOrAppendMuteFrame();
    }

    static /* synthetic */ void access$lambda$6(UGCSingleFileAudioFrameProvider uGCSingleFileAudioFrameProvider) {
        uGCSingleFileAudioFrameProvider.DecodeOrAppendMuteFrame();
    }
}

