/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import android.opengl.GLES20;
import android.opengl.Matrix;
import com.tencent.ugc.fc;
import com.tencent.ugc.fd;
import com.tencent.ugc.fe;
import com.tencent.ugc.videobase.chain.TXCGPUImageFilter;
import com.tencent.ugc.videobase.frame.GLTexturePool;

public class UGCRotateScaleFilter
extends TXCGPUImageFilter {
    private static final String TRANSFORM_VERTEX_SHADER = "attribute vec4 position;\n attribute vec4 inputTextureCoordinate;\n \n uniform mat4 transformMatrix;\n uniform mat4 orthographicMatrix;\n \n varying vec2 textureCoordinate;\n void main()\n {\n     gl_Position = transformMatrix * vec4(position.xyz, 1.0) * orthographicMatrix;\n     textureCoordinate = inputTextureCoordinate.xy;\n }";
    private static final String TRANSFORM_FRAG_SHADER = "precision mediump float;\nvarying mediump vec2 textureCoordinate;\nuniform sampler2D inputImageTexture;\nuniform float scale;\n uniform mediump float alpha;\n\nvoid main(void) {\n    gl_FragColor = vec4(texture2D(inputImageTexture, textureCoordinate).rgb, alpha); \n}\n";
    private int mTransformMatrixUniform = -1;
    private int mAlphaUniform = -1;
    private float[] mTransform3D;

    public UGCRotateScaleFilter() {
        super(TRANSFORM_VERTEX_SHADER, TRANSFORM_FRAG_SHADER);
    }

    @Override
    public void onInit(GLTexturePool texturePool) {
        super.onInit(texturePool);
        this.mTransformMatrixUniform = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"transformMatrix");
        int n2 = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"orthographicMatrix");
        int n3 = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"scale");
        this.mAlphaUniform = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"alpha");
        float[] fArray = new float[16];
        Matrix.orthoM((float[])fArray, (int)0, (float)-1.0f, (float)1.0f, (float)-1.0f, (float)1.0f, (float)-1.0f, (float)1.0f);
        this.setUniformMatrix4f(n2, fArray);
        this.mTransform3D = new float[16];
        Matrix.setIdentityM((float[])this.mTransform3D, (int)0);
        UGCRotateScaleFilter uGCRotateScaleFilter = this;
        uGCRotateScaleFilter.setUniformMatrix4f(uGCRotateScaleFilter.mTransformMatrixUniform, this.mTransform3D);
        this.setFloatOnDraw(n3, 1.0f);
        this.setAlpha(1.0f);
    }

    public void setAlpha(float alpha) {
        UGCRotateScaleFilter uGCRotateScaleFilter = this;
        uGCRotateScaleFilter.setFloatOnDraw(uGCRotateScaleFilter.mAlphaUniform, alpha);
    }

    public void setRotate(float rotate) {
        UGCRotateScaleFilter uGCRotateScaleFilter = this;
        uGCRotateScaleFilter.runOnDraw(fc.a(uGCRotateScaleFilter, rotate));
    }

    public void setRotateAndScale(float rotate, float scale) {
        UGCRotateScaleFilter uGCRotateScaleFilter = this;
        uGCRotateScaleFilter.runOnDraw(fd.a(uGCRotateScaleFilter, rotate, scale));
    }

    private float[] setRotateInternal(float[] rotatePoint, float rotate) {
        float[] fArray = rotatePoint;
        if (rotatePoint == null) {
            fArray = new float[16];
            Matrix.setIdentityM((float[])fArray, (int)0);
        }
        Matrix.setRotateM((float[])fArray, (int)0, (float)rotate, (float)0.0f, (float)0.0f, (float)1.0f);
        this.mTransform3D = fArray;
        GLES20.glUniformMatrix4fv((int)this.mTransformMatrixUniform, (int)1, (boolean)false, (float[])this.mTransform3D, (int)0);
        return fArray;
    }

    private void setScaleInternal(float[] scalePoint, float scale) {
        float[] fArray = scalePoint;
        if (scalePoint == null) {
            fArray = new float[16];
            Matrix.setIdentityM((float[])fArray, (int)0);
        }
        float f2 = scale;
        Matrix.scaleM((float[])fArray, (int)0, (float)f2, (float)f2, (float)1.0f);
        this.mTransform3D = fArray;
        GLES20.glUniformMatrix4fv((int)this.mTransformMatrixUniform, (int)1, (boolean)false, (float[])this.mTransform3D, (int)0);
    }

    private void setUniformMatrix4f(int location, float[] matrix) {
        this.runOnDraw(fe.a(location, matrix));
    }

    static /* synthetic */ void lambda$setUniformMatrix4f$2(int location, float[] matrix) {
        GLES20.glUniformMatrix4fv((int)location, (int)1, (boolean)false, (float[])matrix, (int)0);
    }

    static /* synthetic */ void lambda$setRotateAndScale$1(UGCRotateScaleFilter this_, float rotate, float scale) {
        float[] originPoint = this_.setRotateInternal(null, rotate);
        this_.setScaleInternal(originPoint, scale);
    }

    static /* synthetic */ void lambda$setRotate$0(UGCRotateScaleFilter this_, float rotate) {
        this_.setRotateInternal(null, rotate);
    }
}

