/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.text.TextUtils;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.ThreadUtils;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.base.util.SoLoader;
import com.tencent.liteav.base.util.f;
import com.tencent.liteav.beauty.TXBeautyManager;
import com.tencent.liteav.videobase.common.d;
import com.tencent.liteav.videobase.videobase.DisplayTarget;
import com.tencent.rtmp.ui.TXCloudVideoView;
import com.tencent.ugc.TXRecordCommon;
import com.tencent.ugc.TXUGCPartsManager;
import com.tencent.ugc.TXUGCPartsManagerImpl;
import com.tencent.ugc.TXUGCRecord;
import com.tencent.ugc.TXVideoEditConstants;
import com.tencent.ugc.TXVideoInfoReader;
import com.tencent.ugc.UGCBeautyManager;
import com.tencent.ugc.UGCInitializer;
import com.tencent.ugc.datereport.UGCDataReport;
import com.tencent.ugc.fb;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

@JNINamespace(value="liteav::ugc")
public class UGCRecorderJni {
    private static final String TAG = "UGCRecorderJni";
    private static final String OUTPUT_DIR_NAME = "TXUGC";
    private static final String OUTPUT_TEMP_DIR_NAME = "TXUGCParts";
    private static final String OUTPUT_VIDEO_NAME = "TXUGCRecord.mp4";
    private static final String OUTPUT_VIDEO_COVER_NAME = "TXUGCCover.jpg";
    private long mNativeUGCRecorderJni = 0L;
    private TXRecordCommon.ITXVideoRecordListener mVideoRecordListener;
    private TXUGCRecord.VideoCustomProcessListener mCustomProcessListener;
    private TXRecordCommon.ITXSnapshotListener mSnapshotListener;
    private TXRecordCommon.ITXBGMNotify mBGMListener;
    private RecordParams mRecorderParams = new RecordParams();
    private TXBeautyManager mBeautyManager;
    private TXUGCPartsManager mTXUGCPartsManager;
    private Context mContext;
    private String mVideoFilePath;
    private String mCoverPath;
    private String mVideoPartFolder;
    private TXCloudVideoView mPreviewView;

    protected UGCRecorderJni(Context context) {
        this.mContext = context.getApplicationContext();
        ContextUtils.initApplicationContext(this.mContext);
        ContextUtils.setDataDirectorySuffix("liteav");
        UGCInitializer.initialize();
        this.mNativeUGCRecorderJni = UGCRecorderJni.nativeCreate(this);
        this.mBeautyManager = new UGCBeautyManager(UGCRecorderJni.nativeCreateBeautyManager(this.mNativeUGCRecorderJni));
        this.mTXUGCPartsManager = new TXUGCPartsManagerImpl(UGCRecorderJni.nativeCreatePartsManager(this.mNativeUGCRecorderJni));
        this.initFileAndFolder();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.mNativeUGCRecorderJni != 0L) {
            UGCRecorderJni.nativeDestroy(this.mNativeUGCRecorderJni);
            this.mNativeUGCRecorderJni = 0L;
        }
        UGCInitializer.uninitialize();
    }

    public void setVideoRecordListener(TXRecordCommon.ITXVideoRecordListener listener) {
        this.mVideoRecordListener = listener;
    }

    private void initRecorderParams(TXRecordCommon.TXUGCSimpleConfig config) {
        switch (config.videoQuality) {
            case 0: {
                this.mRecorderParams.a = 360;
                this.mRecorderParams.b = 640;
                this.mRecorderParams.d = 2000;
                UGCDataReport.reportDAU(1044);
                break;
            }
            case 1: {
                this.mRecorderParams.a = 480;
                this.mRecorderParams.b = 640;
                this.mRecorderParams.d = 3200;
                UGCDataReport.reportDAU(1045);
                break;
            }
            case 3: {
                this.mRecorderParams.a = 720;
                this.mRecorderParams.b = 1280;
                this.mRecorderParams.d = 7200;
                UGCDataReport.reportDAU(1046);
                break;
            }
            default: {
                this.mRecorderParams.a = 540;
                this.mRecorderParams.b = 960;
                this.mRecorderParams.d = 5200;
                UGCDataReport.reportDAU(1045);
            }
        }
        UGCDataReport.reportDAU(1048, this.mRecorderParams.d, "");
        this.mRecorderParams.c = 30;
        this.mRecorderParams.k = config.needEdit;
        this.mRecorderParams.f = config.isFront;
        this.mRecorderParams.g = config.touchFocus;
        this.mRecorderParams.l = this.recordProfileToVideoProfileType(config.profile);
        this.mRecorderParams.h = config.minDuration;
        this.mRecorderParams.i = config.maxDuration;
        this.mRecorderParams.m = true;
        this.mRecorderParams.n = true;
        this.mRecorderParams.o = true;
        if (config.needEdit) {
            this.mRecorderParams.e = 1;
            UGCRecorderJni uGCRecorderJni = this;
            this.mRecorderParams.d = uGCRecorderJni.getEditBitrateWithSize(uGCRecorderJni.mRecorderParams.a, this.mRecorderParams.b);
        }
        UGCDataReport.reportDAU(1049, this.mRecorderParams.c, "");
    }

    private d recordProfileToVideoProfileType(int recordProfile) {
        switch (recordProfile) {
            case 1: {
                return d.b;
            }
            case 2: {
                return d.c;
            }
        }
        return d.d;
    }

    public int startCameraSimplePreview(TXRecordCommon.TXUGCSimpleConfig config, TXCloudVideoView previewView) {
        this.initRecorderParams(config);
        UGCRecorderJni.nativeSetRecordParams(this.mNativeUGCRecorderJni, this.mRecorderParams);
        UGCRecorderJni.nativeSetView(this.mNativeUGCRecorderJni, new DisplayTarget(previewView));
        UGCRecorderJni.nativeEnableCameraAutoFocus(this.mNativeUGCRecorderJni, !this.mRecorderParams.g);
        UGCRecorderJni.nativeStartCamera(this.mNativeUGCRecorderJni, this.mRecorderParams.f);
        UGCRecorderJni.nativeEnableVideoCustomPreprocess(this.mNativeUGCRecorderJni, this.mCustomProcessListener != null);
        if (config.watermark != null) {
            UGCRecorderJni.nativeSetWatermark(this.mNativeUGCRecorderJni, config.watermark, config.watermarkX, config.watermarkY, config.watermark.getWidth());
        }
        this.mPreviewView = previewView;
        return 0;
    }

    private Size getVideoSize(int videoResolution) {
        Size size = new Size();
        switch (videoResolution) {
            case 0: {
                size.width = 360;
                size.height = 640;
                break;
            }
            case 1: {
                size.width = 480;
                size.height = 640;
                break;
            }
            case 3: {
                size.width = 720;
                size.height = 1280;
                break;
            }
            case 4: {
                size.width = 1080;
                size.height = 1920;
                break;
            }
            default: {
                size.width = 540;
                size.height = 960;
            }
        }
        return size;
    }

    private void initRecorderParams(TXRecordCommon.TXUGCCustomConfig config) {
        Size size = this.getVideoSize(config.videoResolution);
        if (config.enableHighResolutionCapture) {
            size.width = 1080;
            size.height = 1920;
        }
        this.mRecorderParams.a = size.width;
        this.mRecorderParams.b = size.height;
        this.mRecorderParams.d = config.videoBitrate;
        this.mRecorderParams.c = config.videoFps;
        this.mRecorderParams.e = config.videoGop;
        this.mRecorderParams.k = config.needEdit;
        this.mRecorderParams.f = config.isFront;
        this.mRecorderParams.g = config.touchFocus;
        this.mRecorderParams.l = this.recordProfileToVideoProfileType(config.profile);
        this.mRecorderParams.h = config.minDuration;
        this.mRecorderParams.i = config.maxDuration;
        this.mRecorderParams.j = config.audioSampleRate;
        this.mRecorderParams.m = config.enableAEC;
        this.mRecorderParams.n = config.enableAGC;
        this.mRecorderParams.o = config.enableANS;
        if (config.needEdit) {
            this.mRecorderParams.e = 1;
            UGCRecorderJni uGCRecorderJni = this;
            this.mRecorderParams.d = uGCRecorderJni.getEditBitrateWithSize(uGCRecorderJni.mRecorderParams.a, this.mRecorderParams.b);
        }
        switch (config.videoResolution) {
            case 0: {
                UGCDataReport.reportDAU(1044, 360, "360x640");
                break;
            }
            case 1: {
                UGCDataReport.reportDAU(1045, 480, "480x640");
                break;
            }
            case 3: {
                UGCDataReport.reportDAU(1046, 720, "720x1280");
                break;
            }
            case 4: {
                UGCDataReport.reportDAU(1047, 1080, "1080x1920");
                break;
            }
            default: {
                UGCDataReport.reportDAU(1045, 540, "540x960");
            }
        }
        UGCDataReport.reportDAU(1049, config.videoFps, "");
        UGCDataReport.reportDAU(1050, config.videoGop, "");
    }

    public int startCameraCustomPreview(TXRecordCommon.TXUGCCustomConfig config, TXCloudVideoView previewView) {
        this.initRecorderParams(config);
        UGCRecorderJni.nativeSetRecordParams(this.mNativeUGCRecorderJni, this.mRecorderParams);
        UGCRecorderJni.nativeSetView(this.mNativeUGCRecorderJni, new DisplayTarget(previewView));
        UGCRecorderJni.nativeEnableCameraAutoFocus(this.mNativeUGCRecorderJni, !this.mRecorderParams.g);
        UGCRecorderJni.nativeStartCamera(this.mNativeUGCRecorderJni, this.mRecorderParams.f);
        UGCRecorderJni.nativeEnableVideoCustomPreprocess(this.mNativeUGCRecorderJni, this.mCustomProcessListener != null);
        if (config.watermark != null) {
            UGCRecorderJni.nativeSetWatermark(this.mNativeUGCRecorderJni, config.watermark, config.watermarkX, config.watermarkY, config.watermark.getWidth());
        }
        this.mPreviewView = previewView;
        return 0;
    }

    public void setVideoResolution(int resolution) {
        Size size = this.getVideoSize(resolution);
        this.mRecorderParams.a = size.width;
        this.mRecorderParams.b = size.height;
        UGCRecorderJni.nativeSetRecordParams(this.mNativeUGCRecorderJni, this.mRecorderParams);
    }

    public void setVideoBitrate(int bitrate) {
        this.mRecorderParams.d = bitrate;
        UGCRecorderJni.nativeSetRecordParams(this.mNativeUGCRecorderJni, this.mRecorderParams);
    }

    public void stopCameraPreview() {
        UGCRecorderJni.nativeEnableVideoCustomPreprocess(this.mNativeUGCRecorderJni, false);
        UGCRecorderJni.nativeStopCamera(this.mNativeUGCRecorderJni);
        this.mPreviewView = null;
    }

    public TXUGCPartsManager getPartsManager() {
        return this.mTXUGCPartsManager;
    }

    public void setMute(boolean isMute) {
        UGCRecorderJni.nativeSetMute(this.mNativeUGCRecorderJni, isMute);
    }

    public int startRecord() {
        UGCDataReport.reportDAU(1002);
        return UGCRecorderJni.nativeStartRecord(this.mNativeUGCRecorderJni, this.mVideoFilePath, this.mVideoPartFolder, this.mCoverPath);
    }

    public int startRecord(String videoFilePath, String coverPath) {
        int n2 = this.checkRecordPath(videoFilePath, this.mVideoPartFolder, coverPath);
        if (n2 != 0) {
            return n2;
        }
        return UGCRecorderJni.nativeStartRecord(this.mNativeUGCRecorderJni, this.mVideoFilePath, this.mVideoPartFolder, this.mCoverPath);
    }

    public int startRecord(String videoFilePath, String videoPartFolder, String coverPath) {
        int n2 = this.checkRecordPath(videoFilePath, videoPartFolder, coverPath);
        if (n2 != 0) {
            return n2;
        }
        return UGCRecorderJni.nativeStartRecord(this.mNativeUGCRecorderJni, this.mVideoFilePath, this.mVideoPartFolder, this.mCoverPath);
    }

    public int pauseRecord() {
        return UGCRecorderJni.nativePauseRecord(this.mNativeUGCRecorderJni);
    }

    public int resumeRecord() {
        return UGCRecorderJni.nativeResumeRecord(this.mNativeUGCRecorderJni);
    }

    public int stopRecord() {
        return UGCRecorderJni.nativeStopRecord(this.mNativeUGCRecorderJni);
    }

    public void release() {
        this.setVoiceChangerType(0);
        this.setReverb(0);
        this.setRecordSpeed(2);
        this.stopBGM();
        this.stopCameraPreview();
        this.stopRecord();
    }

    public boolean switchCamera(boolean isFront) {
        return UGCRecorderJni.nativeSwitchCamera(this.mNativeUGCRecorderJni, isFront);
    }

    public boolean toggleTorch(boolean enable) {
        return UGCRecorderJni.nativeTurnOnTorch(this.mNativeUGCRecorderJni, enable);
    }

    public int getMaxZoom() {
        return UGCRecorderJni.nativeGetZoomLevel(this.mNativeUGCRecorderJni);
    }

    public boolean setZoom(int value) {
        return UGCRecorderJni.nativeSetZoomLevel(this.mNativeUGCRecorderJni, value);
    }

    public void setFocusPosition(float eventX, float eventY) {
        if (!this.mRecorderParams.g) {
            return;
        }
        UGCRecorderJni.nativeSetFocusPosition(this.mNativeUGCRecorderJni, eventX, eventY);
    }

    public void setAspectRatio(int displayType) {
        UGCRecorderJni.nativeSetAspectRatio(this.mNativeUGCRecorderJni, displayType);
        if (displayType == 0) {
            UGCDataReport.reportDAU(1055);
            return;
        }
        if (displayType == 1) {
            UGCDataReport.reportDAU(1042);
            return;
        }
        if (displayType == 2) {
            UGCDataReport.reportDAU(1041);
            return;
        }
        if (displayType == 3) {
            UGCDataReport.reportDAU(1043);
            return;
        }
        if (displayType == 4) {
            UGCDataReport.reportDAU(1056);
        }
    }

    public void setHomeOrientation(int homeOrientation) {
        UGCRecorderJni.nativeSetHomeOrientation(this.mNativeUGCRecorderJni, homeOrientation);
    }

    public void setVideoRenderMode(int renderMode) {
        UGCRecorderJni.nativeSetRenderMode(this.mNativeUGCRecorderJni, renderMode);
    }

    public void setRenderRotation(int renderRotation) {
        UGCRecorderJni.nativeSetRenderRotation(this.mNativeUGCRecorderJni, renderRotation);
    }

    public void setVideoRenderMirrorType(int mirrorType) {
        UGCRecorderJni.nativeSetRenderMirrorType(this.mNativeUGCRecorderJni, mirrorType);
    }

    public void setVideoEncoderMirror(boolean isMirror) {
        UGCRecorderJni.nativeSetVideoEncoderMirror(this.mNativeUGCRecorderJni, isMirror);
    }

    public void snapshot(TXRecordCommon.ITXSnapshotListener listener) {
        this.mSnapshotListener = listener;
        UGCRecorderJni.nativeSnapshot(this.mNativeUGCRecorderJni);
    }

    public void setRecordSpeed(int recordSpeed) {
        UGCRecorderJni.nativeSetRecordSpeed(this.mNativeUGCRecorderJni, recordSpeed);
        switch (recordSpeed) {
            case 3: {
                UGCDataReport.reportDAU(1051, recordSpeed, "FAST");
                return;
            }
            case 4: {
                UGCDataReport.reportDAU(1051, recordSpeed, "FASTEST");
                return;
            }
            case 2: {
                UGCDataReport.reportDAU(1051, recordSpeed, "NORMAL");
                return;
            }
            case 1: {
                UGCDataReport.reportDAU(1051, recordSpeed, "SLOW");
                return;
            }
            case 0: {
                UGCDataReport.reportDAU(1051, recordSpeed, "SLOWEST");
            }
        }
    }

    public void setVideoProcessListener(TXUGCRecord.VideoCustomProcessListener listener) {
        this.mCustomProcessListener = listener;
        UGCRecorderJni.nativeEnableVideoCustomPreprocess(this.mNativeUGCRecorderJni, this.mCustomProcessListener != null);
    }

    public boolean setMicVolume(float volume) {
        int n2 = (int)(volume * 100.0f);
        UGCRecorderJni.nativeSetMicVolume(this.mNativeUGCRecorderJni, n2);
        return true;
    }

    public void setReverb(int reverbType) {
        UGCRecorderJni.nativeSetReverbType(this.mNativeUGCRecorderJni, reverbType);
        UGCDataReport.reportDAU(1054, reverbType, "");
        UGCDataReport.reportDAU(1007);
    }

    public void setVoiceChangerType(int voiceChangerType) {
        UGCRecorderJni.nativeSetVoiceChangerType(this.mNativeUGCRecorderJni, voiceChangerType);
        UGCDataReport.reportDAU(1053, voiceChangerType, "");
    }

    public int setBGM(String path) {
        UGCDataReport.reportDAU(1052);
        return UGCRecorderJni.nativeSetBGMPath(this.mNativeUGCRecorderJni, path != null ? path : "");
    }

    public void setBGMLoop(boolean isLoop) {
        UGCRecorderJni.nativeSetBGMLoop(this.mNativeUGCRecorderJni, isLoop);
    }

    public void setBGMNotify(TXRecordCommon.ITXBGMNotify notify) {
        this.mBGMListener = notify;
        UGCRecorderJni.nativeEnableBGMNotify(this.mNativeUGCRecorderJni, this.mBGMListener != null);
    }

    public boolean playBGMFromTime(int startTime, int endTime) {
        UGCDataReport.reportDAU(1008);
        return UGCRecorderJni.nativePlayBGM(this.mNativeUGCRecorderJni, startTime, endTime);
    }

    public boolean pauseBGM() {
        return UGCRecorderJni.nativePauseBGM(this.mNativeUGCRecorderJni);
    }

    public boolean resumeBGM() {
        return UGCRecorderJni.nativeResumeBGM(this.mNativeUGCRecorderJni);
    }

    public boolean stopBGM() {
        return UGCRecorderJni.nativeStopBGM(this.mNativeUGCRecorderJni);
    }

    public boolean seekBGM(int startTime, int endTime) {
        return UGCRecorderJni.nativePlayBGM(this.mNativeUGCRecorderJni, startTime, endTime);
    }

    public boolean setBGMVolume(float volume) {
        return UGCRecorderJni.nativeSetBGMVolume(this.mNativeUGCRecorderJni, (int)(volume * 100.0f));
    }

    public int getMusicDuration(String path) {
        return UGCRecorderJni.nativeGetMusicDuration(this.mNativeUGCRecorderJni, path != null ? path : "");
    }

    public void setWatermark(Bitmap watermark, TXVideoEditConstants.TXRect rect) {
        UGCRecorderJni.nativeSetWatermark(this.mNativeUGCRecorderJni, watermark, rect.x, rect.y, rect.width);
    }

    public TXBeautyManager getBeautyManager() {
        return this.mBeautyManager;
    }

    public void setMotionTmpl(String tmplPath) {
        this.mBeautyManager.setMotionTmpl(tmplPath != null ? tmplPath : "");
    }

    public void setMotionMute(boolean motionMute) {
        this.mBeautyManager.setMotionMute(motionMute);
    }

    public void setGreenScreenFile(String path, boolean isLoop) {
        this.mBeautyManager.setGreenScreenFile(path != null ? path : "");
    }

    public void setFaceVLevel(int level) {
        this.mBeautyManager.setFaceVLevel(level);
    }

    public void setFaceShortLevel(int level) {
        this.mBeautyManager.setFaceShortLevel(level);
    }

    public void setChinLevel(int level) {
        this.mBeautyManager.setChinLevel(level);
    }

    public void setNoseSlimLevel(int level) {
        this.mBeautyManager.setNoseSlimLevel(level);
    }

    public void setEyeScaleLevel(float level) {
        this.mBeautyManager.setEyeScaleLevel(level);
    }

    public void setFaceScaleLevel(float level) {
        this.mBeautyManager.setFaceSlimLevel(level);
    }

    public void setBeautyStyle(int style) {
        this.mBeautyManager.setBeautyStyle(style);
    }

    public void setBeautyDepth(int style, int beautyDepth, int whiteningDepth, int ruddyDepth) {
        this.mBeautyManager.setBeautyStyle(style);
        this.mBeautyManager.setBeautyLevel(beautyDepth);
        this.mBeautyManager.setWhitenessLevel(whiteningDepth);
        this.mBeautyManager.setRuddyLevel(ruddyDepth);
    }

    public void setFilter(Bitmap filterImage) {
        this.mBeautyManager.setFilter(filterImage);
    }

    public void setFilter(Bitmap leftBitmap, float leftIntensity, Bitmap rightBitmap, float rightIntensity, float leftRatio) {
        UGCRecorderJni.nativeSetFilter(this.mNativeUGCRecorderJni, leftBitmap, leftIntensity, rightBitmap, rightIntensity, leftRatio);
    }

    public void setSpecialRatio(float specialRatio) {
        this.mBeautyManager.setFilterStrength(specialRatio);
    }

    private int checkRecordPath(String videoFilePath, String videoPartFolder, String coverPath) {
        File file;
        if (TextUtils.isEmpty((CharSequence)videoFilePath)) {
            LiteavLog.e(TAG, "startRecord: init videoRecord failed, videoFilePath is empty");
            return -2;
        }
        this.mVideoFilePath = videoFilePath;
        File file2 = new File(videoFilePath);
        if (file2.exists()) {
            file2.delete();
        }
        if (!TextUtils.isEmpty((CharSequence)coverPath)) {
            this.mCoverPath = coverPath;
        }
        if (!TextUtils.isEmpty((CharSequence)videoPartFolder)) {
            this.mVideoPartFolder = videoPartFolder;
        }
        if (!(file = new File(this.mVideoPartFolder)).exists()) {
            file.mkdirs();
        }
        return 0;
    }

    private void initFileAndFolder() {
        File file;
        String string = this.getDefaultDir();
        this.mVideoFilePath = string + File.separator + OUTPUT_VIDEO_NAME;
        this.mCoverPath = string + File.separator + OUTPUT_VIDEO_COVER_NAME;
        this.mVideoPartFolder = string + File.separator + OUTPUT_TEMP_DIR_NAME;
        File file2 = new File(this.mVideoPartFolder);
        if (!file2.exists()) {
            file2.mkdir();
        }
        if ((file = new File(this.mVideoFilePath)).exists()) {
            file.delete();
        }
    }

    private String getDefaultDir() {
        File file = f.a(this.mContext, OUTPUT_DIR_NAME);
        if (file == null) {
            file = this.mContext.getFilesDir();
        }
        if (file != null) {
            return file.getPath();
        }
        return "";
    }

    private void createThumbFile(String videoPath, String coverPath) {
        if (TextUtils.isEmpty((CharSequence)videoPath) || TextUtils.isEmpty((CharSequence)coverPath)) {
            return;
        }
        Bitmap bitmap = TXVideoInfoReader.getInstance(this.mContext).getSampleImage(0L, videoPath);
        if (bitmap == null) {
            return;
        }
        FileOutputStream fileOutputStream = null;
        try {
            File file = new File(coverPath);
            if (file.exists()) {
                file.delete();
            }
            fileOutputStream = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fileOutputStream);
            fileOutputStream.flush();
        }
        catch (Exception exception) {
            f.a(fileOutputStream);
            return;
        }
        catch (Throwable throwable) {
            f.a(fileOutputStream);
            throw throwable;
        }
        f.a(fileOutputStream);
        return;
    }

    private int getEditBitrateWithSize(int videoWidth, int videoHeight) {
        if (videoWidth <= 640 && videoHeight <= 640) {
            return 2000;
        }
        if (videoWidth <= 960 && videoHeight <= 960) {
            return 5200;
        }
        if (videoWidth <= 1280 && videoHeight <= 1280) {
            return 7200;
        }
        return 12000;
    }

    public void onBGMStart() {
        TXRecordCommon.ITXBGMNotify iTXBGMNotify = this.mBGMListener;
        if (iTXBGMNotify != null) {
            iTXBGMNotify.onBGMStart();
        }
    }

    public void onBGMProgress(long progress, long duration) {
        TXRecordCommon.ITXBGMNotify iTXBGMNotify = this.mBGMListener;
        if (iTXBGMNotify != null) {
            iTXBGMNotify.onBGMProgress(progress, duration);
        }
    }

    public void onBGMComplete(int err) {
        TXRecordCommon.ITXBGMNotify iTXBGMNotify = this.mBGMListener;
        if (iTXBGMNotify != null) {
            iTXBGMNotify.onBGMComplete(err);
        }
    }

    public void onRecordEvent(int event) {
        TXRecordCommon.ITXVideoRecordListener iTXVideoRecordListener = this.mVideoRecordListener;
        if (iTXVideoRecordListener != null) {
            Bundle bundle = new Bundle();
            iTXVideoRecordListener.onRecordEvent(event, bundle);
        }
    }

    public void onRecordProgress(long milliSecond) {
        TXRecordCommon.ITXVideoRecordListener iTXVideoRecordListener = this.mVideoRecordListener;
        if (iTXVideoRecordListener != null) {
            iTXVideoRecordListener.onRecordProgress(milliSecond);
        }
    }

    public void onRecordComplete(int code, String msg, String videoPath, String coverPath) {
        TXRecordCommon.ITXVideoRecordListener iTXVideoRecordListener = this.mVideoRecordListener;
        if (iTXVideoRecordListener != null) {
            this.createThumbFile(videoPath, coverPath);
            ThreadUtils.getUiThreadHandler().post(fb.a(code, msg, videoPath, coverPath, iTXVideoRecordListener));
        }
    }

    public int onPreprocessVideoFrame(int srcTextureId, int width, int height) {
        TXUGCRecord.VideoCustomProcessListener videoCustomProcessListener = this.mCustomProcessListener;
        int n2 = -1;
        if (videoCustomProcessListener != null) {
            n2 = videoCustomProcessListener.onTextureCustomProcess(srcTextureId, width, height);
        }
        return n2;
    }

    public void onGLContextDestroy() {
        TXUGCRecord.VideoCustomProcessListener videoCustomProcessListener = this.mCustomProcessListener;
        if (videoCustomProcessListener != null) {
            videoCustomProcessListener.onTextureDestroyed();
        }
    }

    public void onSnapshot(Bitmap bmp) {
        TXRecordCommon.ITXSnapshotListener iTXSnapshotListener = this.mSnapshotListener;
        if (iTXSnapshotListener != null) {
            iTXSnapshotListener.onSnapshot(bmp);
        }
    }

    private static native long nativeCreate(UGCRecorderJni var0);

    private static native void nativeDestroy(long var0);

    private static native long nativeCreateBeautyManager(long var0);

    private static native long nativeCreatePartsManager(long var0);

    private static native void nativeSetRecordParams(long var0, RecordParams var2);

    private static native void nativeSetHomeOrientation(long var0, int var2);

    private static native void nativeSetView(long var0, DisplayTarget var2);

    private static native void nativeStartCamera(long var0, boolean var2);

    private static native void nativeStopCamera(long var0);

    private static native int nativeStartRecord(long var0, String var2, String var3, String var4);

    private static native int nativePauseRecord(long var0);

    private static native int nativeResumeRecord(long var0);

    private static native int nativeStopRecord(long var0);

    private static native void nativeSetRenderRotation(long var0, int var2);

    private static native void nativeSetRenderMirrorType(long var0, int var2);

    private static native void nativeSetVideoEncoderMirror(long var0, boolean var2);

    private static native void nativeSetRenderMode(long var0, int var2);

    private static native void nativeSetWatermark(long var0, Bitmap var2, float var3, float var4, float var5);

    private static native void nativeSetFilter(long var0, Bitmap var2, float var3, Bitmap var4, float var5, float var6);

    private static native boolean nativeSwitchCamera(long var0, boolean var2);

    private static native boolean nativeTurnOnTorch(long var0, boolean var2);

    private static native boolean nativeSetZoomLevel(long var0, int var2);

    private static native int nativeGetZoomLevel(long var0);

    private static native void nativeEnableCameraAutoFocus(long var0, boolean var2);

    private static native void nativeSetFocusPosition(long var0, float var2, float var3);

    private static native void nativeSetAspectRatio(long var0, int var2);

    private static native void nativeSetRecordSpeed(long var0, int var2);

    private static native void nativeSetMicVolume(long var0, int var2);

    private static native void nativeSetReverbType(long var0, int var2);

    private static native void nativeSetVoiceChangerType(long var0, int var2);

    public static native void nativeSetMute(long var0, boolean var2);

    private static native int nativeSetBGMPath(long var0, String var2);

    private static native void nativeSetBGMLoop(long var0, boolean var2);

    private static native void nativeEnableBGMNotify(long var0, boolean var2);

    private static native boolean nativePlayBGM(long var0, int var2, int var3);

    private static native boolean nativePauseBGM(long var0);

    private static native boolean nativeResumeBGM(long var0);

    private static native boolean nativeStopBGM(long var0);

    private static native boolean nativeSetBGMVolume(long var0, int var2);

    private static native int nativeGetMusicDuration(long var0, String var2);

    private static native void nativeSnapshot(long var0);

    private static native void nativeEnableVideoCustomPreprocess(long var0, boolean var2);

    static /* synthetic */ void lambda$onRecordComplete$0(int code, String msg, String videoPath, String coverPath, TXRecordCommon.ITXVideoRecordListener listener) {
        TXRecordCommon.TXRecordResult tXRecordResult = new TXRecordCommon.TXRecordResult();
        new TXRecordCommon.TXRecordResult().retCode = code;
        tXRecordResult.descMsg = msg;
        tXRecordResult.videoPath = videoPath;
        tXRecordResult.coverPath = coverPath;
        listener.onRecordComplete(tXRecordResult);
    }

    static {
        SoLoader.loadAllLibraries();
    }

    static class RecordParams {
        public int a = 540;
        public int b = 960;
        public int c = 20;
        public int d = 1800;
        public int e = 3;
        public boolean f = true;
        public boolean g = false;
        public int h = 5000;
        public int i = 60000;
        public int j = 48000;
        public boolean k = true;
        public d l = com.tencent.liteav.videobase.common.d.d;
        public boolean m = true;
        public boolean n = true;
        public boolean o = true;

        RecordParams() {
        }

        public int getVideoWidth() {
            return this.a;
        }

        public int getVideoHeight() {
            return this.b;
        }

        public int getVideoFps() {
            return this.c;
        }

        public int getVideoBitrate() {
            return this.d;
        }

        public int getVideoGop() {
            return this.e;
        }

        public int getVideoProfile() {
            return this.l.mValue;
        }

        public int getAudioSampleRate() {
            return this.j;
        }

        public int getMaxDuration() {
            return this.i;
        }

        public int getMinDuration() {
            return this.h;
        }

        public boolean isFullIFrame() {
            return this.k;
        }

        public boolean enableAEC() {
            return this.m;
        }

        public boolean enableAGC() {
            return this.n;
        }

        public boolean enableANS() {
            return this.o;
        }
    }
}

