/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import android.graphics.Bitmap;
import android.os.HandlerThread;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.h;
import com.tencent.ugc.AudioFrame;
import com.tencent.ugc.Clip;
import com.tencent.ugc.GlobalContextManager;
import com.tencent.ugc.TXVideoEditConstants;
import com.tencent.ugc.TXVideoJoiner;
import com.tencent.ugc.UGCAudioFrameProvider;
import com.tencent.ugc.UGCFrameQueue;
import com.tencent.ugc.UGCImageProvider;
import com.tencent.ugc.UGCMultiFileAudioFrameProvider;
import com.tencent.ugc.UGCMultiFilePixelFrameProvider;
import com.tencent.ugc.UGCPixelFrameProvider;
import com.tencent.ugc.UGCSingleFileAudioFrameProvider;
import com.tencent.ugc.UGCSingleFilePixelFrameProvider;
import com.tencent.ugc.dn;
import com.tencent.ugc.do;
import com.tencent.ugc.dp;
import com.tencent.ugc.dq;
import com.tencent.ugc.dr;
import com.tencent.ugc.ds;
import com.tencent.ugc.dt;
import com.tencent.ugc.du;
import com.tencent.ugc.dv;
import com.tencent.ugc.dw;
import com.tencent.ugc.dx;
import com.tencent.ugc.dy;
import com.tencent.ugc.dz;
import com.tencent.ugc.ea;
import com.tencent.ugc.eb;
import com.tencent.ugc.ec;
import com.tencent.ugc.ed;
import com.tencent.ugc.ee;
import com.tencent.ugc.ef;
import com.tencent.ugc.eg;
import com.tencent.ugc.eh;
import com.tencent.ugc.ei;
import com.tencent.ugc.ej;
import com.tencent.ugc.ek;
import com.tencent.ugc.el;
import com.tencent.ugc.em;
import com.tencent.ugc.en;
import com.tencent.ugc.eo;
import com.tencent.ugc.ep;
import com.tencent.ugc.eq;
import com.tencent.ugc.er;
import com.tencent.ugc.es;
import com.tencent.ugc.retriver.FFmpegMediaRetriever;
import com.tencent.ugc.videobase.egl.EGLCore;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import com.tencent.ugc.videobase.frame.PixelFrame;
import com.tencent.ugc.videobase.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class UGCMediaListSource {
    public static final int SEEK_TIME_OUT = 1000;
    private static final int MAX_FRAME_SIZE = 5;
    private static final int READ_FRAME_TIME_OUT_MS = 5;
    private final String mTAG;
    private final List<Clip> mClipList;
    private final List<a> mMediaInfoList;
    private final UGCFrameQueue<List<PixelFrame>> mPixelFrameListQueue;
    private final UGCFrameQueue<List<AudioFrame>> mAudioFrameListQueue;
    private final List<PixelFrame> mTailPixelFrameList;
    private final AtomicInteger mCountOfPendingResetInputData = new AtomicInteger();
    private final AtomicReference<Long> mPendingSeekTime = new AtomicReference();
    private UGCPixelFrameProvider mCurrentPixelFrameProvider;
    private UGCPixelFrameProvider mNextPixelFrameProvider;
    private UGCAudioFrameProvider mCurrentAudioFrameProvider;
    private int mCurrentVideoClipIndex = 0;
    private int mCurrentAudioClipIndex = 0;
    private int mNextVideoClipIndex = 0;
    private long mVideoSeekTimeInClip = -1L;
    private long mAudioSeekTimeInClip = -1L;
    private long mLastVideoFrameTimestamp = -1L;
    private long mLastAudioFrameTimestamp = -1L;
    private boolean mIsSplitScreenMode = false;
    private CustomHandler mWorkHandler;
    private List<String> mSources;
    private List<Bitmap> mBitmapList;
    private int mFps = 20;
    private int mTransitionType = 1;
    private List<TXVideoEditConstants.TXRepeat> mRepeatList;
    private List<TXVideoEditConstants.TXSpeed> mSpeedList;
    private long mSourceRangeStart = 0L;
    private long mSourceRangeEnd = Integer.MAX_VALUE;
    private long mTotalDuration = 0L;
    private long mTailWaterMarkDurationMs = 0L;
    private boolean mIsPreciseSeek = true;
    private boolean mIsReverse = false;
    private boolean mNeedAudioSource = false;
    private int mMaxBufferFrame = 3;
    private CustomHandler mAudioHandler;
    private CustomHandler mVideoHandler;
    private FutureTask<Long> mCalculateDurationTask;
    private FutureTask<Boolean> mHasAudioDataTask;
    private long mPlayEndTime = Long.MAX_VALUE;
    private TXVideoJoiner.DurationControlMode mDurationControlMode = TXVideoJoiner.DurationControlMode.ALIGNS_TO_LONGEST;
    private EGLCore mEGLCore;

    public UGCMediaListSource() {
        this.mClipList = new ArrayList<Clip>();
        this.mMediaInfoList = new ArrayList<a>();
        this.mPixelFrameListQueue = new UGCFrameQueue();
        this.mAudioFrameListQueue = new UGCFrameQueue();
        this.mTailPixelFrameList = new ArrayList<PixelFrame>();
        this.mTAG = "UGCMediaListSource_" + this.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        LiteavLog.i(this.mTAG, "initialize");
        UGCMediaListSource uGCMediaListSource = this;
        synchronized (uGCMediaListSource) {
            if (this.mWorkHandler != null) {
                LiteavLog.w(this.mTAG, "UGCMediaStreamSpliter is initialized");
                return;
            }
            HandlerThread handlerThread = new HandlerThread("ugc-media-list-source");
            handlerThread.start();
            this.mWorkHandler = new CustomHandler(handlerThread.getLooper());
            return;
        }
    }

    public void uninitialize() {
        LiteavLog.i(this.mTAG, "unInitialize");
        UGCMediaListSource uGCMediaListSource = this;
        uGCMediaListSource.runOnWorkThread(dn.a(uGCMediaListSource));
    }

    private void uninitializeInternal() {
        this.clearFrameQueue();
        this.clearTailPixelFrameQueue();
        this.closeCurrentPixelFrameProvider();
        this.closeNextPixelFrameProvider();
        this.closeCurrentAudioFrameProvider();
        if (this.mVideoHandler != null) {
            this.mVideoHandler.quitLooper();
            this.mVideoHandler = null;
        }
        if (this.mAudioHandler != null) {
            this.mAudioHandler.quitLooper();
            this.mAudioHandler = null;
        }
        EGLCore.destroy(this.mEGLCore);
        this.mEGLCore = null;
        this.mClipList.clear();
        this.mMediaInfoList.clear();
        this.mSources = null;
        this.mRepeatList = null;
        this.mSpeedList = null;
        this.mSourceRangeStart = 0L;
        this.mSourceRangeEnd = Integer.MAX_VALUE;
        this.mCurrentVideoClipIndex = 0;
        this.mCurrentAudioClipIndex = 0;
        this.mVideoSeekTimeInClip = -1L;
        this.mAudioSeekTimeInClip = -1L;
        this.mLastAudioFrameTimestamp = -1L;
        this.mLastVideoFrameTimestamp = -1L;
        this.mIsReverse = false;
        this.mNextVideoClipIndex = 0;
        if (this.mWorkHandler != null) {
            this.mWorkHandler.quitLooper();
            this.mWorkHandler = null;
        }
    }

    public void setVideoSources(List<String> sources) {
        LiteavLog.i(this.mTAG, "setVideoSources");
        FutureTask futureTask = new FutureTask(dy.a(this));
        this.mHasAudioDataTask = futureTask;
        FutureTask futureTask2 = new FutureTask(ej.a(this));
        this.mCalculateDurationTask = futureTask2;
        this.mCountOfPendingResetInputData.incrementAndGet();
        UGCMediaListSource uGCMediaListSource = this;
        uGCMediaListSource.runOnWorkThread(en.a(uGCMediaListSource, sources, futureTask, futureTask2));
    }

    private void setVideoSourcesInternal(List<String> sources) {
        this.resetReadPositionInternal();
        this.mSources = sources;
        this.mMediaInfoList.clear();
        this.clearFrameQueue();
        this.mTotalDuration = 0L;
        for (String string : sources) {
            a a2 = UGCMediaListSource.getMediaInfo(string);
            LiteavLog.i(this.mTAG, string + " get media Info. duration = " + a2.b);
            a2.a = this.mTotalDuration;
            a2.e = string;
            this.mTotalDuration += a2.b;
            this.mMediaInfoList.add(a2);
        }
        this.mSourceRangeStart = 0L;
        this.mSourceRangeEnd = this.mTotalDuration;
        this.updateClipsInfo();
    }

    private void updateClipsInfo() {
        LiteavLog.i(this.mTAG, "updateClipsInfo");
        if (this.mSources == null || this.mSources.isEmpty()) {
            return;
        }
        this.mClipList.clear();
        if (this.mSources.size() > 1) {
            this.cutMultipleFileToClips();
        } else {
            this.cutSingleVideoFileToClips();
        }
        for (Clip clip : this.mClipList) {
            this.updateSpeedInfoToClips(clip);
        }
        this.updateTimelineToClips();
    }

    private void cutMultipleFileToClips() {
        for (a a2 : this.mMediaInfoList) {
            this.addClipToList(0L, a2.b, a2);
        }
    }

    private void cutSingleVideoFileToClips() {
        long l2;
        long l3 = this.mSourceRangeStart;
        if (this.mRepeatList != null && !this.mRepeatList.isEmpty()) {
            Collections.sort(this.mRepeatList, eo.a());
            for (TXVideoEditConstants.TXRepeat tXRepeat : this.mRepeatList) {
                if (this.isInvalidRepeat(tXRepeat)) continue;
                long l4 = tXRepeat.endTime;
                if (l4 > this.mSourceRangeEnd) {
                    l4 = this.mSourceRangeEnd;
                }
                this.addClipToList(l3, l4, this.mMediaInfoList.get(0));
                for (int i2 = 0; i2 < tXRepeat.repeatTimes - 1; ++i2) {
                    this.addClipToList(tXRepeat.startTime, l4, this.mMediaInfoList.get(0));
                }
                l3 = l4;
            }
        }
        if ((l2 = this.mTotalDuration) > this.mSourceRangeEnd) {
            l2 = this.mSourceRangeEnd;
        }
        if (l3 < l2) {
            this.addClipToList(l3, l2, this.mMediaInfoList.get(0));
        }
    }

    private void addClipToList(long startTime, long endTime, a mediaInfo) {
        if (startTime >= endTime) {
            return;
        }
        Clip clip = new Clip();
        new Clip().startInFileTime = startTime;
        clip.endInFileTime = endTime;
        clip.path = mediaInfo.e;
        clip.fps = mediaInfo.d;
        clip.videoMimeType = mediaInfo.f;
        this.mClipList.add(clip);
    }

    private boolean isInvalidRepeat(TXVideoEditConstants.TXRepeat repeat) {
        return repeat.repeatTimes <= 0 || repeat.startTime >= repeat.endTime || repeat.startTime > this.mSourceRangeEnd || repeat.endTime < this.mSourceRangeStart;
    }

    private void updateSpeedInfoToClips(Clip clip) {
        if (this.mSpeedList == null || this.mSpeedList.isEmpty()) {
            return;
        }
        Collections.sort(this.mSpeedList, ep.a());
        ArrayList<TXVideoEditConstants.TXSpeed> arrayList = new ArrayList<TXVideoEditConstants.TXSpeed>();
        long l2 = clip.startInFileTime;
        for (TXVideoEditConstants.TXSpeed tXSpeed : this.mSpeedList) {
            long l3 = tXSpeed.startTime - clip.startInSourceListTimeline;
            long l4 = tXSpeed.endTime - clip.startInSourceListTimeline;
            if (l4 < clip.startInFileTime) continue;
            if (l3 > clip.endInFileTime || l2 >= clip.endInFileTime) break;
            if (l3 > l2) {
                arrayList.add(this.createTXSpeed(l2, l3, 2));
                l2 = l3;
            }
            TXVideoEditConstants.TXSpeed tXSpeed2 = this.createTXSpeed(l2, l4, tXSpeed.speedLevel);
            if (tXSpeed2.endTime > clip.endInFileTime) {
                tXSpeed2.endTime = clip.endInFileTime;
            }
            arrayList.add(tXSpeed2);
            l2 = tXSpeed2.endTime;
        }
        if (l2 != clip.endInFileTime) {
            arrayList.add(this.createTXSpeed(l2, clip.endInFileTime, 2));
        }
        clip.speedList = arrayList;
    }

    private TXVideoEditConstants.TXSpeed createTXSpeed(long startTime, long endTime, int speedLevel) {
        TXVideoEditConstants.TXSpeed tXSpeed = new TXVideoEditConstants.TXSpeed();
        new TXVideoEditConstants.TXSpeed().startTime = startTime;
        tXSpeed.endTime = endTime;
        tXSpeed.speedLevel = speedLevel;
        return tXSpeed;
    }

    private void updateTimelineToClips() {
        long l2 = 0L;
        long l3 = 0L;
        for (Clip clip : this.mClipList) {
            var5_3.next().startInClipsTimeline = l2;
            clip.startTimelineNoSpeed = l3;
            if (this.mIsSplitScreenMode) continue;
            l2 += this.getClipDuration(clip);
            l3 += clip.endInFileTime - clip.startInFileTime;
        }
    }

    private boolean hasAudioDataInternal() {
        Iterator<a> iterator = this.mMediaInfoList.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().c) continue;
            return true;
        }
        return false;
    }

    private long calculateTotalDurationOfClips() {
        if (this.isImageSource()) {
            return this.getImageDuration();
        }
        long l2 = 0L;
        if (this.mIsSplitScreenMode) {
            long l3;
            if (this.mDurationControlMode == TXVideoJoiner.DurationControlMode.ALIGNS_TO_LONGEST) {
                UGCMediaListSource uGCMediaListSource = this;
                l3 = uGCMediaListSource.getMaxClipDuration(uGCMediaListSource.mClipList);
            } else {
                UGCMediaListSource uGCMediaListSource = this;
                l3 = uGCMediaListSource.getMinClipDuration(uGCMediaListSource.mClipList);
            }
            l2 = l3;
        } else {
            for (Clip clip : this.mClipList) {
                l2 += this.getClipDuration(clip);
            }
            long l4 = this.mSourceRangeEnd - this.mSourceRangeStart;
            l2 = l4 < l2 ? l4 : l2;
        }
        return l2;
    }

    private long getMaxClipDuration(List<Clip> clipList) {
        long l2 = 0L;
        for (Clip clip : clipList) {
            if (l2 >= this.getClipDuration(clip)) continue;
            l2 = this.getClipDuration(clip);
        }
        return l2;
    }

    private long getMinClipDuration(List<Clip> clipList) {
        long l2 = Integer.MAX_VALUE;
        for (Clip clip : clipList) {
            if (l2 <= this.getClipDuration(clip)) continue;
            l2 = this.getClipDuration(clip);
        }
        return l2;
    }

    private long getClipDuration(Clip clip) {
        if (clip.speedList == null) {
            return clip.endInFileTime - clip.startInFileTime;
        }
        long l2 = 0L;
        for (TXVideoEditConstants.TXSpeed tXSpeed : clip.speedList) {
            l2 = (long)((float)l2 + (float)(tXSpeed.endTime - tXSpeed.startTime) / UGCMediaListSource.getSpeed(tXSpeed.speedLevel));
        }
        return l2;
    }

    public void setDurationControlMode(TXVideoJoiner.DurationControlMode durationControlMode) {
        LiteavLog.i(this.mTAG, "set duration control mode " + (Object)((Object)this.mDurationControlMode));
        FutureTask futureTask = new FutureTask(eq.a(this));
        this.mCalculateDurationTask = futureTask;
        UGCMediaListSource uGCMediaListSource = this;
        uGCMediaListSource.runOnWorkThread(er.a(uGCMediaListSource, durationControlMode, futureTask));
    }

    public void setIsSplitScreenMode(boolean isSplitScreenMode) {
        LiteavLog.i(this.mTAG, "Set split screen mode is ".concat(String.valueOf(isSplitScreenMode)));
        FutureTask futureTask = new FutureTask(es.a(this));
        this.mCalculateDurationTask = futureTask;
        this.mCountOfPendingResetInputData.incrementAndGet();
        UGCMediaListSource uGCMediaListSource = this;
        uGCMediaListSource.runOnWorkThread(do.a(uGCMediaListSource, isSplitScreenMode, futureTask));
    }

    public void setVideoSourceRange(long startTime, long endTime) {
        LiteavLog.i(this.mTAG, "setVideoSourceRange startTime = " + startTime + " endTime = " + endTime);
        FutureTask futureTask = new FutureTask(dp.a(this));
        this.mCalculateDurationTask = futureTask;
        this.mCountOfPendingResetInputData.incrementAndGet();
        UGCMediaListSource uGCMediaListSource = this;
        uGCMediaListSource.runOnWorkThread(dq.a(uGCMediaListSource, startTime, endTime, futureTask));
    }

    public void setPictureList(List<Bitmap> bitmapList, int fps) {
        LiteavLog.i(this.mTAG, "setPictureList bitmapList size = " + bitmapList.size() + " fps = " + fps);
        this.mCountOfPendingResetInputData.incrementAndGet();
        UGCMediaListSource uGCMediaListSource = this;
        uGCMediaListSource.runOnWorkThread(dr.a(uGCMediaListSource, bitmapList, fps));
    }

    public void setPictureTransition(int type) {
        LiteavLog.i(this.mTAG, "setPictureTransition type = ".concat(String.valueOf(type)));
        FutureTask futureTask = new FutureTask(ds.a(this));
        this.mCalculateDurationTask = futureTask;
        this.mCountOfPendingResetInputData.incrementAndGet();
        UGCMediaListSource uGCMediaListSource = this;
        uGCMediaListSource.runOnWorkThread(dt.a(uGCMediaListSource, type, futureTask));
    }

    public List<AudioFrame> readNextAudioFrame() {
        if (this.isResettingInputData()) {
            this.mAudioFrameListQueue.clear();
        }
        UGCMediaListSource uGCMediaListSource = this;
        uGCMediaListSource.runOnWorkThread(du.a(uGCMediaListSource));
        return this.mAudioFrameListQueue.dequeue();
    }

    public List<PixelFrame> readNextVideoFrame() {
        if (this.isResettingInputData()) {
            this.clearVideoFrameQueue();
        }
        UGCMediaListSource uGCMediaListSource = this;
        uGCMediaListSource.runOnWorkThread(dv.a(uGCMediaListSource));
        return this.mPixelFrameListQueue.dequeue();
    }

    public void seekTo(long timeline) {
        LiteavLog.i(this.mTAG, "seekTo lineTime = ".concat(String.valueOf(timeline)));
        this.seekTo(timeline, true);
    }

    public void setPlayEndTime(long endPts) {
        UGCMediaListSource uGCMediaListSource = this;
        uGCMediaListSource.runOnWorkThread(dw.a(uGCMediaListSource, endPts));
    }

    public void impreciseSeekTo(long timeline) {
        LiteavLog.i(this.mTAG, "impreciseSeekTo lineTime = ".concat(String.valueOf(timeline)));
        this.seekTo(timeline, false);
    }

    private void seekTo(long timeline, boolean isPreciseSeek) {
        if (timeline < 0L) {
            return;
        }
        this.mPendingSeekTime.set(timeline);
        UGCMediaListSource uGCMediaListSource = this;
        uGCMediaListSource.runOnWorkThread(dx.a(uGCMediaListSource, isPreciseSeek));
    }

    public void setNeedAudioSource(boolean needAudioSource) {
        this.mNeedAudioSource = needAudioSource;
    }

    private void seekToInternal(long timeline, boolean isPreciseSeek) {
        timeline = h.a(timeline, 0L, this.mTotalDuration);
        if (this.isImageSource()) {
            this.seekToInternalWithImageSource(timeline);
            return;
        }
        if (this.mClipList.isEmpty()) {
            return;
        }
        this.mLastAudioFrameTimestamp = -1L;
        this.mLastVideoFrameTimestamp = -1L;
        if (this.mIsSplitScreenMode) {
            this.mVideoSeekTimeInClip = timeline;
            this.mAudioSeekTimeInClip = timeline;
            this.clearFrameQueue();
            this.clearTailPixelFrameQueue();
            return;
        }
        int n2 = -1;
        for (int i2 = 0; i2 < this.mClipList.size(); ++i2) {
            Clip clip = this.mClipList.get(i2);
            long l2 = clip.endInFileTime - clip.startInFileTime;
            if (clip.startInClipsTimeline + l2 < timeline) continue;
            n2 = i2;
            break;
        }
        this.mVideoSeekTimeInClip = n2 >= 0 ? timeline - this.mClipList.get((int)n2).startInClipsTimeline : timeline;
        this.mAudioSeekTimeInClip = this.mVideoSeekTimeInClip;
        if (this.mIsReverse) {
            this.mAudioSeekTimeInClip = this.mTotalDuration - this.mVideoSeekTimeInClip;
        }
        this.mIsPreciseSeek = isPreciseSeek;
        if (this.mCurrentVideoClipIndex != n2) {
            this.closeCurrentPixelFrameProvider();
        }
        if (this.mCurrentAudioClipIndex != n2) {
            this.closeCurrentAudioFrameProvider();
        }
        this.mCurrentVideoClipIndex = n2;
        this.mCurrentAudioClipIndex = n2;
        this.mLastVideoFrameTimestamp = -1L;
        this.mLastAudioFrameTimestamp = -1L;
        this.clearFrameQueue();
        this.clearTailPixelFrameQueue();
        this.loadNextVideoFrameInternal(0L);
        if (this.mNeedAudioSource) {
            this.loadNextAudioFrameInternal(0L);
        }
    }

    private void seekToInternalWithImageSource(long timeline) {
        this.mCurrentVideoClipIndex = 0;
        this.mVideoSeekTimeInClip = timeline;
        this.mLastVideoFrameTimestamp = -1L;
        this.mLastAudioFrameTimestamp = -1L;
        this.clearFrameQueue();
        this.clearTailPixelFrameQueue();
        this.loadNextVideoFrameInternal(0L);
    }

    private void resetReadPositionInternal() {
        this.clearFrameQueue();
        this.clearTailPixelFrameQueue();
        this.closeCurrentPixelFrameProvider();
        this.closeCurrentAudioFrameProvider();
        this.mCurrentVideoClipIndex = 0;
        this.mCurrentAudioClipIndex = 0;
        this.mVideoSeekTimeInClip = -1L;
        this.mAudioSeekTimeInClip = -1L;
        this.mLastAudioFrameTimestamp = -1L;
        this.mLastVideoFrameTimestamp = -1L;
    }

    public void setRepeatPlay(List<TXVideoEditConstants.TXRepeat> repeatList) {
        LiteavLog.i(this.mTAG, "setRepeatPlay");
        FutureTask futureTask = new FutureTask(dz.a(this));
        this.mCalculateDurationTask = futureTask;
        this.mCountOfPendingResetInputData.incrementAndGet();
        UGCMediaListSource uGCMediaListSource = this;
        uGCMediaListSource.runOnWorkThread(ea.a(uGCMediaListSource, repeatList, futureTask));
    }

    public void setReverse(boolean isReverse) {
        LiteavLog.i(this.mTAG, "setReverse isReverse = ".concat(String.valueOf(isReverse)));
        if (isReverse == this.mIsReverse) {
            return;
        }
        this.mCountOfPendingResetInputData.incrementAndGet();
        UGCMediaListSource uGCMediaListSource = this;
        uGCMediaListSource.runOnWorkThread(eb.a(uGCMediaListSource, isReverse));
    }

    public void setMaxFrameSize(int count) {
        this.mMaxBufferFrame = count;
        if (this.mCurrentPixelFrameProvider != null) {
            this.mCurrentPixelFrameProvider.setMaxBufferFrameCount(this.mMaxBufferFrame);
        }
    }

    public void setSpeedList(List<TXVideoEditConstants.TXSpeed> speedList) {
        LiteavLog.i(this.mTAG, "setSpeedList");
        FutureTask futureTask = new FutureTask(ec.a(this));
        this.mCalculateDurationTask = futureTask;
        this.mCountOfPendingResetInputData.incrementAndGet();
        UGCMediaListSource uGCMediaListSource = this;
        uGCMediaListSource.runOnWorkThread(ed.a(uGCMediaListSource, speedList, futureTask));
    }

    private void loadNextAudioFrameInternal(long timeOut) {
        if (this.mAudioFrameListQueue.size() > 5) {
            return;
        }
        if (!this.updateCurrentAudioFrameProvider()) {
            if (!this.putAudioFrameToQueue(null)) {
                UGCMediaListSource uGCMediaListSource = this;
                uGCMediaListSource.scheduleTaskOnWorkerThread(ee.a(uGCMediaListSource));
                return;
            }
            LiteavLog.i(this.mTAG, "getAudioFrameProvider fail.AudioFrameListQueue put null");
            return;
        }
        if (this.mAudioSeekTimeInClip != -1L) {
            this.mCurrentAudioFrameProvider.seekTo(this.mAudioSeekTimeInClip);
            this.mCurrentAudioFrameProvider.setPlayEndPts(this.mPlayEndTime);
            this.mAudioSeekTimeInClip = -1L;
        }
        this.readAudioFrameListToQueue(timeOut);
        UGCMediaListSource uGCMediaListSource = this;
        uGCMediaListSource.scheduleTaskOnWorkerThread(ef.a(uGCMediaListSource));
    }

    private void readAudioFrameListToQueue(long timeOut) {
        List<AudioFrame> list = this.mCurrentAudioFrameProvider.getFrameQueue().dequeue(timeOut);
        if (list == null) {
            return;
        }
        if (list == UGCAudioFrameProvider.END_OF_STREAM) {
            LiteavLog.i(this.mTAG, "audio frame provider read END_OF_STREAM");
            this.closeCurrentAudioFrameProvider();
            if (this.mIsReverse) {
                --this.mCurrentAudioClipIndex;
                return;
            }
            ++this.mCurrentAudioClipIndex;
            return;
        }
        if (!this.mIsSplitScreenMode) {
            this.adjustAudioFrameTimestamp(list);
        }
        this.putAudioFrameToQueue(list);
    }

    public boolean putAudioFrameToQueue(List<AudioFrame> audioFrameList) {
        if (this.isResettingInputData()) {
            return false;
        }
        this.mAudioFrameListQueue.queue(audioFrameList);
        return true;
    }

    private void adjustAudioFrameTimestamp(List<AudioFrame> audioFrameList) {
        if (CollectionUtils.isEmpty(audioFrameList)) {
            return;
        }
        AudioFrame audioFrame = audioFrameList.get(0);
        long l2 = this.calculateAudioFrameDuration(audioFrame);
        if (this.mLastAudioFrameTimestamp == -1L || audioFrame.getTimestamp() >= this.mLastAudioFrameTimestamp + l2) {
            this.mLastAudioFrameTimestamp = audioFrame.getTimestamp();
            return;
        }
        l2 = l2 <= 0L ? 1L : l2;
        this.mLastAudioFrameTimestamp += l2;
        audioFrame.setTimestamp(this.mLastAudioFrameTimestamp);
    }

    private long calculateAudioFrameDuration(AudioFrame frame) {
        if (frame == null || frame.getData() == null) {
            return 0L;
        }
        long l2 = 2L * (long)frame.getSampleRate() * (long)frame.getChannelCount();
        if (l2 == 0L) {
            return 0L;
        }
        return (long)frame.getData().limit() * 1000L / l2;
    }

    private boolean updateCurrentAudioFrameProvider() {
        if (this.mCurrentAudioFrameProvider != null) {
            return true;
        }
        if (this.mAudioHandler == null) {
            HandlerThread handlerThread = new HandlerThread("Audio-File-Provider");
            handlerThread.start();
            this.mAudioHandler = new CustomHandler(handlerThread.getLooper());
        }
        if (this.isImageSource() && this.mCurrentAudioClipIndex == 0) {
            this.mCurrentAudioFrameProvider = this.createMuteAudioProvider();
            return true;
        }
        if (this.mCurrentAudioClipIndex >= this.mClipList.size() || this.mCurrentAudioClipIndex < 0) {
            return false;
        }
        if (this.mIsSplitScreenMode) {
            this.mCurrentAudioFrameProvider = new UGCMultiFileAudioFrameProvider(this.mClipList, this.mDurationControlMode, this.mAudioHandler);
            this.mCurrentAudioClipIndex = this.mClipList.size();
        } else {
            this.mCurrentAudioFrameProvider = new UGCSingleFileAudioFrameProvider(this.mClipList.get(this.mCurrentAudioClipIndex), this.mAudioHandler);
        }
        this.mCurrentAudioFrameProvider.initialize();
        this.mCurrentAudioFrameProvider.start();
        return true;
    }

    private UGCAudioFrameProvider createMuteAudioProvider() {
        Clip clip = new Clip();
        new Clip().path = "mute_virtual_file_path";
        clip.startInClipsTimeline = 0L;
        clip.startTimelineNoSpeed = 0L;
        clip.startInFileTime = 0L;
        clip.endInFileTime = this.getImageDuration();
        UGCSingleFileAudioFrameProvider uGCSingleFileAudioFrameProvider = new UGCSingleFileAudioFrameProvider(clip, this.mAudioHandler);
        uGCSingleFileAudioFrameProvider.initialize();
        uGCSingleFileAudioFrameProvider.start();
        return uGCSingleFileAudioFrameProvider;
    }

    private void loadNextVideoFrameInternal(long timeOut) {
        if (this.mPixelFrameListQueue.size() >= 5) {
            return;
        }
        if (!this.updateCurrentPixelFrameProvider()) {
            this.addVideoTailFrameListToQueue();
            if (!this.putPixFrameToQueue(null)) {
                UGCMediaListSource uGCMediaListSource = this;
                uGCMediaListSource.scheduleTaskOnWorkerThread(eg.a(uGCMediaListSource));
                return;
            }
            LiteavLog.i(this.mTAG, "getPixelFrameProvider fail.PixelFrameListQueue put null");
            return;
        }
        if (this.mVideoSeekTimeInClip != -1L) {
            this.mCurrentPixelFrameProvider.seekTo(this.mVideoSeekTimeInClip, this.mIsPreciseSeek);
            this.mCurrentPixelFrameProvider.setPlayEndPts(this.mPlayEndTime);
            this.mVideoSeekTimeInClip = -1L;
        }
        this.readVideoFrameListToQueue(timeOut);
        UGCMediaListSource uGCMediaListSource = this;
        uGCMediaListSource.scheduleTaskOnWorkerThread(eh.a(uGCMediaListSource));
    }

    private boolean updateCurrentPixelFrameProvider() {
        if (this.mCurrentPixelFrameProvider != null) {
            return true;
        }
        if (this.isImageSource() && this.mCurrentVideoClipIndex == 0) {
            this.mCurrentPixelFrameProvider = this.createImageProvider();
            return true;
        }
        if (this.mCurrentVideoClipIndex >= this.mClipList.size() || this.mCurrentVideoClipIndex < 0) {
            return false;
        }
        if (!this.mIsSplitScreenMode) {
            if (this.mCurrentVideoClipIndex == this.mNextVideoClipIndex) {
                this.mCurrentPixelFrameProvider = this.mNextPixelFrameProvider;
                this.mNextPixelFrameProvider = null;
            }
            if (this.mCurrentPixelFrameProvider == null) {
                this.mCurrentPixelFrameProvider = this.createVideoFileProvider(this.mCurrentVideoClipIndex, false);
            }
            UGCMediaListSource uGCMediaListSource = this;
            uGCMediaListSource.removeRunnable(ei.a(uGCMediaListSource));
            UGCMediaListSource uGCMediaListSource2 = this;
            uGCMediaListSource2.runOnWorkThread(ek.a(uGCMediaListSource2), 500);
        } else {
            this.mCurrentPixelFrameProvider = this.createVideoFileProvider(0, true);
            this.mCurrentVideoClipIndex = this.mClipList.size();
        }
        return true;
    }

    private UGCPixelFrameProvider createVideoFileProvider(int clipIndex, boolean isParallelMode) {
        Object object;
        if (this.mVideoHandler == null) {
            object = new HandlerThread("Video-File-Provider");
            object.start();
            this.mVideoHandler = new CustomHandler(object.getLooper());
        }
        if (isParallelMode) {
            object = new UGCMultiFilePixelFrameProvider(this.mClipList, this.mDurationControlMode, this.mVideoHandler);
        } else {
            object = new UGCSingleFilePixelFrameProvider(this.mClipList.get(clipIndex), this.mVideoHandler);
            object.setPlayEndPts(this.mPlayEndTime);
        }
        object.initialize();
        object.setReverse(this.mIsReverse);
        object.setMaxBufferFrameCount(this.mMaxBufferFrame);
        object.start();
        return object;
    }

    private UGCPixelFrameProvider createImageProvider() {
        UGCImageProvider uGCImageProvider = new UGCImageProvider(this.mBitmapList, this.mFps);
        uGCImageProvider.initialize();
        uGCImageProvider.start();
        uGCImageProvider.setPictureTransition(this.mTransitionType);
        return uGCImageProvider;
    }

    private void closeCurrentPixelFrameProvider() {
        if (this.mCurrentPixelFrameProvider == null) {
            return;
        }
        this.mCurrentPixelFrameProvider.stop();
        this.mCurrentPixelFrameProvider.uninitialize();
        this.mCurrentPixelFrameProvider = null;
    }

    private void closeNextPixelFrameProvider() {
        if (this.mNextPixelFrameProvider == null) {
            return;
        }
        this.mNextPixelFrameProvider.stop();
        this.mNextPixelFrameProvider.uninitialize();
        this.mNextPixelFrameProvider = null;
    }

    private void closeCurrentAudioFrameProvider() {
        if (this.mCurrentAudioFrameProvider == null) {
            return;
        }
        this.mCurrentAudioFrameProvider.stop();
        this.mCurrentAudioFrameProvider.uninitialize();
        this.mCurrentAudioFrameProvider = null;
    }

    private void readVideoFrameListToQueue(long timeOut) {
        List<PixelFrame> list = this.mCurrentPixelFrameProvider.getFrameQueue().dequeue(timeOut);
        if (list == null) {
            return;
        }
        if (list == UGCPixelFrameProvider.END_OF_STREAM) {
            LiteavLog.i(this.mTAG, "video frame provider read END_OF_STREAM");
            this.closeCurrentPixelFrameProvider();
            if (this.mIsReverse) {
                --this.mCurrentVideoClipIndex;
                return;
            }
            ++this.mCurrentVideoClipIndex;
            return;
        }
        if (!this.mIsSplitScreenMode) {
            this.adjustPixelFrameTimestamp(list);
        }
        if (this.putPixFrameToQueue(list)) {
            this.saveTailVideoFrameToList(list);
        }
    }

    private boolean putPixFrameToQueue(List<PixelFrame> pixelFrameList) {
        if (this.isResettingInputData()) {
            PixelFrame.releasePixelFrames(pixelFrameList);
            return false;
        }
        this.mPixelFrameListQueue.queue(pixelFrameList);
        return true;
    }

    private void adjustPixelFrameTimestamp(List<PixelFrame> pixelFrameList) {
        if (CollectionUtils.isEmpty(pixelFrameList)) {
            return;
        }
        PixelFrame pixelFrame = pixelFrameList.get(0);
        if (this.mLastVideoFrameTimestamp == -1L || pixelFrame.getTimestamp() > this.mLastVideoFrameTimestamp) {
            this.mLastVideoFrameTimestamp = pixelFrame.getTimestamp();
            return;
        }
        ++this.mLastVideoFrameTimestamp;
        pixelFrame.setTimestamp(this.mLastVideoFrameTimestamp);
    }

    private void prePareNextUGCPixelFrameProvider() {
        this.closeNextPixelFrameProvider();
        this.mNextVideoClipIndex = this.mIsReverse ? this.mCurrentVideoClipIndex - 1 : this.mCurrentVideoClipIndex + 1;
        if (this.mNextVideoClipIndex >= this.mClipList.size() || this.mNextVideoClipIndex < 0) {
            return;
        }
        this.mNextPixelFrameProvider = this.createVideoFileProvider(this.mNextVideoClipIndex, false);
    }

    private boolean isImageSource() {
        return this.mClipList.size() == 0 && this.mBitmapList != null && this.mBitmapList.size() != 0;
    }

    public long transitionOffsetTimeWithPts(long pts) {
        return 0L;
    }

    public boolean hasAudioData() {
        FutureTask<Boolean> futureTask = this.mHasAudioDataTask;
        if (futureTask == null) {
            return false;
        }
        Boolean bl2 = Boolean.FALSE;
        try {
            bl2 = futureTask.get(this.estimateSourceOpenTime(), TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            LiteavLog.w(this.mTAG, "hasAudioData future exception ".concat(String.valueOf(exception)));
        }
        return bl2;
    }

    public void setTailWaterMarkDurationSecond(int duration) {
        UGCMediaListSource uGCMediaListSource = this;
        uGCMediaListSource.runOnWorkThread(el.a(uGCMediaListSource, duration));
    }

    private void addVideoTailFrameListToQueue() {
        if (this.mTailWaterMarkDurationMs <= 0L || this.mTailPixelFrameList.isEmpty()) {
            return;
        }
        long l2 = 40L;
        if (this.mClipList != null && !this.mClipList.isEmpty()) {
            Clip clip;
            Clip clip2 = this.mClipList.get(0);
            if (clip.fps > 0.0f) {
                l2 = (long)(1000.0f / clip2.fps);
            }
        }
        int n2 = (int)(this.mTailWaterMarkDurationMs / l2);
        for (int i2 = 0; i2 < n2; ++i2) {
            LinkedList<PixelFrame> linkedList = new LinkedList<PixelFrame>();
            for (PixelFrame pixelFrame : this.mTailPixelFrameList) {
                PixelFrame pixelFrame2;
                if (pixelFrame instanceof GLTexturePool.TextureFrame) {
                    GLTexturePool.TextureFrame textureFrame = (GLTexturePool.TextureFrame)pixelFrame;
                    pixelFrame2 = textureFrame.getGLTexture().wrap(textureFrame.getGLContext());
                } else {
                    LiteavLog.w(this.mTAG, "addVideoTailFrameListToQueue: pixelFrame is not TextureFrame");
                    pixelFrame2 = new PixelFrame(pixelFrame);
                }
                pixelFrame2.setTimestamp((long)(i2 + 1) * l2 + pixelFrame.getTimestamp());
                linkedList.add(pixelFrame2);
            }
            if (!this.putPixFrameToQueue(linkedList)) break;
        }
    }

    private void saveTailVideoFrameToList(List<PixelFrame> pixelFrameList) {
        if (this.mTailWaterMarkDurationMs == 0L) {
            return;
        }
        Iterator<PixelFrame> iterator = this.mTailPixelFrameList.iterator();
        while (iterator.hasNext()) {
            iterator.next().release();
        }
        this.mTailPixelFrameList.clear();
        for (PixelFrame pixelFrame : pixelFrameList) {
            pixelFrame.retain();
            this.mTailPixelFrameList.add(pixelFrame);
        }
    }

    public long getDuration() {
        FutureTask<Long> futureTask = this.mCalculateDurationTask;
        if (futureTask == null) {
            return 0L;
        }
        Long l2 = 0L;
        try {
            l2 = futureTask.get(this.estimateSourceOpenTime(), TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            LiteavLog.w(this.mTAG, "getDuration future task exception: ".concat(String.valueOf(exception)));
        }
        return l2;
    }

    private long getImageDuration() {
        if (!this.isImageSource()) {
            return 0L;
        }
        if (!this.updateCurrentPixelFrameProvider()) {
            return 0L;
        }
        if (this.mCurrentPixelFrameProvider instanceof UGCImageProvider) {
            return ((UGCImageProvider)this.mCurrentPixelFrameProvider).getDuration();
        }
        return 0L;
    }

    private void clearFrameQueue() {
        this.clearVideoFrameQueue();
        this.mAudioFrameListQueue.clear();
    }

    private void clearVideoFrameQueue() {
        List<List<PixelFrame>> list = this.mPixelFrameListQueue.dequeueAll();
        UGCMediaListSource uGCMediaListSource = this;
        uGCMediaListSource.runOnWorkThread(em.a(uGCMediaListSource, list));
    }

    private void clearTailPixelFrameQueue() {
        this.ensureEGLCoreCreated();
        if (EGLCore.makeCurrent(this.mEGLCore)) {
            PixelFrame.releasePixelFrames(this.mTailPixelFrameList);
        }
        this.mTailPixelFrameList.clear();
    }

    private void ensureEGLCoreCreated() {
        if (this.mEGLCore == null) {
            this.mEGLCore = EGLCore.create(GlobalContextManager.getInstance().getGLContext());
        }
    }

    private void removeRunnable(Runnable runnable) {
        CustomHandler customHandler = this.mWorkHandler;
        if (customHandler != null) {
            customHandler.removeCallbacks(runnable);
        }
    }

    private void scheduleTaskOnWorkerThread(Runnable runnable) {
        CustomHandler customHandler = this.mWorkHandler;
        if (customHandler != null) {
            customHandler.post(runnable);
        }
    }

    private boolean isResettingInputData() {
        return this.mCountOfPendingResetInputData.get() > 0 || this.mPendingSeekTime.get() != null;
    }

    private void runOnWorkThread(Runnable runnable) {
        this.runOnWorkThread(runnable, 0);
    }

    private void runOnWorkThread(Runnable runnable, int delay) {
        CustomHandler customHandler = this.mWorkHandler;
        if (customHandler != null) {
            customHandler.runOrPost(runnable, delay);
        }
    }

    private static a getMediaInfo(String path) {
        a a2 = new a(0);
        FFmpegMediaRetriever fFmpegMediaRetriever = new FFmpegMediaRetriever();
        if (fFmpegMediaRetriever.setDataSource(path) == 0) {
            long l2 = fFmpegMediaRetriever.getAudioDurationMs();
            long l3 = fFmpegMediaRetriever.getVideoDurationMs();
            a2.b = Math.max(l2, l3);
            a2.c = l2 != 0L;
            a2.d = fFmpegMediaRetriever.getFPS();
            a2.f = fFmpegMediaRetriever.getVideoMimeType();
        }
        return a2;
    }

    private long estimateSourceOpenTime() {
        List<String> list = this.mSources;
        long l2 = 1000L;
        if (list != null && list.size() > 1) {
            l2 = (long)list.size() * 1000L;
        }
        return l2;
    }

    public static float getSpeed(int speedLevel) {
        switch (speedLevel) {
            case 0: {
                return 0.25f;
            }
            case 1: {
                return 0.5f;
            }
            case 2: {
                return 1.0f;
            }
            case 3: {
                return 1.5f;
            }
            case 4: {
                return 2.0f;
            }
        }
        return 1.0f;
    }

    static /* synthetic */ void lambda$clearVideoFrameQueue$20(UGCMediaListSource this_, List pixelFrameList) {
        this_.ensureEGLCoreCreated();
        if (EGLCore.makeCurrent(this_.mEGLCore)) {
            Iterator iterator = pixelFrameList.iterator();
            while (iterator.hasNext()) {
                PixelFrame.releasePixelFrames((List)iterator.next());
            }
        }
    }

    static /* synthetic */ void lambda$setTailWaterMarkDurationSecond$19(UGCMediaListSource this_, int duration) {
        this_.mTailWaterMarkDurationMs = (long)duration * 1000L;
    }

    static /* synthetic */ void lambda$loadNextVideoFrameInternal$18(UGCMediaListSource this_) {
        this_.loadNextVideoFrameInternal(5L);
    }

    static /* synthetic */ void lambda$loadNextVideoFrameInternal$17(UGCMediaListSource this_) {
        this_.loadNextVideoFrameInternal(5L);
    }

    static /* synthetic */ void lambda$loadNextAudioFrameInternal$16(UGCMediaListSource this_) {
        this_.loadNextAudioFrameInternal(5L);
    }

    static /* synthetic */ void lambda$loadNextAudioFrameInternal$15(UGCMediaListSource this_) {
        this_.loadNextAudioFrameInternal(5L);
    }

    static /* synthetic */ void lambda$setSpeedList$14(UGCMediaListSource this_, List speedList, FutureTask calculateDurationTask) {
        this_.mSpeedList = speedList;
        this_.updateClipsInfo();
        this_.resetReadPositionInternal();
        calculateDurationTask.run();
        this_.mCountOfPendingResetInputData.decrementAndGet();
    }

    static /* synthetic */ void lambda$setReverse$13(UGCMediaListSource this_, boolean isReverse) {
        this_.resetReadPositionInternal();
        this_.mIsReverse = isReverse;
        this_.mCurrentVideoClipIndex = isReverse ? this_.mClipList.size() - 1 : 0;
        this_.mCountOfPendingResetInputData.decrementAndGet();
    }

    static /* synthetic */ void lambda$setRepeatPlay$12(UGCMediaListSource this_, List repeatList, FutureTask calculateDurationTask) {
        this_.mRepeatList = repeatList;
        this_.updateClipsInfo();
        this_.resetReadPositionInternal();
        calculateDurationTask.run();
        this_.mCountOfPendingResetInputData.decrementAndGet();
    }

    static /* synthetic */ void lambda$seekTo$11(UGCMediaListSource this_, boolean isPreciseSeek) {
        Long l2 = this_.mPendingSeekTime.getAndSet(null);
        if (l2 != null) {
            this_.seekToInternal(l2, isPreciseSeek);
        }
    }

    static /* synthetic */ void lambda$setPlayEndTime$10(UGCMediaListSource this_, long endPts) {
        this_.mPlayEndTime = endPts;
        if (this_.mCurrentPixelFrameProvider != null) {
            this_.mCurrentPixelFrameProvider.setPlayEndPts(endPts);
        }
        if (this_.mCurrentAudioFrameProvider != null) {
            this_.mCurrentAudioFrameProvider.setPlayEndPts(endPts);
        }
    }

    static /* synthetic */ void lambda$readNextVideoFrame$9(UGCMediaListSource this_) {
        this_.loadNextVideoFrameInternal(5L);
    }

    static /* synthetic */ void lambda$readNextAudioFrame$8(UGCMediaListSource this_) {
        this_.loadNextAudioFrameInternal(5L);
    }

    static /* synthetic */ void lambda$setPictureTransition$7(UGCMediaListSource this_, int type, FutureTask calculateDurationTask) {
        this_.resetReadPositionInternal();
        this_.mTransitionType = type;
        this_.updateCurrentPixelFrameProvider();
        calculateDurationTask.run();
        this_.mCountOfPendingResetInputData.decrementAndGet();
    }

    static /* synthetic */ void lambda$setPictureList$6(UGCMediaListSource this_, List bitmapList, int fps) {
        this_.resetReadPositionInternal();
        this_.mClipList.clear();
        this_.mBitmapList = bitmapList;
        this_.mFps = fps;
        this_.mCountOfPendingResetInputData.decrementAndGet();
    }

    static /* synthetic */ void lambda$setVideoSourceRange$5(UGCMediaListSource this_, long startTime, long endTime, FutureTask calculateDurationTask) {
        if (!this_.mIsSplitScreenMode) {
            this_.mSourceRangeStart = startTime;
            this_.mSourceRangeEnd = endTime;
            this_.updateClipsInfo();
        }
        this_.resetReadPositionInternal();
        calculateDurationTask.run();
        this_.mCountOfPendingResetInputData.decrementAndGet();
    }

    static /* synthetic */ void lambda$setIsSplitScreenMode$4(UGCMediaListSource this_, boolean isSplitScreenMode, FutureTask calculateDurationTask) {
        this_.mIsSplitScreenMode = isSplitScreenMode;
        this_.mSourceRangeStart = 0L;
        this_.mSourceRangeEnd = Integer.MAX_VALUE;
        this_.updateTimelineToClips();
        calculateDurationTask.run();
        this_.mCountOfPendingResetInputData.decrementAndGet();
    }

    static /* synthetic */ void lambda$setDurationControlMode$3(UGCMediaListSource this_, TXVideoJoiner.DurationControlMode durationControlMode, FutureTask calculateDurationTask) {
        this_.mDurationControlMode = durationControlMode;
        calculateDurationTask.run();
    }

    static /* synthetic */ int lambda$updateSpeedInfoToClips$2(TXVideoEditConstants.TXSpeed speed1, TXVideoEditConstants.TXSpeed speed2) {
        return (int)(speed1.startTime - speed2.startTime);
    }

    static /* synthetic */ int lambda$cutSingleVideoFileToClips$1(TXVideoEditConstants.TXRepeat repeat1, TXVideoEditConstants.TXRepeat repeat2) {
        return (int)(repeat1.startTime - repeat2.startTime);
    }

    static /* synthetic */ void lambda$setVideoSources$0(UGCMediaListSource this_, List sources, FutureTask hasAudioDataTask, FutureTask calculateDurationTask) {
        this_.setVideoSourcesInternal(sources);
        hasAudioDataTask.run();
        calculateDurationTask.run();
        this_.mCountOfPendingResetInputData.decrementAndGet();
    }

    static /* synthetic */ void access$lambda$0(UGCMediaListSource uGCMediaListSource) {
        uGCMediaListSource.uninitializeInternal();
    }

    static /* synthetic */ boolean access$lambda$1(UGCMediaListSource uGCMediaListSource) {
        return uGCMediaListSource.hasAudioDataInternal();
    }

    static /* synthetic */ long access$lambda$2(UGCMediaListSource uGCMediaListSource) {
        return uGCMediaListSource.calculateTotalDurationOfClips();
    }

    static /* synthetic */ long access$lambda$3(UGCMediaListSource uGCMediaListSource) {
        return uGCMediaListSource.calculateTotalDurationOfClips();
    }

    static /* synthetic */ long access$lambda$4(UGCMediaListSource uGCMediaListSource) {
        return uGCMediaListSource.calculateTotalDurationOfClips();
    }

    static /* synthetic */ long access$lambda$5(UGCMediaListSource uGCMediaListSource) {
        return uGCMediaListSource.calculateTotalDurationOfClips();
    }

    static /* synthetic */ long access$lambda$6(UGCMediaListSource uGCMediaListSource) {
        return uGCMediaListSource.calculateTotalDurationOfClips();
    }

    static /* synthetic */ long access$lambda$7(UGCMediaListSource uGCMediaListSource) {
        return uGCMediaListSource.calculateTotalDurationOfClips();
    }

    static /* synthetic */ long access$lambda$8(UGCMediaListSource uGCMediaListSource) {
        return uGCMediaListSource.calculateTotalDurationOfClips();
    }

    static /* synthetic */ void access$lambda$9(UGCMediaListSource uGCMediaListSource) {
        uGCMediaListSource.prePareNextUGCPixelFrameProvider();
    }

    static /* synthetic */ void access$lambda$10(UGCMediaListSource uGCMediaListSource) {
        uGCMediaListSource.prePareNextUGCPixelFrameProvider();
    }

    static final class a {
        public long a = 0L;
        public long b = 0L;
        public boolean c = false;
        public float d = 25.0f;
        public String e;
        public String f;

        private a() {
        }

        /* synthetic */ a(byte by2) {
            this();
        }
    }
}

