/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import android.graphics.Bitmap;
import android.os.HandlerThread;
import com.tencent.liteav.base.Log;
import com.tencent.liteav.base.b.b;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.ugc.GlobalContextManager;
import com.tencent.ugc.UGCFrameQueue;
import com.tencent.ugc.UGCPixelFrameProvider;
import com.tencent.ugc.UGCTransitionRules;
import com.tencent.ugc.dc;
import com.tencent.ugc.dd;
import com.tencent.ugc.de;
import com.tencent.ugc.df;
import com.tencent.ugc.dg;
import com.tencent.ugc.dh;
import com.tencent.ugc.di;
import com.tencent.ugc.dj;
import com.tencent.ugc.dk;
import com.tencent.ugc.dl;
import com.tencent.ugc.dm;
import com.tencent.ugc.videobase.egl.EGLCore;
import com.tencent.ugc.videobase.egl.EGLException;
import com.tencent.ugc.videobase.frame.GLTexture;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import com.tencent.ugc.videobase.frame.PixelFrame;
import com.tencent.ugc.videobase.utils.OpenGlUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;

public class UGCImageProvider
implements UGCFrameQueue.UGCFrameQueueListener,
UGCPixelFrameProvider {
    private static final String TAG = "UGCImageProvider";
    private static final int MAX_FRAME_SIZE = 5;
    private final List<Bitmap> mBitmapList;
    private final Map<Bitmap, GLTexture> mGLTextureMap;
    private final b mThrottlers = new b();
    private CustomHandler mWorkHandler;
    private final UGCFrameQueue<List<PixelFrame>> mFrameQueue;
    private final int mFps;
    private final int mFrameIntervalMs;
    private int mTotalFrameCount;
    private int mCurrentFrameCount = 0;
    private long mStayDurationMs = 1000L;
    private long mMotionDurationMs = 500L;
    private long mDurationMs;
    private int mTransitionType = 1;
    private EGLCore mEGLCore;
    private GLTexturePool mGLTexturePool;
    private FutureTask<Long> mDurationFuture;

    public UGCImageProvider(List<Bitmap> bitmapList, int fps) {
        LiteavLog.i(TAG, TAG);
        this.mFps = fps > 0 ? fps : 20;
        this.mFrameIntervalMs = 1000 / this.mFps;
        this.mFrameQueue = new UGCFrameQueue();
        this.mGLTextureMap = new HashMap<Bitmap, GLTexture>();
        this.mBitmapList = bitmapList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        LiteavLog.i(TAG, "initialize");
        UGCImageProvider uGCImageProvider = this;
        synchronized (uGCImageProvider) {
            if (this.mWorkHandler != null) {
                LiteavLog.w(TAG, "UGCPixelFrameProvider is initialized");
                return;
            }
            HandlerThread handlerThread = new HandlerThread("ugc-image-frame-provider");
            handlerThread.start();
            this.mWorkHandler = new CustomHandler(handlerThread.getLooper());
        }
        UGCImageProvider uGCImageProvider2 = this;
        uGCImageProvider2.runOnWorkThread(dc.a(uGCImageProvider2));
    }

    @Override
    public void uninitialize() {
        LiteavLog.i(TAG, "unInitialize");
        UGCImageProvider uGCImageProvider = this;
        uGCImageProvider.runOnWorkThread(df.a(uGCImageProvider));
    }

    @Override
    public void start() {
        Log.i(TAG, "Start", new Object[0]);
        UGCImageProvider uGCImageProvider = this;
        uGCImageProvider.runOnWorkThread(dg.a(uGCImageProvider));
    }

    @Override
    public void stop() {
        LiteavLog.i(TAG, "stop");
        UGCImageProvider uGCImageProvider = this;
        uGCImageProvider.runOnWorkThread(dh.a(uGCImageProvider));
    }

    @Override
    public void seekTo(long timeMs, boolean isPreciseSeek) {
        UGCImageProvider uGCImageProvider = this;
        uGCImageProvider.runOnWorkThread(di.a(uGCImageProvider, timeMs));
    }

    @Override
    public void setPlayEndPts(long playEndPts) {
    }

    @Override
    public void setMaxBufferFrameCount(int count) {
    }

    @Override
    public UGCFrameQueue<List<PixelFrame>> getFrameQueue() {
        return this.mFrameQueue;
    }

    @Override
    public void setReverse(boolean isReverse) {
    }

    public void setPictureTransition(int type) {
        LiteavLog.i(TAG, "setPictureTransition type = ".concat(String.valueOf(type)));
        this.mDurationFuture = new FutureTask(dj.a(this, type));
        UGCImageProvider uGCImageProvider = this;
        uGCImageProvider.runOnWorkThread(uGCImageProvider.mDurationFuture);
    }

    public long getDuration() {
        if (this.mDurationFuture == null) {
            return 0L;
        }
        Long l2 = 0L;
        try {
            l2 = this.mDurationFuture.get(500L, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            LiteavLog.w(TAG, "getDuration future task exception: ".concat(String.valueOf(exception)));
        }
        return l2;
    }

    @Override
    public void onFrameDequeued() {
        UGCImageProvider uGCImageProvider = this;
        uGCImageProvider.runOnWorkThread(dk.a(uGCImageProvider));
    }

    private void uninitGLComponents() {
        if (this.mEGLCore == null) {
            return;
        }
        try {
            this.mEGLCore.makeCurrent();
            if (this.mGLTexturePool != null) {
                this.mGLTexturePool.evictAll();
                this.mGLTexturePool.destroy();
            }
        }
        catch (EGLException eGLException) {
            LiteavLog.e(this.mThrottlers.a("uninitGL"), TAG, "EGLCore destroy failed.", eGLException);
        }
        this.mGLTexturePool = null;
        EGLCore.destroy(this.mEGLCore);
        this.mEGLCore = null;
    }

    private void initializeGLComponents() {
        this.mEGLCore = new EGLCore();
        try {
            this.mEGLCore.initialize(GlobalContextManager.getInstance().getGLContext(), null, 128, 128);
            this.mEGLCore.makeCurrent();
            this.mGLTexturePool = new GLTexturePool();
            return;
        }
        catch (EGLException eGLException) {
            LiteavLog.e(this.mThrottlers.a("initGL"), TAG, "create EGLCore failed.", eGLException);
            this.mEGLCore = null;
            return;
        }
    }

    private void decodeBitmapFrame() {
        if (this.mEGLCore == null || this.mFrameQueue.size() > 5) {
            return;
        }
        if (this.mCurrentFrameCount >= this.mTotalFrameCount) {
            this.mFrameQueue.queue(END_OF_STREAM);
            return;
        }
        ArrayList<PixelFrame> arrayList = new ArrayList<PixelFrame>();
        long l2 = (long)this.mCurrentFrameCount * (long)this.mFrameIntervalMs;
        ++this.mCurrentFrameCount;
        int n2 = (int)(l2 / (this.mStayDurationMs + this.mMotionDurationMs));
        n2 = this.clamp(n2, 0, this.mBitmapList.size() - 1);
        Bitmap bitmap = this.mBitmapList.get(n2);
        arrayList.add(this.loadBitmapToPixelFrame(bitmap, l2));
        n2 = this.clamp(n2 + 1, 0, this.mBitmapList.size() - 1);
        Bitmap bitmap2 = this.mBitmapList.get(n2);
        arrayList.add(this.loadBitmapToPixelFrame(bitmap2, l2));
        this.mFrameQueue.queue(arrayList);
        CustomHandler customHandler = this.mWorkHandler;
        if (customHandler != null) {
            customHandler.removeCallbacks(dl.a(this));
            customHandler.post(dm.a(this));
        }
    }

    private int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    private PixelFrame loadBitmapToPixelFrame(Bitmap bitmap, long pts) {
        GLTexture gLTexture;
        try {
            if (this.mEGLCore != null) {
                this.mEGLCore.makeCurrent();
            }
        }
        catch (Exception exception) {
            LiteavLog.e(this.mThrottlers.a("make_current_fail"), TAG, "loadBitmapToPixelFrame makeCurrent fail".concat(String.valueOf(exception)), new Object[0]);
        }
        if (!this.mGLTextureMap.containsKey(bitmap)) {
            gLTexture = this.mGLTexturePool.obtain(bitmap.getWidth(), bitmap.getHeight());
            gLTexture.setColorFormat(GLConstants.ColorRange.b, GLConstants.ColorSpace.b);
            OpenGlUtils.loadTexture(bitmap, gLTexture.getId(), false);
            this.mGLTextureMap.put(bitmap, gLTexture);
        } else {
            gLTexture = this.mGLTextureMap.get(bitmap);
        }
        PixelFrame pixelFrame = gLTexture.wrap(GlobalContextManager.getInstance().getGLContext());
        pixelFrame.setTimestamp(pts);
        return pixelFrame;
    }

    private void setPictureTransitionInternal(int type) {
        this.mTransitionType = type;
        this.mStayDurationMs = UGCTransitionRules.getStayDurationMs(type);
        this.mMotionDurationMs = UGCTransitionRules.getMotionDurationMs(type);
        if (this.mBitmapList == null) {
            return;
        }
        this.mDurationMs = type == 5 || type == 4 ? (long)this.mBitmapList.size() * (this.mStayDurationMs + this.mMotionDurationMs) : (long)this.mBitmapList.size() * (this.mStayDurationMs + this.mMotionDurationMs) - this.mMotionDurationMs;
        this.mTotalFrameCount = (int)(this.mDurationMs / 1000L * (long)this.mFps);
    }

    private void clearPixelFrameQueue() {
        for (List<PixelFrame> list : this.mFrameQueue.dequeueAll()) {
            if (list == null) continue;
            Iterator<PixelFrame> iterator = list.iterator();
            while (iterator.hasNext()) {
                iterator.next().release();
            }
        }
    }

    private void clearGLTextureCache() {
        for (GLTexture gLTexture : this.mGLTextureMap.values()) {
            if (gLTexture == null) continue;
            gLTexture.release();
        }
        this.mGLTextureMap.clear();
    }

    private boolean runOnWorkThread(Runnable runnable) {
        CustomHandler customHandler = this.mWorkHandler;
        if (customHandler != null) {
            return customHandler.runOrPost(runnable, 0);
        }
        return false;
    }

    static /* synthetic */ Long lambda$setPictureTransition$5(UGCImageProvider this_, int type) throws Exception {
        this_.setPictureTransitionInternal(type);
        return this_.mDurationMs;
    }

    static /* synthetic */ void lambda$seekTo$4(UGCImageProvider this_, long timeMs) {
        this_.mCurrentFrameCount = (int)(timeMs - 1L) / this_.mFrameIntervalMs + 1;
        this_.clearPixelFrameQueue();
        UGCImageProvider uGCImageProvider = this_;
        uGCImageProvider.runOnWorkThread(dd.a(uGCImageProvider));
    }

    static /* synthetic */ void lambda$stop$3(UGCImageProvider this_) {
        if (this_.mWorkHandler != null) {
            this_.mWorkHandler.removeCallbacks(de.a(this_));
        }
    }

    static /* synthetic */ void lambda$start$2(UGCImageProvider this_) {
        UGCImageProvider uGCImageProvider = this_;
        uGCImageProvider.setPictureTransitionInternal(uGCImageProvider.mTransitionType);
        this_.decodeBitmapFrame();
    }

    static /* synthetic */ void lambda$uninitialize$1(UGCImageProvider this_) {
        this_.clearPixelFrameQueue();
        this_.clearGLTextureCache();
        this_.uninitGLComponents();
        this_.mFrameQueue.setUGCFrameQueueListener(null);
        if (this_.mWorkHandler != null) {
            this_.mWorkHandler.quitLooper();
            this_.mWorkHandler = null;
        }
    }

    static /* synthetic */ void lambda$initialize$0(UGCImageProvider this_) {
        this_.mFrameQueue.setUGCFrameQueueListener(this_);
        this_.initializeGLComponents();
    }

    static /* synthetic */ void access$lambda$0(UGCImageProvider uGCImageProvider) {
        uGCImageProvider.decodeBitmapFrame();
    }

    static /* synthetic */ void access$lambda$1(UGCImageProvider uGCImageProvider) {
        uGCImageProvider.decodeBitmapFrame();
    }

    static /* synthetic */ void access$lambda$2(UGCImageProvider uGCImageProvider) {
        uGCImageProvider.decodeBitmapFrame();
    }

    static /* synthetic */ void access$lambda$3(UGCImageProvider uGCImageProvider) {
        uGCImageProvider.decodeBitmapFrame();
    }

    static /* synthetic */ void access$lambda$4(UGCImageProvider uGCImageProvider) {
        uGCImageProvider.decodeBitmapFrame();
    }
}

