/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.ugc.videobase.frame.PixelFrame;

@JNINamespace(value="liteav::ugc")
public class UGCFrameRateFilter {
    private final String TAG = "UGCFrameRateFilter_" + this.hashCode();
    private long mNativeHandler;

    public UGCFrameRateFilter(int frameRate) {
        LiteavLog.i(this.TAG, "set frame rate. frame rate is ".concat(String.valueOf(frameRate)));
        this.mNativeHandler = UGCFrameRateFilter.nativeCreate(frameRate);
    }

    public void finalize() throws Throwable {
        UGCFrameRateFilter.nativeDestroy(this.mNativeHandler);
    }

    public boolean isFilterOutFrame(PixelFrame pixelFrame) {
        if (pixelFrame == null) {
            return true;
        }
        if (this.mNativeHandler == 0L) {
            return false;
        }
        Result result = (Result)UGCFrameRateFilter.nativeFilterFrame(this.mNativeHandler, pixelFrame.getTimestamp());
        pixelFrame.setTimestamp(result.b);
        return result.a;
    }

    private static Result createFilterFrameResult(boolean filteredOut, long pts) {
        Result result = new Result();
        new Result().a = filteredOut;
        result.b = pts;
        return result;
    }

    private static native long nativeCreate(int var0);

    private static native void nativeDestroy(long var0);

    private static native Object nativeFilterFrame(long var0, long var2);

    static class Result {
        boolean a;
        long b;

        Result() {
        }
    }
}

