/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import android.content.Context;
import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.f;
import com.tencent.ugc.TXVideoEditConstants;
import com.tencent.ugc.ch;
import com.tencent.ugc.ci;
import com.tencent.ugc.common.MediaExtractorBuilder;
import com.tencent.ugc.common.MediaRetrieverBuilder;
import com.tencent.ugc.retriver.FFmpegMediaRetriever;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicInteger;

public class TXVideoInfoReader {
    private final String TAG = "TXVideoInfoReader";
    private static final int RETRY_MAX_COUNT = 3;
    private Context mContext;
    private int mCount;
    private volatile WeakReference<OnSampleProgrocess> mListener;
    private a mGenerateImageThread;
    private static TXVideoInfoReader sInstance;
    private final Handler mMainHandler;
    private final AtomicInteger mRetryTimes;

    private TXVideoInfoReader(Context context) {
        this.mContext = context.getApplicationContext();
        ContextUtils.initApplicationContext(this.mContext);
        ContextUtils.setDataDirectorySuffix("liteav");
        this.mRetryTimes = new AtomicInteger(0);
        this.mMainHandler = new Handler(Looper.getMainLooper());
    }

    private TXVideoInfoReader() {
        this.mRetryTimes = new AtomicInteger(0);
        this.mMainHandler = new Handler(Looper.getMainLooper());
    }

    @Deprecated
    public static TXVideoInfoReader getInstance() {
        if (sInstance == null) {
            sInstance = new TXVideoInfoReader();
        }
        return sInstance;
    }

    public static TXVideoInfoReader getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new TXVideoInfoReader(context);
        }
        return sInstance;
    }

    public TXVideoEditConstants.TXVideoInfo getVideoFileInfo(String videoSource) {
        Object object;
        LiteavLog.i("TXVideoInfoReader", "videoSource:".concat(String.valueOf(videoSource)));
        if (LiteavSystemInfo.getSystemOSVersionInt() < 18) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)videoSource)) {
            LiteavLog.e("TXVideoInfoReader", "videoSource is empty!!");
            return null;
        }
        if (!(MediaExtractorBuilder.isContentUri(videoSource) || ((File)(object = new File(videoSource))).exists() && ((File)object).canRead())) {
            LiteavLog.e("TXVideoInfoReader", "getVideoFileInfo  file exist = " + ((File)object).exists() + " can read = " + ((File)object).canRead());
            return null;
        }
        object = new TXVideoEditConstants.TXVideoInfo();
        FFmpegMediaRetriever fFmpegMediaRetriever = new FFmpegMediaRetriever();
        fFmpegMediaRetriever.setDataSource(videoSource);
        ((TXVideoEditConstants.TXVideoInfo)object).duration = fFmpegMediaRetriever.getVideoDurationMs();
        LiteavLog.i("TXVideoInfoReader", "getVideoFileInfo: duration = " + ((TXVideoEditConstants.TXVideoInfo)object).duration);
        ((TXVideoEditConstants.TXVideoInfo)object).coverImage = new MediaRetrieverBuilder().setPath(videoSource).build().getFrameAtTime();
        ((TXVideoEditConstants.TXVideoInfo)object).fps = fFmpegMediaRetriever.getFPS();
        ((TXVideoEditConstants.TXVideoInfo)object).bitrate = (int)(fFmpegMediaRetriever.getVideoBitrate() / 1024L);
        ((TXVideoEditConstants.TXVideoInfo)object).audioSampleRate = fFmpegMediaRetriever.getSampleRate();
        int n2 = fFmpegMediaRetriever.getRotation();
        LiteavLog.i("TXVideoInfoReader", "rotation: ".concat(String.valueOf(n2)));
        if (n2 == 90 || n2 == 270) {
            ((TXVideoEditConstants.TXVideoInfo)object).width = fFmpegMediaRetriever.getVideoHeight();
            ((TXVideoEditConstants.TXVideoInfo)object).height = fFmpegMediaRetriever.getVideoWidth();
        } else {
            ((TXVideoEditConstants.TXVideoInfo)object).width = fFmpegMediaRetriever.getVideoWidth();
            ((TXVideoEditConstants.TXVideoInfo)object).height = fFmpegMediaRetriever.getVideoHeight();
        }
        if (MediaExtractorBuilder.isContentUri(videoSource)) {
            ((TXVideoEditConstants.TXVideoInfo)object).fileSize = this.getContentUrlFileSize(videoSource);
        } else {
            File file = new File(videoSource);
            ((TXVideoEditConstants.TXVideoInfo)object).fileSize = file.length();
        }
        return object;
    }

    private long getContentUrlFileSize(String videoSource) {
        block4: {
            long l2;
            Uri uri = Uri.parse((String)videoSource);
            ParcelFileDescriptor parcelFileDescriptor = null;
            FileInputStream fileInputStream = null;
            try {
                if (this.mContext == null) break block4;
                parcelFileDescriptor = this.mContext.getContentResolver().openFileDescriptor(uri, "r");
                fileInputStream = new FileInputStream(parcelFileDescriptor.getFileDescriptor());
                l2 = fileInputStream.available();
            }
            catch (Exception exception) {
                try {
                    LiteavLog.e("TXVideoInfoReader", "getVideoFileInfo  not found , uri = ".concat(String.valueOf(uri)));
                }
                catch (Throwable throwable) {
                    f.a(parcelFileDescriptor);
                    f.a(fileInputStream);
                    throw throwable;
                }
                f.a((Closeable)parcelFileDescriptor);
                f.a(fileInputStream);
            }
            f.a((Closeable)parcelFileDescriptor);
            f.a(fileInputStream);
            return l2;
        }
        f.a(null);
        f.a(null);
        return 0L;
    }

    public Bitmap getSampleImage(long time, String videoPath) {
        if (TextUtils.isEmpty((CharSequence)videoPath)) {
            LiteavLog.w("TXVideoInfoReader", "videoPath is null");
            return null;
        }
        if (!new File(videoPath).exists()) {
            LiteavLog.w("TXVideoInfoReader", "videoPath is not exist");
            return null;
        }
        FFmpegMediaRetriever fFmpegMediaRetriever = new FFmpegMediaRetriever();
        fFmpegMediaRetriever.setDataSource(videoPath);
        long l2 = fFmpegMediaRetriever.getVideoDurationMs() * 1000L;
        long l3 = time * 1000L;
        if (l3 > l2) {
            l3 = l2;
        }
        if (l2 <= 0L) {
            LiteavLog.w("TXVideoInfoReader", "video duration is 0");
            return null;
        }
        Bitmap bitmap = new MediaRetrieverBuilder().setPath(videoPath).build().getFrameAtTime(l3);
        if (bitmap == null) {
            LiteavLog.e("TXVideoInfoReader", "getSampleImages failed!");
            return bitmap;
        }
        LiteavLog.i("TXVideoInfoReader", "getSampleImages bmp= " + bitmap + ",time= " + l3 + ",duration= " + l2);
        return bitmap;
    }

    public void getSampleImages(int count, String videoPath, OnSampleProgrocess listener) {
        this.mCount = count;
        this.mListener = new WeakReference<OnSampleProgrocess>(listener);
        if (TextUtils.isEmpty((CharSequence)videoPath)) {
            LiteavLog.w("TXVideoInfoReader", "getSampleImages: videoPath is empty.");
            return;
        }
        if (!f.a(videoPath)) {
            LiteavLog.w("TXVideoInfoReader", "getSampleImages: file is not exist.");
            return;
        }
        this.cancelThread();
        this.mGenerateImageThread = new a(videoPath);
        this.mGenerateImageThread.start();
        LiteavLog.i("TXVideoInfoReader", "getSampleImages: thread start");
    }

    public void cancel() {
        LiteavLog.i("TXVideoInfoReader", "cancel");
        this.cancelThread();
        this.mMainHandler.removeCallbacksAndMessages(null);
        if (this.mListener != null) {
            this.mListener.clear();
            this.mListener = null;
        }
    }

    private void cancelThread() {
        if (this.mGenerateImageThread != null && this.mGenerateImageThread.isAlive() && !this.mGenerateImageThread.isInterrupted()) {
            LiteavLog.i("TXVideoInfoReader", "cancelThread: thread cancel");
            this.mGenerateImageThread.interrupt();
            this.mGenerateImageThread = null;
        }
    }

    public static interface OnSampleProgrocess {
        public void sampleProcess(int var1, Bitmap var2);
    }

    final class a
    extends Thread {
        private final String b;
        private volatile Bitmap c;
        private final int d;

        public a(String string) {
            this.d = TXVideoInfoReader.this.mListener.hashCode();
            this.b = string;
        }

        @Override
        public final void run() {
            MediaMetadataRetriever mediaMetadataRetriever = new MediaRetrieverBuilder().setPath(this.b).build();
            long l2 = new FFmpegMediaRetriever().getVideoDurationMs() * 1000L;
            long l3 = l2 / (long)TXVideoInfoReader.this.mCount;
            LiteavLog.i("TXVideoInfoReader", "run duration = " + l2 + " count = " + TXVideoInfoReader.this.mCount);
            for (int i2 = 0; i2 < TXVideoInfoReader.this.mCount && !Thread.currentThread().isInterrupted(); ++i2) {
                a a2;
                Object object;
                a a3;
                Bitmap bitmap;
                long l4 = l3 * (long)i2;
                if (l4 > l2) {
                    l4 = l2;
                }
                if ((bitmap = mediaMetadataRetriever.getFrameAtTime(l4)) == null) {
                    Bitmap bitmap2;
                    LiteavLog.w("TXVideoInfoReader", "getSampleImages failed!");
                    if (i2 == 0) {
                        a a4 = this;
                        String string = a4.b;
                        a3 = a4;
                        if (a4.TXVideoInfoReader.this.mRetryTimes.get() >= 3) break;
                        LiteavLog.i("TXVideoInfoReader", "retry to get sample images");
                        object = string;
                        a2 = a3;
                        a3.TXVideoInfoReader.this.mMainHandler.post((Runnable)new ci(a2, (String)object));
                        break;
                    }
                    a3 = this;
                    if (a3.c != null && !a3.c.isRecycled()) {
                        LiteavLog.i("TXVideoInfoReader", "copy last image");
                        bitmap2 = a3.c.copy(a3.c.getConfig(), true);
                    } else {
                        bitmap2 = null;
                    }
                    bitmap = bitmap2;
                }
                this.c = bitmap;
                TXVideoInfoReader.this.mRetryTimes.set(0);
                if (TXVideoInfoReader.this.mListener == null || TXVideoInfoReader.this.mCount <= 0 || TXVideoInfoReader.this.mListener.hashCode() != this.d) continue;
                a2 = bitmap;
                int n2 = i2;
                a3 = this;
                object = (OnSampleProgrocess)a3.TXVideoInfoReader.this.mListener.get();
                if (object == null) continue;
                a a5 = a2;
                int n3 = n2;
                Object object2 = object;
                a3.TXVideoInfoReader.this.mMainHandler.post((Runnable)new ch((OnSampleProgrocess)object2, n3, (Bitmap)a5));
            }
            this.c = null;
            mediaMetadataRetriever.release();
        }

        static /* synthetic */ void a(a a2, String string) {
            a2.TXVideoInfoReader.this.getSampleImages(a2.TXVideoInfoReader.this.mCount, string, (OnSampleProgrocess)a2.TXVideoInfoReader.this.mListener.get());
            a2.TXVideoInfoReader.this.mRetryTimes.getAndIncrement();
        }

        static /* synthetic */ void a(OnSampleProgrocess onSampleProgrocess, int n2, Bitmap bitmap) {
            onSampleProgrocess.sampleProcess(n2, bitmap);
        }
    }
}

