/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videobase.videobase;

import android.app.Activity;
import android.content.Context;
import android.hardware.display.DisplayManager;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.base.util.j;
import com.tencent.liteav.base.util.l;

@JNINamespace(value="liteav::video")
public class SystemDisplayInfo {
    private static final String TAG = "SystemDisplayInfo";

    public static Display getDisplay() {
        if (SystemDisplayInfo.nativeGetDisplayRotationObtainMethod() == 0) {
            Display display = SystemDisplayInfo.getDisplayByDisplayManager();
            if (display != null) {
                return display;
            }
            return SystemDisplayInfo.getDefaultDisplayByWindowManager();
        }
        Display display = SystemDisplayInfo.getDefaultDisplayByWindowManager();
        if (display != null) {
            return display;
        }
        return SystemDisplayInfo.getDisplayByDisplayManager();
    }

    public static Size getDisplaySize() {
        try {
            Display display = SystemDisplayInfo.getDisplay();
            if (display != null) {
                DisplayMetrics displayMetrics = new DisplayMetrics();
                display.getRealMetrics(displayMetrics);
                return new Size(displayMetrics.widthPixels, displayMetrics.heightPixels);
            }
        }
        catch (Exception exception) {
            LiteavLog.e(TAG, "error getting display size.", exception);
        }
        return new Size(720, 1280);
    }

    public static int getDisplayRotationDegree() {
        return SystemDisplayInfo.getDisplayRotation().mValue;
    }

    public static l getDisplayRotation() {
        l l2 = SystemDisplayInfo.getDisplayRotationCorrection();
        if (l2 != null) {
            return l2;
        }
        try {
            Display display = SystemDisplayInfo.getDisplay();
            if (display != null) {
                return SystemDisplayInfo.surfaceRotationEnumToRotation(display.getRotation());
            }
        }
        catch (Exception exception) {
            LiteavLog.e(TAG, "error getting display rotation.", exception);
        }
        return l.a;
    }

    private static Display getDisplayByDisplayManager() {
        if (LiteavSystemInfo.getSystemOSVersionInt() < 32) {
            return null;
        }
        Context context = ContextUtils.getApplicationContext();
        if (context == null) {
            LiteavLog.e(TAG, "context is null.");
            return null;
        }
        try {
            return ((DisplayManager)context.getSystemService("display")).getDisplay(0);
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "error getting display from display service.", throwable);
            return null;
        }
    }

    private static Display getDefaultDisplayByWindowManager() {
        Activity activity = j.a().c();
        Object object = activity != null ? activity : ContextUtils.getApplicationContext();
        if (object == null) {
            LiteavLog.e(TAG, "context is null.");
            return null;
        }
        try {
            return ((WindowManager)object.getSystemService("window")).getDefaultDisplay();
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "error getting display from window service.", throwable);
            return null;
        }
    }

    private static l surfaceRotationEnumToRotation(int surfaceRotationEnum) {
        switch (surfaceRotationEnum) {
            case 1: {
                return l.b;
            }
            case 2: {
                return l.c;
            }
            case 3: {
                return l.d;
            }
        }
        return l.a;
    }

    private static l getDisplayRotationCorrection() {
        int n2 = SystemDisplayInfo.nativeGetDisplayRotationCorrection();
        if (l.b(n2)) {
            return l.a(n2);
        }
        return null;
    }

    private static synchronized native int nativeGetDisplayRotationCorrection();

    private static synchronized native int nativeGetDisplayRotationObtainMethod();
}

