/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.base.util;

import android.text.TextUtils;
import android.util.Log;
import java.util.ArrayList;
import java.util.Arrays;

public class SoLoader {
    private static final String TAG = "SoLoader";
    private static final Object mLoadLock = new Object();
    private static boolean mHasLoaded = false;
    private static String mLibraryPath = "";
    private static ExternalSoLoader mExternalSoLoader = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setExternalSoLoader(ExternalSoLoader loader) {
        Object object = mLoadLock;
        synchronized (object) {
            mExternalSoLoader = loader;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadAllLibraries() {
        Object object = mLoadLock;
        synchronized (object) {
            if (!mHasLoaded) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("txsoundtouch");
                arrayList.add("txffmpeg");
                arrayList.add("liteavsdk");
                if (mExternalSoLoader != null) {
                    ArrayList<String> arrayList2 = arrayList;
                    mHasLoaded = SoLoader.loadLibraryByExternal(arrayList2.toArray(new String[arrayList2.size()]));
                } else if (!TextUtils.isEmpty((CharSequence)mLibraryPath)) {
                    ArrayList<String> arrayList3 = arrayList;
                    mHasLoaded = SoLoader.loadLibraryInCustomerPath(arrayList3.toArray(new String[arrayList3.size()]));
                } else {
                    ArrayList<String> arrayList4 = arrayList;
                    mHasLoaded = SoLoader.loadLibraryDefault(arrayList4.toArray(new String[arrayList4.size()]));
                }
            }
            return mHasLoaded;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadLibrary(String name) {
        try {
            Object object = mLoadLock;
            synchronized (object) {
                if (mExternalSoLoader != null) {
                    return mExternalSoLoader.loadLibrary(new String[]{name});
                }
                if (!TextUtils.isEmpty((CharSequence)mLibraryPath)) {
                    boolean bl2 = SoLoader.loadLibrary(mLibraryPath, name);
                    Log.w((String)TAG, (String)("load library " + name + " in customer path:" + bl2));
                    return bl2;
                }
                Log.w((String)TAG, (String)("load library " + name + " from system path "));
                System.loadLibrary(name);
            }
            return true;
        }
        catch (Throwable throwable) {
            Log.w((String)TAG, (String)("load library " + name + " failed: " + throwable));
            return false;
        }
    }

    public static String getLibraryPath() {
        return mLibraryPath;
    }

    public static void setLibraryPath(String path) {
        Log.w((String)TAG, (String)"setLibraryPath ".concat(String.valueOf(path)));
        mLibraryPath = path;
    }

    private static boolean loadLibrary(String path, String name) {
        boolean bl2 = false;
        try {
            if (!TextUtils.isEmpty((CharSequence)path)) {
                Log.w((String)TAG, (String)("load library " + name + " from path " + path));
                System.load(path + "/lib" + name + ".so");
                bl2 = true;
            }
        }
        catch (Throwable throwable) {
            Log.w((String)TAG, (String)("load library " + name + "in path" + path + " failed: " + throwable));
        }
        return bl2;
    }

    private static boolean loadLibraryInCustomerPath(String[] so_name_array) {
        if (so_name_array == null || so_name_array.length == 0) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)mLibraryPath)) {
            return false;
        }
        boolean bl2 = false;
        String[] stringArray = so_name_array;
        int n2 = so_name_array.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            bl2 = SoLoader.loadLibrary(mLibraryPath, string);
            Log.i((String)TAG, (String)("load library " + string + " in customer path:" + bl2));
            if (!bl2) break;
        }
        return bl2;
    }

    private static boolean loadLibraryDefault(String[] so_name_array) {
        if (so_name_array == null || so_name_array.length == 0) {
            return false;
        }
        try {
            String[] stringArray = so_name_array;
            int n2 = so_name_array.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = stringArray[i2];
                System.loadLibrary(string);
                Log.i((String)TAG, (String)("load library " + string + " in default path success."));
            }
            return true;
        }
        catch (Throwable throwable) {
            Log.w((String)TAG, (String)("load libraries " + Arrays.toString(so_name_array) + " in default path error: " + throwable));
            return false;
        }
    }

    private static boolean loadLibraryByExternal(String[] so_name_array) {
        if (mExternalSoLoader == null || so_name_array == null || so_name_array.length == 0) {
            return false;
        }
        try {
            boolean bl2 = mExternalSoLoader.loadLibrary(so_name_array);
            Log.i((String)TAG, (String)("load libraries " + Arrays.toString(so_name_array) + " by external: " + bl2));
            return bl2;
        }
        catch (Throwable throwable) {
            Log.w((String)TAG, (String)("load libraries " + Arrays.toString(so_name_array) + " by external: " + throwable));
            return false;
        }
    }

    public static interface ExternalSoLoader {
        public boolean loadLibrary(String[] var1);
    }
}

