/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.base.http;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.SystemClock;
import android.text.TextUtils;
import com.tencent.liteav.base.Log;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.HttpDnsUtil;
import com.tencent.liteav.base.util.LiteavLog;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLException;

@JNINamespace(value="liteav")
public class HttpClientAndroid {
    private static final String TAG = "HttpClientAndroid";
    private static final String HTTP_PREFIX = "http://";
    private static final String HTTPS_PREFIX = "https://";
    private static final String METHOD_GET = "GET";
    private static final String METHOD_POST = "POST";
    private static final String METHOD_PUT = "PUT";
    private static final int ERROR_CODE_INVALID_REQUEST = 0;
    private static final int READ_STREAM_SIZE = 8192;
    private static final int REDIRECT_REQUEST_MAX = 3;
    private static final Object mLock = new Object();
    private final ConcurrentHashMap<Long, d> mRunningRequestMap = new ConcurrentHashMap();
    private final Handler mHttpHandler;
    private b mHttpConfig;
    private String mLastRequestURL;
    private HttpURLConnection mConnection;
    private final Object mLocker = new Object();
    private long mNativeHttpClientAndroidJni;
    private volatile c mInternalState = c.a;
    private long mTotalReadBytes = 0L;
    private long mStartReadTime = 0L;
    byte[] mReadDataBytes = new byte[8192];
    private boolean mPausedRepeatDownloading = false;
    private g mRepeatDownloadingStatusCode = g.x;

    public HttpClientAndroid(int connectTimeoutMs, int readTimeoutMs, int writeTimeoutMs, boolean isKeepAlive, int maxRecvSpeed, int socks5Port, String socks5Ip, String socks5User, String socks5Password, long nativeHttpClientAndroidJni) {
        this.mHttpConfig = new b(connectTimeoutMs, readTimeoutMs, writeTimeoutMs, isKeepAlive, maxRecvSpeed, socks5Port, socks5Ip, socks5User, socks5Password);
        this.mNativeHttpClientAndroidJni = nativeHttpClientAndroidJni;
        HandlerThread handlerThread = new HandlerThread("HttpClient_" + this.hashCode());
        handlerThread.start();
        LiteavLog.i(TAG, "Create http client(" + this.hashCode() + "). [ThreadName:" + handlerThread.getName() + "][ThreadId:" + handlerThread.getId() + "]");
        this.mHttpHandler = new Handler(handlerThread.getLooper());
    }

    public long send(long requestId, String url, String method, byte[] body, Map<String, String> headers, boolean isRepeat, boolean autoRedirect) {
        if (!this.checkNativeValid()) {
            LiteavLog.e(TAG, "(" + this.hashCode() + ")Send request failed. Invalid native handle.");
            return 0L;
        }
        d d2 = new d(url, method, body, headers, autoRedirect);
        return this.sendInternal(requestId, d2, isRepeat);
    }

    public long uploadFile(long requestId, String url, String method, byte[] body, Map<String, String> headers, boolean isRepeat, boolean autoRedirect, String filePath, byte[] rfc1867Header, byte[] rfc1867Footer) {
        if (!this.checkNativeValid()) {
            LiteavLog.e(TAG, "(" + this.hashCode() + ")upload file failed. Invalid native handle.");
            return 0L;
        }
        if (filePath.isEmpty()) {
            LiteavLog.e(TAG, "(" + this.hashCode() + ")upload file failed. Invalid file path(" + filePath + ").");
            return 0L;
        }
        d d2 = new d(url, method, body, headers, autoRedirect, filePath, rfc1867Header, rfc1867Footer);
        return this.sendInternal(requestId, d2, isRepeat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long sendInternal(long requestId, d request, boolean isRepeat) {
        if (request == null || !request.a()) {
            LiteavLog.e(TAG, "(" + this.hashCode() + ")upload file failed. Invalid request url(" + request.b + ").");
            return 0L;
        }
        if (!(!TextUtils.isEmpty((CharSequence)request.d()))) {
            LiteavLog.e(TAG, "(" + this.hashCode() + ")upload file failed. Request method(" + request.c + ") is not supported.");
            return 0L;
        }
        Object object = this.mLocker;
        synchronized (object) {
            boolean bl2 = false;
            if (this.mInternalState == c.a) {
                this.mInternalState = isRepeat ? c.b : c.c;
                bl2 = true;
            } else if (this.mInternalState == c.c) {
                bl2 = true;
            }
            if (bl2) {
                request.a = requestId;
                this.mRunningRequestMap.put(requestId, request);
                this.mHttpHandler.post(com.tencent.liteav.base.http.a.a(this, request));
                return request.a;
            }
            LiteavLog.e(TAG, "(" + this.hashCode() + ")Send request failed. Invalid state:" + (Object)((Object)this.mInternalState));
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(long requestId) {
        Object object = this.mLocker;
        synchronized (object) {
            if (!this.checkNativeValid()) {
                LiteavLog.e(TAG, "(" + this.hashCode() + ")Cancel request failed. Invalid native handle.");
                return;
            }
            if (this.mRunningRequestMap.size() == 0) {
                return;
            }
            d d2 = this.mRunningRequestMap.remove(requestId);
            LiteavLog.i(TAG, "(" + this.hashCode() + ")Cancel request. request:" + d2);
            if (this.mRunningRequestMap.size() == 0) {
                this.mInternalState = c.a;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        Object object = this.mLocker;
        synchronized (object) {
            if (!this.checkNativeValid()) {
                LiteavLog.e(TAG, "(" + this.hashCode() + ")Cancel all request failed. Invalid native handle.");
                return;
            }
            if (this.mInternalState == c.a) {
                return;
            }
            this.mInternalState = c.a;
            LiteavLog.i(TAG, "(" + this.hashCode() + ")Cancel all. size:" + this.mRunningRequestMap.size());
            this.mRunningRequestMap.clear();
            this.mHttpHandler.post(com.tencent.liteav.base.http.b.a(this));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeRepeatDownload(long requestId) {
        Object object = this.mLocker;
        synchronized (object) {
            if (!this.checkNativeValid()) {
                LiteavLog.e(TAG, "(" + this.hashCode() + ")Cancel request failed. Invalid native handle.");
                return;
            }
            if (this.mRunningRequestMap.size() == 0) {
                return;
            }
            if (this.mInternalState != c.b || !this.mPausedRepeatDownloading) {
                return;
            }
            this.mPausedRepeatDownloading = false;
            if (requestId == 0L) {
                for (Long l2 : this.mRunningRequestMap.keySet()) {
                    this.mHttpHandler.post(com.tencent.liteav.base.http.c.a(this, l2));
                }
            } else if (this.checkRequestValid(requestId)) {
                if (this.mRunningRequestMap.get(requestId) == null) {
                    return;
                }
                this.mHttpHandler.post(com.tencent.liteav.base.http.d.a(this, requestId));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.mLocker;
        synchronized (object) {
            this.mRunningRequestMap.clear();
            this.mNativeHttpClientAndroidJni = -1L;
            this.mHttpHandler.post(com.tencent.liteav.base.http.e.a(this));
            return;
        }
    }

    public void updateConfig(final int connectTimeoutMs, final int readTimeoutMs, final int writeTimeoutMs, final boolean isKeepAlive, final int maxRecvSpeed, final int socks5Port, final String socks5Ip, final String socks5User, final String socks5Password, long nativeHttpClientAndroidJni) {
        this.mHttpHandler.post(new Runnable(){

            @Override
            public final void run() {
                HttpClientAndroid.this.mHttpConfig = new b(connectTimeoutMs, readTimeoutMs, writeTimeoutMs, isKeepAlive, maxRecvSpeed, socks5Port, socks5Ip, socks5User, socks5Password);
                if (maxRecvSpeed > 0) {
                    HttpClientAndroid.this.mTotalReadBytes = 0L;
                    HttpClientAndroid.this.mStartReadTime = SystemClock.elapsedRealtime();
                }
            }
        });
    }

    private boolean checkRequestValid(long requestId) {
        return this.mRunningRequestMap.containsKey(requestId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkNativeValid() {
        Object object = this.mLocker;
        synchronized (object) {
            return this.mNativeHttpClientAndroidJni != -1L;
        }
    }

    private HttpURLConnection createConnection(d request) throws Exception {
        HttpURLConnection httpURLConnection;
        block13: {
            Proxy proxy = null;
            String string = request.b.replace(" ", "%20");
            URL uRL = new URL(string);
            if (!TextUtils.isEmpty((CharSequence)this.mHttpConfig.g) && this.mHttpConfig.f > 0) {
                proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(this.mHttpConfig.g, this.mHttpConfig.f));
                Authenticator.setDefault(new a(this.mHttpConfig.h, this.mHttpConfig.i));
            } else if ("127.0.0.1".equals(uRL.getHost()) || "localhost".equals(uRL.getHost())) {
                proxy = Proxy.NO_PROXY;
            }
            if (proxy != null) {
                httpURLConnection = (HttpURLConnection)uRL.openConnection(proxy);
            } else {
                if (HttpDnsUtil.verifyCustomHttpDNS(uRL.getHost())) {
                    try {
                        httpURLConnection = HttpDnsUtil.createConnectionUseCustomHttpDNS(string, uRL.getHost());
                        break block13;
                    }
                    catch (Exception exception) {
                        LiteavLog.w(TAG, "(" + this.hashCode() + ")createConnectionUseCustomHttpDNS failed. error: " + Log.getStackTraceString(exception));
                    }
                }
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
            }
        }
        httpURLConnection.setInstanceFollowRedirects(false);
        httpURLConnection.setConnectTimeout(this.mHttpConfig.a);
        httpURLConnection.setReadTimeout(this.mHttpConfig.b);
        httpURLConnection.setRequestProperty("Accept-Encoding", "identity");
        httpURLConnection.setRequestMethod(request.d());
        if (request.c()) {
            httpURLConnection.setDoOutput(true);
        }
        if (this.mHttpConfig.d) {
            httpURLConnection.setRequestProperty("Connection", "Keep-Alive");
        } else {
            httpURLConnection.setRequestProperty("Connection", "close");
        }
        if (request.e != null && !request.e.isEmpty()) {
            for (Map.Entry<String, String> entry : request.e.entrySet()) {
                httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return httpURLConnection;
    }

    /*
     * Loose catch block
     */
    private void closeConnectionSafely(HttpURLConnection connection) {
        if (connection != null) {
            this.closeIO(connection.getInputStream());
            try {
                connection.disconnect();
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            catch (Exception exception) {
                try {
                    exception.printStackTrace();
                }
                catch (Throwable throwable) {
                    try {
                        connection.disconnect();
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    connection.disconnect();
                    return;
                }
                catch (Exception exception3) {
                    exception3.printStackTrace();
                    return;
                }
            }
        }
    }

    private void closeIO(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void doRequest(d request) {
        e e2 = null;
        for (int i2 = 0; i2 < 4; ++i2) {
            e2 = this.internalRequest(request);
            if (e2 == null) {
                return;
            }
            if (!request.h || e2.a != g.d && e2.a != g.e) break;
            request.b = this.mConnection.getHeaderField("Location");
            ++request.f;
            request.g = request.b;
        }
        this.mTotalReadBytes = 0L;
        this.mStartReadTime = SystemClock.elapsedRealtime();
        this.doReadData(request.a, e2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadFileByPath(d request, OutputStream outputStream) throws Exception {
        if (TextUtils.isEmpty((CharSequence)request.i)) {
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            int n2;
            File file = new File(request.i);
            fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[524288];
            long l2 = 0L;
            long l3 = file.length();
            while ((n2 = fileInputStream.read(byArray)) != -1) {
                Object object = this.mLocker;
                synchronized (object) {
                    if (!this.checkRequestValid(request.a) || !this.checkNativeValid()) {
                        break;
                    }
                    outputStream.write(byArray, 0, n2);
                    HttpClientAndroid.nativeOnUploadProgress(this.mNativeHttpClientAndroidJni, request.a, l2 += (long)n2, l3);
                }
            }
            this.closeIO(fileInputStream);
            return;
        }
        catch (Throwable throwable) {
            this.closeIO(fileInputStream);
            throw throwable;
        }
    }

    private void writeRequestBody(d request) {
        OutputStream outputStream = null;
        try {
            if (request.c() && request.b()) {
                outputStream = this.mConnection.getOutputStream();
                outputStream.write(request.d);
                outputStream.flush();
            } else if (request.c() && !TextUtils.isEmpty((CharSequence)request.i)) {
                outputStream = this.mConnection.getOutputStream();
                if (request.j != null && request.j.length > 0) {
                    outputStream.write(request.j);
                }
                this.uploadFileByPath(request, outputStream);
                if (request.k != null && request.k.length > 0) {
                    outputStream.write(request.k);
                }
                outputStream.flush();
            }
            this.closeIO(outputStream);
            return;
        }
        catch (Exception exception) {
            try {
                exception.printStackTrace();
                LiteavLog.w(TAG, "(" + this.hashCode() + ")Do write request body failed.");
                this.closeIO(outputStream);
                return;
            }
            catch (Throwable throwable) {
                this.closeIO(outputStream);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private e internalRequest(d request) {
        boolean bl2;
        if (!request.a()) {
            LiteavLog.e(TAG, "(" + this.hashCode() + ")Send request failed. Invalid request url(" + request.b + ").");
            return null;
        }
        if (!this.checkRequestValid(request.a)) {
            LiteavLog.w(TAG, "(" + this.hashCode() + ")Do send failed. ignore request when cancelled. request:" + request);
            return null;
        }
        e e2 = new e();
        new e().h = request.f;
        e2.i = request.g;
        Object object = this.mLocker;
        synchronized (object) {
            bl2 = this.mInternalState == c.c;
        }
        if (bl2 && this.mConnection != null && !request.b.equals(this.mLastRequestURL)) {
            HttpClientAndroid httpClientAndroid = this;
            httpClientAndroid.closeConnectionSafely(httpClientAndroid.mConnection);
            this.mConnection = null;
        }
        this.mLastRequestURL = request.b;
        try {
            this.mConnection = this.createConnection(request);
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            LiteavLog.e(TAG, "(" + this.hashCode() + ")Do send failed. Fail to create http connection. ex= " + Log.getStackTraceString((Throwable)object));
            e2.a = this.getStatusCode((Throwable)object);
            e2.b = ((Throwable)object).toString();
            this.doCallbackAndResetState(f.b, request.a, e2, true);
            return null;
        }
        this.writeRequestBody(request);
        try {
            HttpClientAndroid httpClientAndroid = this;
            e2.a = httpClientAndroid.getStatusCode(httpClientAndroid.mConnection.getResponseCode());
            e2.b = this.mConnection.getResponseMessage();
            HttpClientAndroid httpClientAndroid2 = this;
            e2.e = httpClientAndroid2.parseHostAddress(httpClientAndroid2.mConnection.getURL().getHost());
            e2.g = this.mConnection.getURL().getPort();
            HttpClientAndroid httpClientAndroid3 = this;
            e2.f = httpClientAndroid3.getResponseHeaders(httpClientAndroid3.mConnection.getHeaderFields());
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            LiteavLog.e(TAG, "(" + this.hashCode() + ")Do send failed. Catch error. ex= " + Log.getStackTraceString((Throwable)object));
            e2.a = this.getStatusCode((Throwable)object);
            e2.b = ((Throwable)object).toString();
            this.doCallbackAndResetState(f.b, request.a, e2, true);
            return null;
        }
        if (!this.checkRequestValid(request.a)) {
            HttpClientAndroid httpClientAndroid = this;
            httpClientAndroid.closeConnectionSafely(httpClientAndroid.mConnection);
            LiteavLog.w(TAG, "(" + this.hashCode() + ")Do send failed. Invalid request, abort request.");
            return null;
        }
        return e2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void doReadData(long requestId, e response) {
        if (!this.checkRequestValid(requestId)) {
            v0 = this;
            v0.closeConnectionSafely(v0.mConnection);
            LiteavLog.w("HttpClientAndroid", "(" + this.hashCode() + ")Do read data failed. Invalid request id. id:" + requestId);
            return;
        }
        try {
            var4_3 = this.mConnection.getInputStream();
        }
        catch (Exception v1) {
            var5_4 = v1;
            v1.printStackTrace();
            LiteavLog.e("HttpClientAndroid", "(" + this.hashCode() + ")Do read data failed. Fail to get InputStream.");
            response.a = this.getStatusCode(var5_4);
            response.b = var5_4.toString();
            this.doCallbackAndResetState(f.b, requestId, response, true);
            return;
        }
        var6_6 = this.mLocker;
        synchronized (var6_6) {
            var5_5 = this.mInternalState == c.c;
        }
        var6_7 = 0L;
        if (var5_5) {
            try {
                var8_9 = new ByteArrayOutputStream();
                do {
                    if ((var10_13 = var4_3.read(this.mReadDataBytes)) <= 0) continue;
                    var8_9.write(this.mReadDataBytes, 0, var10_13);
                } while (var10_13 > 0 && this.checkRequestValid(requestId) != false);
                var10_13 = var8_9.size();
                if (var10_13 <= 0) ** GOTO lbl65
                response.c = ByteBuffer.allocateDirect(var10_13);
                response.c.put(var8_9.toByteArray(), 0, var10_13);
                response.d = var10_13;
            }
            catch (Throwable v2) {
                var8_10 = v2;
                v2.printStackTrace();
                LiteavLog.e("HttpClientAndroid", "(" + this.hashCode() + ")Do read data failed. Catch error when reading.");
                response.a = this.getStatusCode(var8_10);
                response.b = var8_10.toString();
                this.doCallbackAndResetState(f.b, requestId, response, true);
                return;
            }
        } else {
            try {
                var8_11 = var4_3.read(this.mReadDataBytes);
                this.mTotalReadBytes += (long)var8_11;
                var6_7 = SystemClock.elapsedRealtime();
            }
            catch (Exception v3) {
                var9_15 = v3;
                v3.printStackTrace();
                LiteavLog.e("HttpClientAndroid", "(" + this.hashCode() + ")Do read data failed. Catch error when reading.");
                response.a = this.getStatusCode(var9_15);
                response.b = var9_15.toString();
                this.doCallbackAndResetState(f.b, requestId, response, true);
                return;
            }
            if (var8_11 > 0) {
                response.c = ByteBuffer.allocateDirect(var8_11);
                response.c.put(this.mReadDataBytes, 0, var8_11);
                response.d = var8_11;
            }
        }
lbl65:
        // 5 sources

        if (response.d == 0 && !var5_5) {
            LiteavLog.w("HttpClientAndroid", "(" + this.hashCode() + ")Do read data failed. Rsp size is 0.");
            this.doCallbackAndResetState(f.c, requestId, response, this.mHttpConfig.d == false);
            return;
        }
        if (var5_5) {
            this.doCallbackAndResetState(f.c, requestId, response, this.mHttpConfig.d == false);
            return;
        }
        this.mPausedRepeatDownloading = this.doOnCallback(f.a, requestId, response);
        this.mRepeatDownloadingStatusCode = response.a;
        if (!this.mPausedRepeatDownloading) {
            var8_12 = 0L;
            if (this.mHttpConfig.e > 0) {
                v4 = var10_14 = var6_7 - this.mStartReadTime == 0L ? 1L : var6_7 - this.mStartReadTime;
                if (this.mTotalReadBytes / var10_14 > (long)(this.mHttpConfig.e / 1000)) {
                    var8_12 = this.mTotalReadBytes * 1000L / (long)this.mHttpConfig.e - var10_14;
                }
            }
            this.mHttpHandler.postDelayed(com.tencent.liteav.base.http.f.a(this, response, requestId), var8_12);
        }
    }

    private String parseHostAddress(String host) {
        try {
            return InetAddress.getByName(host).getHostAddress();
        }
        catch (Exception exception) {
            LiteavLog.w(TAG, "(" + this.hashCode() + ")Parse host error. host:" + host);
            return "";
        }
    }

    private Map<String, String> getResponseHeaders(Map<String, List<String>> headerFields) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : headerFields.entrySet()) {
            if (TextUtils.isEmpty((CharSequence)entry.getKey())) continue;
            hashMap.put(entry.getKey(), entry.getValue().get(0));
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCallbackAndResetState(f state, long requestId, e response, boolean closeConnection) {
        Object object = this.mLocker;
        synchronized (object) {
            boolean bl2 = this.checkNativeValid() && this.checkRequestValid(requestId) && response != null;
            boolean bl3 = c.b == this.mInternalState;
            this.mRunningRequestMap.remove(requestId);
            if (this.mRunningRequestMap.size() == 0) {
                this.mInternalState = c.a;
            }
            if (bl2) {
                HttpClientAndroid.nativeOnCallback(this.mNativeHttpClientAndroidJni, bl3, state.nativeValue, requestId, response.a.nativeValue, response.b, response.g, response.c, response.e, response.f, response.d, response.h, response.i);
            }
        }
        if (closeConnection) {
            HttpClientAndroid httpClientAndroid = this;
            httpClientAndroid.closeConnectionSafely(httpClientAndroid.mConnection);
            this.mConnection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doOnCallback(f state, long requestId, e response) {
        Object object = this.mLocker;
        synchronized (object) {
            if (this.checkNativeValid() && this.checkRequestValid(requestId) && response != null) {
                boolean bl2 = c.b == this.mInternalState;
                return HttpClientAndroid.nativeOnCallback(this.mNativeHttpClientAndroidJni, bl2, state.nativeValue, requestId, response.a.nativeValue, response.b, response.g, response.c, response.e, response.f, response.d, response.h, response.i);
            }
        }
        return false;
    }

    private static native boolean nativeOnCallback(long var0, boolean var2, int var3, long var4, int var6, String var7, int var8, ByteBuffer var9, String var10, Map var11, int var12, int var13, String var14);

    private static native void nativeOnUploadProgress(long var0, long var2, long var4, long var6);

    public static String[] getMapKeys(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return new String[0];
        }
        Set<String> set = map.keySet();
        String[] stringArray = new String[set.size()];
        return set.toArray(stringArray);
    }

    public static String[] getMapValue(Map<String, String> map, String[] keys) {
        if (map == null || map.isEmpty() || keys == null || keys.length == 0) {
            return new String[0];
        }
        String[] stringArray = new String[keys.length];
        for (int i2 = 0; i2 < keys.length; ++i2) {
            stringArray[i2] = map.get(keys[i2]);
        }
        return stringArray;
    }

    public static HashMap getJavaHashMap(String[] keys, String[] values) {
        if (keys == null || keys.length == 0 || values == null || values.length == 0) {
            return new HashMap();
        }
        if (keys.length != values.length) {
            LiteavLog.w(TAG, "Invalid parameter, keys and values do not match.");
            return new HashMap();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i2 = 0; i2 < keys.length; ++i2) {
            hashMap.put(keys[i2], values[i2]);
        }
        return hashMap;
    }

    private g getStatusCode(int code) {
        g g2 = g.x;
        if (code == 200) {
            g2 = g.a;
        } else if (code == 204) {
            g2 = g.b;
        } else if (code == 206) {
            g2 = g.c;
        } else if (code == 301) {
            g2 = g.d;
        } else if (code == 302) {
            g2 = g.e;
        } else if (code == 303) {
            g2 = g.f;
        } else if (code == 304) {
            g2 = g.g;
        } else if (code == 307) {
            g2 = g.h;
        } else if (code == 308) {
            g2 = g.i;
        } else if (code == 403) {
            g2 = g.j;
        } else if (code == 404) {
            g2 = g.k;
        } else if (code == 405) {
            g2 = g.l;
        } else if (code == 503) {
            g2 = g.m;
        } else {
            Log.w(TAG, "(" + this.hashCode() + ")Failed to convert status code\uff1a" + code, new Object[0]);
        }
        return g2;
    }

    private g getStatusCode(Throwable e2) {
        g g2 = g.x;
        if (e2 instanceof FileNotFoundException) {
            g2 = g.n;
        } else if (e2 instanceof EOFException) {
            g2 = g.o;
        } else if (e2 instanceof UnknownHostException) {
            g2 = g.p;
        } else if (e2 instanceof NoRouteToHostException) {
            g2 = g.q;
        } else if (e2 instanceof SocketException || e2 instanceof MalformedURLException) {
            g2 = g.r;
        } else if (e2 instanceof SocketTimeoutException) {
            g2 = g.t;
        } else if (e2 instanceof ConnectException) {
            g2 = g.u;
        } else if (e2 instanceof ProtocolException) {
            g2 = g.v;
        } else if (e2 instanceof SSLException) {
            g2 = g.w;
        } else {
            Log.w(TAG, "(" + this.hashCode() + ")Failed to convert status code, exception\uff1a", e2.toString());
        }
        return g2;
    }

    static /* synthetic */ void lambda$doReadData$5(HttpClientAndroid this_, e response, long requestId) {
        e e2 = new e();
        new e().a = response.a;
        this_.doReadData(requestId, e2);
    }

    static /* synthetic */ void lambda$destroy$4(HttpClientAndroid this_) {
        HttpClientAndroid httpClientAndroid = this_;
        httpClientAndroid.closeConnectionSafely(httpClientAndroid.mConnection);
        this_.mConnection = null;
        if (LiteavSystemInfo.getSystemOSVersionInt() >= 18) {
            this_.mHttpHandler.getLooper().quitSafely();
            return;
        }
        this_.mHttpHandler.getLooper().quit();
    }

    static /* synthetic */ void lambda$resumeRepeatDownload$3(HttpClientAndroid this_, long requestId) {
        e e2 = new e();
        new e().a = this_.mRepeatDownloadingStatusCode;
        this_.doReadData(requestId, e2);
    }

    static /* synthetic */ void lambda$resumeRepeatDownload$2(HttpClientAndroid this_, Long key) {
        e e2 = new e();
        new e().a = this_.mRepeatDownloadingStatusCode;
        this_.doReadData(key, e2);
    }

    static /* synthetic */ void lambda$cancelAll$1(HttpClientAndroid this_) {
        HttpClientAndroid httpClientAndroid = this_;
        httpClientAndroid.closeConnectionSafely(httpClientAndroid.mConnection);
        this_.mConnection = null;
    }

    static /* synthetic */ void lambda$sendInternal$0(HttpClientAndroid this_, d request) {
        this_.doRequest(request);
    }

    static final class a
    extends Authenticator {
        String a;
        String b;

        a(String string, String string2) {
            this.a = string;
            this.b = string2;
        }

        @Override
        protected final PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.a, this.b.toCharArray());
        }
    }

    static enum c {
        a,
        b,
        c;

    }

    public static enum f {
        a(0),
        b(1),
        c(2);

        int nativeValue;

        private f(int n3) {
            this.nativeValue = n3;
        }
    }

    public static final class e {
        g a = com.tencent.liteav.base.http.HttpClientAndroid$g.x;
        String b = "";
        ByteBuffer c;
        int d = 0;
        String e = "";
        Map<String, String> f = null;
        int g = 0;
        int h = 0;
        String i = "";
    }

    public static final class d {
        long a;
        String b;
        String c;
        byte[] d;
        Map<String, String> e;
        int f;
        String g;
        boolean h = true;
        String i;
        byte[] j;
        byte[] k;

        d(String string, String string2, byte[] byArray, Map<String, String> map, boolean bl2) {
            this(string, string2, byArray, map, bl2, "", null, null);
        }

        d(String string, String string2, byte[] byArray, Map<String, String> map, boolean bl2, String string3, byte[] byArray2, byte[] byArray3) {
            this.b = string;
            this.c = string2;
            this.d = byArray;
            this.e = map;
            this.f = 0;
            this.g = "";
            this.h = bl2;
            this.i = string3;
            this.j = byArray2;
            this.k = byArray3;
        }

        final boolean a() {
            if (TextUtils.isEmpty((CharSequence)this.b)) {
                return false;
            }
            return this.b.startsWith(HttpClientAndroid.HTTP_PREFIX) || this.b.startsWith(HttpClientAndroid.HTTPS_PREFIX);
        }

        final boolean b() {
            return this.d != null && this.d.length > 0;
        }

        final boolean c() {
            return HttpClientAndroid.METHOD_POST.equals(this.d()) || HttpClientAndroid.METHOD_PUT.equals(this.d());
        }

        final String d() {
            if (TextUtils.isEmpty((CharSequence)this.c)) {
                return "";
            }
            if (HttpClientAndroid.METHOD_POST.equalsIgnoreCase(this.c)) {
                return HttpClientAndroid.METHOD_POST;
            }
            if (HttpClientAndroid.METHOD_GET.equalsIgnoreCase(this.c)) {
                return HttpClientAndroid.METHOD_GET;
            }
            if (HttpClientAndroid.METHOD_PUT.equalsIgnoreCase(this.c)) {
                return HttpClientAndroid.METHOD_PUT;
            }
            return "";
        }

        public final String toString() {
            return "Request{requestId=" + this.a + ", url='" + this.b + '\'' + ", method='" + this.c + '\'' + ", body.size=" + (this.b() ? this.d.length : 0) + ", headers=" + this.e + ", autoRedirect=" + this.h + '}';
        }
    }

    public static final class b {
        int a;
        int b;
        int c;
        boolean d;
        int e;
        int f;
        String g;
        String h;
        String i;

        b(int n2, int n3, int n4, boolean bl2, int n5, int n6, String string, String string2, String string3) {
            this.a = n2;
            this.b = n3;
            this.c = n4;
            this.d = bl2;
            this.e = n5;
            this.f = n6;
            this.g = string;
            this.h = string2;
            this.i = string3;
        }
    }

    static enum g {
        a(200),
        b(204),
        c(206),
        d(301),
        e(302),
        f(303),
        g(304),
        h(307),
        i(308),
        j(403),
        k(404),
        l(405),
        m(503),
        n(1001),
        o(1002),
        p(1003),
        q(1004),
        r(1005),
        s(1006),
        t(1007),
        u(1008),
        v(1009),
        w(1010),
        x(1999);

        final int nativeValue;

        private g(int n3) {
            this.nativeValue = n3;
        }
    }
}

