/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trtc.hardwareearmonitor.honor;

import com.tencent.liteav.base.util.LiteavLog;
import java.util.IllegalFormatException;
import java.util.Locale;
import java.util.regex.PatternSyntaxException;

public class HonorLogUtils {
    public static final int LOG_LEVEL = 6;
    public static final int ERROR = 1;
    public static final int WARN = 2;
    public static final int INFO = 3;
    public static final int DEBUG = 4;
    public static final int VERBOSE = 5;
    private static final String ERROR_MESSAGE = "log message error : ";

    private HonorLogUtils() {
    }

    public static void error(String tag, String msg) {
        LiteavLog.e(tag, msg);
    }

    public static <T> void error(String tag, String msg, T ... args) {
        if (msg != null) {
            LiteavLog.e(tag, HonorLogUtils.getMessageString(msg, args));
        }
    }

    public static void warn(String tag, String msg) {
        LiteavLog.w(tag, msg);
    }

    public static void info(String tag, String msg) {
        LiteavLog.i(tag, msg);
    }

    public static <T> void info(String tag, String msg, T ... args) {
        if (msg != null) {
            LiteavLog.i(tag, HonorLogUtils.getMessageString(msg, args));
        }
    }

    public static void debug(String tag, String msg) {
        LiteavLog.d(tag, msg);
    }

    public static <T> void debug(String tag, String msg, T ... args) {
        if (msg != null) {
            LiteavLog.d(tag, HonorLogUtils.getMessageString(msg, args));
        }
    }

    public static void verbose(String tag, String msg) {
        LiteavLog.v(tag, msg);
    }

    private static <T> String getMessageString(String msg, T[] args) {
        try {
            return String.format(Locale.ENGLISH, msg.replaceAll("\\{\\}", "%s"), (Object[])args);
        }
        catch (IllegalFormatException | PatternSyntaxException illegalArgumentException) {
            return ERROR_MESSAGE + illegalArgumentException.getMessage();
        }
    }
}

