/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trtc.hardwareearmonitor.honor;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import com.tencent.trtc.hardwareearmonitor.honor.HonorAdvancedRecordClient;
import com.tencent.trtc.hardwareearmonitor.honor.HonorAudioFeaturesKit;
import com.tencent.trtc.hardwareearmonitor.honor.HonorAudioPlayClient;
import com.tencent.trtc.hardwareearmonitor.honor.HonorEarReturnClient;
import com.tencent.trtc.hardwareearmonitor.honor.HonorLogUtils;
import com.tencent.trtc.hardwareearmonitor.honor.IHonorAudioServiceCallback;

public class HonorFeatureKitManager {
    public static long mMinVersion;
    private static final String TAG = "HnAudioEngine.FeatureKitManager";
    private static final String ENGINE_PACKAGE_NAME = "com.hihonor.android.magicx.media.audioengine";
    private static final int PACKAGE_INFO_FLAG = 0;
    private static final int SUB_VERSION_MASK = 1000;
    private IHonorAudioServiceCallback mCallBack = null;
    private static final Object SET_CALL_BACK_LOCK;
    private static final Object NEW_FEATUREMANAGER_LOCK;
    private static final Object BIND_SERVICE_LOCK;
    private static final Object UNBIND_SERVICE_LOCK;
    private static HonorFeatureKitManager sInstance;

    private HonorFeatureKitManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HonorFeatureKitManager getInstance() {
        HonorFeatureKitManager honorFeatureKitManager;
        Object object = NEW_FEATUREMANAGER_LOCK;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new HonorFeatureKitManager();
            }
            honorFeatureKitManager = sInstance;
        }
        return honorFeatureKitManager;
    }

    public <T extends HonorAudioFeaturesKit> T createFeatureKit(int type, Context context) {
        HonorLogUtils.info(TAG, "createFeatureKit, type =".concat(String.valueOf(type)));
        if (context == null) {
            return null;
        }
        switch (type) {
            case 1: {
                HonorEarReturnClient honorEarReturnClient = new HonorEarReturnClient(context);
                honorEarReturnClient.initialize(context);
                return (T)honorEarReturnClient;
            }
            case 2: 
            case 4: {
                HonorAdvancedRecordClient honorAdvancedRecordClient = new HonorAdvancedRecordClient(context);
                honorAdvancedRecordClient.initialize(context);
                return (T)honorAdvancedRecordClient;
            }
            case 3: {
                HonorAudioPlayClient honorAudioPlayClient = new HonorAudioPlayClient(context);
                honorAudioPlayClient.initialize(context);
                return (T)honorAudioPlayClient;
            }
        }
        HonorLogUtils.info(TAG, "createFeatureKit, type error");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindService(Context context, ServiceConnection connection, String classeName) {
        Object object = BIND_SERVICE_LOCK;
        synchronized (object) {
            if (context == null) {
                return;
            }
            Intent intent = new Intent();
            intent.setClassName(ENGINE_PACKAGE_NAME, classeName);
            try {
                HonorLogUtils.info(TAG, "bindService");
                context.bindService(intent, connection, 1);
            }
            catch (Throwable throwable) {
                HonorLogUtils.error(TAG, "bindService, SecurityException, " + throwable.getMessage());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindService(Context context, ServiceConnection connectionService) {
        HonorLogUtils.info(TAG, "unbindService");
        Object object = UNBIND_SERVICE_LOCK;
        synchronized (object) {
            if (context != null) {
                context.unbindService(connectionService);
            }
            return;
        }
    }

    public static boolean isAudioKitSupport(Context context) {
        if (context == null) {
            HonorLogUtils.error(TAG, "context is null");
            return false;
        }
        PackageManager packageManager = context.getPackageManager();
        try {
            if (packageManager != null) {
                int n2 = packageManager.getPackageInfo((String)ENGINE_PACKAGE_NAME, (int)0).versionCode / 1000;
                mMinVersion = (long)n2 > 1000001L ? 1000001L : (long)n2;
                HonorLogUtils.info(TAG, " isDeviceSupport is true, enginVersionCode=" + n2 + " audioKitVersionCode=1000001");
                return true;
            }
            HonorLogUtils.error(TAG, "packageManager is null");
            return false;
        }
        catch (Throwable throwable) {
            HonorLogUtils.error(TAG, "isAudioKitSupport ,NameNotFoundException");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCallBack(int result) {
        HonorLogUtils.info(TAG, "onCallBack, result =".concat(String.valueOf(result)));
        Object object = SET_CALL_BACK_LOCK;
        synchronized (object) {
            if (this.getCallBack() != null) {
                this.getCallBack().onResult(result);
            }
            return;
        }
    }

    public void setCallBack(IHonorAudioServiceCallback callBack) {
        this.mCallBack = callBack;
    }

    protected IHonorAudioServiceCallback getCallBack() {
        return this.mCallBack;
    }

    static {
        SET_CALL_BACK_LOCK = new Object();
        NEW_FEATUREMANAGER_LOCK = new Object();
        BIND_SERVICE_LOCK = new Object();
        UNBIND_SERVICE_LOCK = new Object();
        sInstance = null;
    }
}

