/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trtc.hardwareearmonitor.honor;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.IBinder;
import com.tencent.trtc.hardwareearmonitor.honor.HonorAudioClient;
import com.tencent.trtc.hardwareearmonitor.honor.HonorAudioFeaturesKit;
import com.tencent.trtc.hardwareearmonitor.honor.HonorFeatureKitManager;
import com.tencent.trtc.hardwareearmonitor.honor.HonorLogUtils;
import com.tencent.trtc.hardwareearmonitor.honor.IHonorAdvancedRecordService;

public class HonorAdvancedRecordClient
extends HonorAudioFeaturesKit {
    private static final String TAG = "HnAudioService.HnAdvancedRecordClient";
    private static final String ENGINE_CLASS_NAME = "com.hihonor.android.magicx.media.audioengine.HnAdvancedRecordServiceImpl";
    private HonorFeatureKitManager mFeatureKitManager = null;
    private Context mContext;
    private boolean mIsServiceConnected = false;
    private IHonorAdvancedRecordService mHnAdvancedRecordService = null;
    private IBinder mService = null;
    private final IBinder mClientBinder = new Binder();
    private ServiceConnection mConnection = new ServiceConnection(){

        public final void onServiceConnected(ComponentName name, IBinder service) {
            HonorAdvancedRecordClient.this.mHnAdvancedRecordService = IHonorAdvancedRecordService.Stub.asInterface(service);
            HonorLogUtils.info(HonorAdvancedRecordClient.TAG, "HnAdvancedRecordClient onServiceConnected");
            if (HonorAdvancedRecordClient.this.mHnAdvancedRecordService != null) {
                HonorAdvancedRecordClient.this.mIsServiceConnected = true;
                HonorLogUtils.info(HonorAdvancedRecordClient.TAG, "HnAdvancedRecordClient onServiceConnected, mIHnAdvancedRecordService is not null");
                HonorAdvancedRecordClient.this.mFeatureKitManager.onCallBack(2000);
                HonorAdvancedRecordClient.this.serviceInit(HonorAdvancedRecordClient.this.mContext.getPackageName());
                HonorAdvancedRecordClient.this.serviceLinkToDeath(service);
            }
        }

        public final void onServiceDisconnected(ComponentName name) {
            HonorLogUtils.info(HonorAdvancedRecordClient.TAG, "HnAdvancedRecordClient onServiceDisconnected");
            HonorAdvancedRecordClient.this.mHnAdvancedRecordService = null;
            HonorAdvancedRecordClient.this.mIsServiceConnected = false;
            HonorAdvancedRecordClient.this.mFeatureKitManager.onCallBack(2001);
        }
    };
    private IBinder.DeathRecipient mDeathRecipient = new IBinder.DeathRecipient(){

        public final void binderDied() {
            HonorAdvancedRecordClient.this.mService.unlinkToDeath(HonorAdvancedRecordClient.this.mDeathRecipient, 0);
            HonorAdvancedRecordClient.this.mFeatureKitManager.onCallBack(6);
            HonorLogUtils.error(HonorAdvancedRecordClient.TAG, "service binder died");
            HonorAdvancedRecordClient.this.mService = null;
        }
    };

    private void serviceLinkToDeath(IBinder service) {
        this.mService = service;
        try {
            if (this.mService != null) {
                this.mService.linkToDeath(this.mDeathRecipient, 0);
            }
            return;
        }
        catch (Throwable throwable) {
            this.mFeatureKitManager.onCallBack(2002);
            HonorLogUtils.error(TAG, "serviceLinkToDeath, RemoteException");
            return;
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        HonorLogUtils.info(TAG, "destroy, HnAdvancedRecordClient mIsServiceConnected = " + this.mIsServiceConnected);
        if (this.mIsServiceConnected) {
            this.mIsServiceConnected = false;
            this.mFeatureKitManager.unbindService(this.mContext, this.mConnection);
        }
    }

    private void serviceInit(String packageName) {
        HonorLogUtils.info(TAG, "HnAdvancedRecordClient serviceInit");
        try {
            if (this.mHnAdvancedRecordService != null && this.mIsServiceConnected) {
                this.mHnAdvancedRecordService.init(packageName);
            }
            return;
        }
        catch (Throwable throwable) {
            HonorLogUtils.error(TAG, "HnAdvancedRecordClient isSupported,RemoteException ex :" + throwable.getMessage());
            return;
        }
    }

    public HonorAdvancedRecordClient(Context context) {
        this.mFeatureKitManager = HonorFeatureKitManager.getInstance();
        this.mContext = context;
    }

    public void initialize(Context context) {
        HonorLogUtils.info(TAG, "HnAdvancedRecordClient initialize");
        if (context == null) {
            HonorLogUtils.info(TAG, "initialize, context is null");
            return;
        }
        if (!HonorFeatureKitManager.isAudioKitSupport(context)) {
            this.mFeatureKitManager.onCallBack(2);
            HonorLogUtils.info(TAG, "initialize, not install AudioEngine");
            return;
        }
        this.bindService(context);
    }

    private void bindService(Context context) {
        HonorLogUtils.info(TAG, "HnAdvancedRecordClient bindService");
        if (this.mFeatureKitManager != null && !this.mIsServiceConnected) {
            this.mFeatureKitManager.bindService(context, this.mConnection, ENGINE_CLASS_NAME);
        }
    }

    public boolean enableAdvancedRecord(Context context) {
        HonorLogUtils.info(TAG, "HnAdvancedRecordClient enableAdvancedRecord");
        try {
            if (this.mHnAdvancedRecordService != null && this.mIsServiceConnected) {
                return this.mHnAdvancedRecordService.enableAdvancedRecord();
            }
            return false;
        }
        catch (Throwable throwable) {
            HonorLogUtils.error(TAG, "enableAdvancedRecord failed, RemoteException ex : " + throwable.getMessage());
            return false;
        }
    }

    public boolean disableAdvancedRecord(Context context) {
        HonorLogUtils.info(TAG, "HnAdvancedRecordClient disableAdvancedRecord mIsServiceConnected=" + this.mIsServiceConnected);
        try {
            if (this.mHnAdvancedRecordService != null && this.mIsServiceConnected) {
                return this.mHnAdvancedRecordService.disableAdvancedRecord();
            }
            return false;
        }
        catch (Throwable throwable) {
            HonorLogUtils.error(TAG, "disableAdvancedRecord failed, RemoteException ex : " + throwable.getMessage());
            return false;
        }
    }

    @Override
    public boolean isServiceSupported() {
        HonorLogUtils.info(TAG, "HnAdvancedRecordClient isSupported, type = " + HonorAudioClient.ServiceType.HNAUDIO_SERVICE_ADVANCEDRECORD.getServiceType() + ",mIsServiceConnected=" + this.mIsServiceConnected);
        try {
            if (this.mHnAdvancedRecordService != null && this.mIsServiceConnected) {
                return this.mHnAdvancedRecordService.isSupported(HonorAudioClient.ServiceType.HNAUDIO_SERVICE_ADVANCEDRECORD.getServiceType());
            }
        }
        catch (Throwable throwable) {
            HonorLogUtils.error(TAG, "isSupported,RemoteException ex : " + throwable.getMessage());
        }
        return super.isServiceSupported();
    }

    public int enableRecordDenoise(boolean enable, DenoiseMode mode, DenoiseScene scene, DenoiseLevel level) {
        if (HonorFeatureKitManager.mMinVersion < 1000001L) {
            HonorLogUtils.error(TAG, "enable record denoise fail, mix version is " + HonorFeatureKitManager.mMinVersion);
            return 2004;
        }
        try {
            if (this.mHnAdvancedRecordService != null && this.mIsServiceConnected) {
                return this.mHnAdvancedRecordService.enableRecordDenoise(enable, mode.getMode(), scene.getScene(), level.getLevel(), this.mClientBinder);
            }
            return -2;
        }
        catch (Throwable throwable) {
            HonorLogUtils.error(TAG, "enableRecordDenoise,RemoteException ex : " + throwable.getMessage());
            return -2;
        }
    }

    public static enum DenoiseLevel {
        DENOISE_DEFAULT_LEVEL(1);

        private final int mDenoiseLevel;

        private DenoiseLevel(int type) {
            this.mDenoiseLevel = type;
        }

        public final int getLevel() {
            return this.mDenoiseLevel;
        }
    }

    public static enum DenoiseScene {
        DENOISE_SPEAK_SCENE(1);

        private final int mDenoiseScene;

        private DenoiseScene(int type) {
            this.mDenoiseScene = type;
        }

        public final int getScene() {
            return this.mDenoiseScene;
        }
    }

    public static enum DenoiseMode {
        DENOISE_NN_MODE(1);

        private final int mDenoiseMode;

        private DenoiseMode(int type) {
            this.mDenoiseMode = type;
        }

        public final int getMode() {
            return this.mDenoiseMode;
        }
    }
}

