/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.tcmedia.core.drm.reuse;

import android.media.MediaDrm;
import android.media.MediaDrmException;
import android.os.Build;
import android.os.Handler;
import com.tencent.thumbplayer.tcmedia.core.common.TPNativeLog;
import com.tencent.thumbplayer.tcmedia.core.drm.ITPMediaDrm;
import com.tencent.thumbplayer.tcmedia.core.drm.TPDirectMediaDrm;
import com.tencent.thumbplayer.tcmedia.core.drm.TPMediaDrmFatalException;
import com.tencent.thumbplayer.tcmedia.core.drm.reuse.TPDoubleQueueCachedPool;
import com.tencent.thumbplayer.tcmedia.core.utils.TPThreadPool;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public class TPReuseMediaDrm
implements ITPMediaDrm {
    private static final String TAG = "[PlayerCore][TPReuseMediaDrm]";
    private static final UUID WIDEVINE_UUID = new UUID(-1301668207276963122L, -6645017420763422227L);
    private final TPMediaDrmInfo mTPMediaDrmInfo;
    private final ITPMediaDrm mTPMediaDrm;
    private final UUID mUUID;
    private final boolean mCanReUse;
    private boolean mTPMediaDrmError = false;
    private static final int INIT_POOL_SIZE = 1;
    private static final int KEEP_POOL_SIZE = 2;
    private ITPMediaDrm.OnKeyStatusChangeListener mOnKeyStatusChangeListener;
    private ITPMediaDrm.OnExpirationUpdateListener mOnExpirationUpdateListener;
    private static HashMap<UUID, TPDoubleQueueCachedPool<TPMediaDrmInfo>> mMediaDrmCachedPoolMap = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void preload() {
        if (mMediaDrmCachedPoolMap != null) {
            return;
        }
        TPDoubleQueueCachedPool<TPMediaDrmInfo> tPDoubleQueueCachedPool = new TPDoubleQueueCachedPool<TPMediaDrmInfo>(1, 2, new TPObjectLifecycleMgr(WIDEVINE_UUID));
        Class<TPReuseMediaDrm> clazz = TPReuseMediaDrm.class;
        synchronized (TPReuseMediaDrm.class) {
            if (mMediaDrmCachedPoolMap == null) {
                mMediaDrmCachedPoolMap = new HashMap<UUID, TPDoubleQueueCachedPool<TPMediaDrmInfo>>();
                mMediaDrmCachedPoolMap.put(WIDEVINE_UUID, tPDoubleQueueCachedPool);
                tPDoubleQueueCachedPool = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (tPDoubleQueueCachedPool != null) {
                tPDoubleQueueCachedPool.release();
            }
            return;
        }
    }

    public static void preloadAsync() {
        TPThreadPool.getInstance().obtainThreadExecutor().execute(new Runnable(){

            @Override
            public final void run() {
                TPReuseMediaDrm.preload();
            }
        });
    }

    private TPMediaDrmInfo allocTPMediaDrm(UUID uUID) {
        TPDoubleQueueCachedPool<TPMediaDrmInfo> tPDoubleQueueCachedPool = mMediaDrmCachedPoolMap.get(uUID);
        if (tPDoubleQueueCachedPool == null) {
            TPNativeLog.printLog(4, TAG, "allocTPMediaDrm error, this UUID DRM is not cached");
            return null;
        }
        return tPDoubleQueueCachedPool.allocObject();
    }

    public TPReuseMediaDrm(UUID uUID) {
        TPReuseMediaDrm.preload();
        TPMediaDrmInfo tPMediaDrmInfo = this.allocTPMediaDrm(uUID);
        boolean bl = this.mCanReUse = tPMediaDrmInfo != null;
        if (tPMediaDrmInfo == null) {
            TPDirectMediaDrm tPDirectMediaDrm;
            TPDirectMediaDrm tPDirectMediaDrm2 = tPDirectMediaDrm = new TPDirectMediaDrm(uUID);
            tPMediaDrmInfo = new TPMediaDrmInfo(tPDirectMediaDrm2, tPDirectMediaDrm2.openSession());
        }
        this.mTPMediaDrmInfo = tPMediaDrmInfo;
        this.mTPMediaDrm = tPMediaDrmInfo.tpMediaDrm;
        this.mUUID = uUID;
        TPNativeLog.printLog(2, TAG, "TPReuseMediaDrm constructor");
    }

    @Override
    public synchronized byte[] openSession() {
        return this.mTPMediaDrmInfo.sessionId;
    }

    @Override
    public synchronized void closeSession(byte[] byArray) {
        if (!Arrays.equals(byArray, this.mTPMediaDrmInfo.sessionId)) {
            this.mTPMediaDrmError = true;
        }
    }

    @Override
    public MediaDrm.KeyRequest getKeyRequest(byte[] byArray, byte[] byArray2, String string, int n2, HashMap<String, String> hashMap) {
        return this.mTPMediaDrm.getKeyRequest(byArray, byArray2, string, n2, hashMap);
    }

    @Override
    public byte[] provideKeyResponse(byte[] byArray, byte[] byArray2) {
        return this.mTPMediaDrm.provideKeyResponse(byArray, byArray2);
    }

    @Override
    public MediaDrm.ProvisionRequest getProvisionRequest() {
        return this.mTPMediaDrm.getProvisionRequest();
    }

    @Override
    public void provideProvisionResponse(byte[] byArray) {
        this.mTPMediaDrm.provideProvisionResponse(byArray);
    }

    @Override
    public void restoreKeys(byte[] byArray, byte[] byArray2) {
        this.mTPMediaDrm.restoreKeys(byArray, byArray2);
    }

    @Override
    public void removeKeys(byte[] byArray) {
        this.mTPMediaDrm.removeKeys(byArray);
    }

    @Override
    public void setOnKeyStatusChangeListener(ITPMediaDrm.OnKeyStatusChangeListener onKeyStatusChangeListener, Handler handler) {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        this.mOnKeyStatusChangeListener = onKeyStatusChangeListener;
        this.mTPMediaDrm.setOnKeyStatusChangeListener(new ITPMediaDrm.OnKeyStatusChangeListener(){

            @Override
            public void onKeyStatusChange(ITPMediaDrm iTPMediaDrm, byte[] byArray, List<MediaDrm.KeyStatus> list, boolean bl) {
                ITPMediaDrm.OnKeyStatusChangeListener onKeyStatusChangeListener = TPReuseMediaDrm.this.mOnKeyStatusChangeListener;
                if (onKeyStatusChangeListener != null) {
                    onKeyStatusChangeListener.onKeyStatusChange(TPReuseMediaDrm.this, byArray, list, bl);
                }
            }
        }, handler);
    }

    @Override
    public void setOnExpirationUpdateListener(ITPMediaDrm.OnExpirationUpdateListener onExpirationUpdateListener, Handler handler) {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        this.mOnExpirationUpdateListener = onExpirationUpdateListener;
        this.mTPMediaDrm.setOnExpirationUpdateListener(new ITPMediaDrm.OnExpirationUpdateListener(){

            @Override
            public void onExpirationUpdate(ITPMediaDrm iTPMediaDrm, byte[] byArray, long l2) {
                ITPMediaDrm.OnExpirationUpdateListener onExpirationUpdateListener = TPReuseMediaDrm.this.mOnExpirationUpdateListener;
                if (onExpirationUpdateListener != null) {
                    onExpirationUpdateListener.onExpirationUpdate(TPReuseMediaDrm.this, byArray, l2);
                }
            }
        }, handler);
    }

    @Override
    public HashMap<String, String> queryKeyStatus(byte[] byArray) {
        return this.mTPMediaDrm.queryKeyStatus(byArray);
    }

    @Override
    public String getPropertyString(String string) {
        return this.mTPMediaDrm.getPropertyString(string);
    }

    @Override
    public void setPropertyString(String string, String string2) {
        this.mTPMediaDrm.setPropertyString(string, string2);
    }

    private void freeTPMediaDrm(UUID uUID, TPMediaDrmInfo tPMediaDrmInfo, boolean bl) {
        TPDoubleQueueCachedPool<TPMediaDrmInfo> tPDoubleQueueCachedPool = mMediaDrmCachedPoolMap.get(uUID);
        if (tPDoubleQueueCachedPool == null) {
            tPMediaDrmInfo.tpMediaDrm.close();
            return;
        }
        if (bl) {
            tPDoubleQueueCachedPool.freeObject(tPMediaDrmInfo);
            return;
        }
        tPDoubleQueueCachedPool.recycleObject(tPMediaDrmInfo);
    }

    @Override
    public void close() {
        if (Build.VERSION.SDK_INT >= 23) {
            this.mTPMediaDrm.setOnExpirationUpdateListener(null, null);
        }
        this.mOnExpirationUpdateListener = null;
        if (Build.VERSION.SDK_INT >= 23) {
            this.mTPMediaDrm.setOnKeyStatusChangeListener(null, null);
        }
        this.mOnKeyStatusChangeListener = null;
        if (!this.mCanReUse) {
            this.mTPMediaDrm.close();
            return;
        }
        TPThreadPool.getInstance().obtainThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                TPReuseMediaDrm.this.freeTPMediaDrm(TPReuseMediaDrm.this.mUUID, TPReuseMediaDrm.this.mTPMediaDrmInfo, TPReuseMediaDrm.this.mTPMediaDrmError);
            }
        });
    }

    static class TPObjectLifecycleMgr
    implements TPDoubleQueueCachedPool.ITPObjectLifecycleMgr<TPMediaDrmInfo> {
        private final UUID mUUID;

        public TPObjectLifecycleMgr(UUID uUID) {
            this.mUUID = uUID;
        }

        @Override
        public TPMediaDrmInfo create(TPDoubleQueueCachedPool<TPMediaDrmInfo> tPDoubleQueueCachedPool) {
            try {
                TPDirectMediaDrm tPDirectMediaDrm;
                TPDirectMediaDrm tPDirectMediaDrm2 = tPDirectMediaDrm = new TPDirectMediaDrm(this.mUUID);
                return new TPMediaDrmInfo(tPDirectMediaDrm2, tPDirectMediaDrm2.openSession());
            }
            catch (MediaDrmException | TPMediaDrmFatalException throwable) {
                TPNativeLog.printLog(4, TPReuseMediaDrm.TAG, "createObject error:".concat(String.valueOf(throwable)));
                return null;
            }
        }

        @Override
        public void release(TPDoubleQueueCachedPool<TPMediaDrmInfo> tPDoubleQueueCachedPool, TPMediaDrmInfo tPMediaDrmInfo) {
            tPMediaDrmInfo.tpMediaDrm.close();
        }

        @Override
        public boolean reset(TPDoubleQueueCachedPool<TPMediaDrmInfo> tPDoubleQueueCachedPool, TPMediaDrmInfo tPMediaDrmInfo) {
            tPMediaDrmInfo.tpMediaDrm.closeSession(tPMediaDrmInfo.sessionId);
            try {
                tPMediaDrmInfo.sessionId = tPMediaDrmInfo.tpMediaDrm.openSession();
            }
            catch (MediaDrmException | TPMediaDrmFatalException throwable) {
                TPNativeLog.printLog(4, TPReuseMediaDrm.TAG, "reset error:".concat(String.valueOf(throwable)));
                return false;
            }
            return true;
        }
    }

    static class TPMediaDrmInfo {
        final ITPMediaDrm tpMediaDrm;
        byte[] sessionId;

        public TPMediaDrmInfo(ITPMediaDrm iTPMediaDrm, byte[] byArray) {
            this.tpMediaDrm = iTPMediaDrm;
            this.sessionId = byArray;
        }
    }
}

