/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.tcmedia.core.downloadproxy.utils;

import android.content.Context;
import android.os.Environment;
import com.tencent.thumbplayer.tcmedia.core.downloadproxy.utils.TPDLIOUtil;
import java.io.File;

public class TPDLFileSystem {
    public static File getExternalDirectory(Context context) {
        File file = Environment.getExternalStorageDirectory();
        if (file == null) {
            return null;
        }
        String string = file.getAbsolutePath() + File.separator + "Android" + File.separator + "data" + File.separator + context.getPackageName() + File.separator + "files";
        return new File(string);
    }

    public static File getExternalDirectory(Context context, String subdir) {
        File file = TPDLFileSystem.getExternalDirectory(context);
        if (file == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(file.getAbsolutePath()).append(File.separator).append(subdir);
        return new File(stringBuilder.toString());
    }

    public static void deleteExternalDirectory(Context context, String subdir) {
        TPDLIOUtil.recursiveDelete(TPDLFileSystem.getExternalDirectory(context, subdir));
    }

    public static File getExternalFile(Context context, String subdir, String filename) {
        File file = TPDLFileSystem.getExternalDirectory(context, subdir);
        if (file == null) {
            return null;
        }
        return new File(file, filename);
    }

    public static File getExternalCacheDirectory(Context context) {
        return context.getExternalCacheDir();
    }

    public static File getExternalCacheDirectory(Context context, String subdir) {
        File file = TPDLFileSystem.getExternalCacheDirectory(context);
        if (file == null) {
            return null;
        }
        String string = file.getAbsolutePath() + File.separator + subdir;
        return new File(string);
    }

    public static File getExternalCacheFile(Context context, String subdir, String filename) {
        File file = TPDLFileSystem.getExternalCacheDirectory(context, subdir);
        if (file == null) {
            return null;
        }
        return new File(file, filename);
    }

    public static void clearExternalCache(Context context) {
        TPDLIOUtil.recursiveDelete(TPDLFileSystem.getExternalCacheDirectory(context));
    }

    public static void clearExternalCache(Context context, String subdir) {
        TPDLIOUtil.recursiveDelete(TPDLFileSystem.getExternalCacheDirectory(context, subdir));
    }

    public static File getInternalDirectory(Context context) {
        return context.getFilesDir();
    }

    public static File getInternalDirectory(Context context, String subdir) {
        File file = TPDLFileSystem.getInternalDirectory(context);
        if (file == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(file.getAbsolutePath()).append(File.separator).append(subdir);
        return new File(stringBuilder.toString());
    }

    public static void deleteInternalDirectory(Context context, String subdir) {
        TPDLIOUtil.recursiveDelete(TPDLFileSystem.getInternalDirectory(context, subdir));
    }

    public static File getInternalFile(Context context, String subdir, String filename) {
        File file = TPDLFileSystem.getInternalDirectory(context, subdir);
        if (file == null) {
            return null;
        }
        return new File(file, filename);
    }

    public static File getInternalCacheDirectory(Context context) {
        return context.getCacheDir();
    }

    public static File getInternalCacheDirectory(Context context, String subdir) {
        File file = TPDLFileSystem.getInternalCacheDirectory(context);
        if (file == null) {
            return null;
        }
        String string = file.getAbsolutePath() + File.separator + subdir;
        return new File(string);
    }

    public static File getInternalCacheFile(Context context, String subdir, String filename) {
        File file = TPDLFileSystem.getInternalCacheDirectory(context, subdir);
        if (file == null) {
            return null;
        }
        return new File(file, filename);
    }

    public static void clearInternalCache(Context context) {
        TPDLIOUtil.recursiveDelete(TPDLFileSystem.getInternalCacheDirectory(context));
    }

    public static void clearInternalCache(Context context, String subdir) {
        TPDLIOUtil.recursiveDelete(TPDLFileSystem.getInternalCacheDirectory(context, subdir));
    }

    public static File getProperFile(Context context, String subdir, String filename) {
        if (TPDLIOUtil.isExternalStorageMounted()) {
            return TPDLFileSystem.getExternalFile(context, subdir, filename);
        }
        return TPDLFileSystem.getInternalFile(context, subdir, filename);
    }

    public static File getProperCacheFile(Context context, String subdir, String filename) {
        if (TPDLIOUtil.isExternalStorageMounted()) {
            return TPDLFileSystem.getExternalCacheFile(context, subdir, filename);
        }
        return TPDLFileSystem.getInternalCacheFile(context, subdir, filename);
    }

    public static void clearCache(Context context) {
        TPDLFileSystem.clearInternalCache(context);
        TPDLFileSystem.clearExternalCache(context);
    }

    public static void clearCache(Context context, String subdir) {
        TPDLFileSystem.clearInternalCache(context, subdir);
        TPDLFileSystem.clearExternalCache(context, subdir);
    }

    public static void deleteDirectory(Context context, String subdir) {
        TPDLFileSystem.deleteInternalDirectory(context, subdir);
        TPDLFileSystem.deleteExternalDirectory(context, subdir);
    }

    public static File getNewerFile(Context context, String subdir, String filename) {
        File file = TPDLFileSystem.getInternalFile(context, subdir, filename);
        File file2 = TPDLFileSystem.getExternalFile(context, subdir, filename);
        return TPDLIOUtil.compare(file, file2);
    }

    public static File getNewerCacheFile(Context context, String subdir, String filename) {
        File file = TPDLFileSystem.getInternalCacheFile(context, subdir, filename);
        File file2 = TPDLFileSystem.getExternalCacheFile(context, subdir, filename);
        return TPDLIOUtil.compare(file, file2);
    }

    public static File getProperCacheDirectory(Context context, String subdir) {
        if (TPDLIOUtil.isExternalStorageMounted()) {
            return TPDLFileSystem.getExternalCacheDirectory(context, subdir);
        }
        return TPDLFileSystem.getInternalCacheDirectory(context, subdir);
    }

    public static File getProperDirectory(Context context, String subdir) {
        if (TPDLIOUtil.isExternalStorageMounted()) {
            return TPDLFileSystem.getExternalDirectory(context, subdir);
        }
        return TPDLFileSystem.getInternalDirectory(context, subdir);
    }
}

