/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.tcmedia.core.common;

import android.content.Context;
import android.text.TextUtils;
import com.tencent.thumbplayer.tcmedia.core.common.ITPNativeLibraryExternalLoader;
import com.tencent.thumbplayer.tcmedia.core.common.TPLoadLibFromApk;
import com.tencent.thumbplayer.tcmedia.core.common.TPNativeLog;
import com.tencent.thumbplayer.tcmedia.core.common.TPSystemInfo;

public class TPNativeLibraryLoader {
    private static Object mIsLibLoadedLock = new Object();
    private static boolean mIsLibLoaded = false;
    private static ITPNativeLibraryExternalLoader mLibLoader = null;
    private static final String MAIN_PLAYER_CORE_VERSION = "2.32.0";
    private static final String DEFAULT_LIB_PLAYER_CORE_VERSION = "2.32.0.495.min";
    private static final String mLibPlayerCorePrefix = "tpcore-master";
    private static final String mLibThirdPartiesPrefix = "tpthirdparties-master";
    private static final String mLibIjkPrefix = "ijkhlscache-master";
    private static final boolean mIsNeedLoadThirdPartiesAndFFmpeg = true;
    private static final boolean mLibNameHasArchSuffix = false;
    private static final int mPlayerCoreSupportMinAndroidAPILevel = 14;

    private static native String _getPlayerCoreVersion();

    public static void setLibLoader(ITPNativeLibraryExternalLoader iTPNativeLibraryExternalLoader) {
        mLibLoader = iTPNativeLibraryExternalLoader;
    }

    public static String getLibVersion() {
        return TPNativeLibraryLoader.getPlayerCoreVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLibIfNeeded(Context context) {
        Object object = mIsLibLoadedLock;
        synchronized (object) {
            if (!mIsLibLoaded) {
                mIsLibLoaded = TPNativeLibraryLoader.loadLib(context);
                if (mIsLibLoaded) {
                    TPNativeLog.printLog(2, "TPNativeLibraryLoader load lib successfully");
                } else {
                    TPNativeLog.printLog(2, "TPNativeLibraryLoader load lib failed");
                }
            }
            if (!mIsLibLoaded) {
                throw new UnsupportedOperationException("Failed to load native library");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLibLoadedAndTryToLoad() {
        boolean bl;
        try {
            TPNativeLibraryLoader.loadLibIfNeeded(null);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, "TPNativeLibraryLoader isLibLoaded error:" + throwable.getMessage());
        }
        Object object = mIsLibLoadedLock;
        synchronized (object) {
            bl = mIsLibLoaded;
        }
        return bl;
    }

    public static boolean isLibLoaded() {
        return mIsLibLoaded;
    }

    public static String getPlayerCoreVersion() {
        try {
            return TPNativeLibraryLoader._getPlayerCoreVersion();
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(2, "getPlayerCoreVersion: *.so is not loaded yet, return the hard-coded version number:2.32.0.495.min");
            return DEFAULT_LIB_PLAYER_CORE_VERSION;
        }
    }

    private static boolean loadLib(Context context) {
        String string;
        TPNativeLog.printLog(2, "loadLib cpu arch:" + TPSystemInfo.getCpuArchitecture());
        if (TPSystemInfo.getApiLevel() < 14) {
            TPNativeLog.printLog(3, "so load failed, current api level " + TPSystemInfo.getApiLevel() + " is less than 14");
            return false;
        }
        if (TPSystemInfo.getCpuArchitecture() == 3 || TPSystemInfo.getCpuArchitecture() == 4 || TPSystemInfo.getCpuArchitecture() == 0) {
            return false;
        }
        String string2 = "";
        String string3 = mLibThirdPartiesPrefix.concat(String.valueOf(string2));
        boolean bl = mLibLoader != null ? mLibLoader.loadLib(string3, DEFAULT_LIB_PLAYER_CORE_VERSION) : TPNativeLibraryLoader.loadLibDefault(string3, context);
        if (!bl) {
            TPNativeLog.printLog(4, "Failed to load ".concat(String.valueOf(string3)));
            return false;
        }
        string3 = mLibPlayerCorePrefix.concat(String.valueOf(string2));
        bl = mLibLoader != null ? mLibLoader.loadLib(string3, DEFAULT_LIB_PLAYER_CORE_VERSION) : TPNativeLibraryLoader.loadLibDefault(string3, context);
        if (bl && !(bl = TPNativeLibraryLoader.isMatchJavaAndPlayerCore(MAIN_PLAYER_CORE_VERSION, string = TPNativeLibraryLoader.getPlayerCoreVersion()))) {
            TPNativeLog.printLog(4, "nativePlayerCoreVer(" + string + ") doesn't match javaPlayerCoreVer:(2.32.0)");
        }
        string3 = mLibIjkPrefix.concat(String.valueOf(string2));
        if (mLibLoader != null) {
            mLibLoader.loadLib(string3, DEFAULT_LIB_PLAYER_CORE_VERSION);
        } else {
            TPNativeLibraryLoader.loadLibDefault(string3, context);
        }
        if (bl) {
            TPNativeLog.printLog(2, "Native libs loaded successfully");
        } else {
            TPNativeLog.printLog(4, "Failed to load native libs");
        }
        return bl;
    }

    private static boolean loadLibDefault(String string, Context context) {
        boolean bl = false;
        try {
            TPNativeLog.printLog(2, "loadLibDefault loading ".concat(String.valueOf(string)));
            System.loadLibrary(string);
            bl = true;
            TPNativeLog.printLog(2, "loadLibDefault " + string + " loaded successfully");
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, "loadLibDefault failed to load " + string + "," + throwable.getMessage());
        }
        if (!bl && context != null && TPSystemInfo.getCpuArchitecture() >= 6) {
            try {
                TPNativeLog.printLog(2, "loadLibDefault try to load " + string + " from APK");
                bl = TPLoadLibFromApk.load(string, TPNativeLibraryLoader.class.getClassLoader(), context);
                if (bl) {
                    TPNativeLog.printLog(2, "loadLibDefault loaded " + string + " from APK successfully");
                } else {
                    TPNativeLog.printLog(4, "loadLibDefault loaded " + string + " from APK failed");
                }
            }
            catch (Throwable throwable) {
                TPNativeLog.printLog(4, "loadLibDefault loaded " + string + " from APK failed," + throwable.getMessage());
            }
        }
        return bl;
    }

    private static boolean isMatchJavaAndPlayerCore(String string, String string2) {
        boolean bl = true;
        TPNativeLog.printLog(2, "javaVersion:" + string + ", coreVersion:" + string2);
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
            bl = false;
        } else {
            String[] stringArray = string.split("\\.");
            String[] stringArray2 = string2.split("\\.");
            if (stringArray.length < 3 || stringArray2.length < 3) {
                bl = false;
            } else {
                for (int i2 = 0; i2 < 3; ++i2) {
                    if (stringArray[i2].matches(stringArray2[i2])) continue;
                    bl = false;
                    break;
                }
            }
        }
        return bl;
    }
}

