/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.tcmedia.core.common;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import com.tencent.thumbplayer.tcmedia.core.common.TPAudioPassThroughPluginDetector;
import com.tencent.thumbplayer.tcmedia.core.common.TPCodecCapability;
import com.tencent.thumbplayer.tcmedia.core.common.TPMediaCodecProfileLevel;
import com.tencent.thumbplayer.tcmedia.core.common.TPMediaDecoderInfo;
import com.tencent.thumbplayer.tcmedia.core.common.TPMediaDecoderList;
import com.tencent.thumbplayer.tcmedia.core.common.TPNativeLog;
import com.tencent.thumbplayer.tcmedia.core.common.TPSystemInfo;
import com.tencent.thumbplayer.tcmedia.core.thirdparties.LocalCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class TPCodecUtils {
    private static final String TAG = "TPCodecUtils";
    public static final int PLAYER_LEVEL_UNKNOWN = -1;
    public static final int PLAYER_LEVEL_0 = 0;
    public static final int PLAYER_LEVEL_1 = 1;
    public static final int PLAYER_LEVEL_6 = 6;
    public static final int PLAYER_LEVEL_11 = 11;
    public static final int PLAYER_LEVEL_16 = 16;
    public static final int PLAYER_LEVEL_21 = 21;
    public static final int PLAYER_LEVEL_26 = 26;
    public static final int PLAYER_LEVEL_28 = 28;
    public static final int PLAYER_LEVEL_33 = 33;
    private static int mHevcDeviceLevel = -1;
    private static int mAvs3DeviceLevel = -1;
    private static int mVvcDeviceLevel = -1;
    private static int mAACMaxSupportedSamplerate = 96000;
    private static int mFLACMaxSupportedSamplerate = 192000;
    private static int mDDPMaxSupportedSamplerate = 48000;
    private static int mAACMaxSupportedChannels = 8;
    private static int mFLACMaxSupportedChannels = 8;
    private static int mDDPMaxSupportedChannels = 8;
    private static int mAACMaxSupportedBitrate = 510000;
    private static int mFLACMaxSupportedBitrate = 21000000;
    private static int mDDPMaxSupportedBitrate = 6144000;
    private static HashMap<String, Integer> mCodecCapWhiteList = null;
    private static HashMap<String, Integer> mCodecCapBlackList = null;
    private static Context mContext = null;
    private static LocalCache mLocalCache = null;
    protected static ArrayList<String> mVMediaCodecCapList = new ArrayList();
    protected static ArrayList<String> mAMediaCodecCapList = new ArrayList();
    private static ArrayList<String> mVMediaCodecBlackListModel = new ArrayList();
    private static ArrayList<String> mAMediaCodecBlackListModel = new ArrayList();
    private static ArrayList<String> mAMediaCodecBlackListInstance = new ArrayList();
    private static ArrayList<String> mSupportedMediaCodec = new ArrayList();
    private static HashMap<Integer, HashMap<String, TPCodecCapability.TPHdrSupportVersionRange>> mHdrWhiteMap = new HashMap();
    private static HashMap<Integer, HashMap<String, TPCodecCapability.TPHdrSupportVersionRange>> mHdrBlackMap = new HashMap();
    private static HashMap<String, TPCodecCapability.TPHdrSupportVersionRange> mHDRVividSupportVersionMap = new HashMap();
    private static HashMap<Integer, ArrayList<TPCodecCapability.TPHdrSupportVersionRange>> mHDRTypeToHDRSoftwareCodecWhiteListMap = new HashMap();
    private static HashMap<Integer, ArrayList<TPCodecCapability.TPHdrSupportVersionRange>> mHDRTypeToHDRHardwareCodecWhiteListMap = new HashMap();
    private static HashMap<String, String> mAudioMaxCapCodecInstance = new HashMap();
    private static ArrayList<String> mWideVineBlackListModel = new ArrayList();
    private static HashMap<Integer, ArrayList<String>> mDrmL1BlackList = new HashMap();
    private static boolean mIsInitDone = false;
    private static boolean mPreferredSoftwareComponent = false;
    private static int mShdHevcQualcommIndex = 32;
    private static int mHdHevcQualcommIndex = 20;
    private static int mShdHevcMtkIndex = 12;
    private static int mHdHevcMtkIndex = 8;
    private static int mShdHevcHisiIndex = 8;
    private static int mHdHevcHisiIndex = 3;
    private static int mShdHevcSamsungIndex = 8;
    private static int mHdHevcSamsungIndex = 5;
    private static int mFhdAvs3QualcommIndex = 58;
    private static int mShdAvs3QualcommIndex = 55;
    private static int mFhdAvs3HisiIndex = 14;
    private static final String VVC_SHD_QUALCOMMN_CPU_NAME = "SM8250";
    private static final String VVC_SHD_MTK_CPU_NAME = "MT6893";
    private static final String VVC_SHD_HISI_CPU_NAME = "Kirin9000E";
    private static final String VVC_SHD_SAMSUNG_CPU_NAME = "Exynos2100";
    public static final int CAP_VIDEO_AVC = 1;
    public static final int CAP_VIDEO_HEVC = 2;
    public static final int CAP_VIDEO_VP9 = 4;
    public static final int CAP_AUDIO_AAC = 8;
    public static final int CAP_AUDIO_DD = 16;
    public static final int CAP_AUDIO_DDP = 32;
    public static final int CAP_AUDIO_FLAC = 64;
    public static final int CAP_AUDIO_DTS = 128;
    public static final int CAP_VIDEO_VP8 = 256;
    private static SparseArray<VideoSwCapabilityModel> mVideoCodecIdToSwCapabilityModel = new SparseArray();
    private static HashMap<DefinitionName, Integer> mDefinitionNameToDecodeLevelTable = new HashMap();
    private static boolean mIsFFmpegCapGot;
    private static TPCodecCapability.TPCodecMaxCapability mAVCSWMaxCapability;
    private static TPCodecCapability.TPCodecMaxCapability mHEVCSWMaxCapability;
    private static TPCodecCapability.TPCodecMaxCapability mVP9SWMaxCapability;
    private static TPCodecCapability.TPCodecMaxCapability mAVS3WMaxCapability;
    private static TPCodecCapability.TPCodecMaxCapability mAV1SWMaxCapability;
    private static TPCodecCapability.TPCodecMaxCapability mVP8SWMaxCapability;
    private static TPCodecCapability.TPCodecMaxCapability mVVCSWMaxCapability;
    private static HashMap<Integer, TPCodecCapability.TPCodecMaxCapability> mMaxVCodecHwCapabilityMap;
    private static HashMap<Integer, TPCodecCapability.TPCodecMaxCapability> mMaxVCodecSwCapabilityMap;
    private static HashMap<Integer, TPCodecCapability.TPCodecMaxCapability> mMaxACodecHwCapabilityMap;
    private static HashMap<Integer, TPCodecCapability.TPCodecMaxCapability> mMaxACodecSwCapabilityMap;

    public static synchronized void init(Context context, boolean bl) {
        mContext = context.getApplicationContext();
        if (bl) {
            mLocalCache = LocalCache.get(mContext);
        }
        TPCodecUtils.getDecoderMaxCapabilityMapAsync();
    }

    public static synchronized void getDecoderMaxCapabilityMapAsync() {
        if (mIsInitDone) {
            return;
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public final void run() {
                TPCodecUtils.getVMediaCodecMaxCapabilityMap();
                TPCodecUtils.getAMediaCodecMaxCapabilityMap();
                TPCodecUtils.getVCodecSWMaxCapabilityMap();
                TPCodecUtils.getACodecSWMaxCapabilityMap();
                mIsInitDone = true;
            }
        });
        thread.setName("TP_codec_init_thread");
        thread.start();
    }

    /*
     * Unable to fully structure code
     */
    public static int getHevcSWDecodeLevel() {
        var2 = TPSystemInfo.getCpuHarewareName();
        var0_1 = TPSystemInfo.getCpuHWProducter(var2);
        var1_2 = TPSystemInfo.getCpuHWProductIndex(var2);
        TPNativeLog.printLog(2, "TPCodecUtils", "[getHevcSWDecodeLevel], mCpuHWProducter = " + var0_1 + ", getMaxCpuFreq() = " + TPSystemInfo.getMaxCpuFreq() + ", numCores = " + TPSystemInfo.getNumCores() + ", mCpuHWProductIdx=" + var1_2 + ", hardware=" + var2);
        if (-1 != TPCodecUtils.mHevcDeviceLevel) {
            return TPCodecUtils.mHevcDeviceLevel;
        }
        TPCodecUtils.mHevcDeviceLevel = 0;
        if (-1 == var0_1) ** GOTO lbl44
        switch (var0_1) {
            case 0: {
                if (var1_2 >= TPCodecUtils.mShdHevcQualcommIndex) {
                    TPCodecUtils.mHevcDeviceLevel = 21;
                    break;
                }
                if (var1_2 >= TPCodecUtils.mHdHevcQualcommIndex) {
                    TPCodecUtils.mHevcDeviceLevel = 16;
                    break;
                }
                TPCodecUtils.mHevcDeviceLevel = TPCodecUtils.getDecodeLevelByCoresAndFreq();
                break;
            }
            case 1: {
                if (var1_2 >= TPCodecUtils.mShdHevcMtkIndex) {
                    TPCodecUtils.mHevcDeviceLevel = 21;
                    break;
                }
                if (var1_2 >= TPCodecUtils.mHdHevcMtkIndex) {
                    TPCodecUtils.mHevcDeviceLevel = 16;
                    break;
                }
                TPCodecUtils.mHevcDeviceLevel = TPCodecUtils.getDecodeLevelByCoresAndFreq();
                break;
            }
            case 2: {
                if (var1_2 >= TPCodecUtils.mShdHevcHisiIndex) {
                    TPCodecUtils.mHevcDeviceLevel = 21;
                    break;
                }
                if (var1_2 >= TPCodecUtils.mHdHevcHisiIndex) {
                    TPCodecUtils.mHevcDeviceLevel = 16;
                    break;
                }
                TPCodecUtils.mHevcDeviceLevel = TPCodecUtils.getDecodeLevelByCoresAndFreq();
                break;
            }
            case 3: {
                if (var1_2 >= TPCodecUtils.mShdHevcSamsungIndex) {
                    TPCodecUtils.mHevcDeviceLevel = 21;
                    break;
                }
                if (var1_2 >= TPCodecUtils.mHdHevcSamsungIndex) {
                    TPCodecUtils.mHevcDeviceLevel = 16;
                    break;
                }
lbl44:
                // 3 sources

                TPCodecUtils.mHevcDeviceLevel = TPCodecUtils.getDecodeLevelByCoresAndFreq();
            }
        }
        return TPCodecUtils.mHevcDeviceLevel;
    }

    public static int getAV1SWDecodeLevel() {
        return TPCodecUtils.getDecodeLevelByCoresAndFreq();
    }

    private static int convertDefinitionNameToDecodeLevel(DefinitionName definitionName) {
        Integer n2 = mDefinitionNameToDecodeLevelTable.get((Object)definitionName);
        if (n2 != null) {
            return n2;
        }
        return -1;
    }

    private static int selectBestDecodeLevelFromCapabilityTable(int n2, int n3, int n4) {
        VideoSwCapabilityModel videoSwCapabilityModel = (VideoSwCapabilityModel)mVideoCodecIdToSwCapabilityModel.get(n2);
        if (videoSwCapabilityModel == null) {
            TPNativeLog.printLog(3, TAG, "No corresponding codec id found, codecId:".concat(String.valueOf(n2)));
            return -1;
        }
        HashMap hashMap = (HashMap)videoSwCapabilityModel.mCpuProducerToAllDefinitionDecTable.get(n3);
        if (hashMap == null || hashMap.isEmpty()) {
            TPNativeLog.printLog(3, TAG, "No corresponding cpu producer found, cpuHwProducer:".concat(String.valueOf(n3)));
            return -1;
        }
        for (DefinitionName definitionName : DefinitionName.values()) {
            String string = (String)hashMap.get((Object)definitionName);
            if (TextUtils.isEmpty((CharSequence)string) || n4 < TPSystemInfo.getCpuHWProductIndex(n3, string)) continue;
            return TPCodecUtils.convertDefinitionNameToDecodeLevel(definitionName);
        }
        return -1;
    }

    private static int getVvcSWDecodeLevel() {
        if (mVvcDeviceLevel != -1) {
            return mVvcDeviceLevel;
        }
        String string = TPSystemInfo.getCpuHarewareName();
        int n2 = TPSystemInfo.getCpuHWProducter(string);
        int n3 = TPSystemInfo.getCpuHWProductIndex(string);
        TPNativeLog.printLog(2, TAG, "[getVvcSWDecodeLevel], mCpuHWProducer = " + n2 + ", getMaxCpuFreq() = " + TPSystemInfo.getMaxCpuFreq() + ", numCores = " + TPSystemInfo.getNumCores() + ", mCpuHWProductIdx = " + n3 + ", hardware = " + string);
        if (n2 == -1) {
            TPNativeLog.printLog(3, TAG, "current cpu manufacturer is not listed in the performance list, cpuHwProducer:".concat(String.valueOf(n2)));
            mVvcDeviceLevel = 0;
            return 0;
        }
        if (n3 == -1) {
            TPNativeLog.printLog(3, TAG, "current cpu model is not listed in the performance list, cpuHwProductIdx:".concat(String.valueOf(n3)));
            mVvcDeviceLevel = 0;
            return 0;
        }
        int n4 = TPCodecUtils.selectBestDecodeLevelFromCapabilityTable(193, n2, n3);
        mVvcDeviceLevel = n4 != -1 ? n4 : 0;
        return mVvcDeviceLevel;
    }

    /*
     * Unable to fully structure code
     */
    public static int getAvs3SWDecodeLevel() {
        var2 = TPSystemInfo.getCpuHarewareName();
        var0_1 = TPSystemInfo.getCpuHWProducter(var2);
        var1_2 = TPSystemInfo.getCpuHWProductIndex(var2);
        TPNativeLog.printLog(2, "TPCodecUtils", "[getAvs3SWDecodeLevel], mCpuHWProducter = " + var0_1 + ", getMaxCpuFreq() = " + TPSystemInfo.getMaxCpuFreq() + ", numCores = " + TPSystemInfo.getNumCores() + ", mCpuHWProductIdx=" + var1_2 + ", hardware=" + var2);
        if (-1 != TPCodecUtils.mAvs3DeviceLevel) {
            return TPCodecUtils.mAvs3DeviceLevel;
        }
        TPCodecUtils.mAvs3DeviceLevel = 0;
        if (-1 == var0_1) ** GOTO lbl-1000
        switch (var0_1) {
            case 0: {
                if (var1_2 >= TPCodecUtils.mFhdAvs3QualcommIndex) {
                    TPCodecUtils.mAvs3DeviceLevel = 26;
                    break;
                }
                if (var1_2 >= TPCodecUtils.mShdAvs3QualcommIndex) {
                    TPCodecUtils.mAvs3DeviceLevel = 21;
                    break;
                }
                TPCodecUtils.mAvs3DeviceLevel = TPCodecUtils.getDecodeLevelByCoresAndFreq();
                break;
            }
            case 1: {
                TPCodecUtils.mAvs3DeviceLevel = TPCodecUtils.getDecodeLevelByCoresAndFreq();
                break;
            }
            case 2: {
                if (var1_2 >= TPCodecUtils.mFhdAvs3HisiIndex) {
                    TPCodecUtils.mAvs3DeviceLevel = 26;
                    break;
                }
                TPCodecUtils.mAvs3DeviceLevel = TPCodecUtils.getDecodeLevelByCoresAndFreq();
                break;
            }
            case 3: lbl-1000:
            // 2 sources

            {
                TPCodecUtils.mAvs3DeviceLevel = TPCodecUtils.getDecodeLevelByCoresAndFreq();
            }
        }
        return TPCodecUtils.mAvs3DeviceLevel;
    }

    private static int getDecodeLevelByCoresAndFreq() {
        int n2 = TPSystemInfo.getNumCores() >= 8 ? (TPSystemInfo.getMaxCpuFreq() / 1000L >= 1200L ? 21 : 16) : (TPSystemInfo.getNumCores() >= 6 ? (TPSystemInfo.getMaxCpuFreq() / 1000L >= 1400L ? 21 : 16) : (TPSystemInfo.getNumCores() >= 4 ? (TPSystemInfo.getMaxCpuFreq() / 1000L >= 1600L ? 21 : 16) : 6));
        return n2;
    }

    private static <K, T> void replace(K k2, T t2, HashMap<K, T> hashMap) {
        if (hashMap.containsKey(k2)) {
            hashMap.remove(k2);
            hashMap.put(k2, t2);
            return;
        }
        hashMap.put(k2, t2);
    }

    private static int getSoftMaxSamples(int n2) {
        int n3 = 0;
        switch (n2) {
            case 1: {
                n3 = 129600;
                break;
            }
            case 6: {
                n3 = 307200;
                break;
            }
            case 11: {
                n3 = 407040;
                break;
            }
            case 16: {
                n3 = 480000;
                break;
            }
            case 21: {
                n3 = 921600;
                break;
            }
            case 26: {
                n3 = 2073600;
                break;
            }
            case 28: {
                n3 = 8294400;
                break;
            }
            case 33: {
                n3 = 0x870000;
            }
        }
        return n3;
    }

    private static int getValueFromSubstring(String string, int n2, int n3) {
        n2 = n2 < 0 ? 0 : n2;
        n3 = n3 >= string.length() ? string.length() - 1 : n3;
        n2 = n2 > n3 ? n3 : n2;
        return Integer.parseInt(string.substring(n2, n3));
    }

    public static synchronized HashMap<Integer, TPCodecCapability.TPCodecMaxCapability> getVCodecSWMaxCapabilityMap() {
        if (mIsFFmpegCapGot) {
            return mMaxVCodecSwCapabilityMap;
        }
        try {
            int n2 = TPCodecUtils.getHevcSWDecodeLevel();
            int n3 = TPCodecUtils.getSoftMaxSamples(n2);
            int n4 = TPCodecUtils.getAvs3SWDecodeLevel();
            int n5 = TPCodecUtils.getAV1SWDecodeLevel();
            int n6 = TPCodecUtils.getVvcSWDecodeLevel();
            int n7 = TPCodecUtils.getSoftMaxSamples(n4);
            int n8 = TPCodecUtils.getSoftMaxSamples(n5);
            int n9 = TPCodecUtils.getSoftMaxSamples(n6);
            TPNativeLog.printLog(2, "getVCodecSWMaxCapabilityMap, hevcDecodeLevel:" + n2 + ", avs3DecodeLevel:" + n4 + ", AV1DecodeLevel:" + n5 + ", vvcDecodeLevel:" + n6);
            TPCodecUtils.mAVCSWMaxCapability.maxLumaSamples = n3;
            TPCodecUtils.mAVCSWMaxCapability.maxProfile = 64;
            TPCodecUtils.mAVCSWMaxCapability.maxLevel = 65536;
            mMaxVCodecSwCapabilityMap.put(26, mAVCSWMaxCapability);
            TPCodecUtils.mHEVCSWMaxCapability.maxLumaSamples = n3;
            TPCodecUtils.mHEVCSWMaxCapability.maxProfile = 2;
            TPCodecUtils.mHEVCSWMaxCapability.maxLevel = 0x2000000;
            mMaxVCodecSwCapabilityMap.put(172, mHEVCSWMaxCapability);
            TPCodecUtils.mVP9SWMaxCapability.maxLumaSamples = n3;
            TPCodecUtils.mVP9SWMaxCapability.maxProfile = 8;
            TPCodecUtils.mVP9SWMaxCapability.maxLevel = 8192;
            mMaxVCodecSwCapabilityMap.put(166, mVP9SWMaxCapability);
            TPCodecUtils.mVP8SWMaxCapability.maxLumaSamples = n3;
            TPCodecUtils.mVP8SWMaxCapability.maxProfile = 1;
            TPCodecUtils.mVP8SWMaxCapability.maxLevel = 8;
            mMaxVCodecSwCapabilityMap.put(138, mVP8SWMaxCapability);
            TPCodecUtils.mAVS3WMaxCapability.maxLumaSamples = n7;
            TPCodecUtils.mAVS3WMaxCapability.maxProfile = 0;
            TPCodecUtils.mAVS3WMaxCapability.maxLevel = 0;
            mMaxVCodecSwCapabilityMap.put(192, mAVS3WMaxCapability);
            TPCodecUtils.mAV1SWMaxCapability.maxLumaSamples = n8;
            TPCodecUtils.mAV1SWMaxCapability.maxProfile = 0;
            TPCodecUtils.mAV1SWMaxCapability.maxLevel = 0;
            mMaxVCodecSwCapabilityMap.put(1029, mAV1SWMaxCapability);
            TPCodecUtils.mVVCSWMaxCapability.maxLumaSamples = n9;
            TPCodecUtils.mVVCSWMaxCapability.maxProfile = 0;
            TPCodecUtils.mVVCSWMaxCapability.maxLevel = 0;
            mMaxVCodecSwCapabilityMap.put(193, mVVCSWMaxCapability);
            TPNativeLog.printLog(2, "getVCodecSWMaxCapabilityMap success, maxHevcLumaSamples:" + n3 + ", maxAvs3LumaSamples:" + n7 + ", maxAV1LumaSamples:" + n8 + ", maxVvcLumaSamples:" + n9);
            mIsFFmpegCapGot = true;
            return mMaxVCodecSwCapabilityMap;
        }
        catch (Exception exception) {
            TPNativeLog.printLog(4, TAG, "getVCodecSWMaxCapabilityMap exception");
            return null;
        }
    }

    public static boolean isInMediaCodecWhiteList(String string) {
        boolean bl = false;
        String string2 = TPSystemInfo.getDeviceName();
        if (!TextUtils.isEmpty((CharSequence)string2) && mCodecCapWhiteList != null && mCodecCapWhiteList.containsKey(string2)) {
            Integer n2 = mCodecCapWhiteList.get(string2);
            if (TextUtils.equals((CharSequence)string, (CharSequence)"video/avc")) {
                bl = (n2 & 1) != 0;
            } else if (TextUtils.equals((CharSequence)string, (CharSequence)"video/hevc")) {
                bl = (n2 & 2) != 0;
            } else if (TextUtils.equals((CharSequence)string, (CharSequence)"video/x-vnd.on2.vp8")) {
                bl = (n2 & 0x100) != 0;
            } else if (TextUtils.equals((CharSequence)string, (CharSequence)"video/x-vnd.on2.vp9")) {
                bl = (n2 & 4) != 0;
            } else if (TextUtils.equals((CharSequence)string, (CharSequence)"audio/mp4a-latm")) {
                bl = (n2 & 8) != 0;
            } else if (TextUtils.equals((CharSequence)string, (CharSequence)"audio/ac3")) {
                bl = (n2 & 0x10) != 0;
            } else if (TextUtils.equals((CharSequence)string, (CharSequence)"audio/eac3")) {
                bl = (n2 & 0x20) != 0;
            } else if (TextUtils.equals((CharSequence)string, (CharSequence)"audio/flac")) {
                bl = (n2 & 0x40) != 0;
            } else if (TextUtils.equals((CharSequence)string, (CharSequence)"audio/vnd.dts")) {
                bl = (n2 & 0x80) != 0;
            }
            return bl;
        }
        return false;
    }

    public static boolean isInMediaCodecBlackList(String string) {
        boolean bl = false;
        String string2 = TPSystemInfo.getDeviceName();
        if (!TextUtils.isEmpty((CharSequence)string2) && mCodecCapBlackList != null && mCodecCapBlackList.containsKey(string2)) {
            Integer n2 = mCodecCapBlackList.get(string2);
            if (TextUtils.equals((CharSequence)string, (CharSequence)"video/avc")) {
                bl = (n2 & 1) != 0;
            } else if (TextUtils.equals((CharSequence)string, (CharSequence)"video/hevc")) {
                bl = (n2 & 2) != 0;
            } else if (TextUtils.equals((CharSequence)string, (CharSequence)"video/x-vnd.on2.vp8")) {
                bl = (n2 & 0x100) != 0;
            } else if (TextUtils.equals((CharSequence)string, (CharSequence)"video/x-vnd.on2.vp9")) {
                bl = (n2 & 4) != 0;
            } else if (TextUtils.equals((CharSequence)string, (CharSequence)"audio/mp4a-latm")) {
                bl = (n2 & 8) != 0;
            } else if (TextUtils.equals((CharSequence)string, (CharSequence)"audio/ac3")) {
                bl = (n2 & 0x10) != 0;
            } else if (TextUtils.equals((CharSequence)string, (CharSequence)"audio/eac3")) {
                bl = (n2 & 0x20) != 0;
            } else if (TextUtils.equals((CharSequence)string, (CharSequence)"audio/flac")) {
                bl = (n2 & 0x40) != 0;
            } else if (TextUtils.equals((CharSequence)string, (CharSequence)"audio/vnd.dts")) {
                bl = (n2 & 0x80) != 0;
            } else if (TextUtils.equals((CharSequence)string, (CharSequence)"audio/eac3-joc")) {
                bl = (n2 & 0x20) != 0;
            }
            return bl;
        }
        return false;
    }

    public static boolean isVMediaCodecBlackListModel() {
        return mVMediaCodecBlackListModel.contains(TPSystemInfo.getDeviceName());
    }

    public static boolean isAMediaCodecBlackListModel() {
        return mAMediaCodecBlackListModel.contains(TPSystemInfo.getDeviceName());
    }

    public static boolean isAMediaCodecBlackListInstance(String string) {
        return mAMediaCodecBlackListInstance.contains(string);
    }

    public static boolean isBlackListType(String string) {
        return Arrays.asList("PRO 7 Plus", "PRO 7-H", "PRO+7+Plus").contains(TPSystemInfo.getDeviceName()) && TextUtils.equals((CharSequence)string, (CharSequence)"video/hevc") && Build.VERSION.SDK_INT >= 14;
    }

    public static synchronized boolean isMediaCodecDolbyDSSupported() {
        if (TPCodecUtils.isAMediaCodecBlackListModel()) {
            return false;
        }
        return mAMediaCodecCapList.contains("audio/ac3");
    }

    public static synchronized boolean isMediaCodecDDPlusSupported() {
        if (TPCodecUtils.isAMediaCodecBlackListModel()) {
            return false;
        }
        return mAMediaCodecCapList.contains("audio/eac3") || mAMediaCodecCapList.contains("audio/eac3-joc");
    }

    private static synchronized boolean isHDRDVSupport(int n2, int n3) {
        if (n2 == 0 && n3 == 0) {
            return mVMediaCodecCapList.contains("video/dolby-vision");
        }
        for (TPMediaDecoderInfo tPMediaDecoderInfo : TPMediaDecoderList.getTPMediaDecoderInfos(mLocalCache)) {
            if (!TextUtils.equals((CharSequence)tPMediaDecoderInfo.getDecoderMimeType(), (CharSequence)"video/dolby-vision")) continue;
            for (TPMediaDecoderInfo.DecoderProfileLevel decoderProfileLevel : tPMediaDecoderInfo.getProfileLevels()) {
                if (decoderProfileLevel.profile != n2 || decoderProfileLevel.level != n3) continue;
                TPNativeLog.printLog(2, TAG, "support dolbyvision");
                return true;
            }
        }
        return false;
    }

    private static synchronized boolean isHDR10Support(int n2) {
        for (TPMediaDecoderInfo tPMediaDecoderInfo : TPMediaDecoderList.getTPMediaDecoderInfos(mLocalCache)) {
            if (!TextUtils.equals((CharSequence)tPMediaDecoderInfo.getDecoderMimeType(), (CharSequence)"video/hevc")) continue;
            TPMediaDecoderInfo.DecoderProfileLevel[] decoderProfileLevelArray = tPMediaDecoderInfo.getProfileLevels();
            int n3 = decoderProfileLevelArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                if (decoderProfileLevelArray[i2].profile != n2) continue;
                TPNativeLog.printLog(2, TAG, "support hdr10 ".concat(String.valueOf(n2)));
                return true;
            }
        }
        return false;
    }

    public static boolean isHDRsupport(int n2, int n3, int n4) {
        if (n2 == 2) {
            return TPCodecUtils.isHDRDVSupport(n3, n4);
        }
        if (n2 == 0) {
            return TPCodecUtils.isHDR10Support(4096);
        }
        if (n2 == 1) {
            return TPCodecUtils.isHDR10Support(8192);
        }
        if (n2 == 4) {
            String string = TPCodecUtils.getDisplayVersion();
            String string2 = TPCodecUtils.getSystemPatchVersion();
            TPNativeLog.printLog(2, TAG, "isHDRsupport(HDRVivid):display version:".concat(String.valueOf(string)));
            TPNativeLog.printLog(2, TAG, "isHDRsupport(HDRVivid):patch version:".concat(String.valueOf(string2)));
            return TPCodecUtils.checkHDRVividSupportByVersion(TPSystemInfo.getDeviceName(), string, string2);
        }
        return false;
    }

    public static boolean getAudioMediaCodecPassThroughCap(int n2, int n3, int n4) {
        if (n2 != 5004) {
            return false;
        }
        int n5 = 1;
        if (n3 == 20) {
            n5 = 7;
        } else if (n3 == 50 || n3 == 60) {
            n5 = 8;
        }
        return TPAudioPassThroughPluginDetector.isAudioPassThroughSupport(n5, n4);
    }

    private static int getSupportedCodecId(String string) {
        if (TextUtils.equals((CharSequence)string, (CharSequence)"video/avc")) {
            return 26;
        }
        if (TextUtils.equals((CharSequence)string, (CharSequence)"video/hevc")) {
            return 172;
        }
        if (TextUtils.equals((CharSequence)string, (CharSequence)"video/x-vnd.on2.vp8")) {
            return 138;
        }
        if (TextUtils.equals((CharSequence)string, (CharSequence)"video/x-vnd.on2.vp9")) {
            return 166;
        }
        if (TextUtils.equals((CharSequence)string, (CharSequence)"video/av01")) {
            return 1029;
        }
        if (TextUtils.equals((CharSequence)string, (CharSequence)"audio/mp4a-latm")) {
            return 5002;
        }
        if (TextUtils.equals((CharSequence)string, (CharSequence)"audio/ac3")) {
            return 5003;
        }
        if (TextUtils.equals((CharSequence)string, (CharSequence)"audio/eac3") || TextUtils.equals((CharSequence)string, (CharSequence)"audio/eac3-joc")) {
            return 5040;
        }
        if (TextUtils.equals((CharSequence)string, (CharSequence)"audio/flac")) {
            return 5012;
        }
        if (TextUtils.equals((CharSequence)string, (CharSequence)"audio/vnd.dts")) {
            return 5004;
        }
        return -1;
    }

    private static String getSupportedHWMimeType(int n2) {
        String string = "";
        switch (n2) {
            case 26: {
                string = "video/avc";
                break;
            }
            case 172: {
                string = "video/hevc";
                break;
            }
            case 138: {
                string = "video/x-vnd.on2.vp8";
                break;
            }
            case 166: {
                string = "video/x-vnd.on2.vp9";
                break;
            }
            case 1029: {
                string = "video/av01";
            }
        }
        return string;
    }

    private static boolean isSupportedMediaCodec(String string) {
        return mSupportedMediaCodec.contains(string);
    }

    public static int getMaxLumaSample(String string, int n2) {
        if (TextUtils.equals((CharSequence)string, (CharSequence)"video/avc")) {
            return TPMediaCodecProfileLevel.getAVCMaxLumaSample(n2);
        }
        if (TextUtils.equals((CharSequence)string, (CharSequence)"video/hevc")) {
            return TPMediaCodecProfileLevel.getHEVCMaxLumaSample(n2);
        }
        if (TextUtils.equals((CharSequence)string, (CharSequence)"video/x-vnd.on2.vp8")) {
            return TPMediaCodecProfileLevel.getVP8MaxLumaSample(n2);
        }
        if (TextUtils.equals((CharSequence)string, (CharSequence)"video/x-vnd.on2.vp9")) {
            return TPMediaCodecProfileLevel.getVP9MaxLumaSample(n2);
        }
        if (TextUtils.equals((CharSequence)string, (CharSequence)"video/av01")) {
            return TPMediaCodecProfileLevel.getAV1MaxLumaSample(n2);
        }
        return 0;
    }

    public static synchronized int getMaxSupportedFrameRatesFor(int n2, int n3, int n4, int n5) {
        if (Build.VERSION.SDK_INT < 21 || n2 == 101 || n2 == -1) {
            return 30;
        }
        String string = TPCodecUtils.getSupportedHWMimeType(n3);
        if (string.isEmpty()) {
            return 30;
        }
        Integer n6 = 30;
        try {
            for (TPMediaDecoderInfo tPMediaDecoderInfo : TPMediaDecoderList.getTPMediaDecoderInfos(mLocalCache)) {
                if (!string.equals(tPMediaDecoderInfo.getDecoderMimeType())) continue;
                int n7 = tPMediaDecoderInfo.getDecoderMaxWidth();
                int n8 = tPMediaDecoderInfo.getDecoderMaxHeight();
                int n9 = tPMediaDecoderInfo.getDecoderLumaWidth();
                int n10 = tPMediaDecoderInfo.getDecoderLumaHeight();
                int n11 = tPMediaDecoderInfo.getDecoderMaxFrameRateForMaxLuma();
                int n12 = tPMediaDecoderInfo.getDecoderMaxFrameRate();
                if (TPCodecUtils.isLimitMaxWidthOrMaxHeight(n7, n8, n9, n10, n4, n5)) {
                    return 0;
                }
                long l2 = (long)(n7 * n10) * 1L / Math.max((long)(n4 * n5) * 1L, 1L);
                n6 = Math.min(n12, Math.max(1, n11 * (int)l2));
                TPNativeLog.printLog(2, TAG, "getSupportedFrameRatesFor max width:" + n7 + " max height:" + n10 + " max framerate for max resolution:" + n11 + " current width:" + n4 + " height:" + n5 + " max support framerate:" + n6);
                break;
            }
        }
        catch (Exception exception) {
            TPNativeLog.printLog(4, TAG, "getMaxSupportedFrameRatesFor failed:" + exception.getMessage());
        }
        return n6;
    }

    private static boolean isLimitMaxWidthOrMaxHeight(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n6 > n7 && (n6 > n2 || n7 > n5) || n6 < n7 && (n6 > n4 || n7 > n3)) {
            int n8;
            int n9 = n8 = n6 > n7 ? n2 * n5 : n4 * n3;
            if (n2 >= n6 && n3 >= n7 && n8 >= n6 * n7) {
                TPNativeLog.printLog(2, TAG, "getSupportedFrameRatesFor width:" + n6 + " height:" + n7 + " limit maxLumaWidth or maxLumaHeight, but not limit maxLumaSamples, do support! maxWidth:" + n2 + " maxHeight:" + n3 + " maxLumaSamples:" + n8);
                return false;
            }
            TPNativeLog.printLog(4, TAG, "getSupportedFrameRatesFor width:" + n6 + " height:" + n7 + " do not support! maxWidth:" + n2 + " maxHeight:" + n3);
            return true;
        }
        return false;
    }

    public static synchronized HashMap<Integer, TPCodecCapability.TPCodecMaxCapability> getVMediaCodecMaxCapabilityMap() {
        if (!mMaxVCodecHwCapabilityMap.isEmpty()) {
            TPNativeLog.printLog(2, TAG, "return memory stored video max cap map");
            return mMaxVCodecHwCapabilityMap;
        }
        try {
            for (TPMediaDecoderInfo tPMediaDecoderInfo : TPMediaDecoderList.getTPMediaDecoderInfos(mLocalCache)) {
                String string = tPMediaDecoderInfo.getDecoderMimeType();
                if (!tPMediaDecoderInfo.isVideo()) continue;
                mVMediaCodecCapList.add(string);
                if (!TPCodecUtils.isSupportedMediaCodec(string) || tPMediaDecoderInfo.isSecureDecoder()) continue;
                TPMediaDecoderInfo.DecoderProfileLevel decoderProfileLevel = tPMediaDecoderInfo.getMaxProfileLevel();
                TPCodecCapability.TPCodecMaxCapability tPCodecMaxCapability = new TPCodecCapability.TPCodecMaxCapability(TPCodecUtils.getMaxLumaSample(string, decoderProfileLevel.level), decoderProfileLevel.profile, decoderProfileLevel.level, tPMediaDecoderInfo.getDecoderMaxFrameRateForMaxLuma());
                if (mMaxVCodecHwCapabilityMap.containsKey(TPCodecUtils.getSupportedCodecId(string)) && decoderProfileLevel.level <= TPCodecUtils.mMaxVCodecHwCapabilityMap.get((Object)Integer.valueOf((int)TPCodecUtils.getSupportedCodecId((String)string))).maxLevel) continue;
                TPCodecUtils.replace(TPCodecUtils.getSupportedCodecId(string), tPCodecMaxCapability, mMaxVCodecHwCapabilityMap);
            }
        }
        catch (Exception exception) {
            TPNativeLog.printLog(4, TAG, "getVMediaCodecMaxCapabilityMap failed:" + Log.getStackTraceString((Throwable)exception));
        }
        return mMaxVCodecHwCapabilityMap;
    }

    public static synchronized HashMap<Integer, TPCodecCapability.TPCodecMaxCapability> getAMediaCodecMaxCapabilityMap() {
        if (!mMaxACodecHwCapabilityMap.isEmpty()) {
            return mMaxACodecHwCapabilityMap;
        }
        try {
            for (TPMediaDecoderInfo tPMediaDecoderInfo : TPMediaDecoderList.getTPMediaDecoderInfos(mLocalCache)) {
                String string = tPMediaDecoderInfo.getDecoderMimeType();
                if (!tPMediaDecoderInfo.isAudio() || !TPCodecUtils.isSupportedMediaCodec(string) || TPCodecUtils.isInMediaCodecBlackList(string) || TPCodecUtils.isAMediaCodecBlackListInstance(tPMediaDecoderInfo.getDecoderName())) continue;
                TPMediaDecoderInfo.DecoderProfileLevel decoderProfileLevel = tPMediaDecoderInfo.getMaxProfileLevel();
                TPCodecCapability.TPCodecMaxCapability tPCodecMaxCapability = new TPCodecCapability.TPCodecMaxCapability(decoderProfileLevel.profile, decoderProfileLevel.level, tPMediaDecoderInfo.getMaxAudioSampleRate(), tPMediaDecoderInfo.getMaxAudioBitRate(), tPMediaDecoderInfo.getMaxAudioChannels());
                if (mMaxACodecHwCapabilityMap.containsKey(TPCodecUtils.getSupportedCodecId(string))) {
                    if (tPMediaDecoderInfo.getMaxAudioSampleRate() <= TPCodecUtils.mMaxACodecHwCapabilityMap.get((Object)Integer.valueOf((int)TPCodecUtils.getSupportedCodecId((String)string))).maxSampleRate && !TextUtils.equals((CharSequence)string, (CharSequence)"audio/eac3-joc")) continue;
                    TPCodecUtils.replace(TPCodecUtils.getSupportedCodecId(string), tPCodecMaxCapability, mMaxACodecHwCapabilityMap);
                    TPCodecUtils.replace(string, tPMediaDecoderInfo.getDecoderName(), mAudioMaxCapCodecInstance);
                    continue;
                }
                TPCodecUtils.replace(TPCodecUtils.getSupportedCodecId(string), tPCodecMaxCapability, mMaxACodecHwCapabilityMap);
                TPCodecUtils.replace(string, tPMediaDecoderInfo.getDecoderName(), mAudioMaxCapCodecInstance);
                mAMediaCodecCapList.add(string);
            }
        }
        catch (Exception exception) {
            TPNativeLog.printLog(4, TAG, "getAMediaCodecMaxCapabilityMap failed:" + exception.getMessage());
        }
        return mMaxACodecHwCapabilityMap;
    }

    public static synchronized HashMap<Integer, TPCodecCapability.TPCodecMaxCapability> getACodecSWMaxCapabilityMap() {
        if (!mMaxACodecSwCapabilityMap.isEmpty()) {
            return mMaxACodecSwCapabilityMap;
        }
        try {
            TPCodecCapability.TPCodecMaxCapability tPCodecMaxCapability = new TPCodecCapability.TPCodecMaxCapability(0, 0, mAACMaxSupportedSamplerate, mAACMaxSupportedBitrate, mAACMaxSupportedChannels);
            TPCodecCapability.TPCodecMaxCapability tPCodecMaxCapability2 = new TPCodecCapability.TPCodecMaxCapability(0, 0, mFLACMaxSupportedSamplerate, mFLACMaxSupportedBitrate, mFLACMaxSupportedChannels);
            TPCodecCapability.TPCodecMaxCapability tPCodecMaxCapability3 = new TPCodecCapability.TPCodecMaxCapability(0, 0, mDDPMaxSupportedSamplerate, mDDPMaxSupportedBitrate, mDDPMaxSupportedChannels);
            TPCodecCapability.TPCodecMaxCapability tPCodecMaxCapability4 = new TPCodecCapability.TPCodecMaxCapability(0, 0, mDDPMaxSupportedSamplerate, mDDPMaxSupportedBitrate, mDDPMaxSupportedChannels);
            mMaxACodecSwCapabilityMap.put(5002, tPCodecMaxCapability);
            mMaxACodecSwCapabilityMap.put(5012, tPCodecMaxCapability2);
            mMaxACodecSwCapabilityMap.put(5003, tPCodecMaxCapability3);
            mMaxACodecSwCapabilityMap.put(5040, tPCodecMaxCapability4);
            return mMaxACodecSwCapabilityMap;
        }
        catch (Exception exception) {
            TPNativeLog.printLog(4, TAG, "getACodecSWMaxCapabilityMap exception");
            return null;
        }
    }

    public static String getDecoderName(String string, boolean bl) {
        if (string.contains("audio")) {
            if (TextUtils.equals((CharSequence)string, (CharSequence)"audio/eac3") && mAudioMaxCapCodecInstance.containsKey("audio/eac3-joc")) {
                return mAudioMaxCapCodecInstance.get("audio/eac3-joc");
            }
            if (mAudioMaxCapCodecInstance.containsKey(string)) {
                return mAudioMaxCapCodecInstance.get(string);
            }
        } else {
            ArrayList<TPMediaDecoderInfo> arrayList = new ArrayList<TPMediaDecoderInfo>();
            for (TPMediaDecoderInfo tPMediaDecoderInfo : TPMediaDecoderList.getTPMediaDecoderInfos(mLocalCache)) {
                if (!TextUtils.equals((CharSequence)string, (CharSequence)tPMediaDecoderInfo.getDecoderMimeType()) || tPMediaDecoderInfo.isSecureDecoder() != bl) continue;
                arrayList.add(tPMediaDecoderInfo);
            }
            for (TPMediaDecoderInfo tPMediaDecoderInfo : arrayList) {
                if ((!tPMediaDecoderInfo.isVideo() || tPMediaDecoderInfo.isVideoSofwareDecoder() != mPreferredSoftwareComponent) && (!tPMediaDecoderInfo.isAudio() || tPMediaDecoderInfo.isAudioSofwareDecoder() != mPreferredSoftwareComponent)) continue;
                return tPMediaDecoderInfo.getDecoderName();
            }
            if (!arrayList.isEmpty()) {
                return ((TPMediaDecoderInfo)arrayList.get(0)).getDecoderName();
            }
        }
        return null;
    }

    public static void setMediaCodecPreferredSoftwareComponent(boolean bl) {
        mPreferredSoftwareComponent = bl;
    }

    public static String getDolbyVisionDecoderName(String string, int n2, int n3, boolean bl) {
        if (Build.VERSION.SDK_INT < 21 || !TextUtils.equals((CharSequence)"video/dolby-vision", (CharSequence)string)) {
            return null;
        }
        int n4 = TPCodecUtils.convertDolbyVisionToOmxProfile(n2);
        for (TPMediaDecoderInfo tPMediaDecoderInfo : TPMediaDecoderList.getTPMediaDecoderInfos(mLocalCache)) {
            TPMediaDecoderInfo.DecoderProfileLevel[] decoderProfileLevelArray = tPMediaDecoderInfo.getProfileLevels();
            if (!TextUtils.equals((CharSequence)tPMediaDecoderInfo.getDecoderMimeType(), (CharSequence)string)) continue;
            TPMediaDecoderInfo.DecoderProfileLevel[] decoderProfileLevelArray2 = decoderProfileLevelArray;
            int n5 = decoderProfileLevelArray.length;
            for (int i2 = 0; i2 < n5; ++i2) {
                TPMediaDecoderInfo.DecoderProfileLevel decoderProfileLevel = decoderProfileLevelArray2[i2];
                if (decoderProfileLevel.profile != n4) continue;
                TPNativeLog.printLog(1, TAG, "getDolbyVisionDecoderName  profile:" + decoderProfileLevel.profile + " dvProfile:" + n2 + " bSecure:" + bl + " name:" + tPMediaDecoderInfo.getDecoderName());
                if (tPMediaDecoderInfo.isSecureDecoder() != bl) continue;
                return tPMediaDecoderInfo.getDecoderName();
            }
        }
        return null;
    }

    public static int convertDolbyVisionToOmxProfile(int n2) {
        int n3 = 1 << n2;
        if (n2 > 0 && n2 <= 512) {
            TPNativeLog.printLog(2, TAG, "convertDolbyVisionToOmxProfile dolbyVisionProfile:" + n2 + " omxProfile:" + n3);
            return n3;
        }
        TPNativeLog.printLog(2, TAG, "convertDolbyVisionToOmxProfile Unsupported profile".concat(String.valueOf(n2)));
        return n2;
    }

    public static int convertDolbyVisionToOmxLevel(int n2) {
        int n3 = 1 << n2;
        if (n3 > 0 && n3 <= 256) {
            TPNativeLog.printLog(2, TAG, "convertDolbyVisionToOmxLevel dolbyVisionLevel:" + n2 + " omxLevel:" + n3);
            return n3;
        }
        TPNativeLog.printLog(2, TAG, "convertDolbyVisionToOmxLevel Unsupported level".concat(String.valueOf(n2)));
        return n2;
    }

    public static boolean addDRMLevel1Blacklist(int n2) {
        if (mDrmL1BlackList.containsKey(n2)) {
            ArrayList<String> arrayList = mDrmL1BlackList.get(n2);
            if (!arrayList.contains(TPSystemInfo.getDeviceName())) {
                arrayList.add(TPSystemInfo.getDeviceName());
            }
            mDrmL1BlackList.remove(n2);
            mDrmL1BlackList.put(n2, arrayList);
        }
        return true;
    }

    public static boolean isInDRMLevel1Blacklist(int n2) {
        if (mDrmL1BlackList.containsKey(n2)) {
            return mDrmL1BlackList.get(n2).contains(TPSystemInfo.getDeviceName());
        }
        return false;
    }

    public static boolean addHDRWhiteList(int n2, String string, TPCodecCapability.TPHdrSupportVersionRange tPHdrSupportVersionRange) {
        if (tPHdrSupportVersionRange == null) {
            return false;
        }
        if (mHdrWhiteMap.containsKey(n2)) {
            HashMap<String, TPCodecCapability.TPHdrSupportVersionRange> hashMap = mHdrWhiteMap.get(n2);
            mHdrWhiteMap.remove(n2);
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, tPHdrSupportVersionRange);
            }
            hashMap.remove(string);
            hashMap.put(string, tPHdrSupportVersionRange);
            mHdrWhiteMap.put(n2, hashMap);
        } else {
            HashMap<String, TPCodecCapability.TPHdrSupportVersionRange> hashMap = new HashMap<String, TPCodecCapability.TPHdrSupportVersionRange>();
            hashMap.put(string, tPHdrSupportVersionRange);
            mHdrWhiteMap.put(n2, hashMap);
        }
        return true;
    }

    public static boolean isInHDRVividWhiteList(String string, int n2, int n3) {
        if (mHdrWhiteMap.containsKey(4)) {
            HashMap<String, TPCodecCapability.TPHdrSupportVersionRange> hashMap = mHdrWhiteMap.get(4);
            if (hashMap.containsKey(string)) {
                TPCodecCapability.TPHdrSupportVersionRange tPHdrSupportVersionRange = hashMap.get(string);
                return n2 <= tPHdrSupportVersionRange.upperboundSystemVersion && n2 >= tPHdrSupportVersionRange.lowerboundSystemVersion && n3 <= tPHdrSupportVersionRange.upperboundPatchVersion && n3 >= tPHdrSupportVersionRange.lowerboundPatchVersion;
            }
            return false;
        }
        return false;
    }

    public static boolean addHDRBlackList(int n2, String string, TPCodecCapability.TPHdrSupportVersionRange tPHdrSupportVersionRange) {
        if (tPHdrSupportVersionRange == null) {
            return false;
        }
        if (mHdrBlackMap.containsKey(n2)) {
            HashMap<String, TPCodecCapability.TPHdrSupportVersionRange> hashMap = mHdrBlackMap.get(n2);
            mHdrBlackMap.remove(n2);
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, tPHdrSupportVersionRange);
            }
            hashMap.remove(string);
            hashMap.put(string, tPHdrSupportVersionRange);
            mHdrBlackMap.put(n2, hashMap);
        } else {
            HashMap<String, TPCodecCapability.TPHdrSupportVersionRange> hashMap = new HashMap<String, TPCodecCapability.TPHdrSupportVersionRange>();
            hashMap.put(string, tPHdrSupportVersionRange);
            mHdrBlackMap.put(n2, hashMap);
        }
        return true;
    }

    public static boolean addHDRVideoDecoderTypeWhiteList(int n2, int n3, TPCodecCapability.TPHdrSupportVersionRange tPHdrSupportVersionRange) {
        boolean bl = true;
        switch (n3) {
            case 102: {
                TPCodecUtils.addHDRVersionRangeToWhiteList(n2, tPHdrSupportVersionRange, mHDRTypeToHDRHardwareCodecWhiteListMap);
                break;
            }
            case 101: {
                TPCodecUtils.addHDRVersionRangeToWhiteList(n2, tPHdrSupportVersionRange, mHDRTypeToHDRSoftwareCodecWhiteListMap);
                break;
            }
            default: {
                bl = false;
                TPNativeLog.printLog(3, TAG, "addHDRVideoDecoderTypeWhiteList, decoder not support.");
            }
        }
        return bl;
    }

    private static void addHDRVersionRangeToWhiteList(int n2, TPCodecCapability.TPHdrSupportVersionRange tPHdrSupportVersionRange, HashMap<Integer, ArrayList<TPCodecCapability.TPHdrSupportVersionRange>> hashMap) {
        ArrayList<Object> arrayList = hashMap.containsKey(n2) ? hashMap.get(n2) : new ArrayList();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            if (!TPCodecUtils.isTheSameVersionRange(tPHdrSupportVersionRange, (TPCodecCapability.TPHdrSupportVersionRange)arrayList.get(i2))) continue;
            return;
        }
        arrayList.add(tPHdrSupportVersionRange);
        hashMap.put(n2, arrayList);
    }

    private static boolean isTheSameVersionRange(TPCodecCapability.TPHdrSupportVersionRange tPHdrSupportVersionRange, TPCodecCapability.TPHdrSupportVersionRange tPHdrSupportVersionRange2) {
        return tPHdrSupportVersionRange.lowerboundPatchVersion == tPHdrSupportVersionRange2.lowerboundPatchVersion && tPHdrSupportVersionRange.lowerboundSystemVersion == tPHdrSupportVersionRange2.lowerboundSystemVersion && tPHdrSupportVersionRange.upperboundPatchVersion == tPHdrSupportVersionRange2.upperboundPatchVersion && tPHdrSupportVersionRange.upperboundSystemVersion == tPHdrSupportVersionRange2.upperboundSystemVersion;
    }

    public static boolean isInHDRVividBlackList(String string, int n2, int n3) {
        if (mHdrBlackMap.containsKey(4)) {
            HashMap<String, TPCodecCapability.TPHdrSupportVersionRange> hashMap = mHdrBlackMap.get(4);
            if (hashMap.containsKey(string)) {
                TPCodecCapability.TPHdrSupportVersionRange tPHdrSupportVersionRange = hashMap.get(string);
                return n2 <= tPHdrSupportVersionRange.upperboundSystemVersion && n2 >= tPHdrSupportVersionRange.lowerboundSystemVersion && n3 <= tPHdrSupportVersionRange.upperboundPatchVersion && n3 >= tPHdrSupportVersionRange.lowerboundPatchVersion;
            }
            return false;
        }
        return false;
    }

    public static String getDisplayVersion() {
        return null;
    }

    public static String getSystemPatchVersion() {
        return null;
    }

    public static boolean checkHDRVividSupportByVersion(String string, String string2, String string3) {
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        int[] nArray = new int[]{2, 1, 1, 3};
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            n3 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            String[] stringArray = string2.split("\\.");
            boolean bl = true;
            if (stringArray.length == 4) {
                String[] stringArray2 = stringArray[0].split(" ");
                if (stringArray2.length == 2 && stringArray2[1] != null) {
                    stringArray[0] = stringArray2[1];
                }
                if ((stringArray2 = stringArray[3].split("\\(")).length == 2 && stringArray2[0] != null) {
                    stringArray[3] = stringArray2[0];
                }
                for (int i2 = 0; i2 < 4; ++i2) {
                    if (stringArray[i2] != null && stringArray[i2].length() == nArray[i2]) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    try {
                        n2 = string2.indexOf(".");
                        n3 = n2 == -1 ? 0 : TPCodecUtils.getValueFromSubstring(string2, n2 - 2, n2);
                        int n9 = string2.indexOf(".", n2 + 1);
                        n6 = n9 == -1 ? 0 : TPCodecUtils.getValueFromSubstring(string2, n9 - 1, n9);
                        int n10 = string2.indexOf(".", n9 + 1);
                        n7 = n10 == -1 ? 0 : TPCodecUtils.getValueFromSubstring(string2, n10 - 1, n10);
                        n8 = n10 == -1 ? 0 : TPCodecUtils.getValueFromSubstring(string2, n10 + 1, n10 + 4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        TPNativeLog.printLog(4, TAG, "checkHDRVividSupportByVersion failed(versionValue):" + numberFormatException.getMessage());
                    }
                    n4 = n3 * 100000 + n6 * 10000 + n7 * 1000 + n8;
                }
            }
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            n3 = 0;
            String[] stringArray = string3.split("patch");
            if (stringArray.length == 2 && stringArray[1] != null && stringArray[1].length() == 3) {
                try {
                    n2 = string3.indexOf("patch");
                    n3 = n2 == -1 ? 0 : TPCodecUtils.getValueFromSubstring(string3, n2 + 5, n2 + 7);
                }
                catch (NumberFormatException numberFormatException) {
                    TPNativeLog.printLog(4, TAG, "checkHDRVividSupportByVersion failed(patchValue):" + numberFormatException.getMessage());
                }
                n5 = n3;
            }
        }
        if (TPCodecUtils.isInHDRVividWhiteList(string, n4, n5)) {
            TPNativeLog.printLog(2, TAG, "checkHDRVividSupportByVersion in HDRVivid whitelist, model:" + string + " version:" + n4 + " patch:" + string3);
            return true;
        }
        if (TPCodecUtils.isInHDRVividBlackList(string, n4, n5)) {
            TPNativeLog.printLog(2, TAG, "checkHDRVividSupportByVersion in HDRVivid blacklist, model:" + string + " version:" + n4 + " patch:" + string3);
            return false;
        }
        if (mHDRVividSupportVersionMap.containsKey(string)) {
            TPCodecCapability.TPHdrSupportVersionRange tPHdrSupportVersionRange = mHDRVividSupportVersionMap.get(string);
            if (n4 <= tPHdrSupportVersionRange.upperboundSystemVersion) {
                if (n4 > tPHdrSupportVersionRange.lowerboundSystemVersion) {
                    return true;
                }
                if (n4 == tPHdrSupportVersionRange.lowerboundSystemVersion && n5 <= tPHdrSupportVersionRange.upperboundPatchVersion && n5 >= tPHdrSupportVersionRange.lowerboundPatchVersion) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isHDRDecoderTypeSupport(int n2, int n3) {
        if (n3 != 102 && n3 != 101) {
            TPNativeLog.printLog(3, TAG, "isHDRDecodeTypeSupport, not support decoderType, decoderType = ".concat(String.valueOf(n3)));
            return false;
        }
        HashMap<Integer, ArrayList<TPCodecCapability.TPHdrSupportVersionRange>> hashMap = n3 == 102 ? mHDRTypeToHDRHardwareCodecWhiteListMap : mHDRTypeToHDRSoftwareCodecWhiteListMap;
        if (!hashMap.containsKey(n2)) {
            TPNativeLog.printLog(3, TAG, "isHDRDecodeTypeSupport, not config hdrType whiteList, hdrType = ".concat(String.valueOf(n2)));
            return false;
        }
        return TPCodecUtils.isInHDRVersionRangeWhiteList(hashMap.get(n2));
    }

    private static boolean isInHDRVersionRangeWhiteList(ArrayList<TPCodecCapability.TPHdrSupportVersionRange> arrayList) {
        if (arrayList == null) {
            return false;
        }
        boolean bl = false;
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            TPCodecCapability.TPHdrSupportVersionRange tPHdrSupportVersionRange = arrayList.get(i2);
            if (Build.VERSION.SDK_INT > tPHdrSupportVersionRange.upperboundAndroidAPILevel || Build.VERSION.SDK_INT < tPHdrSupportVersionRange.lowerboundAndroidAPILevel) continue;
            TPNativeLog.printLog(2, TAG, "inHDRVersionRangeWhiteList!");
            bl = true;
            break;
        }
        return bl;
    }

    static {
        mCodecCapWhiteList = new HashMap<String, Integer>();
        mCodecCapWhiteList.put("NX511J", 11);
        mCodecCapWhiteList.put("Hi3798MV100", 11);
        mCodecCapWhiteList.put("\u957f\u8679\u667a\u80fd\u7535\u89c6", 11);
        mCodecCapWhiteList.put("Android TV on Tcl 901", 11);
        mCodecCapWhiteList.put("xt880b", 11);
        mSupportedMediaCodec.add("video/avc");
        mSupportedMediaCodec.add("video/hevc");
        mSupportedMediaCodec.add("video/x-vnd.on2.vp8");
        mSupportedMediaCodec.add("video/x-vnd.on2.vp9");
        mSupportedMediaCodec.add("video/av01");
        mSupportedMediaCodec.add("audio/mp4a-latm");
        mSupportedMediaCodec.add("audio/ac3");
        mSupportedMediaCodec.add("audio/eac3");
        mSupportedMediaCodec.add("audio/eac3-joc");
        mSupportedMediaCodec.add("audio/flac");
        mSupportedMediaCodec.add("audio/vnd.dts");
        mAMediaCodecBlackListInstance.add("OMX.qti.audio.decoder.flac");
        mVMediaCodecBlackListModel.add("SM-J7008");
        mVMediaCodecBlackListModel.add("SM-J5008");
        mVMediaCodecBlackListModel.add("TCL i806");
        mVMediaCodecBlackListModel.add("NX511J");
        mVMediaCodecBlackListModel.add("vivo Y11i T");
        mVMediaCodecBlackListModel.add("\u957f\u8679\u667a\u80fd\u7535\u89c6");
        mVMediaCodecBlackListModel.add("MI 1S");
        mVMediaCodecBlackListModel.add("SP9832A");
        mVMediaCodecBlackListModel.add("SP9830A");
        mVMediaCodecBlackListModel.add("VOTO GT17");
        mVMediaCodecBlackListModel.add("EVA-AL10");
        mHDRVividSupportVersionMap.put("TAS-AL00", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 1100165, 99, 3));
        mHDRVividSupportVersionMap.put("TAS-TL00", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 1100165, 99, 3));
        mHDRVividSupportVersionMap.put("TAS-AN00", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 1100165, 99, 3));
        mHDRVividSupportVersionMap.put("LIO-AN00", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 1100165, 99, 3));
        mHDRVividSupportVersionMap.put("LIO-AN00P", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 1100165, 99, 3));
        mHDRVividSupportVersionMap.put("LIO-AN00m", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 1100165, 99, 3));
        mHDRVividSupportVersionMap.put("LIO-TL00", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 1100165, 99, 3));
        mHDRVividSupportVersionMap.put("LIO-AL00", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 1100165, 99, 3));
        mHDRVividSupportVersionMap.put("ANA-AN00", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 1100165, 99, 3));
        mHDRVividSupportVersionMap.put("ANA-TN00", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 1100165, 99, 3));
        mHDRVividSupportVersionMap.put("ELS-AN00", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 1100165, 99, 3));
        mHDRVividSupportVersionMap.put("ELS-TN00", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 1100165, 99, 3));
        mHDRVividSupportVersionMap.put("ELS-AN10", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 1100166, 99, 3));
        mHDRVividSupportVersionMap.put("MRX-AL09", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 1100150, 99, 5));
        mHDRVividSupportVersionMap.put("MRX-AL19", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 1100150, 99, 5));
        mHDRVividSupportVersionMap.put("MRX-W09", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 1100150, 99, 5));
        mHDRVividSupportVersionMap.put("MRX-W19", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 1100150, 99, 5));
        mHDRVividSupportVersionMap.put("MRX-AN19", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 1100150, 99, 5));
        mHDRVividSupportVersionMap.put("MRX-W29", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 1100150, 99, 5));
        mHDRVividSupportVersionMap.put("MRX-W39", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 1100150, 99, 5));
        mHDRVividSupportVersionMap.put("OCE-AN00", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 0, 99, 0));
        mHDRVividSupportVersionMap.put("OCE-AN10", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 0, 99, 0));
        mHDRVividSupportVersionMap.put("OCE-AL50", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 0, 99, 0));
        mHDRVividSupportVersionMap.put("OCE-AN50", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 0, 99, 0));
        mHDRVividSupportVersionMap.put("NOH-NX9", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 0, 99, 0));
        mHDRVividSupportVersionMap.put("NOH-AN00", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 0, 99, 0));
        mHDRVividSupportVersionMap.put("NOH-AN01", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 0, 99, 0));
        mHDRVividSupportVersionMap.put("NOH-AL00", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 0, 99, 0));
        mHDRVividSupportVersionMap.put("NOP-AN00", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 0, 99, 0));
        mHDRVividSupportVersionMap.put("JAD-AN00", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 0, 99, 0));
        mHDRVividSupportVersionMap.put("JAD-AN10", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 0, 99, 0));
        mHDRVividSupportVersionMap.put("JAD-AL50", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 0, 99, 0));
        mHDRVividSupportVersionMap.put("JAD-AL60", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 0, 99, 0));
        mHDRVividSupportVersionMap.put("JAD-N29", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 0, 99, 0));
        mHDRVividSupportVersionMap.put("JAD-N09", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 0, 99, 0));
        mHDRVividSupportVersionMap.put("HEGE-550", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 200187, 99, 0));
        mHDRVividSupportVersionMap.put("HEGE-550B", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 200187, 99, 0));
        mHDRVividSupportVersionMap.put("HEGE-550C", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 200187, 99, 0));
        mHDRVividSupportVersionMap.put("HEGE-550X", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 200187, 99, 0));
        mHDRVividSupportVersionMap.put("HEGE-550AX", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 200187, 99, 0));
        mHDRVividSupportVersionMap.put("HEGE-560", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 200187, 99, 0));
        mHDRVividSupportVersionMap.put("HEGE-560B", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 200187, 99, 0));
        mHDRVividSupportVersionMap.put("HEGE-570", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 200187, 99, 0));
        mHDRVividSupportVersionMap.put("PLAT-760", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 200172, 99, 0));
        mHDRVividSupportVersionMap.put("KANT-350", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 200185, 99, 0));
        mHDRVividSupportVersionMap.put("KANT-350B", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 200185, 99, 0));
        mHDRVividSupportVersionMap.put("KANT-350C", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 200185, 99, 0));
        mHDRVividSupportVersionMap.put("KANT-350S", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 200185, 99, 0));
        mHDRVividSupportVersionMap.put("KANT-360", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 200185, 99, 0));
        mHDRVividSupportVersionMap.put("KANT-360S", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 200185, 99, 0));
        mHDRVividSupportVersionMap.put("KANT-370", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 200185, 99, 0));
        mHDRVividSupportVersionMap.put("KANT-370S", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 200185, 99, 0));
        mHDRVividSupportVersionMap.put("KANT-359", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 200183, 99, 0));
        mHDRVividSupportVersionMap.put("KANT-369", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 200183, 99, 0));
        mHDRVividSupportVersionMap.put("THAL-550", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 0, 99, 0));
        mHDRVividSupportVersionMap.put("THAL-560", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 0, 99, 0));
        mHDRVividSupportVersionMap.put("THAL-570", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 0, 99, 0));
        mHDRVividSupportVersionMap.put("THAL-580", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 0, 99, 0));
        mHDRVividSupportVersionMap.put("FREG-770", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 0, 99, 0));
        mHDRVividSupportVersionMap.put("DESC-220", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 0, 99, 0));
        mHDRVividSupportVersionMap.put("DESC-250SY", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 10200557, 99, 0));
        mHDRVividSupportVersionMap.put("DESC-250S", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 10200557, 99, 0));
        mHDRVividSupportVersionMap.put("DESC-250SZ", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 10200557, 99, 0));
        mHDRVividSupportVersionMap.put("DESC-250", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 10200557, 99, 0));
        mHDRVividSupportVersionMap.put("DESC-260SY", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 10200557, 99, 0));
        mHDRVividSupportVersionMap.put("DESC-260S", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 10200557, 99, 0));
        mHDRVividSupportVersionMap.put("DESC-260SZ", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 10200557, 99, 0));
        mHDRVividSupportVersionMap.put("DESC-260", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 10200557, 99, 0));
        mHDRVividSupportVersionMap.put("DESC-270", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 10200547, 99, 0));
        mHDRVividSupportVersionMap.put("SOKR-790A", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 0, 99, 0));
        mHDRVividSupportVersionMap.put("VOLT-350S", new TPCodecCapability.TPHdrSupportVersionRange(9999999, 0, 99, 0));
        mWideVineBlackListModel.add("RVL-AL09");
        mWideVineBlackListModel.add("CLT-L29");
        mWideVineBlackListModel.add("ASUS_Z00AD");
        mDrmL1BlackList.put(0, mWideVineBlackListModel);
        mVideoCodecIdToSwCapabilityModel.put(193, (Object)new VideoSwCapabilityModel.Builder().addVideoDecCap(0, DefinitionName.DEFINITION_720P, VVC_SHD_QUALCOMMN_CPU_NAME).addVideoDecCap(1, DefinitionName.DEFINITION_720P, VVC_SHD_MTK_CPU_NAME).addVideoDecCap(2, DefinitionName.DEFINITION_720P, VVC_SHD_HISI_CPU_NAME).addVideoDecCap(3, DefinitionName.DEFINITION_720P, VVC_SHD_SAMSUNG_CPU_NAME).build());
        mDefinitionNameToDecodeLevelTable.put(DefinitionName.DEFINITION_720P, 21);
        mIsFFmpegCapGot = false;
        mAVCSWMaxCapability = new TPCodecCapability.TPCodecMaxCapability(0, 0, 0, 30);
        mHEVCSWMaxCapability = new TPCodecCapability.TPCodecMaxCapability(0, 0, 0, 30);
        mVP9SWMaxCapability = new TPCodecCapability.TPCodecMaxCapability(0, 0, 0, 30);
        mAVS3WMaxCapability = new TPCodecCapability.TPCodecMaxCapability(0, 0, 0, 30);
        mAV1SWMaxCapability = new TPCodecCapability.TPCodecMaxCapability(0, 0, 0, 30);
        mVP8SWMaxCapability = new TPCodecCapability.TPCodecMaxCapability(0, 0, 0, 30);
        mVVCSWMaxCapability = new TPCodecCapability.TPCodecMaxCapability(0, 0, 0, 30);
        mMaxVCodecHwCapabilityMap = new HashMap();
        mMaxVCodecSwCapabilityMap = new HashMap();
        mMaxACodecHwCapabilityMap = new HashMap();
        mMaxACodecSwCapabilityMap = new HashMap();
    }

    static class VideoSwCapabilityModel {
        SparseArray<HashMap<DefinitionName, String>> mCpuProducerToAllDefinitionDecTable = new SparseArray();

        private VideoSwCapabilityModel() {
        }

        static class Builder {
            private SparseArray<HashMap<DefinitionName, String>> mCpuProducerToAllDefinitionDecCapabilities = new SparseArray();

            Builder() {
            }

            VideoSwCapabilityModel build() {
                VideoSwCapabilityModel videoSwCapabilityModel = new VideoSwCapabilityModel();
                new VideoSwCapabilityModel().mCpuProducerToAllDefinitionDecTable = this.mCpuProducerToAllDefinitionDecCapabilities;
                return videoSwCapabilityModel;
            }

            Builder addVideoDecCap(int n2, DefinitionName definitionName, String string) {
                HashMap<DefinitionName, String> hashMap = (HashMap<DefinitionName, String>)this.mCpuProducerToAllDefinitionDecCapabilities.get(n2);
                if (hashMap == null) {
                    hashMap = new HashMap<DefinitionName, String>();
                    this.mCpuProducerToAllDefinitionDecCapabilities.put(n2, hashMap);
                }
                hashMap.put(definitionName, string);
                return this;
            }
        }
    }

    static enum DefinitionName {
        DEFINITION_720P;

    }
}

