/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoconsumer2;

import android.graphics.SurfaceTexture;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Handler;
import android.os.Looper;
import android.util.Pair;
import android.util.Range;
import android.view.Surface;
import com.tencent.liteav.base.a.b;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.common.EncodedVideoFrame;
import com.tencent.liteav.videobase.common.MediaCodecAbility;
import com.tencent.liteav.videobase.utils.d;
import com.tencent.liteav.videoconsumer2.a;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.TimeUnit;

@JNINamespace(value="liteav::video")
public class HardwareVideoDecoder2
implements SurfaceTexture.OnFrameAvailableListener {
    private final String mTAG;
    private static final int DRAIN_ERROR = -1;
    private static final int DRAIN_SUCCESS = 0;
    private static final int DRAIN_SUCCESS_MEET_END_OF_STREAM = 1;
    private static final int INVALID_COLOR_FORMAT = 0;
    private final b mThrottlers = new b();
    private long mNativeVideoDecoderImplAndroid;
    private boolean mIsRealTime;
    private boolean mIsStarted;
    private boolean mUseSoftwareDecoder = false;
    private boolean mUseByteBuffer = false;
    private boolean mUseAsyncMode = false;
    private MediaCodec mMediaCodec = null;
    private final Queue<Integer> mInputBufferQueue = new LinkedList<Integer>();
    private final Queue<Pair<Integer, MediaCodec.BufferInfo>> mOutputBufferQueue = new LinkedList<Pair<Integer, MediaCodec.BufferInfo>>();
    private SurfaceTexture mSurfaceTexture;
    private Surface mOutputSurface;
    private Surface mExternalSurface;
    private boolean mEnableLimitMaxDecFrameBufferingInH264Sps = true;
    private final com.tencent.liteav.videoconsumer.a.a mSPSModifier = new com.tencent.liteav.videoconsumer.a.a();
    private long mLastPresentationTimeUs = 0L;
    private int mWidth = 0;
    private int mHeight = 0;
    private boolean mIsHevc = false;

    HardwareVideoDecoder2(String traceId, boolean isRealTime, boolean isHEVC, int width, int height, boolean useSoftwareDecoder, boolean useByteBuffer, boolean useAsyncMode, long nativeVideoDecoderJni) {
        this.mTAG = traceId + "HardwareVideoDecoder2";
        this.mIsRealTime = isRealTime;
        this.mUseSoftwareDecoder = useSoftwareDecoder;
        this.mUseByteBuffer = useByteBuffer;
        this.mUseAsyncMode = useAsyncMode;
        this.mNativeVideoDecoderImplAndroid = nativeVideoDecoderJni;
        this.mWidth = width;
        this.mHeight = height;
        this.mIsHevc = isHEVC;
    }

    public int start(int textureId) {
        if (this.mIsStarted) {
            return 0;
        }
        LiteavLog.i(this.mTAG, "Start: texture_id = %d", textureId);
        if (!this.mUseByteBuffer && !this.initializeSurface(textureId)) {
            return 16;
        }
        int n2 = this.startInternal();
        if (n2 != 0) {
            HardwareVideoDecoder2 hardwareVideoDecoder2 = this;
            hardwareVideoDecoder2.destroyMediaCodec(hardwareVideoDecoder2.mMediaCodec);
            this.mMediaCodec = null;
            this.uninitializeSurface();
        }
        return n2;
    }

    public int start(Surface surface) {
        if (this.mIsStarted) {
            return 0;
        }
        LiteavLog.i(this.mTAG, "Start with surface ".concat(String.valueOf(surface)));
        if (surface == null) {
            return 17;
        }
        this.mExternalSurface = surface;
        int n2 = this.startInternal();
        if (n2 != 0) {
            HardwareVideoDecoder2 hardwareVideoDecoder2 = this;
            hardwareVideoDecoder2.destroyMediaCodec(hardwareVideoDecoder2.mMediaCodec);
            this.mMediaCodec = null;
        }
        return n2;
    }

    private int startInternal() {
        try {
            int n2;
            String string = this.mIsHevc ? "video/hevc" : "video/avc";
            com.tencent.liteav.videobase.utils.b b2 = new com.tencent.liteav.videobase.utils.b();
            new com.tencent.liteav.videobase.utils.b().c = string;
            v0.a = n2 = this.mWidth;
            v1.b = n2 = this.mHeight;
            boolean bl = this.mIsRealTime;
            com.tencent.liteav.videobase.utils.b b3 = b2;
            b2.d = bl;
            com.tencent.liteav.videobase.utils.b b4 = b3;
            MediaFormat mediaFormat = b4.a();
            String string2 = mediaFormat.getString("mime");
            LiteavLog.i(this.mTAG, "Start with media format: ".concat(String.valueOf(mediaFormat)));
            this.mMediaCodec = this.createMediaCodecInternal(this.mUseSoftwareDecoder, string2);
            MediaCodecInfo.CodecCapabilities codecCapabilities = this.mMediaCodec.getCodecInfo().getCapabilitiesForType(string2);
            if (this.mWidth > 0 && this.mHeight > 0 && !this.isResolutionSupported(codecCapabilities, this.mWidth, this.mHeight)) {
                return 18;
            }
            if (this.mUseByteBuffer) {
                int n3 = this.getSupportedByteBufferColorFormat(codecCapabilities);
                if (n3 == 0) {
                    return 6;
                }
                mediaFormat.setInteger("color-format", n3);
            }
            if (this.mUseAsyncMode) {
                HardwareVideoDecoder2 hardwareVideoDecoder2 = this;
                hardwareVideoDecoder2.setCallback(hardwareVideoDecoder2.mMediaCodec);
            }
            Surface surface = this.mUseByteBuffer ? null : (this.mExternalSurface != null ? this.mExternalSurface : this.mOutputSurface);
            HardwareVideoDecoder2 hardwareVideoDecoder2 = this;
            boolean bl2 = hardwareVideoDecoder2.configureDecoder(hardwareVideoDecoder2.mMediaCodec, mediaFormat, surface);
            if (!bl2 && this.mIsRealTime) {
                this.mIsRealTime = false;
                b3 = b4;
                b4.d = false;
                mediaFormat = b3.a();
                HardwareVideoDecoder2 hardwareVideoDecoder22 = this;
                bl2 = hardwareVideoDecoder22.configureDecoder(hardwareVideoDecoder22.mMediaCodec, mediaFormat, surface);
            }
            if (!bl2) {
                return 1;
            }
            this.mIsStarted = true;
            LiteavLog.i(this.mTAG, "Start succeed");
            return 0;
        }
        catch (Throwable throwable) {
            LiteavLog.e(this.mTAG, "Start MediaCodec failed: ", throwable);
            return 1;
        }
    }

    public void stop() {
        LiteavLog.i(this.mTAG, "stop");
        if (!this.mIsStarted) {
            return;
        }
        HardwareVideoDecoder2 hardwareVideoDecoder2 = this;
        hardwareVideoDecoder2.destroyMediaCodec(hardwareVideoDecoder2.mMediaCodec);
        this.mMediaCodec = null;
        this.uninitializeSurface();
        this.mIsStarted = false;
        this.mExternalSurface = null;
    }

    public int drainDecodedFrame() {
        try {
            if (this.mUseAsyncMode) {
                return this.drainDecodedFrameAsyncMode();
            }
            return this.drainDecodedFrameSyncMode();
        }
        catch (Throwable throwable) {
            LiteavLog.e(this.mTAG, "Drain frame failed: ", throwable);
            this.handleDecoderError(4);
            return -1;
        }
    }

    public boolean decodeFrame(EncodedVideoFrame frame) {
        if (this.mMediaCodec == null) {
            LiteavLog.w(this.mTAG, "MediaCodec is stopped.");
            return false;
        }
        if (frame == null) {
            return true;
        }
        try {
            if (!this.feedDataToMediaCodec(frame)) {
                frame.release();
                return false;
            }
        }
        catch (Throwable throwable) {
            LiteavLog.e(this.mTAG, "Feed data failed: ", throwable);
            this.handleDecoderError(4);
        }
        frame.release();
        return true;
    }

    public void setEnableVui(boolean enableVui) {
        this.mEnableLimitMaxDecFrameBufferingInH264Sps = enableVui;
    }

    public float[] updateTexImage() {
        if (this.mSurfaceTexture == null) {
            return null;
        }
        try {
            float[] fArray = new float[16];
            this.mSurfaceTexture.updateTexImage();
            this.mSurfaceTexture.getTransformMatrix(fArray);
            return fArray;
        }
        catch (Throwable throwable) {
            LiteavLog.w(this.mThrottlers.a("updateImage"), this.mTAG, "updateTexImage exception: ".concat(String.valueOf(throwable)), new Object[0]);
            return null;
        }
    }

    public void resetNativeHandle() {
        this.mNativeVideoDecoderImplAndroid = 0L;
    }

    public int getValidInputBufferCount() {
        return this.mInputBufferQueue.size();
    }

    public int getValidOutputBufferCount() {
        return this.mOutputBufferQueue.size();
    }

    private boolean feedDataToMediaCodec(EncodedVideoFrame frame) {
        ByteBuffer byteBuffer;
        int n2;
        if (this.mMediaCodec == null) {
            LiteavLog.w(this.mTAG, "MediaCodec is stopped.");
            return false;
        }
        if (frame == null || !frame.isEosFrame && (frame.data == null || frame.data.remaining() == 0)) {
            LiteavLog.w(this.mTAG, "receive empty buffer.");
            return true;
        }
        if (this.mUseAsyncMode) {
            if (this.mInputBufferQueue.isEmpty()) {
                return false;
            }
            n2 = this.mInputBufferQueue.poll();
            byteBuffer = this.mMediaCodec.getInputBuffer(n2);
        } else {
            ByteBuffer[] byteBufferArray;
            ByteBuffer[] byteBufferArray2 = byteBufferArray = this.mMediaCodec.getInputBuffers();
            if (byteBufferArray == null || byteBufferArray2.length == 0) {
                LiteavLog.e(this.mTAG, "get invalid input buffers.");
                return false;
            }
            n2 = this.mMediaCodec.dequeueInputBuffer(10000L);
            if (n2 < 0) {
                return false;
            }
            byteBuffer = byteBufferArray[n2];
        }
        if (!frame.isEosFrame) {
            this.limitMaxDecFrameBufferingInH264Sps(frame);
            int n3 = frame.data.remaining();
            byteBuffer.put(frame.data);
            this.mMediaCodec.queueInputBuffer(n2, 0, n3, TimeUnit.MILLISECONDS.toMicros(frame.pts), 0);
        } else {
            LiteavLog.i(this.mTAG, "feedDataToMediaCodec BUFFER_FLAG_END_OF_STREAM");
            this.mMediaCodec.queueInputBuffer(n2, 0, 0, 0L, 4);
        }
        return true;
    }

    private int drainDecodedFrameAsyncMode() {
        if (this.mOutputBufferQueue.isEmpty()) {
            return -1;
        }
        Pair<Integer, MediaCodec.BufferInfo> pair = this.mOutputBufferQueue.poll();
        int n2 = (Integer)pair.first;
        MediaCodec.BufferInfo bufferInfo = (MediaCodec.BufferInfo)pair.second;
        this.mLastPresentationTimeUs = bufferInfo.presentationTimeUs;
        if ((bufferInfo.flags & 4) != 0) {
            LiteavLog.i(this.mTAG, "meet end of stream.");
            this.mMediaCodec.releaseOutputBuffer(n2, true);
            return 1;
        }
        int n3 = this.mUseByteBuffer ? this.handleOutputBuffer(n2, bufferInfo) : 0;
        this.mMediaCodec.releaseOutputBuffer(n2, true);
        if (this.mExternalSurface != null) {
            long l2 = TimeUnit.MICROSECONDS.toMillis(bufferInfo.presentationTimeUs);
            if (this.mNativeVideoDecoderImplAndroid != 0L) {
                HardwareVideoDecoder2 hardwareVideoDecoder2 = this;
                hardwareVideoDecoder2.nativeOnDecodedFrameWithSurface(hardwareVideoDecoder2.mNativeVideoDecoderImplAndroid, l2);
            }
        }
        return n3;
    }

    private int drainDecodedFrameSyncMode() {
        for (int i2 = 0; i2 < 3; ++i2) {
            MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
            int n2 = this.mMediaCodec.dequeueOutputBuffer(bufferInfo, TimeUnit.MILLISECONDS.toMicros(10L));
            if (n2 == -1) {
                return -1;
            }
            if (n2 == -3) {
                LiteavLog.i(this.mTAG, "on output buffers changed");
                continue;
            }
            if (n2 == -2) {
                this.outputFormatChange();
                continue;
            }
            if (n2 >= 0) {
                this.mLastPresentationTimeUs = bufferInfo.presentationTimeUs;
                if ((bufferInfo.flags & 4) != 0) {
                    LiteavLog.i(this.mTAG, "meet end of stream.");
                    this.mMediaCodec.releaseOutputBuffer(n2, true);
                    return 1;
                }
                int n3 = this.mUseByteBuffer ? this.handleOutputBuffer(n2, bufferInfo) : 0;
                this.mMediaCodec.releaseOutputBuffer(n2, true);
                if (this.mExternalSurface != null) {
                    long l2 = TimeUnit.MICROSECONDS.toMillis(bufferInfo.presentationTimeUs);
                    if (this.mNativeVideoDecoderImplAndroid != 0L) {
                        HardwareVideoDecoder2 hardwareVideoDecoder2 = this;
                        hardwareVideoDecoder2.nativeOnDecodedFrameWithSurface(hardwareVideoDecoder2.mNativeVideoDecoderImplAndroid, l2);
                    }
                }
                return n3;
            }
            LiteavLog.d(this.mTAG, "dequeueOutputBuffer get invalid index: %d", n2);
            return -1;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int handleOutputBuffer(int bufferIndex, MediaCodec.BufferInfo bufferInfo) {
        HardwareVideoDecoder2 hardwareVideoDecoder2 = this;
        synchronized (hardwareVideoDecoder2) {
            int n2;
            ByteBuffer byteBuffer = this.mMediaCodec.getOutputBuffer(bufferIndex);
            byteBuffer.position(bufferInfo.offset);
            byteBuffer.limit(bufferInfo.offset + bufferInfo.size);
            byteBuffer.rewind();
            MediaFormat mediaFormat = this.mMediaCodec.getOutputFormat();
            int n3 = mediaFormat.getInteger("color-format");
            if (n3 == 19) {
                n2 = GLConstants.PixelFormatType.a.getValue();
            } else if (n3 == 21) {
                n2 = GLConstants.PixelFormatType.b.getValue();
            } else {
                LiteavLog.e(this.mTAG, "Unsupported color format:".concat(String.valueOf(n3)));
                this.handleDecoderError(6);
                return -1;
            }
            int n4 = mediaFormat.getInteger("width");
            int n5 = mediaFormat.getInteger("height");
            int n6 = n4;
            int n7 = n5;
            if (mediaFormat.containsKey("crop-right") && mediaFormat.containsKey("crop-left")) {
                n6 = Math.abs(mediaFormat.getInteger("crop-right") - mediaFormat.getInteger("crop-left")) + 1;
            }
            if (mediaFormat.containsKey("crop-bottom") && mediaFormat.containsKey("crop-top")) {
                n7 = Math.abs(mediaFormat.getInteger("crop-bottom") - mediaFormat.getInteger("crop-top")) + 1;
            }
            int n8 = n4;
            int n9 = n5;
            if (mediaFormat.containsKey("stride")) {
                n8 = mediaFormat.getInteger("stride");
            }
            if (mediaFormat.containsKey("slice-height")) {
                n9 = mediaFormat.getInteger("slice-height");
            }
            long l2 = TimeUnit.MICROSECONDS.toMillis(bufferInfo.presentationTimeUs);
            if (this.mNativeVideoDecoderImplAndroid != 0L) {
                HardwareVideoDecoder2 hardwareVideoDecoder22 = this;
                hardwareVideoDecoder22.nativeOnByteBuffer(hardwareVideoDecoder22.mNativeVideoDecoderImplAndroid, n2, byteBuffer, bufferInfo.size, n6, n7, n8, n9, l2);
            }
        }
        return 0;
    }

    private void limitMaxDecFrameBufferingInH264Sps(EncodedVideoFrame frame) {
        if (!(frame.isIDRFrame() && frame.codecType == com.tencent.liteav.videobase.common.a.b && this.mEnableLimitMaxDecFrameBufferingInH264Sps && this.mIsRealTime)) {
            return;
        }
        byte[] byArray = d.a(frame.data.remaining());
        if (byArray == null) {
            return;
        }
        frame.data.get(byArray);
        frame.data.rewind();
        int[] nArray = new int[]{-1};
        byte[] byArray2 = this.getSpsData(byArray, nArray);
        if (byArray2 == null || nArray[0] < 0) {
            return;
        }
        byte[] byArray3 = null;
        try {
            byte[] byArray4;
            byte[] byArray5;
            Object object = this;
            a a2 = new a((HardwareVideoDecoder2)object);
            byte[] byArray6 = byArray2;
            object = this.mSPSModifier;
            boolean bl = false;
            byte[] byArray7 = byArray6;
            byte[] byArray8 = new byte[byArray6.length];
            int n2 = 0;
            int n3 = 0;
            while (n3 < byArray7.length) {
                if (n3 < byArray7.length - 3 && byArray7[n3] == 0 && byArray7[n3 + 1] == 0 && byArray7[n3 + 2] == 3 && byArray7[n3 + 3] <= 3) {
                    byArray8[n2++] = byArray7[n3];
                    byArray8[n2++] = byArray7[n3 + 1];
                    n3 += 3;
                    continue;
                }
                byArray8[n2++] = byArray7[n3];
                ++n3;
            }
            if (n2 != byArray7.length) {
                byte[] byArray9 = new byte[n2];
                System.arraycopy(byArray8, 0, byArray9, 0, n2);
                byArray5 = byArray9;
            } else {
                byArray5 = byArray4 = null;
            }
            if (byArray5 != null) {
                bl = true;
            } else {
                byArray4 = byArray6;
            }
            byArray4 = ((com.tencent.liteav.videoconsumer.a.a)object).a(new ByteArrayInputStream(byArray4), a2);
            if (byArray4 != null && bl) {
                byArray4 = com.tencent.liteav.videoconsumer.a.a.a(byArray4);
            }
            byArray3 = byArray4;
        }
        catch (Throwable throwable) {
            LiteavLog.e(this.mTAG, "modify dec buffer error ", throwable);
        }
        if (byArray3 == null) {
            return;
        }
        ByteBuffer byteBuffer = d.b(byArray.length - byArray2.length + byArray3.length);
        if (byteBuffer == null) {
            return;
        }
        frame.data = byteBuffer;
        if (nArray[0] > 0) {
            frame.data.put(byArray, 0, nArray[0]);
        }
        frame.data.put(byArray3);
        frame.data.put(byArray, nArray[0] + byArray2.length, byArray.length - nArray[0] - byArray2.length);
        frame.data.rewind();
    }

    private byte[] getSpsData(byte[] data, int[] spsPosition) {
        int n2 = 0;
        while (n2 + 4 < data.length && (n2 = EncodedVideoFrame.getNextNALHeaderPos(n2, ByteBuffer.wrap(data))) >= 0) {
            if ((data[n2] & 0x1F) != 7) continue;
            spsPosition[0] = n2;
            break;
        }
        if (spsPosition[0] < 0) {
            return null;
        }
        n2 = data.length - spsPosition[0];
        int n3 = spsPosition[0];
        while (n3 + 3 < data.length) {
            if (data[n3] == 0 && data[n3 + 1] == 0 && data[n3 + 2] == 1 || data[n3] == 0 && data[n3 + 1] == 0 && data[n3 + 2] == 0 && data[n3 + 3] == 1) {
                n2 = n3 - spsPosition[0];
                break;
            }
            ++n3;
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(data, spsPosition[0], byArray, 0, byArray.length);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initializeSurface(int textureId) {
        HardwareVideoDecoder2 hardwareVideoDecoder2 = this;
        synchronized (hardwareVideoDecoder2) {
            try {
                this.mSurfaceTexture = new SurfaceTexture(textureId);
                this.mOutputSurface = new Surface(this.mSurfaceTexture);
                this.mSurfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
            }
            catch (Surface.OutOfResourcesException outOfResourcesException) {
                LiteavLog.e(this.mTAG, "Initialize surface failed: ", outOfResourcesException);
                return false;
            }
        }
        LiteavLog.i(this.mTAG, "Initialize surface ok.");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uninitializeSurface() {
        LiteavLog.i(this.mTAG, "Uninitialize surface");
        HardwareVideoDecoder2 hardwareVideoDecoder2 = this;
        synchronized (hardwareVideoDecoder2) {
            if (this.mOutputSurface != null) {
                this.mOutputSurface.release();
                this.mOutputSurface = null;
            }
            if (this.mSurfaceTexture != null) {
                this.mSurfaceTexture.release();
                this.mSurfaceTexture = null;
            }
            return;
        }
    }

    private boolean configureDecoder(MediaCodec mediaCodec, MediaFormat mediaFormat, Surface surface) {
        try {
            mediaCodec.configure(mediaFormat, surface, null, 0);
            mediaCodec.setVideoScalingMode(1);
            mediaCodec.start();
            LiteavLog.i(this.mTAG, "Start MediaCodec(%s) success.", mediaCodec.getName());
            return true;
        }
        catch (Throwable throwable) {
            LiteavLog.e(this.mTAG, "Configure MediaCodec failed: ", throwable);
            return false;
        }
    }

    private int getSupportedByteBufferColorFormat(MediaCodecInfo.CodecCapabilities capabilities) {
        boolean bl = false;
        boolean bl2 = false;
        int[] nArray = capabilities.colorFormats;
        int n2 = capabilities.colorFormats.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = nArray[i2];
            if (n3 == 19) {
                bl = true;
                continue;
            }
            if (n3 != 21) continue;
            bl2 = true;
        }
        if (bl) {
            return 19;
        }
        if (bl2) {
            return 21;
        }
        LiteavLog.e(this.mTAG, "I420/NV12 not found, formats: " + Arrays.toString(capabilities.colorFormats));
        return 0;
    }

    private boolean isResolutionSupported(MediaCodecInfo.CodecCapabilities capabilities, int width, int height) {
        if (LiteavSystemInfo.getSystemOSVersionInt() < 21) {
            return true;
        }
        MediaCodecInfo.VideoCapabilities videoCapabilities = capabilities.getVideoCapabilities();
        if (videoCapabilities == null) {
            return true;
        }
        Range range = videoCapabilities.getSupportedWidths();
        Range range2 = videoCapabilities.getSupportedHeights();
        if (range == null || range2 == null) {
            return true;
        }
        if (width < (Integer)range.getLower() || height < (Integer)range2.getLower()) {
            LiteavLog.e(this.mTAG, "Resolution %dx%d below range: %sx%s", width, height, range.toString(), range2.toString());
            return false;
        }
        if (width > (Integer)range.getUpper() || height > (Integer)range2.getUpper()) {
            LiteavLog.w(this.mTAG, "Resolution %dx%d above range: %sx%s", width, height, range.toString(), range2.toString());
        }
        return true;
    }

    /*
     * Loose catch block
     */
    private void destroyMediaCodec(MediaCodec mediaCodec) {
        if (mediaCodec != null) {
            LiteavLog.i(this.mTAG, "mediaCodec stop");
            mediaCodec.stop();
            try {
                LiteavLog.i(this.mTAG, "mediaCodec release");
                mediaCodec.release();
                return;
            }
            catch (Throwable throwable) {
                LiteavLog.e(this.mTAG, "release MediaCodec failed.", throwable);
                return;
            }
            catch (Throwable throwable) {
                try {
                    LiteavLog.e(this.mTAG, "Stop MediaCodec failed." + throwable.getMessage());
                }
                catch (Throwable throwable2) {
                    try {
                        LiteavLog.i(this.mTAG, "mediaCodec release");
                        mediaCodec.release();
                    }
                    catch (Throwable throwable3) {
                        LiteavLog.e(this.mTAG, "release MediaCodec failed.", throwable3);
                    }
                    throw throwable2;
                }
                try {
                    LiteavLog.i(this.mTAG, "mediaCodec release");
                    mediaCodec.release();
                    return;
                }
                catch (Throwable throwable4) {
                    LiteavLog.e(this.mTAG, "release MediaCodec failed.", throwable4);
                    return;
                }
            }
        }
    }

    private void handleDecoderError(int error) {
        if (this.mNativeVideoDecoderImplAndroid != 0L) {
            HardwareVideoDecoder2 hardwareVideoDecoder2 = this;
            hardwareVideoDecoder2.nativeOnDecodedFrameFailed(hardwareVideoDecoder2.mNativeVideoDecoderImplAndroid, error);
        }
    }

    private void outputFormatChange() {
        MediaFormat mediaFormat = this.mMediaCodec.getOutputFormat();
        LiteavLog.i(this.mTAG, "decode output format changed: ".concat(String.valueOf(mediaFormat)));
    }

    private void setCallback(MediaCodec mediaCodec) {
        MediaCodec.Callback callback = new MediaCodec.Callback(){

            public final void onInputBufferAvailable(MediaCodec codec, int index) {
                HardwareVideoDecoder2.this.onMediaCodecInputBufferAvailable(codec, index);
            }

            public final void onOutputBufferAvailable(MediaCodec codec, int index, MediaCodec.BufferInfo info) {
                HardwareVideoDecoder2.this.onMediaCodecOutputBufferAvailable(codec, index, info);
            }

            public final void onError(MediaCodec codec, MediaCodec.CodecException e2) {
                HardwareVideoDecoder2.this.onMediaCodecError(codec, e2);
            }

            public final void onOutputFormatChanged(MediaCodec codec, MediaFormat format) {
                HardwareVideoDecoder2.this.onMediaCodecOutputFormatChanged(codec, format);
            }
        };
        if (LiteavSystemInfo.getSystemOSVersionInt() < 23) {
            mediaCodec.setCallback(callback);
            return;
        }
        Handler handler = new Handler(Looper.myLooper());
        mediaCodec.setCallback(callback, handler);
    }

    private void onMediaCodecInputBufferAvailable(MediaCodec codec, int index) {
        if (codec != this.mMediaCodec) {
            LiteavLog.w(this.mTAG, "onMediaCodecInputBufferAvailable: MediaCodec changed.");
            return;
        }
        this.mInputBufferQueue.offer(index);
        if (this.mNativeVideoDecoderImplAndroid != 0L) {
            HardwareVideoDecoder2 hardwareVideoDecoder2 = this;
            hardwareVideoDecoder2.nativeOnInputBufferAvailable(hardwareVideoDecoder2.mNativeVideoDecoderImplAndroid);
        }
    }

    private void onMediaCodecOutputBufferAvailable(MediaCodec codec, int index, MediaCodec.BufferInfo info) {
        if (codec != this.mMediaCodec) {
            LiteavLog.w(this.mTAG, "onMediaCodecOutputBufferAvailable: MediaCodec changed.");
            return;
        }
        this.mOutputBufferQueue.offer((Pair<Integer, MediaCodec.BufferInfo>)new Pair((Object)index, (Object)info));
        if (this.mNativeVideoDecoderImplAndroid != 0L) {
            HardwareVideoDecoder2 hardwareVideoDecoder2 = this;
            hardwareVideoDecoder2.nativeOnOutputBufferAvailable(hardwareVideoDecoder2.mNativeVideoDecoderImplAndroid);
        }
    }

    private void onMediaCodecError(MediaCodec codec, MediaCodec.CodecException e2) {
        if (codec != this.mMediaCodec) {
            LiteavLog.w(this.mTAG, "onMediaCodecOutputBufferAvailable: MediaCodec changed.");
            return;
        }
        LiteavLog.e(this.mTAG, "onMediaCodecError: " + e2.toString());
        this.handleDecoderError(4);
    }

    private void onMediaCodecOutputFormatChanged(MediaCodec codec, MediaFormat format) {
        if (codec != this.mMediaCodec) {
            LiteavLog.w(this.mTAG, "onMediaCodecOutputFormatChanged: MediaCodec changed.");
            return;
        }
        LiteavLog.i(this.mTAG, "onMediaCodecOutputFormatChanged: ".concat(String.valueOf(format)));
    }

    public MediaCodec createMediaCodecInternal(boolean forceSoftware, String mimeType) throws IOException {
        if (!forceSoftware) {
            return MediaCodec.createDecoderByType((String)mimeType);
        }
        for (MediaCodecInfo mediaCodecInfo : new MediaCodecList(0).getCodecInfos()) {
            String[] stringArray = mediaCodecInfo.getSupportedTypes();
            if (mediaCodecInfo.isEncoder()) continue;
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!stringArray2[i2].contains(mimeType) || !MediaCodecAbility.isSoftOnlyDecoder(mediaCodecInfo)) continue;
                LiteavLog.i(this.mTAG, "Use soft only decoder:%s", mediaCodecInfo.getName());
                return MediaCodec.createByCodecName((String)mediaCodecInfo.getName());
            }
        }
        return MediaCodec.createDecoderByType((String)mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        long l2;
        HardwareVideoDecoder2 hardwareVideoDecoder2 = this;
        synchronized (hardwareVideoDecoder2) {
            if (this.mSurfaceTexture == null || this.mSurfaceTexture != surfaceTexture) {
                return;
            }
            l2 = TimeUnit.NANOSECONDS.toMillis(surfaceTexture.getTimestamp());
            if (l2 == 0L) {
                l2 = TimeUnit.MICROSECONDS.toMillis(this.mLastPresentationTimeUs);
            }
        }
        if (this.mNativeVideoDecoderImplAndroid != 0L) {
            HardwareVideoDecoder2 hardwareVideoDecoder22 = this;
            hardwareVideoDecoder22.nativeOnFrameAvailable(hardwareVideoDecoder22.mNativeVideoDecoderImplAndroid, l2);
        }
    }

    private native void nativeOnFrameFlagCropExist(long var1, int var3, int var4, int var5, int var6);

    private native void nativeOnDecodedFrameFailed(long var1, int var3);

    private native void nativeOnFrameAvailable(long var1, long var3);

    private native void nativeOnByteBuffer(long var1, int var3, ByteBuffer var4, int var5, int var6, int var7, int var8, int var9, long var10);

    private native void nativeOnDecodedFrameWithSurface(long var1, long var3);

    private native void nativeOnInputBufferAvailable(long var1);

    private native void nativeOnOutputBufferAvailable(long var1);

    static /* synthetic */ boolean lambda$limitMaxDecFrameBufferingInH264Sps$0(HardwareVideoDecoder2 this_, int left, int right, int top, int bottom) {
        LiteavLog.e(this_.mTAG, "frame cropping flag exist, crop[l:" + left + ",r:" + right + ",t:" + top + ",b:" + bottom + "]");
        this_.mEnableLimitMaxDecFrameBufferingInH264Sps = false;
        if (this_.mNativeVideoDecoderImplAndroid != 0L) {
            HardwareVideoDecoder2 hardwareVideoDecoder2 = this_;
            hardwareVideoDecoder2.nativeOnFrameFlagCropExist(hardwareVideoDecoder2.mNativeVideoDecoderImplAndroid, left, right, top, bottom);
        }
        return false;
    }
}

