/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videobase.videobase;

import android.view.TextureView;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.videobase.DisplayTarget;
import com.tencent.rtmp.ui.AndroidViewEventListener;
import com.tencent.rtmp.ui.TXCloudVideoView;
import java.lang.reflect.Method;

@JNINamespace(value="liteav::video")
public class TXCCloudVideoViewMethodInvoker {
    private static final String TAG = "TXCCloudVideoViewMethodInvoker";

    public static void setTouchToFocusEnabled(TXCloudVideoView view, boolean enable) {
        Class[] classArray = new Class[]{Boolean.TYPE};
        TXCCloudVideoViewMethodInvoker.callMethod(view, "setTouchToFocusEnabled", classArray, enable);
    }

    public static void setZoomEnabled(TXCloudVideoView view, boolean enable) {
        Class[] classArray = new Class[]{Boolean.TYPE};
        TXCCloudVideoViewMethodInvoker.callMethod(view, "setZoomEnabled", classArray, enable);
    }

    public static void setAndroidViewEventListener(TXCloudVideoView view, AndroidViewEventListener listener) {
        Class[] classArray = new Class[]{AndroidViewEventListener.class};
        TXCCloudVideoViewMethodInvoker.callMethod(view, "setAndroidViewEventListener", classArray, listener);
    }

    public static void setBackgroundColorForInternalView(TXCloudVideoView view, int color) {
        Class[] classArray = new Class[]{Integer.TYPE};
        TXCCloudVideoViewMethodInvoker.callMethod(view, "setBackgroundColorForInternalView", classArray, color);
    }

    public static void showFocusView(TXCloudVideoView view, int x2, int y2, int width, int height) {
        Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE};
        TXCCloudVideoViewMethodInvoker.callMethod(view, "showFocusView", classArray, x2, y2, width, height);
    }

    public static TextureView getTextureViewSetByUser(TXCloudVideoView view) {
        Object object = TXCCloudVideoViewMethodInvoker.callMethod(view, "getTextureViewSetByUser", new Class[0], new Object[0]);
        if (object instanceof TextureView) {
            return (TextureView)object;
        }
        return null;
    }

    public static TextureView getInnerTextureView(TXCloudVideoView view) {
        Object object = TXCCloudVideoViewMethodInvoker.callMethod(view, "getInnerTextureView", new Class[0], new Object[0]);
        if (object instanceof TextureView) {
            return (TextureView)object;
        }
        return null;
    }

    public static void setRenderClient(TXCloudVideoView view, Object client, TextureView.SurfaceTextureListener listener) {
        Class[] classArray = new Class[]{Object.class, TextureView.SurfaceTextureListener.class};
        TXCCloudVideoViewMethodInvoker.callMethod(view, "setRenderClient", classArray, client, listener);
    }

    public static void releaseRenderClient(TXCloudVideoView view, Object client, boolean clearLastImage) {
        Class[] classArray = new Class[]{Object.class, Boolean.TYPE};
        TXCCloudVideoViewMethodInvoker.callMethod(view, "releaseRenderClient", classArray, client, clearLastImage);
    }

    public static Object getGLContextFromView(DisplayTarget target) {
        if (target == null || target.getTXCloudVideoView() == null) {
            return null;
        }
        return target.getTXCloudVideoView().getOpenGLContext();
    }

    private static Object callMethod(TXCloudVideoView view, String name, Class<?>[] argsTypes, Object ... args) {
        if (view == null) {
            LiteavLog.w(TAG, name + ",TXCloudVideoView is null.");
            return null;
        }
        try {
            Method method = TXCloudVideoView.class.getDeclaredMethod(name, argsTypes);
            method.setAccessible(true);
            return method.invoke((Object)view, args);
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, name + ",Exception:", throwable);
            return null;
        }
    }
}

