/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videobase.utils;

import android.graphics.SurfaceTexture;
import android.opengl.Matrix;
import android.os.Handler;
import android.os.Looper;
import android.view.Surface;
import com.tencent.liteav.base.a.b;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.utils.g;

@JNINamespace(value="liteav::video")
public class SurfaceTextureHolder
implements SurfaceTexture.OnFrameAvailableListener {
    private final String mTag = "SurfaceTextureHolder_" + Integer.toHexString(this.hashCode());
    private SurfaceTexture mSurfaceTexture;
    private CustomHandler mCallbackHandler;
    private SurfaceTexture.OnFrameAvailableListener mOnFrameAvailableListener;
    private Surface mSurface;
    private final b mThrottlers = new b();

    public SurfaceTextureHolder(int texName, boolean createSurface) {
        this.mSurfaceTexture = new SurfaceTexture(texName);
        if (createSurface) {
            this.mSurface = new Surface(this.mSurfaceTexture);
        }
    }

    public void setOnFrameAvailableListener(SurfaceTexture.OnFrameAvailableListener listener, Handler callbackHandler) {
        if (this.mSurfaceTexture == null) {
            LiteavLog.e(this.mThrottlers.a("setOnFrameAvailableListener"), this.mTag, "setOnFrameAvailableListener, surface texture is released!", new Object[0]);
            return;
        }
        Looper looper = callbackHandler != null ? callbackHandler.getLooper() : Looper.getMainLooper();
        this.mCallbackHandler = new CustomHandler(looper);
        this.mOnFrameAvailableListener = listener;
        if (LiteavSystemInfo.getSystemOSVersionInt() >= 21) {
            SurfaceTextureHolder surfaceTextureHolder = this;
            this.mSurfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)surfaceTextureHolder, (Handler)surfaceTextureHolder.mCallbackHandler);
            return;
        }
        this.mSurfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
    }

    public Surface getSurface() {
        return this.mSurface;
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.mSurfaceTexture;
    }

    public void updateTexImage() {
        if (this.mSurfaceTexture == null) {
            LiteavLog.e(this.mThrottlers.a("updateTexImage"), this.mTag, "updateTexImage, surface texture is released!", new Object[0]);
            return;
        }
        try {
            this.mSurfaceTexture.updateTexImage();
            return;
        }
        catch (Throwable throwable) {
            LiteavLog.w(this.mThrottlers.a("updateTexImage"), this.mTag, "updateTexImage exception: ".concat(String.valueOf(throwable)), new Object[0]);
            return;
        }
    }

    public void setDefaultBufferSize(int width, int height) {
        if (this.mSurfaceTexture == null) {
            LiteavLog.e(this.mThrottlers.a("setDefaultBufferSize"), this.mTag, "setDefaultBufferSize, surface texture is released!", new Object[0]);
            return;
        }
        this.mSurfaceTexture.setDefaultBufferSize(width, height);
    }

    public void release() {
        if (this.mSurface != null) {
            this.mSurface.release();
            this.mSurface = null;
        }
        if (this.mSurfaceTexture != null) {
            this.mSurfaceTexture.release();
            this.mSurfaceTexture = null;
        }
    }

    public float[] getTransformMatrix(boolean needCrop, float transX, float transY, float scaleX, float scaleY) {
        if (this.mSurfaceTexture == null) {
            LiteavLog.e(this.mThrottlers.a("getTransformMatrix"), this.mTag, "getTransformMatrix, surface texture is released!", new Object[0]);
            return null;
        }
        float[] fArray = new float[16];
        try {
            this.mSurfaceTexture.getTransformMatrix(fArray);
        }
        catch (Throwable throwable) {
            LiteavLog.w(this.mThrottlers.a("getTransformMatrix"), this.mTag, "updateTexImage exception: ".concat(String.valueOf(throwable)), new Object[0]);
        }
        if (needCrop) {
            if (!com.tencent.liteav.base.util.g.a(transX, 0.0f) || !com.tencent.liteav.base.util.g.a(transY, 0.0f)) {
                Matrix.translateM((float[])fArray, (int)0, (float)transX, (float)transY, (float)0.0f);
            }
            if (!com.tencent.liteav.base.util.g.a(scaleX, 1.0f) || !com.tencent.liteav.base.util.g.a(scaleY, 1.0f)) {
                Matrix.scaleM((float[])fArray, (int)0, (float)scaleX, (float)scaleY, (float)1.0f);
            }
        }
        return fArray;
    }

    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        CustomHandler customHandler = this.mCallbackHandler;
        if (customHandler != null) {
            customHandler.runOrPost(g.a(this, surfaceTexture));
        }
    }

    static /* synthetic */ void lambda$onFrameAvailable$0(SurfaceTextureHolder this_, SurfaceTexture surfaceTexture) {
        SurfaceTexture.OnFrameAvailableListener onFrameAvailableListener = this_.mOnFrameAvailableListener;
        if (onFrameAvailableListener != null) {
            onFrameAvailableListener.onFrameAvailable(surfaceTexture);
        }
    }
}

