/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.sdkcommon;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.Log;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.sdkcommon.a;
import com.tencent.liteav.sdkcommon.b;
import com.tencent.liteav.sdkcommon.c;
import com.tencent.liteav.sdkcommon.d;
import com.tencent.liteav.sdkcommon.e;
import com.tencent.liteav.sdkcommon.f;
import com.tencent.liteav.sdkcommon.g;
import com.tencent.liteav.sdkcommon.i;
import com.tencent.liteav.sdkcommon.j;
import com.tencent.liteav.sdkcommon.k;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@JNINamespace(value="liteav::dashboard")
public class DashboardManager {
    private static final String TAG = "DashboardManager";
    private final Context mAppContext;
    private final g mDashboardManagerView;
    private final Handler mUIHandler;
    private final ArrayList<String> mDashboards = new ArrayList();
    private final Map<String, String> mDashboardStatus = new HashMap<String, String>();
    private final Map<String, StringBuilder> mDashboardLogs = new HashMap<String, StringBuilder>();
    private boolean mIsInit;
    private String mSelectedDashboardId;
    private static final int LOG_MAX_SIZE = 15000;
    private final g.a mSelectedDashboardChangeListener = new g.a(){

        @Override
        public final void a(int n2) {
            if (DashboardManager.this.mDashboards.size() <= n2) {
                return;
            }
            DashboardManager.this.mSelectedDashboardId = (String)DashboardManager.this.mDashboards.get(n2);
            if (!DashboardManager.this.mDashboards.contains(DashboardManager.this.mSelectedDashboardId)) {
                return;
            }
            DashboardManager.this.mDashboardManagerView.b((String)DashboardManager.this.mDashboardStatus.get(DashboardManager.this.mSelectedDashboardId));
            StringBuilder stringBuilder = (StringBuilder)DashboardManager.this.mDashboardLogs.get(DashboardManager.this.mSelectedDashboardId);
            if (stringBuilder != null) {
                DashboardManager.this.mDashboardManagerView.a(stringBuilder.toString());
                return;
            }
            DashboardManager.this.mDashboardManagerView.a("");
        }
    };

    public DashboardManager() {
        LiteavLog.i(TAG, "java DashBoardManager Construct");
        this.mIsInit = false;
        this.mAppContext = ContextUtils.getApplicationContext();
        this.mDashboardManagerView = new g(this.mAppContext, this.mSelectedDashboardChangeListener);
        this.mUIHandler = new Handler(Looper.getMainLooper());
    }

    public int showDashboard(boolean isShow) {
        LiteavLog.i(TAG, "showDashBoard isShow = ".concat(String.valueOf(isShow)));
        this.mUIHandler.post(a.a(this, isShow));
        return 0;
    }

    public int addDashboard(String dashboardId) {
        LiteavLog.i(TAG, "addDashboard dashboardId = ".concat(String.valueOf(dashboardId)));
        this.mUIHandler.post(b.a(this, dashboardId));
        return 0;
    }

    public int removeDashboard(String dashboardId) {
        LiteavLog.i(TAG, "removeDashboard dashboardId = ".concat(String.valueOf(dashboardId)));
        this.mUIHandler.post(c.a(this, dashboardId));
        return 0;
    }

    public int removeAllDashboard() {
        LiteavLog.i(TAG, "removeAllDashboard ");
        this.mUIHandler.post(d.a(this));
        return 0;
    }

    public int setStatus(String dashboardId, String status) {
        this.mUIHandler.post(e.a(this, dashboardId, status));
        return 0;
    }

    public int appendLog(String dashboardId, String log) {
        this.mUIHandler.post(f.a(this, dashboardId, log));
        return 0;
    }

    private boolean checkPermission() {
        if (LiteavSystemInfo.getSystemOSVersionInt() > 23 && !Settings.canDrawOverlays((Context)this.mAppContext)) {
            Toast.makeText((Context)this.mAppContext, (CharSequence)"no system alert window permission, please authorize", (int)0).show();
            return false;
        }
        return true;
    }

    private boolean init() {
        boolean bl;
        if (this.mIsInit) {
            return true;
        }
        g g2 = this.mDashboardManagerView;
        if (g2.c == null) {
            Log.e("DashboardManagerView", "dashBoardManagerView context is null", new Object[0]);
            bl = false;
        } else {
            g2.f = (WindowManager)g2.c.getSystemService("window");
            if (g2.f == null) {
                Log.e("DashboardManagerView", "get windowManager is fail", new Object[0]);
                bl = false;
            } else {
                g2.f.getDefaultDisplay().getMetrics(g2.a);
                g2.n = g2.a.heightPixels - g2.a(50);
                bl = true;
            }
        }
        if (!bl) {
            return false;
        }
        g2 = this.mDashboardManagerView;
        g2.b.type = Build.VERSION.SDK_INT >= 26 ? 2038 : 2002;
        g2.b.format = 1;
        g2.b.gravity = 0x800033;
        g2.b.width = g2.a.widthPixels;
        g2.b.height = g2.n;
        g2.b.x = 0;
        g2.b.y = 0;
        g2.b.flags = 32;
        g g3 = g2;
        LinearLayout linearLayout = new LinearLayout(g3.c);
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
        linearLayout.setLayoutParams(layoutParams);
        linearLayout.setOrientation(1);
        linearLayout.setOnTouchListener((View.OnTouchListener)g3.new g.b(0));
        g g4 = g3;
        LinearLayout.LayoutParams layoutParams2 = new LinearLayout.LayoutParams(g4.a(70), g4.a(40));
        Button button = new Button(g4.c);
        button.setText((CharSequence)"Resize");
        button.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        button.setOnClickListener(j.a(g4, button));
        Button button2 = new Button(g4.c);
        button2.setText((CharSequence)"close");
        layoutParams2.leftMargin = g4.a(10);
        button2.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        button2.setOnClickListener(k.a(g4));
        LinearLayout linearLayout2 = new LinearLayout(g4.c);
        linearLayout2.addView((View)button);
        linearLayout2.addView((View)button2);
        ViewGroup.LayoutParams layoutParams3 = new ViewGroup.LayoutParams(-1, -2);
        linearLayout2.setLayoutParams(layoutParams3);
        linearLayout2.setOrientation(0);
        linearLayout2.setBackgroundColor(-7829368);
        linearLayout2.setAlpha(0.5f);
        linearLayout.addView((View)linearLayout2);
        g4 = g3;
        g3.j = new Spinner(g4.c);
        g4.j.setAdapter(g4.e);
        layoutParams2 = new LinearLayout.LayoutParams(-1, g4.a(30));
        new LinearLayout.LayoutParams(-1, g4.a(30)).topMargin = g4.a(2);
        g4.j.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        g4.j.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)g4.new g.c(0));
        g4.j.setBackgroundColor(-7829368);
        g4.j.setAlpha(0.5f);
        linearLayout.addView((View)g4.j);
        g4 = g3;
        g3.h = new TextView(g4.c);
        layoutParams2 = new LinearLayout.LayoutParams(-1, g4.a(160));
        new LinearLayout.LayoutParams(-1, g4.a(160)).topMargin = g4.a(10);
        layoutParams2.leftMargin = g4.a(10);
        layoutParams2.rightMargin = g4.a(3);
        g4.h.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        g4.h.setTextColor(-65536);
        linearLayout.addView((View)g4.h);
        g4 = g3;
        g3.k = new ScrollView(g4.c);
        layoutParams2 = new LinearLayout.LayoutParams(-1, g4.b());
        new LinearLayout.LayoutParams(-1, g4.b()).leftMargin = g4.a(10);
        layoutParams2.rightMargin = g4.a(3);
        g4.k.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        g4.k.setVerticalScrollBarEnabled(true);
        g4.i = new TextView(g4.c);
        button = new LinearLayout.LayoutParams(-1, -2);
        g4.i.setLayoutParams((ViewGroup.LayoutParams)button);
        g4.i.setTextColor(-65536);
        g4.k.addView((View)g4.i);
        g4.k.fullScroll(130);
        linearLayout.addView((View)g4.k);
        g2.g = linearLayout;
        g2.o.a(0);
        this.mIsInit = true;
        return true;
    }

    private void showDashboardInternal(boolean isShow) {
        if (!(!isShow || this.checkPermission() && this.init())) {
            LiteavLog.i(TAG, "init or check permission is fail");
            return;
        }
        this.mDashboardManagerView.a(isShow);
    }

    private void addDashboardInternal(String dashboardId) {
        if (!this.mDashboards.contains(dashboardId)) {
            this.mDashboards.add(dashboardId);
            String string = dashboardId;
            g g2 = this.mDashboardManagerView;
            g2.e.add((Object)string);
            if (g2.l == null) {
                g2.l = (String)g2.e.getItem(0);
                g2.o.a(0);
            }
            g2.a();
        }
    }

    private void removeDashboardInternal(String dashboardId) {
        if (this.mDashboards.contains(dashboardId)) {
            this.mDashboards.remove(dashboardId);
            this.mDashboardStatus.remove(dashboardId);
            this.mDashboardLogs.remove(dashboardId);
            String string = dashboardId;
            g g2 = this.mDashboardManagerView;
            if (string.equals(g2.l)) {
                int n2 = g2.e.getPosition((Object)g2.l);
                if (n2 != g2.e.getCount() - 1) {
                    g2.l = (String)g2.e.getItem(++n2);
                    g2.o.a(n2 - 1);
                    if (g2.j != null) {
                        g2.j.setSelection(n2);
                    }
                } else if (n2 > 0) {
                    g2.l = (String)g2.e.getItem(n2 - 1);
                    g2.o.a(n2 - 1);
                    if (g2.j != null) {
                        g2.j.setSelection(n2 - 1);
                    }
                }
            }
            g2.e.remove((Object)string);
            if (g2.e.getCount() == 0) {
                g2.l = null;
            }
            g2.a();
        }
    }

    private void removeAllDashboardInternal() {
        this.mDashboards.clear();
        this.mDashboardStatus.clear();
        this.mDashboardLogs.clear();
        g g2 = this.mDashboardManagerView;
        g2.e.clear();
        g2.l = null;
        if (g2.h != null) {
            g2.h.setText((CharSequence)"");
        }
        if (g2.i != null) {
            g2.i.setText((CharSequence)"");
        }
    }

    private void setStatusInternal(String dashboardId, String status) {
        if (this.mDashboards.contains(dashboardId)) {
            this.mDashboardStatus.put(dashboardId, status);
            if (dashboardId.equals(this.mSelectedDashboardId)) {
                this.mDashboardManagerView.b(status);
            }
        }
    }

    private void appendLogInternal(String dashboardId, String log) {
        if (this.mDashboards.contains(dashboardId)) {
            StringBuilder stringBuilder = this.mDashboardLogs.get(dashboardId);
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
                this.mDashboardLogs.put(dashboardId, stringBuilder);
            }
            stringBuilder.append(log);
            stringBuilder.append("\n");
            if (stringBuilder.length() > 15000) {
                stringBuilder.delete(0, stringBuilder.length() / 2);
            }
            if (dashboardId.equals(this.mSelectedDashboardId)) {
                String string = log;
                g g2 = this.mDashboardManagerView;
                if (g2.i != null) {
                    g2.i.append((CharSequence)(string + "\n"));
                    if (g2.k != null && g2.k.getScrollY() + g2.k.getHeight() + g2.a(100) >= g2.i.getMeasuredHeight()) {
                        g2.d.post(i.a(g2));
                    }
                }
            }
        }
    }

    static /* synthetic */ void lambda$appendLog$5(DashboardManager this_, String dashboardId, String log) {
        this_.appendLogInternal(dashboardId, log);
    }

    static /* synthetic */ void lambda$setStatus$4(DashboardManager this_, String dashboardId, String status) {
        this_.setStatusInternal(dashboardId, status);
    }

    static /* synthetic */ void lambda$removeAllDashboard$3(DashboardManager this_) {
        this_.removeAllDashboardInternal();
    }

    static /* synthetic */ void lambda$removeDashboard$2(DashboardManager this_, String dashboardId) {
        this_.removeDashboardInternal(dashboardId);
    }

    static /* synthetic */ void lambda$addDashboard$1(DashboardManager this_, String dashboardId) {
        this_.addDashboardInternal(dashboardId);
    }

    static /* synthetic */ void lambda$showDashboard$0(DashboardManager this_, boolean isShow) {
        this_.showDashboardInternal(isShow);
    }
}

