/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio2;

import android.media.AudioTrack;
import android.os.Process;
import com.tencent.liteav.base.Log;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import java.nio.ByteBuffer;

@JNINamespace(value="liteav::audio")
public class LiteavAudioTrack2 {
    private static final String TAG = "LiteavAudioTrack2";
    private AudioTrack mAudioTrack;
    private byte[] mPlayBuffer;
    private int mBufferSize = 0;
    private int mSystemOSVersion = 0;

    private static AudioTrack createStartedAudioTrack(int sampleRate, int channelConfig, int bufferSize, int streamType) {
        AudioTrack audioTrack = null;
        try {
            audioTrack = new AudioTrack(streamType, sampleRate, channelConfig, 2, bufferSize, 1);
            if (audioTrack.getState() != 1) {
                throw new RuntimeException("AudioTrack is not initialized.");
            }
            audioTrack.play();
            Log.i(TAG, "create AudioTrack success. sampleRate: %d, channelConfig: %d, bufferSize: %d, streamType: %s", sampleRate, channelConfig, bufferSize, LiteavAudioTrack2.streamTypeToString(streamType));
        }
        catch (Throwable throwable) {
            Log.w(TAG, "create AudioTrack failed. sampleRate: %d, channelConfig: %d, bufferSize: %d, streamType: %s", sampleRate, channelConfig, bufferSize, LiteavAudioTrack2.streamTypeToString(streamType));
            LiteavAudioTrack2.destroyAudioTrack(audioTrack);
            audioTrack = null;
        }
        return audioTrack;
    }

    private static void destroyAudioTrack(AudioTrack audioTrack) {
        if (audioTrack == null) {
            return;
        }
        try {
            if (audioTrack.getPlayState() == 3) {
                audioTrack.stop();
                audioTrack.flush();
            }
            audioTrack.release();
            return;
        }
        catch (Throwable throwable) {
            Log.e(TAG, "stop AudioTrack failed.", throwable);
            return;
        }
    }

    private static String streamTypeToString(int stream) {
        switch (stream) {
            case 0: {
                return "STREAM_VOICE_CALL";
            }
            case 3: {
                return "STREAM_MUSIC";
            }
            case 2: {
                return "STREAM_RING";
            }
            case 4: {
                return "STREAM_ALARM";
            }
            case 5: {
                return "STREAM_NOTIFICATION";
            }
            case 1: {
                return "STREAM_SYSTEM";
            }
        }
        return "STREAM_INVALID";
    }

    public int startPlayout(int streamType, int sampleRate, int channelCount, int frameSize) {
        int[] nArray = new int[]{streamType, 0, 3, 1};
        int n2 = channelCount == 1 ? 4 : 12;
        int n3 = AudioTrack.getMinBufferSize((int)sampleRate, (int)n2, (int)2);
        if (n3 <= 0) {
            Log.e(TAG, "AudioTrack.getMinBufferSize return error: ".concat(String.valueOf(n3)), new Object[0]);
            return -2;
        }
        for (int i2 = 0; i2 < 4 && this.mAudioTrack == null; ++i2) {
            int n4 = nArray[i2];
            for (int i3 = 1; i3 <= 2 && this.mAudioTrack == null; ++i3) {
                this.mBufferSize = n3 * i3;
                if (this.mBufferSize < frameSize * 4 && i3 < 2) continue;
                this.mAudioTrack = LiteavAudioTrack2.createStartedAudioTrack(sampleRate, n2, this.mBufferSize, n4);
            }
        }
        if (this.mAudioTrack == null) {
            return -1;
        }
        this.mSystemOSVersion = LiteavSystemInfo.getSystemOSVersionInt();
        Process.setThreadPriority((int)-19);
        return 0;
    }

    public int write(ByteBuffer buffer, int offset, int size, boolean isNonBlockingWrite) {
        int n2;
        if (this.mAudioTrack == null) {
            return -1;
        }
        buffer.position(offset);
        if (this.mSystemOSVersion >= 21) {
            int n3 = isNonBlockingWrite ? 1 : 0;
            n2 = this.mAudioTrack.write(buffer, size, n3);
        } else {
            if (this.mPlayBuffer == null || this.mPlayBuffer.length < size) {
                this.mPlayBuffer = new byte[size];
            }
            buffer.get(this.mPlayBuffer, 0, size);
            n2 = this.mAudioTrack.write(this.mPlayBuffer, 0, size);
        }
        if (n2 < 0) {
            Log.e(TAG, "write audio data to AudioTrack failed. ".concat(String.valueOf(n2)), new Object[0]);
            return -1;
        }
        return n2;
    }

    public void stopPlayout() {
        LiteavAudioTrack2.destroyAudioTrack(this.mAudioTrack);
        this.mAudioTrack = null;
    }

    public int getBufferSize() {
        return this.mBufferSize;
    }
}

