/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.v2;

import android.content.Context;
import android.text.TextUtils;
import com.tencent.imsdk.common.IMCallback;
import com.tencent.imsdk.common.IMContext;
import com.tencent.imsdk.common.IMLog;
import com.tencent.imsdk.common.SystemUtil;
import com.tencent.imsdk.conversation.ConversationKey;
import com.tencent.imsdk.conversation.ConversationManager;
import com.tencent.imsdk.group.GroupMemberInfo;
import com.tencent.imsdk.manager.BaseManager;
import com.tencent.imsdk.manager.CustomServerInfo;
import com.tencent.imsdk.manager.SDKConfig;
import com.tencent.imsdk.message.Message;
import com.tencent.imsdk.message.MessageCenter;
import com.tencent.imsdk.message.MessageExtension;
import com.tencent.imsdk.message.MessageExtensionResult;
import com.tencent.imsdk.message.TextElement;
import com.tencent.imsdk.offlinepush.OfflinePushConfig;
import com.tencent.imsdk.offlinepush.OfflinePushEventItem;
import com.tencent.imsdk.offlinepush.OfflinePushManager;
import com.tencent.imsdk.v2.V2TIMConversationManagerImpl;
import com.tencent.imsdk.v2.V2TIMGroupMemberFullInfo;
import com.tencent.imsdk.v2.V2TIMMessage;
import com.tencent.imsdk.v2.V2TIMMessageExtension;
import com.tencent.imsdk.v2.V2TIMMessageExtensionResult;
import com.tencent.imsdk.v2.V2TIMValueCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class V2TIMManagerExperimentImpl {
    public static V2TIMManagerExperimentImpl getInstance() {
        return V2TIMManagerExperimentImplHolder.v2TIMManagerExperiment;
    }

    protected V2TIMManagerExperimentImpl() {
    }

    public void callExperimentalAPI(String api, Object param, V2TIMValueCallback<Object> callback) {
        if (TextUtils.isEmpty((CharSequence)api)) {
            this.callbackOnError(callback, 6017, "invalid api");
            return;
        }
        if (api.equals("setCustomServerInfo")) {
            this.setCustomServerInfo(param, callback);
        } else if (api.equals("enableQuicChannel")) {
            this.setQuicChannelEnabled(param, callback);
        } else if (api.equals("setProxyInfo")) {
            this.setProxyInfo(param, callback);
        } else if (api.equals("setLibraryPath")) {
            this.setLibraryPath(param, callback);
        } else if (api.equals("downloadLibrary")) {
            this.downloadLibrary(param, callback);
        } else if (api.equals("initLocalStorage")) {
            this.initLocalStorage(param, callback);
        } else if (api.equals("setTestEnvironment")) {
            this.setTestEnvironment(param, callback);
        } else if (api.equals("setIPv6Prior")) {
            this.setIPv6Prior(param, callback);
        } else if (api.equals("setCosSaveRegionForConversation")) {
            this.setCosSaveRegion(param, callback);
        } else if (api.equals("setUIPlatform")) {
            this.setUIPlatform(param, callback);
        } else if (api.equals("setBuildInfo")) {
            this.setBuildInfo(param, callback);
        } else if (api.equals("setDatabaseEncryptInfo")) {
            this.setDatabaseEncryptInfo(param, callback);
        } else if (api.equals("isCommercialAbilityEnabled")) {
            this.isCommercialAbilityEnabled(param, callback);
        } else if (api.equals("setPacketRetryInfo")) {
            this.setPacketRetryInfo(param, callback);
        } else if (api.equals("setOfflinePushState")) {
            this.setOfflinePushState(param, callback);
        } else if (api.equals("getOfflinePushState")) {
            this.getOfflinePushState(callback);
        } else if (api.equals("getMessageRevoker")) {
            this.getMessageRevoker(param, callback);
        } else if (api.equals("writeLog")) {
            this.writeLog(param, callback);
        } else if (api.equals("getAIDenoiseSignature")) {
            this.getAIDenoiseSignature(callback);
        } else if (api.equals("getVideoEditSignature")) {
            this.getVideoEditSignature(callback);
        } else if (api.equals("sendTRTCCustomData")) {
            this.sendTRTCCustomData(param, callback);
        } else if (api.equals("setMessageExtensionsBySequence")) {
            this.setMessageExtensionsBySequence(param, callback);
        } else if (api.equals("getMessageExtensionsBySequence")) {
            this.getMessageExtensionsBySequence(param, callback);
        } else if (api.equals("clearLocalHistoryMessage")) {
            this.clearLocalHistoryMessage(param, callback);
        } else if (api.equals("reportTUIComponentUsage")) {
            this.reportTUIComponentUsage(param, callback);
        } else if (api.equals("setConversationGroupOrderData")) {
            this.setConversationGroupOrderData(param, callback);
        } else if (api.equals("getConversationGroupOrderData")) {
            this.getConversationGroupOrderData(param, callback);
        } else if (api.equals("reportOfflinePushEvent")) {
            this.reportOfflinePushEvent(param, callback);
        } else if (api.equals("setOfflinePushInfo")) {
            this.setOfflinePushInfo(param, callback);
        } else if (api.equals("setApplicationID")) {
            this.setApplicationID(param, callback);
        } else if (api.equals("findMergerMessages")) {
            this.findMergerMessages(param, callback);
        } else if (api.equals("getBriefGroupMemberList")) {
            this.getBriefGroupMemberList(param, callback);
        } else if (api.equals("pushLogin")) {
            this.pushLogin(param, callback);
        } else if (api.equals("reportPushSDKEvent")) {
            this.reportPushSDKEvent(param, callback);
        } else if (api.equals("setCustomLoginInfo")) {
            this.setCustomLoginInfo(param, callback);
        } else if (api.equals("disableHttpRequest")) {
            this.disableHttpRequest(param, callback);
        } else if (api.equals("getLoginAccountType")) {
            this.getLoginAccountType(param, callback);
        } else if (api.equals("cancelSendingMessage")) {
            this.cancelSendingMessage(param, callback);
        } else if (api.equals("getMessageSource")) {
            this.getMessageSource(param, callback);
        } else {
            this.callbackOnError(callback, 6017, "unsupported api");
        }
    }

    private void setConversationGroupOrderData(Object param, V2TIMValueCallback<Object> callback) {
        if (null == param || !(param instanceof String)) {
            this.callbackOnError(callback, 6017, "param is not string");
            return;
        }
        String conversationGroupOrderData = (String)param;
        ConversationManager.getInstance().setConversationGroupOrderData(conversationGroupOrderData, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    private void getConversationGroupOrderData(Object param, final V2TIMValueCallback<Object> callback) {
        V2TIMValueCallback<String> v2TIMValueCallback = new V2TIMValueCallback<String>(){

            @Override
            public void onSuccess(String orderData) {
                callback.onSuccess(orderData);
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        ConversationManager.getInstance().getConversationGroupOrderData(new IMCallback<String>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(String orderData) {
                super.success(orderData);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    private void reportTUIComponentUsage(Object param, V2TIMValueCallback<Object> callback) {
        if (null == param || !(param instanceof String)) {
            this.callbackOnError(callback, 6017, "param is not string");
            return;
        }
        String json = (String)param;
        if (TextUtils.isEmpty((CharSequence)json)) {
            this.callbackOnError(callback, 6017, "param is empty");
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(json);
            long uiComponentType = jsonObject.optLong("UIComponentType");
            long uiStyleType = jsonObject.optLong("UIStyleType");
            BaseManager.getInstance().reportTUIComponentUsage(uiComponentType, uiStyleType);
            this.callbackOnSuccess(callback, null);
        }
        catch (JSONException e) {
            this.callbackOnError(callback, 6017, "convert param to json failed");
            e.printStackTrace();
        }
    }

    private void setMessageExtensionsBySequence(Object param, final V2TIMValueCallback<Object> callback) {
        if (null == param || !(param instanceof String)) {
            this.callbackOnError(callback, 6017, "param is not string");
            return;
        }
        String json = (String)param;
        if (TextUtils.isEmpty((CharSequence)json)) {
            this.callbackOnError(callback, 6017, "param is empty");
            return;
        }
        String groupID = "";
        long messageSequence = 0L;
        ArrayList<MessageExtension> extensionList = new ArrayList<MessageExtension>();
        try {
            JSONObject jsonObject = new JSONObject(json);
            groupID = jsonObject.optString("groupID");
            messageSequence = jsonObject.optLong("messageSequence");
            JSONArray extensionJsonArray = jsonObject.optJSONArray("messageExtensionList");
            for (int i = 0; i < extensionJsonArray.length(); ++i) {
                JSONObject extensionJson = extensionJsonArray.getJSONObject(i);
                MessageExtension extension = new MessageExtension();
                extension.setExtensionKey(extensionJson.optString("extensionKey"));
                extension.setExtensionValue(extensionJson.optString("extensionValue"));
                extensionList.add(extension);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        V2TIMValueCallback<List<MessageExtensionResult>> v2TIMValueCallback = new V2TIMValueCallback<List<MessageExtensionResult>>(){

            @Override
            public void onSuccess(List<MessageExtensionResult> messageExtensionResults) {
                if (callback != null) {
                    ArrayList<V2TIMMessageExtensionResult> v2TIMMessageExtensionResults = new ArrayList<V2TIMMessageExtensionResult>();
                    for (MessageExtensionResult result : messageExtensionResults) {
                        V2TIMMessageExtensionResult v2TIMMessageExtensionResult = new V2TIMMessageExtensionResult();
                        v2TIMMessageExtensionResult.setMessageExtensionResult(result);
                        v2TIMMessageExtensionResults.add(v2TIMMessageExtensionResult);
                    }
                    callback.onSuccess(v2TIMMessageExtensionResults);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        Message message = new Message();
        message.setMessageStatus(2);
        message.setSupportMessageExtension(true);
        message.addElement(new TextElement());
        message.setMessageType(2);
        message.setGroupID(groupID);
        message.setSeq(messageSequence);
        MessageCenter.getInstance().setMessageExtensions(message, extensionList, new IMCallback<List<MessageExtensionResult>>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(List<MessageExtensionResult> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    private void getMessageExtensionsBySequence(Object param, final V2TIMValueCallback<Object> callback) {
        if (null == param || !(param instanceof String)) {
            this.callbackOnError(callback, 6017, "param is not string");
            return;
        }
        String json = (String)param;
        if (TextUtils.isEmpty((CharSequence)json)) {
            this.callbackOnError(callback, 6017, "param is empty");
            return;
        }
        String groupID = "";
        long messageSequence = 0L;
        ArrayList extensionList = new ArrayList();
        try {
            JSONObject jsonObject = new JSONObject(json);
            groupID = jsonObject.optString("groupID");
            messageSequence = jsonObject.optLong("messageSequence");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        V2TIMValueCallback<List<MessageExtension>> v2TIMValueCallback = new V2TIMValueCallback<List<MessageExtension>>(){

            @Override
            public void onSuccess(List<MessageExtension> extensions) {
                if (callback != null) {
                    ArrayList<V2TIMMessageExtension> v2TIMMessageExtensions = new ArrayList<V2TIMMessageExtension>();
                    for (MessageExtension extension : extensions) {
                        V2TIMMessageExtension v2TIMMessageExtension = new V2TIMMessageExtension();
                        v2TIMMessageExtension.setMessageExtension(extension);
                        v2TIMMessageExtensions.add(v2TIMMessageExtension);
                    }
                    callback.onSuccess(v2TIMMessageExtensions);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        Message message = new Message();
        message.setMessageStatus(2);
        message.setSupportMessageExtension(true);
        message.addElement(new TextElement());
        message.setMessageType(2);
        message.setGroupID(groupID);
        message.setSeq(messageSequence);
        MessageCenter.getInstance().getMessageExtensions(message, new IMCallback<List<MessageExtension>>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(List<MessageExtension> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    private void clearLocalHistoryMessage(Object param, V2TIMValueCallback<Object> callback) {
        if (null == param || !(param instanceof String)) {
            this.callbackOnError(callback, 6017, "param is not string");
            return;
        }
        String json = (String)param;
        if (TextUtils.isEmpty((CharSequence)json)) {
            this.callbackOnError(callback, 6017, "param is empty");
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(json);
            String conversationID = jsonObject.optString("conversationID");
            ConversationKey conversationKey = V2TIMConversationManagerImpl.getInstance().getConversationKey(conversationID);
            long beginTimestamp = jsonObject.optLong("beginTimestamp");
            long endTimestamp = jsonObject.optLong("endTimestamp");
            MessageCenter.getInstance().clearLocalHistoryMessage(conversationKey, beginTimestamp, endTimestamp, new IMCallback(callback){

                public void success(Object data) {
                    super.success(data);
                }

                @Override
                public void fail(int code, String errorMessage) {
                    super.fail(code, errorMessage);
                }
            });
        }
        catch (JSONException e) {
            this.callbackOnError(callback, 6017, "convert param to json failed");
            e.printStackTrace();
        }
    }

    private void sendTRTCCustomData(Object param, V2TIMValueCallback<Object> callback) {
        if (null == param || !(param instanceof byte[])) {
            this.callbackOnError(callback, 6017, "param is not byte array");
            return;
        }
        byte[] data = (byte[])param;
        BaseManager.getInstance().sendTRTCCustomData(data, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    private void getAIDenoiseSignature(V2TIMValueCallback<Object> callback) {
        BaseManager.getInstance().getAIDenoiseSignature(new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    private void getVideoEditSignature(V2TIMValueCallback<Object> callback) {
        BaseManager.getInstance().getVideoEditSignature(new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    private void writeLog(Object param, V2TIMValueCallback<Object> callback) {
        if (null == param || !(param instanceof String)) {
            this.callbackOnError(callback, 6017, "param is not string");
            return;
        }
        String json = (String)param;
        if (TextUtils.isEmpty((CharSequence)json)) {
            this.callbackOnError(callback, 6017, "param is empty");
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(json);
            int logLevel = jsonObject.optInt("logLevel");
            String logContent = jsonObject.optString("logContent");
            String fileName = jsonObject.optString("fileName");
            switch (logLevel) {
                case 2: {
                    IMLog.v(fileName, logContent);
                    break;
                }
                case 3: {
                    IMLog.d(fileName, logContent);
                    break;
                }
                case 4: {
                    IMLog.i(fileName, logContent);
                    break;
                }
                case 5: {
                    IMLog.w(fileName, logContent);
                    break;
                }
                case 6: {
                    IMLog.e(fileName, logContent);
                    break;
                }
                default: {
                    this.callbackOnError(callback, 6017, "invalid logLevel");
                    return;
                }
            }
            this.callbackOnSuccess(callback, null);
        }
        catch (JSONException e) {
            this.callbackOnError(callback, 6017, "convert param to json failed");
            e.printStackTrace();
        }
    }

    private void getMessageRevoker(Object param, final V2TIMValueCallback<Object> callback) {
        Object messageID;
        if (!(param instanceof List)) {
            this.callbackOnError(callback, 6017, "param is not list");
            return;
        }
        List messageIDList = (List)param;
        Iterator iterator = messageIDList.iterator();
        if (iterator.hasNext() && !((messageID = iterator.next()) instanceof String)) {
            this.callbackOnError(callback, 6017, "item is no String type");
            return;
        }
        V2TIMValueCallback<List<Message>> v2TIMValueCallback = new V2TIMValueCallback<List<Message>>(){

            @Override
            public void onSuccess(List<Message> messageList) {
                if (messageList.size() == 0) {
                    if (callback != null) {
                        callback.onError(6017, "local messages do not exist");
                    }
                } else if (callback != null) {
                    HashMap<String, String> revokerMap = new HashMap<String, String>();
                    for (Message message : messageList) {
                        revokerMap.put(message.getMsgID(), message.getRevokerInfo().getUserID());
                    }
                    callback.onSuccess(revokerMap);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        MessageCenter.getInstance().findMessageByMessageId(messageIDList, new IMCallback<List<Message>>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(List<Message> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    private void setOfflinePushState(Object param, V2TIMValueCallback<Object> callback) {
        if (null == param || !(param instanceof Integer)) {
            this.callbackOnError(callback, 6017, "param is not int");
            return;
        }
        OfflinePushConfig pushConfig = new OfflinePushConfig();
        pushConfig.setOpenOfflinePush((Integer)param);
        OfflinePushManager.getInstance().setOfflinePushConfig(pushConfig, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    private void getOfflinePushState(V2TIMValueCallback<Object> valueCallback) {
        OfflinePushManager.getInstance().getOfflinePushConfig(new IMCallback(valueCallback){

            public void success(Object data) {
                OfflinePushConfig pushConfig = (OfflinePushConfig)data;
                final int openPush = pushConfig.getOpenOfflinePush();
                IMContext.getInstance().runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        if (valueCallback != null) {
                            valueCallback.onSuccess(openPush);
                        }
                    }
                });
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    private void setBuildInfo(Object param, V2TIMValueCallback<Object> callback) {
        if (null == param || !(param instanceof String)) {
            this.callbackOnError(callback, 6017, "param is not string");
            return;
        }
        String json = (String)param;
        if (TextUtils.isEmpty((CharSequence)json)) {
            this.callbackOnError(callback, 6017, "param is empty");
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(json);
            String buildBrand = jsonObject.optString("buildBrand");
            String buildManufacturer = jsonObject.optString("buildManufacturer");
            String buildModel = jsonObject.optString("buildModel");
            String buildVersionRelease = jsonObject.optString("buildVersionRelease");
            int buildVersionSDKInt = jsonObject.optInt("buildVersionSDKInt");
            SystemUtil.setBuildBrand(buildBrand);
            SystemUtil.setBuildManufacturer(buildManufacturer);
            SystemUtil.setBuildModel(buildModel);
            SystemUtil.setBuildVersionRelease(buildVersionRelease);
            SystemUtil.setBuildVersionSDKInt(buildVersionSDKInt);
            this.callbackOnSuccess(callback, null);
        }
        catch (JSONException e) {
            this.callbackOnError(callback, 6017, "convert param to json failed");
            e.printStackTrace();
        }
    }

    private void setDatabaseEncryptInfo(Object param, V2TIMValueCallback<Object> callback) {
        if (null == param || !(param instanceof String)) {
            this.callbackOnError(callback, 6017, "param is not string");
            return;
        }
        String json = (String)param;
        if (TextUtils.isEmpty((CharSequence)json)) {
            this.callbackOnError(callback, 6017, "param is empty");
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(json);
            if (!jsonObject.has("encryptType")) {
                this.callbackOnError(callback, 6017, "encryptType must be set");
                return;
            }
            SDKConfig.DatabaseEncryptInfo databaseEncryptInfo = new SDKConfig.DatabaseEncryptInfo();
            databaseEncryptInfo.encryptType = jsonObject.optInt("encryptType");
            if (jsonObject.has("encryptKey")) {
                databaseEncryptInfo.encryptKey = jsonObject.optString("encryptKey");
            }
            BaseManager.getInstance().setDatabaseEncryptInfo(databaseEncryptInfo);
            this.callbackOnSuccess(callback, null);
        }
        catch (JSONException e) {
            this.callbackOnError(callback, 6017, "convert param to json failed");
            e.printStackTrace();
        }
    }

    private void isCommercialAbilityEnabled(Object param, V2TIMValueCallback<Object> callback) {
        if (null == param || !(param instanceof Long)) {
            this.callbackOnError(callback, 6017, "param is not int");
            return;
        }
        Long longParam = (Long)param;
        BaseManager.getInstance().isCommercialAbilityEnabled(longParam, new IMCallback<Object>(callback){

            @Override
            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    private void setPacketRetryInfo(Object param, V2TIMValueCallback<Object> callback) {
        if (null == param || !(param instanceof String)) {
            this.callbackOnError(callback, 6017, "param is not string");
            return;
        }
        String json = (String)param;
        if (TextUtils.isEmpty((CharSequence)json)) {
            this.callbackOnError(callback, 6017, "param is empty");
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(json);
            SDKConfig.PacketRetryInfo info = new SDKConfig.PacketRetryInfo();
            if (jsonObject.has("maxRetryCount")) {
                info.maxRetryCount = jsonObject.optInt("maxRetryCount");
            }
            if (jsonObject.has("packetRequestTimeout")) {
                info.packetRequestTimeout = jsonObject.optInt("packetRequestTimeout");
            }
            BaseManager.getInstance().setPacketRetryInfo(info);
            this.callbackOnSuccess(callback, null);
        }
        catch (JSONException e) {
            this.callbackOnError(callback, 6017, "convert param to json failed");
            e.printStackTrace();
        }
    }

    private void setCosSaveRegion(Object param, V2TIMValueCallback<Object> callback) {
        if (null == param || !(param instanceof String)) {
            this.callbackOnError(callback, 6017, "param is not string");
            return;
        }
        String json = (String)param;
        if (TextUtils.isEmpty((CharSequence)json)) {
            this.callbackOnError(callback, 6017, "param is empty");
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(json);
            String conversationID = jsonObject.optString("conversationID");
            String cosSaveRegion = jsonObject.optString("cosSaveRegion");
            if (TextUtils.isEmpty((CharSequence)conversationID) || TextUtils.isEmpty((CharSequence)cosSaveRegion)) {
                this.callbackOnError(callback, 6017, "invalid param");
                return;
            }
            ConversationKey conversationKey = V2TIMConversationManagerImpl.getInstance().getConversationKey(conversationID);
            ConversationManager.getInstance().setCosSaveRegionForConversation(conversationKey, cosSaveRegion, new IMCallback(callback){

                public void success(Object data) {
                    super.success(data);
                }

                @Override
                public void fail(int code, String errorMessage) {
                    super.fail(code, errorMessage);
                }
            });
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void callbackOnError(V2TIMValueCallback<Object> callback, int code, String desc) {
        if (callback != null) {
            callback.onError(code, desc);
        }
    }

    private void callbackOnSuccess(V2TIMValueCallback<Object> callback, Object result) {
        if (callback != null) {
            callback.onSuccess(result);
        }
    }

    private void setLibraryPath(Object param, V2TIMValueCallback<Object> callback) {
        if (!(param instanceof String)) {
            this.callbackOnError(callback, 6017, "param is not string");
            return;
        }
        String path = (String)param;
        boolean isSuccess = BaseManager.getInstance().setLibraryPath(path);
        if (isSuccess) {
            this.callbackOnSuccess(callback, null);
        } else {
            this.callbackOnError(callback, 6017, "system load so library failed");
        }
    }

    private void downloadLibrary(Object param, V2TIMValueCallback<Object> callback) {
        if (param == null || !(param instanceof Context)) {
            this.callbackOnError(callback, 6017, "param is not context");
        }
        BaseManager.getInstance().downloadLibrary((Context)param, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    private void initLocalStorage(Object param, V2TIMValueCallback<Object> callback) {
        if (!(param instanceof String)) {
            this.callbackOnError(callback, 6017, "param is not string");
            return;
        }
        String userID = (String)param;
        if (TextUtils.isEmpty((CharSequence)userID)) {
            this.callbackOnError(callback, 6017, "invalid userID");
            return;
        }
        BaseManager.getInstance().initLocalStorage(userID, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    private void setCustomServerInfo(Object param, V2TIMValueCallback<Object> callback) {
        if (null == param || !(param instanceof String)) {
            this.callbackOnError(callback, 6017, "param is not string");
            return;
        }
        String json = (String)param;
        if (TextUtils.isEmpty((CharSequence)json)) {
            this.callbackOnError(callback, 6017, "param is empty");
            return;
        }
        CustomServerInfo customServerInfo = new CustomServerInfo();
        try {
            JSONArray shortconnectionAddressList;
            JSONObject jsonObject = new JSONObject(json);
            JSONArray longconnectionAddressList = jsonObject.optJSONArray("longconnectionAddressList");
            if (longconnectionAddressList != null && longconnectionAddressList.length() > 0) {
                ArrayList<CustomServerInfo.ServerAddress> list = new ArrayList<CustomServerInfo.ServerAddress>();
                for (int i = 0; i < longconnectionAddressList.length(); ++i) {
                    JSONObject address = longconnectionAddressList.getJSONObject(i);
                    CustomServerInfo.ServerAddress serverAddress = new CustomServerInfo.ServerAddress();
                    serverAddress.ip = address.optString("ip");
                    serverAddress.port = address.optInt("port");
                    serverAddress.isIPv6 = address.has("isIPv6") ? address.optBoolean("isIPv6") : false;
                    serverAddress.isQuic = address.has("isQuic") ? address.optBoolean("isQuic") : false;
                    list.add(serverAddress);
                }
                customServerInfo.longconnectionAddressList = list;
            }
            if ((shortconnectionAddressList = jsonObject.optJSONArray("shortconnectionAddressList")) != null && shortconnectionAddressList.length() > 0) {
                ArrayList<CustomServerInfo.ServerAddress> list = new ArrayList<CustomServerInfo.ServerAddress>();
                for (int i = 0; i < shortconnectionAddressList.length(); ++i) {
                    JSONObject address = shortconnectionAddressList.getJSONObject(i);
                    CustomServerInfo.ServerAddress serverAddress = new CustomServerInfo.ServerAddress();
                    serverAddress.ip = address.optString("ip");
                    serverAddress.port = address.optInt("port");
                    serverAddress.isIPv6 = address.has("isIPv6") ? address.optBoolean("isIPv6") : false;
                    list.add(serverAddress);
                }
                customServerInfo.shortconnectionAddressList = list;
            }
            customServerInfo.serverPublicKey = jsonObject.optString("serverPublicKey");
            BaseManager.getInstance().setCustomServerInfo(customServerInfo);
            this.callbackOnSuccess(callback, null);
        }
        catch (JSONException e) {
            this.callbackOnError(callback, 6017, "convert param to json failed");
            e.printStackTrace();
        }
    }

    private void setQuicChannelEnabled(Object param, V2TIMValueCallback<Object> callback) {
        if (null == param || !(param instanceof String)) {
            this.callbackOnError(callback, 6017, "param is not string");
            return;
        }
        String json = (String)param;
        if (TextUtils.isEmpty((CharSequence)json)) {
            this.callbackOnError(callback, 6017, "param is empty");
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(json);
            boolean enableQuic = jsonObject.optBoolean("enableQuic");
            BaseManager.getInstance().setQuicEnabled(enableQuic);
            this.callbackOnSuccess(callback, null);
        }
        catch (JSONException e) {
            this.callbackOnError(callback, 6017, "convert param to json failed");
            e.printStackTrace();
        }
    }

    private void setProxyInfo(Object param, V2TIMValueCallback<Object> callback) {
        if (null == param || !(param instanceof String)) {
            this.callbackOnError(callback, 6017, "param is not string");
            return;
        }
        String json = (String)param;
        if (TextUtils.isEmpty((CharSequence)json)) {
            this.callbackOnError(callback, 6017, "param is empty");
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(json);
            if (!jsonObject.has("proxyType")) {
                this.callbackOnError(callback, 6017, "proxyType must be set");
                return;
            }
            if (jsonObject.has("proxyHost") && !jsonObject.has("proxyPort") || !jsonObject.has("proxyHost") && jsonObject.has("proxyPort")) {
                this.callbackOnError(callback, 6017, "proxyHost and proxyPort must be set together if need");
                return;
            }
            SDKConfig.ProxyInfo proxyInfo = new SDKConfig.ProxyInfo();
            proxyInfo.proxyType = jsonObject.optInt("proxyType");
            if (jsonObject.has("proxyHost") && jsonObject.has("proxyPort")) {
                proxyInfo.proxyHost = jsonObject.optString("proxyHost");
                proxyInfo.proxyPort = jsonObject.optInt("proxyPort");
            }
            if (jsonObject.has("proxyUsername")) {
                proxyInfo.proxyUsername = jsonObject.optString("proxyUsername");
            }
            if (jsonObject.has("proxyPassword")) {
                proxyInfo.proxyPassword = jsonObject.optString("proxyPassword");
            }
            BaseManager.getInstance().setProxyInfo(proxyInfo);
            this.callbackOnSuccess(callback, null);
        }
        catch (JSONException e) {
            this.callbackOnError(callback, 6017, "convert param to json failed");
            e.printStackTrace();
        }
    }

    private void setUIPlatform(Object param, V2TIMValueCallback<Object> callback) {
        if (null == param) {
            this.callbackOnError(callback, 6017, "param is null");
            return;
        }
        String stringUIPlatform = "";
        int numberUIPlatform = 0;
        if (param instanceof String) {
            stringUIPlatform = (String)param;
        } else if (param instanceof Integer) {
            numberUIPlatform = (Integer)param;
        } else {
            this.callbackOnError(callback, 6017, "param is invalid");
        }
        BaseManager.getInstance().setCustomUIPlatform(stringUIPlatform, numberUIPlatform);
        this.callbackOnSuccess(callback, null);
    }

    private void setTestEnvironment(Object param, V2TIMValueCallback<Object> callback) {
        if (param != null && param instanceof Boolean) {
            BaseManager.getInstance().setTestEnvironment((Boolean)param);
        }
        this.callbackOnSuccess(callback, null);
    }

    private void setIPv6Prior(Object param, V2TIMValueCallback<Object> callback) {
        if (param != null && param instanceof Boolean) {
            BaseManager.getInstance().setIPv6Prior((Boolean)param);
        }
        this.callbackOnSuccess(callback, null);
    }

    private void setApplicationID(Object param, V2TIMValueCallback<Object> callback) {
        if (param != null && param instanceof Integer) {
            BaseManager.getInstance().setApplicationID((Integer)param);
        }
        this.callbackOnSuccess(callback, null);
    }

    private void disableHttpRequest(Object param, V2TIMValueCallback<Object> callback) {
        if (param != null && param instanceof Boolean) {
            BaseManager.getInstance().disableHttpRequest((Boolean)param);
        }
        this.callbackOnSuccess(callback, null);
    }

    private void getLoginAccountType(Object param, V2TIMValueCallback<Object> callback) {
        BaseManager.getInstance().getLoginAccountType(new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    private void findMergerMessages(Object param, final V2TIMValueCallback<Object> callback) {
        if (null == param || !(param instanceof String)) {
            this.callbackOnError(callback, 6017, "param is not string");
            return;
        }
        String json = (String)param;
        if (TextUtils.isEmpty((CharSequence)json)) {
            this.callbackOnError(callback, 6017, "param is empty");
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(json);
            String messageID = jsonObject.optString("messageID");
            if (TextUtils.isEmpty((CharSequence)messageID)) {
                this.callbackOnError(callback, 6017, "messageID is empty");
                return;
            }
            JSONArray mergerMessageIDList = jsonObject.optJSONArray("mergerMessageIDList");
            ArrayList<String> mergerMessageIDItemList = new ArrayList<String>();
            if (mergerMessageIDList != null && mergerMessageIDList.length() > 0) {
                for (int i = 0; i < mergerMessageIDList.length(); ++i) {
                    String mergerMessageID = mergerMessageIDList.getString(i);
                    if (null == mergerMessageID || !(mergerMessageID instanceof String)) {
                        this.callbackOnError(callback, 6017, "mergerMessageID is empty");
                        return;
                    }
                    mergerMessageIDItemList.add(mergerMessageID);
                }
            }
            if (0 == mergerMessageIDItemList.size()) {
                this.callbackOnError(callback, 6017, "mergerMessageIDList is empty");
                return;
            }
            V2TIMValueCallback<List<Message>> v2TIMValueCallback = new V2TIMValueCallback<List<Message>>(){

                @Override
                public void onSuccess(List<Message> messageList) {
                    ArrayList<V2TIMMessage> v2TIMMessageList = new ArrayList<V2TIMMessage>();
                    for (Message message : messageList) {
                        V2TIMMessage v2TIMMessage = new V2TIMMessage();
                        v2TIMMessage.setMessage(message);
                        v2TIMMessageList.add(v2TIMMessage);
                    }
                    if (callback != null) {
                        callback.onSuccess(v2TIMMessageList);
                    }
                }

                @Override
                public void onError(int code, String desc) {
                    if (callback != null) {
                        callback.onError(code, desc);
                    }
                }
            };
            MessageCenter.getInstance().findRelayMessageList(messageID, mergerMessageIDItemList, new IMCallback<List<Message>>((V2TIMValueCallback)v2TIMValueCallback){

                @Override
                public void success(List<Message> data) {
                    super.success(data);
                }

                @Override
                public void fail(int code, String errorMessage) {
                    super.fail(code, errorMessage);
                }
            });
        }
        catch (JSONException e) {
            this.callbackOnError(callback, 6017, "convert param to json failed");
            e.printStackTrace();
        }
    }

    private void getBriefGroupMemberList(Object param, final V2TIMValueCallback<Object> callback) {
        if (null == param || !(param instanceof String)) {
            this.callbackOnError(callback, 6017, "param is not string");
            return;
        }
        String groupID = (String)param;
        V2TIMValueCallback<List<GroupMemberInfo>> v2Callback = new V2TIMValueCallback<List<GroupMemberInfo>>(){

            @Override
            public void onSuccess(List<GroupMemberInfo> memberInfoList) {
                if (callback != null) {
                    ArrayList<V2TIMGroupMemberFullInfo> resultList = new ArrayList<V2TIMGroupMemberFullInfo>();
                    for (GroupMemberInfo item : memberInfoList) {
                        V2TIMGroupMemberFullInfo member = new V2TIMGroupMemberFullInfo();
                        member.setGroupMemberInfo(item);
                        resultList.add(member);
                    }
                    callback.onSuccess(resultList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        BaseManager.getInstance().getBriefGroupMemberList(groupID, new IMCallback<List<GroupMemberInfo>>((V2TIMValueCallback)v2Callback){

            @Override
            public void success(List<GroupMemberInfo> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    private void reportOfflinePushEvent(Object param, V2TIMValueCallback<Object> callback) {
        if (null == param || !(param instanceof String)) {
            this.callbackOnError(callback, 6017, "param is not string");
            return;
        }
        String json = (String)param;
        if (TextUtils.isEmpty((CharSequence)json)) {
            this.callbackOnError(callback, 6017, "param is empty");
            return;
        }
        ArrayList<OfflinePushEventItem> reportEventItemList = new ArrayList<OfflinePushEventItem>();
        try {
            JSONObject jsonObject = new JSONObject(json);
            JSONArray reportEventList = jsonObject.optJSONArray("eventList");
            if (reportEventList != null && reportEventList.length() > 0) {
                for (int i = 0; i < reportEventList.length(); ++i) {
                    JSONObject eventItemJson = reportEventList.getJSONObject(i);
                    OfflinePushEventItem eventItem = new OfflinePushEventItem();
                    eventItem.setEventType(eventItemJson.optInt("type"));
                    eventItem.setEventTime(eventItemJson.getLong("time"));
                    eventItem.setPushId(eventItemJson.optString("pushId"));
                    reportEventItemList.add(eventItem);
                }
            }
            OfflinePushManager.getInstance().reportOfflinePushEvent(reportEventItemList, new IMCallback(callback){

                public void success(Object data) {
                    super.success(data);
                }

                @Override
                public void fail(int code, String errorMessage) {
                    super.fail(code, errorMessage);
                }
            });
        }
        catch (JSONException e) {
            this.callbackOnError(callback, 6017, "convert param to json failed");
            e.printStackTrace();
        }
    }

    private void setOfflinePushInfo(Object param, V2TIMValueCallback<Object> callback) {
        if (null == param || !(param instanceof String)) {
            this.callbackOnError(callback, 6017, "param is not string");
            return;
        }
        String json = (String)param;
        if (TextUtils.isEmpty((CharSequence)json)) {
            this.callbackOnError(callback, 6017, "param is empty");
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(json);
            int status = jsonObject.optInt("notification_bar_state");
            String version = jsonObject.optString("tim_push_plugin_version");
            if (status < 0 || status > 2) {
                status = 0;
            }
            OfflinePushManager.getInstance().setOfflinePushInfo(version, status);
            this.callbackOnSuccess(callback, null);
        }
        catch (JSONException e) {
            this.callbackOnError(callback, 6017, "convert param to json failed");
            e.printStackTrace();
        }
    }

    private void pushLogin(Object param, V2TIMValueCallback<Object> callback) {
        if (null == param || !(param instanceof String)) {
            this.callbackOnError(callback, 6017, "param is not string");
            return;
        }
        String json = (String)param;
        if (TextUtils.isEmpty((CharSequence)json)) {
            this.callbackOnError(callback, 6017, "param is empty");
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(json);
            String userID = jsonObject.optString("userID");
            String appKey = jsonObject.optString("appKey");
            BaseManager.getInstance().login(userID, appKey, new IMCallback(callback){

                public void success(Object data) {
                    super.success(data);
                }

                @Override
                public void fail(int code, String errorMessage) {
                    super.fail(code, errorMessage);
                }
            }, 2);
        }
        catch (JSONException e) {
            this.callbackOnError(callback, 6017, "convert param to json failed");
            e.printStackTrace();
        }
    }

    private void reportPushSDKEvent(Object param, V2TIMValueCallback<Object> callback) {
        if (null == param || !(param instanceof String)) {
            this.callbackOnError(callback, 6017, "param is not string");
            return;
        }
        String json = (String)param;
        if (TextUtils.isEmpty((CharSequence)json)) {
            this.callbackOnError(callback, 6017, "param is empty");
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(json);
            long eventID = jsonObject.optLong("event_id");
            long eventCode = jsonObject.optLong("event_code");
            long eventResult = jsonObject.optLong("event_result");
            String eventMessage = jsonObject.optString("event_message");
            String moreMessage = jsonObject.optString("more_message");
            String extensionMessage = jsonObject.optString("extension_message");
            BaseManager.getInstance().reportPushSDKEvent(eventID, eventCode, eventResult, eventMessage, moreMessage, extensionMessage, new IMCallback(callback){

                public void success(Object data) {
                    super.success(data);
                }

                @Override
                public void fail(int code, String errorMessage) {
                    super.fail(code, errorMessage);
                }
            });
        }
        catch (JSONException e) {
            this.callbackOnError(callback, 6017, "convert param to json failed");
            e.printStackTrace();
        }
    }

    private void setCustomLoginInfo(Object param, V2TIMValueCallback<Object> callback) {
        if (null == param || !(param instanceof String)) {
            this.callbackOnError(callback, 6017, "param is not string");
            return;
        }
        String json = (String)param;
        if (TextUtils.isEmpty((CharSequence)json)) {
            this.callbackOnError(callback, 6017, "param is empty");
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(json);
            if (!jsonObject.has("userID") || !jsonObject.has("customLoginInfo")) {
                this.callbackOnError(callback, 6017, "invalid param");
                return;
            }
            String userID = jsonObject.optString("userID");
            String customLoginInfo = jsonObject.optString("customLoginInfo");
            BaseManager.getInstance().setCustomLoginInfo(userID, customLoginInfo, new IMCallback(callback){

                public void success(Object data) {
                    super.success(data);
                }

                @Override
                public void fail(int code, String errorMessage) {
                    super.fail(code, errorMessage);
                }
            });
        }
        catch (JSONException e) {
            this.callbackOnError(callback, 6017, "convert param to json failed");
            e.printStackTrace();
        }
    }

    private void cancelSendingMessage(Object param, V2TIMValueCallback<Object> callback) {
        if (null == param || !(param instanceof String)) {
            this.callbackOnError(callback, 6017, "param is not string");
            return;
        }
        String messageID = (String)param;
        MessageCenter.getInstance().cancelSendingMessage(messageID, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    private void getMessageSource(Object param, V2TIMValueCallback<Object> callback) {
        if (null == param || !(param instanceof V2TIMMessage)) {
            this.callbackOnError(callback, 6017, "param is not int");
            return;
        }
        V2TIMMessage v2TIMMessage = (V2TIMMessage)param;
        Message message = v2TIMMessage.getMessage();
        int messageSource = 0;
        messageSource = message != null ? message.getMessageSource() : 0;
        this.callbackOnSuccess(callback, new Integer(messageSource));
    }

    private static class V2TIMManagerExperimentImplHolder {
        private static final V2TIMManagerExperimentImpl v2TIMManagerExperiment = new V2TIMManagerExperimentImpl();

        private V2TIMManagerExperimentImplHolder() {
        }
    }
}

