/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.common;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Process;
import android.os.SystemClock;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.tencent.imsdk.common.IMLog;
import com.tencent.imsdk.common.SystemUtil;
import java.lang.ref.WeakReference;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.List;

public class NetworkInfoCenter
extends BroadcastReceiver {
    private static final String TAG = NetworkInfoCenter.class.getSimpleName();
    private boolean isInit = false;
    private static final int NETWORK_UNKNOWN = 0;
    private static final int NETWORK_WIFI = 1;
    private static final int NETWORK_2G3G = 2;
    private static final int NETWORK_GPRS = 101;
    private static final int NETWORK_EDGE = 102;
    private static final int NETWORK_CDMA = 104;
    private static final int NETWORK_1xRTT = 107;
    private static final int NETWORK_IDEN = 111;
    private static final int NETWORK_CDMA1X = 98;
    private static final int NETWORK_WCDMA = 99;
    private static final int NETWORK_UMTS = 103;
    private static final int NETWORK_EVDO_0 = 105;
    private static final int NETWORK_EVDO_A = 106;
    private static final int NETWORK_HSDPA = 108;
    private static final int NETWORK_HSUPA = 109;
    private static final int NETWORK_HSPA = 110;
    private static final int NETWORK_EVDO_B = 112;
    private static final int NETWORK_EHRPD = 114;
    private static final int NETWORK_HSPAP = 115;
    private static final int NETWORK_LTE = 113;
    private static final int IP_TYPE_UNKNOWN = 0;
    private static final int IP_TYPE_IPV4_ONLY = 1;
    private static final int IP_TYPE_IPV6_ONLY = 2;
    private static final int IP_TYPE_IPV6_DUAL = 3;
    private Context mContext;
    private WeakReference<INetworkChangeListener> mListener;
    private ConnectivityManager mConnectivityManager;
    private WifiManager mWifiManager;
    private TelephonyManager mTelephonyManager;
    private boolean mNetworkConnected = false;
    private int mNetworkType = 0;
    private int mIPType = 0;
    private String mNetworkSSID = "";
    private String mServiceProvider = "";
    private long mInitializeCostTime = 0L;
    private boolean isRegisterReceiver = false;
    private boolean mCheckNetworkInterface = false;
    private long mWifiNetworkHandle = 0L;
    private long mXgNetworkHandle = 0L;

    public static NetworkInfoCenter getInstance() {
        return Holder.instance;
    }

    public void init(Context context, INetworkChangeListener listener) {
        if (this.isInit) {
            IMLog.w(TAG, "NetworkInfoCenter has init");
            return;
        }
        long begin = SystemClock.uptimeMillis();
        this.mContext = context.getApplicationContext();
        this.mListener = new WeakReference<INetworkChangeListener>(listener);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        intentFilter.addAction("android.net.wifi.STATE_CHANGE");
        intentFilter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
        intentFilter.addAction("android.intent.action.SCREEN_ON");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        if (this.mContext != null) {
            this.mContext.getApplicationContext().registerReceiver((BroadcastReceiver)this, intentFilter);
            this.isRegisterReceiver = true;
        }
        this.mCheckNetworkInterface = SystemUtil.isQuicPluginLibraryLoaded();
        this.mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (this.mConnectivityManager != null) {
            NetworkInfo activeNetworkInfo = null;
            try {
                activeNetworkInfo = this.mConnectivityManager.getActiveNetworkInfo();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.updateNetworkType(activeNetworkInfo);
        }
        this.updateNetworkSSID();
        this.updateProviderName();
        this.updateIPType();
        this.updateNetworkInterface();
        this.mInitializeCostTime = SystemClock.uptimeMillis() - begin;
        this.isInit = true;
    }

    public void uninit() {
        if (this.isRegisterReceiver && this.mContext != null) {
            this.mContext.getApplicationContext().unregisterReceiver((BroadcastReceiver)this);
            this.isRegisterReceiver = false;
        }
        this.isInit = false;
    }

    public void onReceive(Context context, Intent intent) {
        if (intent == null) {
            Log.e((String)TAG, (String)"receive broadcast intent == null");
            return;
        }
        String action = intent.getAction();
        if (action == null) {
            Log.e((String)TAG, (String)"receive broadcast intent.getAction == null");
            return;
        }
        if (action.equals("android.net.conn.CONNECTIVITY_CHANGE") || action.equals("android.net.wifi.STATE_CHANGE") || action.equals("android.net.wifi.WIFI_STATE_CHANGED")) {
            this.onNetworkChanged(context, intent);
        }
        if (action.equals("android.intent.action.SCREEN_ON") || action.equals("android.intent.action.SCREEN_OFF")) {
            this.onScreenStatusChange(context, intent);
        }
    }

    private void onNetworkChanged(Context context, Intent intent) {
        Log.i((String)TAG, (String)("network changed, action: " + intent.getAction()));
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
            if (this.mConnectivityManager == null) {
                this.mConnectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
            }
            if (this.mConnectivityManager == null) {
                Log.e((String)TAG, (String)"network changed, mConnectivityManager is null");
                return;
            }
            long begin = SystemClock.uptimeMillis();
            NetworkInfo activeNetworkInfo = null;
            try {
                activeNetworkInfo = this.mConnectivityManager.getActiveNetworkInfo();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (activeNetworkInfo != null) {
                this.mNetworkConnected = activeNetworkInfo.isConnected();
                this.updateNetworkType(activeNetworkInfo);
                this.updateNetworkSSID();
                this.updateProviderName();
                this.updateNetworkInterface();
                Log.i((String)TAG, (String)("mNetworkConnected: " + this.mNetworkConnected + ", current network: " + activeNetworkInfo));
            } else {
                this.mNetworkConnected = false;
                this.mNetworkType = 0;
                Log.e((String)TAG, (String)"no network connection found");
            }
            this.updateIPType();
            this.mInitializeCostTime = SystemClock.uptimeMillis() - begin;
            INetworkChangeListener listener = (INetworkChangeListener)this.mListener.get();
            if (listener != null) {
                listener.onNetworkChange(this.mNetworkConnected, this.getNetworkType(), this.getIPType(), this.getNetworkID(), this.getWifiNetworkHandle(), this.getXgNetworkHandle(), this.getInitializeCostTime());
            }
        }
    }

    private void updateNetworkType(NetworkInfo activeNetInfo) {
        int permissionResult;
        NetworkInfo.State state;
        if (activeNetInfo == null || !activeNetInfo.isAvailable()) {
            this.mNetworkType = 0;
            return;
        }
        if (this.mConnectivityManager == null) {
            this.mConnectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        }
        if (this.mConnectivityManager == null) {
            this.mNetworkType = 0;
            return;
        }
        NetworkInfo wifiInfo = this.mConnectivityManager.getNetworkInfo(1);
        if (wifiInfo != null && null != (state = wifiInfo.getState()) && (state == NetworkInfo.State.CONNECTED || state == NetworkInfo.State.CONNECTING)) {
            this.mNetworkType = 1;
            return;
        }
        if (SystemUtil.getSDKVersion() >= 30 && 0 != (permissionResult = this.mContext.checkPermission("android.permission.READ_PHONE_STATE", Process.myPid(), Process.myUid()))) {
            if (this.mNetworkConnected) {
                this.mNetworkType = 113;
            }
            return;
        }
        TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        if (telephonyManager == null) {
            this.mNetworkType = 0;
            return;
        }
        int networkType = 0;
        try {
            networkType = telephonyManager.getNetworkType();
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.w((String)TAG, (String)("getNetworkType:" + e.getLocalizedMessage()));
        }
        switch (networkType) {
            case 1: {
                this.mNetworkType = 101;
                break;
            }
            case 4: {
                this.mNetworkType = 104;
                break;
            }
            case 2: {
                this.mNetworkType = 102;
                break;
            }
            case 7: {
                this.mNetworkType = 107;
                break;
            }
            case 11: {
                this.mNetworkType = 111;
                break;
            }
            case 6: {
                this.mNetworkType = 106;
                break;
            }
            case 3: {
                this.mNetworkType = 103;
                break;
            }
            case 5: {
                this.mNetworkType = 105;
                break;
            }
            case 8: {
                this.mNetworkType = 108;
                break;
            }
            case 9: {
                this.mNetworkType = 109;
                break;
            }
            case 10: {
                this.mNetworkType = 110;
                break;
            }
            case 12: {
                this.mNetworkType = 112;
                break;
            }
            case 14: {
                this.mNetworkType = 114;
                break;
            }
            case 15: {
                this.mNetworkType = 115;
                break;
            }
            case 13: {
                this.mNetworkType = 113;
                break;
            }
            default: {
                this.mNetworkType = 0;
            }
        }
    }

    private void updateIPType() {
        if (SystemUtil.getSDKVersion() < 23) {
            return;
        }
        this.mIPType = 0;
        if (this.mConnectivityManager == null) {
            this.mConnectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        }
        if (this.mConnectivityManager == null) {
            Log.e((String)TAG, (String)"updateIPType, mConnectivityManager is null");
            return;
        }
        try {
            LinkProperties linkProperties = this.mConnectivityManager.getLinkProperties(this.mConnectivityManager.getActiveNetwork());
            if (linkProperties == null) {
                Log.i((String)TAG, (String)"updateIPType, no linkProperties");
                return;
            }
            List linkAddresses = linkProperties.getLinkAddresses();
            for (LinkAddress linkAddress : linkAddresses) {
                InetAddress address = linkAddress.getAddress();
                if (address instanceof Inet4Address && !address.isLinkLocalAddress()) {
                    this.mIPType |= 1;
                    continue;
                }
                if (!(address instanceof Inet6Address) || address.isLinkLocalAddress()) continue;
                this.mIPType |= 2;
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("updateIPType, e: " + e.getLocalizedMessage()));
            e.printStackTrace();
        }
        Log.i((String)TAG, (String)("updateIPType|type:" + this.mIPType));
    }

    private void updateNetworkSSID() {
    }

    private void updateProviderName() {
    }

    private void updateNetworkInterface() {
        Network[] allNetworks;
        if (!this.mCheckNetworkInterface) {
            return;
        }
        if (Build.VERSION.SDK_INT < 21) {
            Log.w((String)TAG, (String)"updateNetworkInterface, support from Android LOLLIPOP");
            return;
        }
        this.mWifiNetworkHandle = 0L;
        this.mXgNetworkHandle = 0L;
        if (this.mConnectivityManager == null) {
            this.mConnectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        }
        if (this.mConnectivityManager == null) {
            Log.e((String)TAG, (String)"updateNetworkInterface, mConnectivityManager is null");
            return;
        }
        for (Network network : allNetworks = this.mConnectivityManager.getAllNetworks()) {
            if (network == null) continue;
            NetworkCapabilities networkCapabilities = null;
            try {
                networkCapabilities = this.mConnectivityManager.getNetworkCapabilities(network);
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)("updateNetworkInterface, system exception:" + e.getLocalizedMessage()));
                e.printStackTrace();
            }
            if (networkCapabilities == null) continue;
            if (networkCapabilities.hasTransport(1) && networkCapabilities.hasCapability(12)) {
                this.mWifiNetworkHandle = NetworkInfoCenter.networkToNetId(network);
                continue;
            }
            if (!networkCapabilities.hasTransport(0) || !networkCapabilities.hasCapability(12)) continue;
            this.mXgNetworkHandle = NetworkInfoCenter.networkToNetId(network);
        }
        Log.i((String)TAG, (String)("updateNetworkInterface, wifiNetworkHandle = " + this.mWifiNetworkHandle + " xgNetworkHandle = " + this.mXgNetworkHandle));
    }

    private static long networkToNetId(Network network) {
        if (Build.VERSION.SDK_INT >= 23) {
            return network.getNetworkHandle();
        }
        return Integer.parseInt(network.toString());
    }

    private void onScreenStatusChange(Context context, Intent intent) {
        Log.i((String)TAG, (String)("screen status changed, action: " + intent.getAction()));
        INetworkChangeListener listener = (INetworkChangeListener)this.mListener.get();
        boolean isScreenOn = false;
        if ("android.intent.action.SCREEN_ON".equals(intent.getAction())) {
            isScreenOn = true;
        }
        if (this.isInit && listener != null) {
            listener.onScreenStatusChange(isScreenOn);
        }
    }

    public int getNetworkType() {
        return this.mNetworkType;
    }

    public String getNetworkSSID() {
        return this.mNetworkSSID;
    }

    private String getProviderName() {
        return this.mServiceProvider;
    }

    public int getIPType() {
        return this.mIPType;
    }

    public String getNetworkID() {
        int netType = this.getNetworkType();
        if (1 == netType) {
            return this.getNetworkSSID();
        }
        return this.getProviderName();
    }

    public long getWifiNetworkHandle() {
        return this.mWifiNetworkHandle;
    }

    public long getXgNetworkHandle() {
        return this.mXgNetworkHandle;
    }

    public long getInitializeCostTime() {
        return this.mInitializeCostTime;
    }

    public boolean isNetworkConnected() {
        if (this.mConnectivityManager == null) {
            if (this.mContext == null) {
                return false;
            }
            this.mConnectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        }
        if (this.mConnectivityManager == null) {
            Log.e((String)TAG, (String)"isNetworkConnected, mConnectivityManager is null");
            return false;
        }
        NetworkInfo activeNetworkInfo = null;
        try {
            activeNetworkInfo = this.mConnectivityManager.getActiveNetworkInfo();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (activeNetworkInfo != null) {
            return activeNetworkInfo.isConnected();
        }
        Log.e((String)TAG, (String)"isNetworkConnected, activeNetwork is null");
        return false;
    }

    private static class Holder {
        static NetworkInfoCenter instance = new NetworkInfoCenter();

        private Holder() {
        }
    }

    public static interface INetworkChangeListener {
        public void onNetworkChange(boolean var1, int var2, int var3, String var4, long var5, long var7, long var9);

        public void onScreenStatusChange(boolean var1);
    }
}

