/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.v2;

import com.tencent.imsdk.common.IMCallback;
import com.tencent.imsdk.community.TopicInfo;
import com.tencent.imsdk.conversation.ConversationAtInfo;
import com.tencent.imsdk.group.GroupManager;
import com.tencent.imsdk.group.GroupMemberInfo;
import com.tencent.imsdk.group.GroupMemberInfoModifyParam;
import com.tencent.imsdk.message.DraftMessage;
import com.tencent.imsdk.message.Message;
import com.tencent.imsdk.v2.V2TIMCallback;
import com.tencent.imsdk.v2.V2TIMCreateGroupMemberInfo;
import com.tencent.imsdk.v2.V2TIMGroupAtInfo;
import com.tencent.imsdk.v2.V2TIMManager;
import com.tencent.imsdk.v2.V2TIMMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class V2TIMTopicInfo
implements Serializable {
    public static final int V2TIM_TOPIC_ADD_FORBID = 0;
    public static final int V2TIM_TOPIC_ADD_AUTH = 1;
    public static final int V2TIM_TOPIC_ADD_ANY = 2;
    private TopicInfo topicInfo = new TopicInfo();
    private int modifyFlag = 0;

    protected void setTopicInfo(TopicInfo topicInfo) {
        if (topicInfo == null) {
            return;
        }
        this.topicInfo = topicInfo;
    }

    TopicInfo getTopicInfo() {
        return this.topicInfo;
    }

    int getModifyFlag() {
        return this.modifyFlag;
    }

    public String getTopicID() {
        return this.topicInfo.getTopicID();
    }

    public void setTopicID(String topicID) {
        this.topicInfo.setTopicID(topicID);
    }

    public String getTopicType() {
        return this.topicInfo.getTopicType();
    }

    public void setTopicType(String topicType) {
        this.topicInfo.setTopicType(topicType);
    }

    public String getTopicName() {
        return this.topicInfo.getTopicName();
    }

    public void setTopicName(String topicName) {
        this.topicInfo.setTopicName(topicName);
        this.modifyFlag = (int)((long)this.modifyFlag | TopicInfo.TOPIC_INFO_MODIFY_FLAG_NAME);
    }

    public String getTopicFaceUrl() {
        return this.topicInfo.getFaceUrl();
    }

    public void setTopicFaceUrl(String faceUrl) {
        this.topicInfo.setFaceUrl(faceUrl);
        this.modifyFlag = (int)((long)this.modifyFlag | TopicInfo.TOPIC_INFO_MODIFY_FLAG_FACE_URL);
    }

    public String getIntroduction() {
        return this.topicInfo.getIntroduction();
    }

    public void setIntroduction(String introduction) {
        this.topicInfo.setIntroduction(introduction);
        this.modifyFlag = (int)((long)this.modifyFlag | TopicInfo.TOPIC_INFO_MODIFY_FLAG_INTRODUCTION);
    }

    public String getNotification() {
        return this.topicInfo.getNotification();
    }

    public void setNotification(String notification) {
        this.topicInfo.setNotification(notification);
        this.modifyFlag = (int)((long)this.modifyFlag | TopicInfo.TOPIC_INFO_MODIFY_FLAG_NOTIFICATION);
    }

    public boolean isAllMute() {
        return this.topicInfo.isAllMute();
    }

    public void setAllMute(boolean allMute) {
        this.topicInfo.setAllMute(allMute);
        this.modifyFlag = (int)((long)this.modifyFlag | TopicInfo.TOPIC_INFO_MODIFY_FLAG_MUTE_ALL);
    }

    public long getSelfMuteTime() {
        return this.topicInfo.getSelfMuteTime();
    }

    public String getCustomString() {
        return this.topicInfo.getTopicCustomString();
    }

    public void setCustomString(String customString) {
        this.topicInfo.setTopicCustomString(customString);
        this.modifyFlag = (int)((long)this.modifyFlag | TopicInfo.TOPIC_INFO_MODIFY_FLAG_TOPIC_CUSTOM_STRING);
    }

    public int getRecvOpt() {
        int recvOpt = this.topicInfo.getMessageReceiveOption();
        if (recvOpt == GroupMemberInfo.MESSAGE_RECEIVE_OPTION_AUTO_RECEIVE) {
            return 0;
        }
        if (recvOpt == GroupMemberInfo.MESSAGE_RECEIVE_OPTION_NOT_RECEIVE) {
            return 1;
        }
        if (recvOpt == GroupMemberInfo.MESSAGE_RECEIVE_OPTION_RECEIVE_WITH_NO_OFFLINE_PUSH) {
            return 2;
        }
        if (recvOpt == GroupMemberInfo.MESSAGE_RECEIVE_OPTION_RECEIVE_WITH_NO_OFFLINE_PUSH_EXCEPT_AT) {
            return 3;
        }
        if (recvOpt == GroupMemberInfo.MESSAGE_RECEIVE_OPTION_NOT_RECEIVE_EXCEPT_AT) {
            return 4;
        }
        return 0;
    }

    public String getDraftText() {
        DraftMessage draftMessage = this.topicInfo.getDraftMessage();
        if (draftMessage == null) {
            return null;
        }
        byte[] draftData = draftMessage.getUserDefinedData();
        if (draftData != null) {
            return new String(draftData);
        }
        return null;
    }

    public void setDraft(String draftText) {
        DraftMessage draftMessage = new DraftMessage();
        if (draftText != null) {
            draftMessage.setUserDefinedData(draftText.getBytes());
        }
        this.topicInfo.setDraftMessage(draftMessage);
        this.modifyFlag = (int)((long)this.modifyFlag | TopicInfo.TOPIC_INFO_MODIFY_FLAG_DRAFT);
    }

    public long getUnreadCount() {
        return this.topicInfo.getUnreadCount();
    }

    public V2TIMMessage getLastMessage() {
        Message message = this.topicInfo.getLastMessage();
        if (message == null) {
            return null;
        }
        V2TIMMessage v2TIMMessage = new V2TIMMessage();
        v2TIMMessage.setMessage(message);
        return v2TIMMessage;
    }

    public long getReadSequence() {
        return this.topicInfo.getReadSequence();
    }

    public List<V2TIMGroupAtInfo> getGroupAtInfoList() {
        ArrayList<V2TIMGroupAtInfo> v2TIMGroupAtInfoList = new ArrayList<V2TIMGroupAtInfo>();
        List<ConversationAtInfo> conversationAtInfoList = this.topicInfo.getConversationAtInfoList();
        for (ConversationAtInfo conversationAtInfo : conversationAtInfoList) {
            V2TIMGroupAtInfo v2TIMGroupAtInfo = new V2TIMGroupAtInfo();
            v2TIMGroupAtInfo.setConversationGroupAtInfo(conversationAtInfo);
            v2TIMGroupAtInfoList.add(v2TIMGroupAtInfo);
        }
        return v2TIMGroupAtInfoList;
    }

    public long getCreateTime() {
        return this.topicInfo.getCreateTime();
    }

    public int getTopicAddOpt() {
        int addOption = this.topicInfo.getTopicAddOpt();
        if (addOption == TopicInfo.TOPIC_ADD_OPTION_ALLOW_ANY) {
            return 2;
        }
        if (addOption == TopicInfo.TOPIC_ADD_OPTION_FORBID_ANY) {
            return 0;
        }
        if (addOption == TopicInfo.TOPIC_ADD_OPTION_NEED_AUTHENTICATION) {
            return 1;
        }
        return 2;
    }

    public void setTopicAddOpt(int groupAddOpt) {
        if (2 == groupAddOpt) {
            this.topicInfo.setTopicAddOpt(TopicInfo.TOPIC_ADD_OPTION_ALLOW_ANY);
        } else if (0 == groupAddOpt) {
            this.topicInfo.setTopicAddOpt(TopicInfo.TOPIC_ADD_OPTION_FORBID_ANY);
        } else if (1 == groupAddOpt) {
            this.topicInfo.setTopicAddOpt(TopicInfo.TOPIC_ADD_OPTION_NEED_AUTHENTICATION);
        }
        this.modifyFlag = (int)((long)this.modifyFlag | TopicInfo.TOPIC_INFO_MODIFY_FLAG_TOPIC_ADD_OPT);
    }

    public int getTopicApproveOpt() {
        int approveOption = this.topicInfo.getTopicApproveOpt();
        if (approveOption == TopicInfo.TOPIC_ADD_OPTION_ALLOW_ANY) {
            return 2;
        }
        if (approveOption == TopicInfo.TOPIC_ADD_OPTION_FORBID_ANY) {
            return 0;
        }
        if (approveOption == TopicInfo.TOPIC_ADD_OPTION_NEED_AUTHENTICATION) {
            return 1;
        }
        return 2;
    }

    public void setTopicApproveOpt(int approveOpt) {
        if (2 == approveOpt) {
            this.topicInfo.setTopicApproveOpt(TopicInfo.TOPIC_ADD_OPTION_ALLOW_ANY);
        } else if (0 == approveOpt) {
            this.topicInfo.setTopicApproveOpt(TopicInfo.TOPIC_ADD_OPTION_FORBID_ANY);
        } else if (1 == approveOpt) {
            this.topicInfo.setTopicApproveOpt(TopicInfo.TOPIC_ADD_OPTION_NEED_AUTHENTICATION);
        }
        this.modifyFlag = (int)((long)this.modifyFlag | TopicInfo.TOPIC_INFO_MODIFY_FLAG_TOPIC_APPROVE_OPT);
    }

    public void setMemberList(List<V2TIMCreateGroupMemberInfo> memberList) {
        ArrayList<GroupMemberInfo> groupMembers = new ArrayList<GroupMemberInfo>();
        if (memberList != null) {
            for (V2TIMCreateGroupMemberInfo item : memberList) {
                GroupMemberInfo member = new GroupMemberInfo();
                member.setUserID(item.getUserID());
                member.setRole(item.getRole());
                groupMembers.add(member);
            }
        }
        this.topicInfo.setMemberList(groupMembers);
    }

    public long getMemberMaxCount() {
        return this.topicInfo.getMemberMaxCount();
    }

    public void setMemberMaxCount(long memberMaxCount) {
        this.topicInfo.setMemberMaxCount(memberMaxCount);
    }

    public Long getDefaultPermissions() {
        return this.topicInfo.getDefaultPermissions();
    }

    public void setDefaultPermissions(long defaultPermissions) {
        this.topicInfo.setDefaultPermissions(defaultPermissions);
        this.modifyFlag = (int)((long)this.modifyFlag | TopicInfo.TOPIC_INFO_MODIFY_FLAG_DEFAULT_PERMISSIONS);
    }

    public boolean isInheritMessageReceiveOptionFromCommunity() {
        return this.topicInfo.isInheritMessageReceiveOptionFromCommunity();
    }

    public void setInheritMessageReceiveOptionFromCommunity(final boolean inheritMessageReceiveOptionFromCommunity, V2TIMCallback v2TIMCallback) {
        GroupMemberInfo memberInfo = new GroupMemberInfo();
        memberInfo.setGroupID(this.getTopicID());
        memberInfo.setUserID(V2TIMManager.getInstance().getLoginUser());
        memberInfo.setInheritMessageReceiveOptionFromCommunity(inheritMessageReceiveOptionFromCommunity);
        GroupMemberInfoModifyParam param = new GroupMemberInfoModifyParam();
        param.setModifyFlag(GroupMemberInfo.GROUP_MEMBER_INFO_MODIFY_FLAG_INHERIT_MESSAGE_RECEIVE_OPTION_FROM_COMMUNITY);
        param.setMemberInfo(memberInfo);
        GroupManager.getInstance().setGroupMemberInfo(param, new IMCallback(v2TIMCallback){

            public void success(Object data) {
                V2TIMTopicInfo.this.topicInfo.setInheritMessageReceiveOptionFromCommunity(inheritMessageReceiveOptionFromCommunity);
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }
}

