/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.common;

import com.tencent.imsdk.common.IMContext;
import com.tencent.imsdk.v2.V2TIMCallback;
import com.tencent.imsdk.v2.V2TIMCompleteCallback;
import com.tencent.imsdk.v2.V2TIMValueCallback;

public abstract class IMCallback<T> {
    protected V2TIMCallback callback;
    protected V2TIMValueCallback<T> valueCallback;
    protected V2TIMCompleteCallback<T> completeCallback;

    protected IMCallback(V2TIMCallback cb) {
        this.callback = cb;
    }

    protected IMCallback(V2TIMValueCallback<T> cb) {
        this.valueCallback = cb;
    }

    protected IMCallback(V2TIMCompleteCallback<T> cb) {
        this.completeCallback = cb;
    }

    public void success(final T data) {
        IMContext.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                if (IMCallback.this.callback != null) {
                    IMCallback.this.callback.onSuccess();
                } else if (IMCallback.this.valueCallback != null) {
                    IMCallback.this.valueCallback.onSuccess(data);
                } else if (IMCallback.this.completeCallback != null) {
                    IMCallback.this.completeCallback.onComplete(0, "", data);
                }
            }
        });
    }

    public void fail(final int code, final String errorMessage) {
        IMContext.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                if (IMCallback.this.callback != null) {
                    IMCallback.this.callback.onError(code, errorMessage);
                } else if (IMCallback.this.valueCallback != null) {
                    IMCallback.this.valueCallback.onError(code, errorMessage);
                }
            }
        });
    }

    public void fail(final int code, final String errorMessage, final T data) {
        IMContext.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                if (IMCallback.this.callback != null) {
                    IMCallback.this.callback.onError(code, errorMessage);
                } else if (IMCallback.this.valueCallback != null) {
                    IMCallback.this.valueCallback.onError(code, errorMessage);
                } else if (IMCallback.this.completeCallback != null) {
                    IMCallback.this.completeCallback.onComplete(code, errorMessage, data);
                }
            }
        });
    }
}

