/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rmonitor.sla;

import com.tencent.bugly.proguard.ph;
import com.tencent.rmonitor.base.reporter.DiscardReason;
import com.tencent.rmonitor.base.reporter.ReporterMachine;
import com.tencent.rmonitor.common.logger.Logger;
import com.tencent.rmonitor.sla.AttaDBManager;
import com.tencent.rmonitor.sla.AttaEvent;
import com.tencent.rmonitor.sla.AttaEventHelper;
import com.tencent.rmonitor.sla.AttaEventReporter;
import com.tencent.rmonitor.sla.StatisticsEvent;
import com.tencent.rmonitor.sla.StatisticsReporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 !2\u00020\u0001:\u0001!B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u001e\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016J \u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J.\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cJ0\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\b\u0010 \u001a\u00020\u000bH\u0002R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/tencent/rmonitor/sla/StatisticsReporter;", "", "()V", "eventMap", "Ljava/util/HashMap;", "", "Lcom/tencent/rmonitor/sla/StatisticsEvent;", "Lkotlin/collections/HashMap;", "uploadRunnable", "Ljava/lang/Runnable;", "deleteDataInDB", "", "list", "", "Lcom/tencent/rmonitor/sla/AttaEvent;", "fillAttaEvent", "statisticsEvent", "getEvent", "baseType", "subType", "recordDiscard", "discardReason", "Lcom/tencent/rmonitor/base/reporter/DiscardReason;", "recordDiscardInternal", "recordUpload", "success", "", "contentLength", "", "cost", "recordUploadInternal", "saveDataToDB", "upload", "Companion", "bugly-pro_release"})
public final class StatisticsReporter {
    private final HashMap<String, StatisticsEvent> eventMap;
    private final Runnable uploadRunnable;
    private static final String TAG = "RMonitor_sla_StatisticsReporter";
    private static final long UPLOAD_INTERVAL = 600000L;
    @NotNull
    private static final Lazy instance$delegate;
    public static final Companion Companion;

    public final void recordUpload(@NotNull String string, @NotNull String string2, boolean bl2, int n2, int n3) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"baseType");
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"subType");
        if (!ph.iJ().bp("RMRecordReport")) {
            if (Logger.verbos) {
                Logger.INSTANCE.v(TAG, "recordUpload, [" + string + ", " + string2 + "] miss hit");
            }
            return;
        }
        if (Logger.verbos) {
            Logger.INSTANCE.v(TAG, "recordUpload [" + string + ", " + string2 + "], success:" + bl2 + ", length:" + n2 + ", cost:" + n3);
        }
        ReporterMachine.INSTANCE.post(new Runnable(this, string, string2, bl2, n2, n3){
            final /* synthetic */ StatisticsReporter this$0;
            final /* synthetic */ String $baseType;
            final /* synthetic */ String $subType;
            final /* synthetic */ boolean $success;
            final /* synthetic */ int $contentLength;
            final /* synthetic */ int $cost;

            public final void run() {
                StatisticsReporter.access$recordUploadInternal(this.this$0, this.$baseType, this.$subType, this.$success, this.$contentLength, this.$cost);
            }
            {
                this.this$0 = statisticsReporter;
                this.$baseType = string;
                this.$subType = string2;
                this.$success = bl2;
                this.$contentLength = n2;
                this.$cost = n3;
            }
        });
    }

    private final void recordUploadInternal(String object, String string, boolean bl2, int n2, int n3) {
        object = this.getEvent((String)object, string);
        if (bl2) {
            Object object2 = object;
            ((StatisticsEvent)object2).setSuccCount(((StatisticsEvent)object2).getSuccCount() + 1);
            Object object3 = object;
            ((StatisticsEvent)object3).setSuccContentLengthSum(((StatisticsEvent)object3).getSuccContentLengthSum() + n2);
            Object object4 = object;
            ((StatisticsEvent)object4).setSuccCostSum(((StatisticsEvent)object4).getSuccCostSum() + n3);
        } else {
            Object object5 = object;
            ((StatisticsEvent)object5).setFailCount(((StatisticsEvent)object5).getFailCount() + 1);
            Object object6 = object;
            ((StatisticsEvent)object6).setFailContentLengthSum(((StatisticsEvent)object6).getFailContentLengthSum() + n2);
            Object object7 = object;
            ((StatisticsEvent)object7).setFailCostSum(((StatisticsEvent)object7).getFailCostSum() + n3);
        }
        this.saveDataToDB((StatisticsEvent)object);
    }

    public final void recordDiscard(@NotNull String string, @NotNull String string2, @NotNull DiscardReason discardReason) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"baseType");
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"subType");
        Intrinsics.checkParameterIsNotNull((Object)((Object)discardReason), (String)"discardReason");
        if (!ph.iJ().bp("RMRecordReport")) {
            if (Logger.verbos) {
                Logger.INSTANCE.v(TAG, "recordDiscard, [" + string + ", " + string2 + "] miss hit");
            }
            return;
        }
        if (Logger.verbos) {
            Logger.INSTANCE.v(TAG, "recordDiscard baseType:" + string + ", subType:" + string2);
        }
        ReporterMachine.INSTANCE.post(new Runnable(this, string, string2, discardReason){
            final /* synthetic */ StatisticsReporter this$0;
            final /* synthetic */ String $baseType;
            final /* synthetic */ String $subType;
            final /* synthetic */ DiscardReason $discardReason;

            public final void run() {
                StatisticsReporter.access$recordDiscardInternal(this.this$0, this.$baseType, this.$subType, this.$discardReason);
            }
            {
                this.this$0 = statisticsReporter;
                this.$baseType = string;
                this.$subType = string2;
                this.$discardReason = discardReason;
            }
        });
    }

    private final void recordDiscardInternal(String object, String string, DiscardReason discardReason) {
        object = this.getEvent((String)object, string);
        if (discardReason == DiscardReason.CACHE_EXPIRE) {
            Object object2 = object;
            ((StatisticsEvent)object2).setExpiredCount(((StatisticsEvent)object2).getExpiredCount() + 1);
        } else if (discardReason == DiscardReason.RETRY_EXCEEDED) {
            Object object3 = object;
            ((StatisticsEvent)object3).setDiscardCount(((StatisticsEvent)object3).getDiscardCount() + 1);
        }
        this.saveDataToDB((StatisticsEvent)object);
    }

    private final void upload() {
        if (Logger.verbos) {
            Logger.INSTANCE.v(TAG, "upload statistics data");
        }
        if (this.eventMap.isEmpty()) {
            Logger.INSTANCE.d(TAG, "statistics data is empty , wait next upload");
        } else {
            ArrayList<AttaEvent> arrayList = new ArrayList<AttaEvent>();
            Collection<StatisticsEvent> collection = this.eventMap.values();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"eventMap.values");
            for (StatisticsEvent statisticsEvent : (Iterable)collection) {
                arrayList.add(statisticsEvent.getAttaEvent());
            }
            if (AttaEventReporter.Companion.getInstance().batchReportSync((List<AttaEvent>)arrayList, false)) {
                this.eventMap.clear();
                this.deleteDataInDB((List<AttaEvent>)arrayList);
            }
        }
        ReporterMachine.INSTANCE.postDelayed(this.uploadRunnable, 600000L);
    }

    private final StatisticsEvent getEvent(String string, String string2) {
        String string3 = string + '-' + string2;
        StatisticsEvent statisticsEvent = this.eventMap.get(string3);
        if (statisticsEvent == null) {
            statisticsEvent = new StatisticsEvent(string, string2);
        }
        ((Map)this.eventMap).put(string3, statisticsEvent);
        return statisticsEvent;
    }

    private final void deleteDataInDB(List<AttaEvent> list) {
        AttaDBManager.INSTANCE.batchDeleteData(list);
    }

    private final void saveDataToDB(StatisticsEvent statisticsEvent) {
        if (Logger.verbos) {
            Logger.INSTANCE.v(TAG, "saveDataToDB baseType:" + statisticsEvent.getBaseType() + " subType:" + statisticsEvent.getSubType());
        }
        this.fillAttaEvent(statisticsEvent);
        AttaDBManager.INSTANCE.saveData(statisticsEvent.getAttaEvent());
    }

    private final void fillAttaEvent(StatisticsEvent statisticsEvent) {
        AttaEvent attaEvent = statisticsEvent.getAttaEvent();
        AttaEventHelper.INSTANCE.fillBaseInfo(attaEvent);
        attaEvent.setParam0(statisticsEvent.getBaseType());
        attaEvent.setParam1(statisticsEvent.getSubType());
        attaEvent.setParam2(String.valueOf(statisticsEvent.getDiscardCount()));
        attaEvent.setParam3(String.valueOf(statisticsEvent.getFailCount()));
        attaEvent.setParam4(String.valueOf(statisticsEvent.getSuccCount()));
        attaEvent.setParam5(String.valueOf(statisticsEvent.getExpiredCount()));
        attaEvent.setParam10(String.valueOf(statisticsEvent.getSuccContentLengthSum()));
        attaEvent.setParam11(String.valueOf(statisticsEvent.getFailContentLengthSum()));
        attaEvent.setParam12(String.valueOf(statisticsEvent.getSuccCostSum()));
        attaEvent.setParam13(String.valueOf(statisticsEvent.getFailCostSum()));
    }

    private StatisticsReporter() {
        StatisticsReporter statisticsReporter = this;
        HashMap hashMap = new HashMap();
        statisticsReporter.eventMap = hashMap;
        this.uploadRunnable = new Runnable(this){
            final /* synthetic */ StatisticsReporter this$0;

            public final void run() {
                StatisticsReporter.access$upload(this.this$0);
            }
            {
                this.this$0 = statisticsReporter;
            }
        };
        ReporterMachine.INSTANCE.postDelayed(this.uploadRunnable, 600000L);
    }

    static {
        Companion = new Companion(null);
        instance$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)Companion.instance.2.INSTANCE);
    }

    public static final /* synthetic */ void access$recordUploadInternal(StatisticsReporter statisticsReporter, String string, String string2, boolean bl2, int n2, int n3) {
        statisticsReporter.recordUploadInternal(string, string2, bl2, n2, n3);
    }

    public static final /* synthetic */ void access$recordDiscardInternal(StatisticsReporter statisticsReporter, String string, String string2, DiscardReason discardReason) {
        statisticsReporter.recordDiscardInternal(string, string2, discardReason);
    }

    public static final /* synthetic */ void access$upload(StatisticsReporter statisticsReporter) {
        statisticsReporter.upload();
    }

    public /* synthetic */ StatisticsReporter(DefaultConstructorMarker defaultConstructorMarker) {
        this();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/tencent/rmonitor/sla/StatisticsReporter$Companion;", "", "()V", "TAG", "", "UPLOAD_INTERVAL", "", "instance", "Lcom/tencent/rmonitor/sla/StatisticsReporter;", "getInstance", "()Lcom/tencent/rmonitor/sla/StatisticsReporter;", "instance$delegate", "Lkotlin/Lazy;", "bugly-pro_release"})
    public static final class Companion {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "instance", "getInstance()Lcom/tencent/rmonitor/sla/StatisticsReporter;"))};
        }

        @NotNull
        public final StatisticsReporter getInstance() {
            Lazy lazy = instance$delegate;
            return (StatisticsReporter)lazy.getValue();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

