/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rmonitor.sla;

import com.tencent.rmonitor.base.db.table.AttaEventTable;
import com.tencent.rmonitor.common.logger.Logger;
import com.tencent.rmonitor.sla.AttaEvent;
import com.tencent.rmonitor.sla.AttaEventReporter;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\fJ\u0006\u0010\u0011\u001a\u00020\u000eJ\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/tencent/rmonitor/sla/AttaDBManager;", "", "()V", "LIMIT", "", "TAG", "isLocalDataReported", "Ljava/util/concurrent/atomic/AtomicBoolean;", "batchDeleteData", "", "list", "", "Lcom/tencent/rmonitor/sla/AttaEvent;", "batchSaveData", "", "deleteData", "attaEvent", "reportLocalData", "saveData", "bugly-pro_release"})
public final class AttaDBManager {
    private static final String TAG = "RMonitor_sla_AttaDBManager";
    private static final String LIMIT = "30";
    private static AtomicBoolean isLocalDataReported;
    public static final AttaDBManager INSTANCE;

    public final void saveData(@NotNull AttaEvent attaEvent) {
        Intrinsics.checkParameterIsNotNull((Object)attaEvent, (String)"attaEvent");
        Logger.INSTANCE.d(TAG, "saveData eventCode:" + attaEvent.getEventCode());
        if (!isLocalDataReported.get()) {
            this.reportLocalData();
        }
        AttaEventTable.Companion.getInstance().replace(attaEvent);
    }

    public final void batchSaveData(@NotNull List<AttaEvent> object) {
        Intrinsics.checkParameterIsNotNull(object, (String)"list");
        Logger.INSTANCE.d(TAG, "batchSaveData size:" + object.size());
        if (!isLocalDataReported.get()) {
            this.reportLocalData();
        }
        for (AttaEvent attaEvent : (Iterable)object) {
            AttaEventTable.Companion.getInstance().replace(attaEvent);
        }
    }

    public final int deleteData(@NotNull AttaEvent attaEvent) {
        Intrinsics.checkParameterIsNotNull((Object)attaEvent, (String)"attaEvent");
        Logger.INSTANCE.d(TAG, "deleteData , eventCode:" + attaEvent.getEventCode());
        return AttaEventTable.Companion.getInstance().delete(attaEvent);
    }

    public final int batchDeleteData(@NotNull List<AttaEvent> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        int n2 = AttaEventTable.Companion.getInstance().batchDelete(list);
        Logger.INSTANCE.d(TAG, "deleteDataInDB count:".concat(String.valueOf(n2)));
        return n2;
    }

    public final void reportLocalData() {
        if (!isLocalDataReported.compareAndSet(false, true)) {
            Logger.INSTANCE.d(TAG, "already report local data");
            return;
        }
        List list = AttaEventTable.query$default(AttaEventTable.Companion.getInstance(), null, null, null, false, null, null, null, LIMIT, 127, null);
        Logger.INSTANCE.d(TAG, "reportLocalData , size:" + list.size());
        if (list.isEmpty()) {
            return;
        }
        if (AttaEventReporter.Companion.getInstance().batchReportSync(list, false)) {
            this.batchDeleteData(list);
        }
    }

    private AttaDBManager() {
    }

    static {
        INSTANCE = new AttaDBManager();
        isLocalDataReported = new AtomicBoolean(false);
    }
}

