/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rmonitor.manager;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import com.tencent.bugly.common.network.NetworkWatcher;
import com.tencent.bugly.common.utils.AndroidVersion;
import com.tencent.bugly.proguard.cn;
import com.tencent.bugly.proguard.he;
import com.tencent.bugly.proguard.ml;
import com.tencent.bugly.proguard.my;
import com.tencent.bugly.proguard.mz;
import com.tencent.bugly.proguard.na;
import com.tencent.bugly.proguard.pj;
import com.tencent.rmonitor.base.config.ConfigProxy;
import com.tencent.rmonitor.base.config.DefaultPluginConfig;
import com.tencent.rmonitor.base.config.PluginCombination;
import com.tencent.rmonitor.base.db.DBHandler;
import com.tencent.rmonitor.base.meta.BaseInfo;
import com.tencent.rmonitor.base.plugin.monitor.QAPMMonitorPlugin;
import com.tencent.rmonitor.base.reporter.ReporterMachine;
import com.tencent.rmonitor.common.lifecycle.LifecycleCallback;
import com.tencent.rmonitor.common.logger.Logger;
import com.tencent.rmonitor.manager.EnvironmentChecker;
import com.tencent.rmonitor.manager.RMonitorLauncher;
import com.tencent.rmonitor.manager.RMonitorPluginManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u000eH\u0002J\u0016\u0010\u0010\u001a\u00020\n2\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0012J\u0016\u0010\u0013\u001a\u00020\n2\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0012J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\nJ\b\u0010\u0018\u001a\u00020\u000eH\u0002J\b\u0010\u0019\u001a\u00020\u000eH\u0002J\b\u0010\u001a\u001a\u00020\u000eH\u0002J\u0016\u0010\u001b\u001a\u00020\u000e2\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0012J\u001e\u0010\u001b\u001a\u00020\u000e2\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00122\u0006\u0010\u001c\u001a\u00020\u0004J\u0006\u0010\u001d\u001a\u00020\u000eJ\u000e\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\bJ\u000e\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020%J\u0016\u0010&\u001a\u00020\u000e2\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0012J\u0006\u0010'\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/tencent/rmonitor/manager/RMonitorLauncher;", "", "()V", "TAG", "", "configLoadListener", "Lcom/tencent/rmonitor/base/config/IConfigLoadListener;", "environmentChecker", "Lcom/tencent/rmonitor/manager/EnvironmentChecker;", "hasPreLaunched", "", "pluginManager", "Lcom/tencent/rmonitor/manager/IPluginManager;", "abolish", "", "addPluginNameForUserInfoReport", "checkAllDesiredPluginStarted", "monitorList", "", "checkSomeDesiredPluginStarted", "getPlugin", "Lcom/tencent/rmonitor/base/plugin/monitor/QAPMMonitorPlugin;", "pluginName", "needRegister", "initConfigListener", "initCrashInfo", "initLifecycleCallback", "launch", "from", "preLaunch", "setEnvironmentChecker", "checker", "setPluginFactory", "pluginFactory", "Lcom/tencent/rmonitor/manager/PluginFactory;", "setQAPMPluginManager", "manager", "Lcom/tencent/rmonitor/manager/RMonitorPluginManager;", "stop", "stopDisabledPlugins", "bugly-pro_release"})
public final class RMonitorLauncher {
    @NotNull
    public static final String TAG = "RMonitor_plugins";
    private static EnvironmentChecker environmentChecker;
    private static my pluginManager;
    private static volatile boolean hasPreLaunched;
    private static he configLoadListener;
    public static final RMonitorLauncher INSTANCE;

    public final void setEnvironmentChecker(@NotNull EnvironmentChecker environmentChecker) {
        Intrinsics.checkParameterIsNotNull((Object)environmentChecker, (String)"checker");
        RMonitorLauncher.environmentChecker = environmentChecker;
    }

    public final void setQAPMPluginManager(@NotNull RMonitorPluginManager rMonitorPluginManager) {
        Intrinsics.checkParameterIsNotNull((Object)rMonitorPluginManager, (String)"manager");
        pluginManager = rMonitorPluginManager;
    }

    private final void initCrashInfo() {
        Application application = BaseInfo.app;
        if (application != null) {
            SharedPreferences sharedPreferences = application.getSharedPreferences("BuglySdkInfos", 0);
            Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences, (String)"application.getSharedPre\u2026s\", Context.MODE_PRIVATE)");
            application = sharedPreferences.edit();
            application.putString("730dcb1b75", BaseInfo.userMeta.sdkVersion);
            application.commit();
        }
    }

    private final void addPluginNameForUserInfoReport() {
        Object object = CollectionsKt.listOf((Object[])new String[]{"looper_stack", "battery_ele_metric", "battery_element", "battery_metric", "page_launch", "asan", "fd_leak", "java_memory_ceiling_hprof", "activity_leak", "native_memory"});
        cn cn2 = cn.aT();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            cn2.C((String)object);
        }
    }

    public final synchronized void preLaunch() {
        if (hasPreLaunched) {
            return;
        }
        Logger.INSTANCE.i(TAG, "preLaunch");
        pj.iM().iQ();
        this.initLifecycleCallback();
        BaseInfo.Info.initUrl();
        BaseInfo.Info.initInfo();
        this.initCrashInfo();
        ml.hl().hm();
        this.initConfigListener();
        mz.p((Context)BaseInfo.app, BaseInfo.userMeta.appId);
        this.addPluginNameForUserInfoReport();
        hasPreLaunched = true;
        pj.iM().iR();
    }

    private final void initLifecycleCallback() {
        Application application;
        if (AndroidVersion.Companion.isOverIceScreamSandwich() && (application = BaseInfo.app) != null) {
            LifecycleCallback.init(application);
        }
    }

    public final void setPluginFactory(@NotNull na na2) {
        Intrinsics.checkParameterIsNotNull((Object)na2, (String)"pluginFactory");
        pluginManager.setPluginFactory(na2);
    }

    public final void launch(@Nullable List<String> list) {
        this.launch(list, "Magnifier");
    }

    public final void launch(@Nullable List<String> object, @NotNull String object22) {
        Intrinsics.checkParameterIsNotNull((Object)object22, (String)"from");
        Logger.INSTANCE.i(TAG, "launch: " + object + ", from: " + (String)object22);
        if (object == null || object.isEmpty()) {
            Logger.INSTANCE.e(TAG, "none plugin to launch.");
            return;
        }
        if (BaseInfo.app == null) {
            Logger.INSTANCE.w(TAG, "launch fail for app is null.");
            return;
        }
        if (!environmentChecker.checkSysPermission()) {
            Logger.INSTANCE.e(TAG, "launch fail, please check environment.");
            return;
        }
        NetworkWatcher.INSTANCE.init();
        object22 = environmentChecker.checkConfigs((List<String>)object);
        if (object22 != null && !((Collection)object22).isEmpty()) {
            for (Object object22 : (Iterable)object22) {
                pluginManager.start((String)object22);
            }
        } else {
            this.stop((List<String>)object);
        }
        ReporterMachine.INSTANCE.start();
    }

    public final void stop(@Nullable List<String> object) {
        if (object == null || object.isEmpty()) {
            Logger.INSTANCE.e(TAG, "none plugin to stop.");
            return;
        }
        for (String string : (Iterable)object) {
            pluginManager.stop(string);
        }
    }

    public final void abolish() {
        Logger.INSTANCE.i(TAG, "abolish");
        Object object = BaseInfo.dbHelper;
        if (object != null && (object = object.getDbHandler()) != null) {
            ((DBHandler)object).close();
        }
        pluginManager.stopAll();
        NetworkWatcher.INSTANCE.unInit();
    }

    public final void stopDisabledPlugins() {
        List list = new ArrayList();
        for (Object object : (Iterable)PluginCombination.Companion.getAllPlugin()) {
            if (((DefaultPluginConfig)object).config.enabled) continue;
            list.add(((DefaultPluginConfig)object).pluginName);
        }
        Logger.INSTANCE.i(TAG, "stop disabled plugins {" + list + '}');
        for (Object object : (Iterable)list) {
            pluginManager.stop((String)object);
        }
    }

    @Nullable
    public final QAPMMonitorPlugin getPlugin(@NotNull String string, boolean bl2) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"pluginName");
        return pluginManager.getPlugin(bl2, string);
    }

    public final boolean checkAllDesiredPluginStarted(@Nullable List<String> object) {
        if (object == null || object.isEmpty()) {
            return true;
        }
        boolean bl2 = true;
        for (String string : (Iterable)object) {
            if (pluginManager.isPluginStart(string)) continue;
            bl2 = false;
        }
        return bl2;
    }

    public final boolean checkSomeDesiredPluginStarted(@Nullable List<String> object) {
        if (object == null || object.isEmpty()) {
            return true;
        }
        boolean bl2 = false;
        for (String string : (Iterable)object) {
            if (!pluginManager.isPluginStart(string)) continue;
            bl2 = true;
        }
        return bl2;
    }

    private final void initConfigListener() {
        if (configLoadListener == null) {
            configLoadListener = initConfigListener.1.INSTANCE;
            ConfigProxy.INSTANCE.getConfig().a(configLoadListener);
        }
    }

    private RMonitorLauncher() {
    }

    static {
        INSTANCE = new RMonitorLauncher();
        environmentChecker = new EnvironmentChecker();
        pluginManager = new RMonitorPluginManager();
    }
}

