/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rmonitor.looper.provider;

import com.tencent.rmonitor.common.logger.Logger;
import com.tencent.rmonitor.looper.MonitorInfo;
import com.tencent.rmonitor.looper.meta.StackFrame;
import com.tencent.rmonitor.looper.meta.StackQueue;
import com.tencent.rmonitor.looper.provider.MultiStackProvider;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0016\u0018\u0000 $2\u00020\u0001:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J%\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019H\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0018\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J#\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016\u00a2\u0006\u0002\u0010 J\u0006\u0010!\u001a\u00020\u000bJ\u0010\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/tencent/rmonitor/looper/provider/StackQueueProvider;", "Lcom/tencent/rmonitor/looper/provider/MultiStackProvider;", "()V", "realRecycleStackQueueCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "stackQueueMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/tencent/rmonitor/looper/meta/StackQueue;", "tryRecycleStackQueueCount", "beginTrace", "", "monitorInfo", "Lcom/tencent/rmonitor/looper/MonitorInfo;", "checkStackTraceNormal", "dealStackFrameQueue", "Lorg/json/JSONObject;", "stackFrameQueue", "", "Lcom/tencent/rmonitor/looper/meta/StackFrame;", "dealStackTrace", "", "buffer", "Ljava/lang/StringBuffer;", "stackTrace", "", "Ljava/lang/StackTraceElement;", "(Ljava/lang/StringBuffer;[Ljava/lang/StackTraceElement;)Ljava/lang/String;", "endTrace", "isOverThreshold", "", "onTrace", "(Lcom/tencent/rmonitor/looper/MonitorInfo;[Ljava/lang/StackTraceElement;)V", "recycleRemainStackQueue", "recycleStackQueue", "stackQueue", "Companion", "bugly-pro_release"})
public class StackQueueProvider
extends MultiStackProvider {
    private final ConcurrentHashMap<Long, StackQueue> stackQueueMap = new ConcurrentHashMap();
    private final AtomicInteger tryRecycleStackQueueCount = new AtomicInteger();
    private final AtomicInteger realRecycleStackQueueCount = new AtomicInteger();
    @NotNull
    public static final String TAG = "RMonitor_looper_StackProvider";
    public static final int MAX_COUNT_OF_NOT_RECYCLE_STACK_QUEUE = 100;
    public static final int MAX_COUNT_OF_STACK_QUEUE_MAP = 20;
    public static final Companion Companion = new Companion(0);

    @Override
    public void beginTrace(@NotNull MonitorInfo monitorInfo) {
        Intrinsics.checkParameterIsNotNull((Object)monitorInfo, (String)"monitorInfo");
    }

    @Override
    public void onTrace(@NotNull MonitorInfo monitorInfo, @NotNull StackTraceElement[] stackTraceElementArray) {
        Intrinsics.checkParameterIsNotNull((Object)monitorInfo, (String)"monitorInfo");
        Intrinsics.checkParameterIsNotNull((Object)stackTraceElementArray, (String)"stackTrace");
        StackQueue stackQueue = this.stackQueueMap.get(monitorInfo.getLastStackRequestTime());
        if (stackQueue == null && this.isCurrentMsg(monitorInfo)) {
            stackQueue = StackQueue.Companion.hz();
            if (stackQueue != null) {
                StackQueue stackQueue2 = stackQueue;
                ((Map)this.stackQueueMap).put(monitorInfo.getLastStackRequestTime(), stackQueue2);
            }
        } else if (stackQueue == null) {
            Logger.INSTANCE.d(TAG, "deal msg not latest msg on trace, deal: " + monitorInfo.getLastStackRequestTime());
        }
        StackQueue stackQueue3 = stackQueue;
        if (stackQueue3 != null) {
            stackQueue3.addStackTrace(stackTraceElementArray);
            return;
        }
    }

    @Override
    public void endTrace(@NotNull MonitorInfo monitorInfo, boolean bl2) {
        Intrinsics.checkParameterIsNotNull((Object)monitorInfo, (String)"monitorInfo");
        boolean bl3 = monitorInfo.isDetectedLongLag();
        StackQueue stackQueue = bl3 ? this.stackQueueMap.get(monitorInfo.getLastStackRequestTime()) : this.stackQueueMap.remove(monitorInfo.getLastStackRequestTime());
        if (stackQueue == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)stackQueue, (String)"(if (isDetectedLongLag) \u2026ime)\n        }) ?: return");
        StackQueue stackQueue2 = stackQueue;
        if (bl2) {
            stackQueue2.dealStackTrace((Function1<? super List<StackFrame>, Unit>)((Function1)new Function1<List<StackFrame>, Unit>(this, monitorInfo){
                final /* synthetic */ StackQueueProvider this$0;
                final /* synthetic */ MonitorInfo $monitorInfo;

                public final void invoke(@NotNull List<StackFrame> list) {
                    Intrinsics.checkParameterIsNotNull(list, (String)"it");
                    try {
                        this.$monitorInfo.setFullStack(StackQueueProvider.access$dealStackFrameQueue(this.this$0, list));
                        return;
                    }
                    catch (Throwable throwable) {
                        this.$monitorInfo.setFullStack(null);
                        return;
                    }
                }
                {
                    this.this$0 = stackQueueProvider;
                    this.$monitorInfo = monitorInfo;
                    super(1);
                }
            }));
        }
        if (!bl3 && (monitorInfo = this.getStackThreadHandler()) != null) {
            this.tryRecycleStackQueueCount.incrementAndGet();
            monitorInfo.post(new Runnable(this, stackQueue2){
                final /* synthetic */ StackQueueProvider this$0;
                final /* synthetic */ StackQueue $stackQueue;

                public final void run() {
                    StackQueueProvider.access$recycleStackQueue(this.this$0, this.$stackQueue);
                }
                {
                    this.this$0 = stackQueueProvider;
                    this.$stackQueue = stackQueue;
                }
            });
        }
        this.checkStackTraceNormal();
    }

    private final void recycleStackQueue(StackQueue stackQueue) {
        StackQueue.Companion.a(stackQueue);
        this.realRecycleStackQueueCount.incrementAndGet();
        this.recycleRemainStackQueue();
        this.checkStackTraceNormal();
    }

    public final void recycleRemainStackQueue() {
        if (this.stackQueueMap.size() > 20) {
            Enumeration<Long> enumeration = this.stackQueueMap.keys();
            Intrinsics.checkExpressionValueIsNotNull(enumeration, (String)"stackQueueMap.keys()");
            Iterator iterator = CollectionsKt.iterator(enumeration);
            while (iterator.hasNext()) {
                Object object = (Long)iterator.next();
                if (object == null || (object = this.stackQueueMap.remove(object)) == null) continue;
                this.tryRecycleStackQueueCount.incrementAndGet();
                StackQueue.Companion.a((StackQueue)object);
                this.realRecycleStackQueueCount.incrementAndGet();
            }
        }
    }

    @Override
    public void checkStackTraceNormal() {
        int n2 = this.stackQueueMap.size();
        int n3 = this.tryRecycleStackQueueCount.get() - this.realRecycleStackQueueCount.get();
        if (n2 > 20 || n3 > 100) {
            this.markStackTrace(false);
            return;
        }
        if (n2 < 10 && n3 < 50) {
            this.markStackTrace(true);
        }
    }

    private final JSONObject dealStackFrameQueue(List<StackFrame> list) {
        JSONArray jSONArray = new JSONArray();
        StringBuffer stringBuffer = new StringBuffer(2048);
        int n2 = ((Collection)list).size();
        for (int i2 = 0; i2 < n2; ++i2) {
            StackFrame stackFrame = list.get(i2);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("type", (Object)"normal");
            jSONObject.put("thread_name", (Object)this.getLooperThreadName());
            jSONObject.put("thread_id", (Object)this.getLooperThreadId());
            jSONObject.put("index", stackFrame.getFrameIndex());
            jSONObject.put("repeat_count", stackFrame.getFrameCount());
            jSONObject.put("timestamp", stackFrame.getStartTime());
            jSONObject.put("end_time", stackFrame.getEndTime());
            jSONObject.put("call_stack", (Object)this.dealStackTrace(stringBuffer, stackFrame.getStack()));
            jSONArray.put((Object)jSONObject);
        }
        JSONObject jSONObject = null;
        if (jSONArray.length() > 0) {
            jSONObject = new JSONObject();
            jSONObject.put("stacks", (Object)jSONArray);
        }
        return jSONObject;
    }

    private final String dealStackTrace(StringBuffer stringBuffer, StackTraceElement[] stackTraceElementArray) {
        stringBuffer.delete(0, stringBuffer.length());
        if (stackTraceElementArray != null) {
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                stringBuffer.append(stackTraceElement.toString()).append("\n");
            }
        }
        String string = stringBuffer.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"buffer.toString()");
        return string;
    }

    public static final /* synthetic */ JSONObject access$dealStackFrameQueue(StackQueueProvider stackQueueProvider, List list) {
        return stackQueueProvider.dealStackFrameQueue(list);
    }

    public static final /* synthetic */ void access$recycleStackQueue(StackQueueProvider stackQueueProvider, StackQueue stackQueue) {
        stackQueueProvider.recycleStackQueue(stackQueue);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/tencent/rmonitor/looper/provider/StackQueueProvider$Companion;", "", "()V", "MAX_COUNT_OF_NOT_RECYCLE_STACK_QUEUE", "", "MAX_COUNT_OF_STACK_QUEUE_MAP", "TAG", "", "bugly-pro_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(byte by2) {
            this();
        }
    }
}

