/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rmonitor.looper.meta;

import android.os.Looper;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.tencent.bugly.common.utils.RecyclablePool;
import com.tencent.bugly.proguard.mx;

@Keep
class PoolProvider {
    private final Class<? extends RecyclablePool.Recyclable> clz;
    private final int capacity;
    private volatile RecyclablePool mainThreadPool = null;
    private volatile RecyclablePool otherThreadPool = null;

    public PoolProvider(Class<? extends RecyclablePool.Recyclable> clazz, int n2) {
        this.clz = clazz;
        this.capacity = n2;
    }

    @NonNull
    public RecyclablePool getPool() {
        if (this.isMonitoredThreadMainThread()) {
            return this.getMainThreadPool();
        }
        return this.getOtherThreadPool();
    }

    private boolean isMonitoredThreadMainThread() {
        Thread thread = Looper.getMainLooper().getThread();
        Thread thread2 = Thread.currentThread();
        if (thread2 == thread) {
            return true;
        }
        return mx.e(thread).getThread() == thread2;
    }

    private RecyclablePool getMainThreadPool() {
        if (this.mainThreadPool == null) {
            this.mainThreadPool = new RecyclablePool(this.clz, this.capacity);
        }
        return this.mainThreadPool;
    }

    private RecyclablePool getOtherThreadPool() {
        if (this.otherThreadPool == null) {
            this.otherThreadPool = new RecyclablePool(this.clz, this.capacity);
        }
        return this.otherThreadPool;
    }
}

