/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rmonitor.fd.utils;

import com.tencent.bugly.proguard.me;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import shark.FilteringLeakingObjectFinder;
import shark.HeapAnalysis;
import shark.HeapAnalysisFailure;
import shark.HeapAnalysisSuccess;
import shark.HeapAnalyzer;
import shark.HeapGraph;
import shark.HeapObject;
import shark.Leak;
import shark.LeakTrace;
import shark.LeakingObjectFinder;
import shark.ObjectInspector;
import shark.ObjectReporter;
import shark.OnAnalysisProgressListener;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001c\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/tencent/rmonitor/fd/utils/SharkAnalysisUtil;", "Lshark/OnAnalysisProgressListener;", "()V", "CLASS_FINALIZER_REFERENCE", "", "OBJECT_ID_PREFIX", "TAG", "findPathsFromGcRoots", "", "", "graph", "Lshark/HeapGraph;", "objectIds", "", "getGcPathFeature", "trace", "Lshark/LeakTrace;", "getObjectIdFromLeakTrace", "onAnalysisProgress", "", "step", "Lshark/OnAnalysisProgressListener$Step;", "processAnalysisResult", "heapAnalysis", "Lshark/HeapAnalysis;", "bugly-pro_release"})
public final class SharkAnalysisUtil
implements OnAnalysisProgressListener {
    private static final String TAG = "SharkAnalysisUtil";
    private static final String OBJECT_ID_PREFIX = "ObjectId=";
    private static final String CLASS_FINALIZER_REFERENCE = "java.lang.ref.FinalizerReference";
    public static final SharkAnalysisUtil INSTANCE = new SharkAnalysisUtil();

    @JvmStatic
    @NotNull
    public static final Map<Long, String> findPathsFromGcRoots(@NotNull HeapGraph heapGraph, @NotNull Set<Long> object) {
        Intrinsics.checkParameterIsNotNull((Object)heapGraph, (String)"graph");
        Intrinsics.checkParameterIsNotNull(object, (String)"objectIds");
        object = new FilteringLeakingObjectFinder.LeakingObjectFilter((Set)object){
            final /* synthetic */ Set $objectIds;

            public final boolean isLeakingObject(@NotNull HeapObject heapObject) {
                Intrinsics.checkParameterIsNotNull((Object)heapObject, (String)"heapObject");
                return this.$objectIds.contains(heapObject.getObjectId());
            }
            {
                this.$objectIds = set;
            }
        };
        object = new FilteringLeakingObjectFinder(CollectionsKt.listOf((Object)object));
        ObjectInspector objectInspector = new ObjectInspector(){

            public final void inspect(@NotNull ObjectReporter object) {
                Intrinsics.checkParameterIsNotNull((Object)object, (String)"reporter");
                Collection collection = object.getLabels();
                object = "ObjectId=" + object.getHeapObject().getObjectId();
                collection.add(object);
            }
        };
        heapGraph = HeapAnalyzer.analyze$default((HeapAnalyzer)new HeapAnalyzer((OnAnalysisProgressListener)INSTANCE), (File)new File(""), (HeapGraph)heapGraph, (LeakingObjectFinder)((LeakingObjectFinder)object), null, (boolean)false, (List)CollectionsKt.listOf((Object)objectInspector), null, (int)88, null);
        return INSTANCE.processAnalysisResult((HeapAnalysis)heapGraph);
    }

    private final Map<Long, String> processAnalysisResult(HeapAnalysis heapAnalysis) {
        HashMap hashMap = new HashMap();
        Object object = heapAnalysis;
        if (object instanceof HeapAnalysisSuccess) {
            object = CollectionsKt.plus((Collection)((HeapAnalysisSuccess)heapAnalysis).getApplicationLeaks(), (Iterable)((HeapAnalysisSuccess)heapAnalysis).getLibraryLeaks()).iterator();
            while (object.hasNext()) {
                long l2;
                if ((LeakTrace)CollectionsKt.firstOrNull((List)((Leak)object.next()).getLeakTraces()) == null || (l2 = this.getObjectIdFromLeakTrace((LeakTrace)heapAnalysis)) == 0L) continue;
                ((Map)hashMap).put(l2, this.getGcPathFeature((LeakTrace)heapAnalysis));
            }
        } else if (object instanceof HeapAnalysisFailure) {
            me.e(TAG, "findPathsFromGcRoots failed: ".concat(String.valueOf(heapAnalysis)));
        }
        return hashMap;
    }

    private final String getGcPathFeature(LeakTrace leakTrace) {
        StringBuilder stringBuilder = new StringBuilder(leakTrace.getLeakingObject().getClassName() + " -> \n");
        boolean bl2 = false;
        for (Object object : (Iterable)CollectionsKt.reversed((Iterable)leakTrace.getReferencePath())) {
            String string = object.getOriginObject().getClassName();
            boolean bl3 = Intrinsics.areEqual((Object)string, (Object)CLASS_FINALIZER_REFERENCE);
            object = string + " -> " + object.getReferenceName() + '\n';
            if (bl3 && !bl2) {
                bl2 = true;
                stringBuilder.append((String)object);
                continue;
            }
            if (bl3) continue;
            stringBuilder.append((String)object);
        }
        stringBuilder.append("GcRoot: " + leakTrace.getGcRootType());
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    private final long getObjectIdFromLeakTrace(LeakTrace object) {
        Object object2;
        Object v0;
        block2: {
            for (Object e2 : (Iterable)object.getLeakingObject().getLabels()) {
                if (!StringsKt.startsWith$default((String)((String)e2), (String)OBJECT_ID_PREFIX, (boolean)false, (int)2, null)) continue;
                v0 = e2;
                break block2;
            }
            v0 = null;
        }
        if ((object2 = (String)v0) != null && (object2 = StringsKt.substringAfter$default((String)object2, (String)OBJECT_ID_PREFIX, null, (int)2, null)) != null && (object2 = StringsKt.toLongOrNull((String)object2)) != null) {
            return (Long)object2;
        }
        return 0L;
    }

    public final void onAnalysisProgress(@NotNull OnAnalysisProgressListener.Step step) {
        Intrinsics.checkParameterIsNotNull((Object)step, (String)"step");
    }

    private SharkAnalysisUtil() {
    }
}

