/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rmonitor.common.util;

import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import com.tencent.bugly.common.utils.ProcessUtil;
import com.tencent.bugly.proguard.bm;
import com.tencent.bugly.proguard.ck;
import com.tencent.rmonitor.common.logger.Logger;
import com.tencent.rmonitor.common.util.AppInfo;
import com.tencent.rmonitor.common.util.FileUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Serializable;
import java.nio.MappedByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 \u00032\u00020\u0001:\u0003\u0003\u0004\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lcom/tencent/rmonitor/common/util/FileUtil;", "", "()V", "Companion", "IStreamListener", "MmapFile", "bugly-pro_release"})
public final class FileUtil {
    private static final String TAG = "RMonitor_common_FileUtil";
    private static String RMONITOR_ROOT;
    private static String SDPath;
    @Nullable
    private static Application app;
    public static final Companion Companion;

    static {
        Companion = new Companion(0);
        RMONITOR_ROOT = "";
    }

    @JvmStatic
    public static final boolean createFile(@Nullable String string, @Nullable String string2) {
        String string3 = string;
        string = string2;
        string2 = string3;
        if (string3 == null || string == null) {
            return false;
        }
        return com.tencent.rmonitor.common.util.FileUtil$Companion.createFile(new File(string2, string).getAbsolutePath());
    }

    @JvmStatic
    public static final boolean createFile(@Nullable String string) {
        return com.tencent.rmonitor.common.util.FileUtil$Companion.createFile(string);
    }

    @JvmStatic
    public static final boolean writeFile(@Nullable String string, @Nullable String string2, boolean bl2) {
        return com.tencent.rmonitor.common.util.FileUtil$Companion.writeFile(string, string2, bl2);
    }

    @JvmStatic
    public static final synchronized boolean writeFile(@Nullable String string, @Nullable byte[] byArray, boolean bl2) {
        return Companion.writeFile(string, byArray, bl2);
    }

    @JvmStatic
    @Nullable
    public static final synchronized BufferedOutputStream getFileBufferStream(@Nullable String string, boolean bl2) {
        return Companion.getFileBufferStream(string, bl2);
    }

    @JvmStatic
    public static final void deleteFile(@Nullable File file) {
        com.tencent.rmonitor.common.util.FileUtil$Companion.deleteFile(file);
    }

    @JvmStatic
    @Nullable
    public static final ArrayList<File> getFiles(@Nullable String string, @Nullable String string2) {
        return com.tencent.rmonitor.common.util.FileUtil$Companion.getFiles(string, string2);
    }

    @JvmStatic
    @NotNull
    public static final String getRootPath() {
        return com.tencent.rmonitor.common.util.FileUtil$Companion.getRootPath();
    }

    @JvmStatic
    @NotNull
    public static final String getTempPath() {
        return com.tencent.rmonitor.common.util.FileUtil$Companion.getTempPath();
    }

    @JvmStatic
    @NotNull
    public static final String makeTempFileName(@NotNull String string, @NotNull String string2) {
        return com.tencent.rmonitor.common.util.FileUtil$Companion.makeTempFileName(string, string2);
    }

    @JvmStatic
    @NotNull
    public static final String readStream(@NotNull InputStream inputStream, int n2) {
        return com.tencent.rmonitor.common.util.FileUtil$Companion.readStream(inputStream, n2);
    }

    @JvmStatic
    @NotNull
    public static final String readStream(@NotNull InputStreamReader inputStreamReader, int n2) {
        return com.tencent.rmonitor.common.util.FileUtil$Companion.readStream(inputStreamReader, n2);
    }

    @JvmStatic
    public static final void readStreamByLine(@Nullable File file, @Nullable IStreamListener iStreamListener) {
        com.tencent.rmonitor.common.util.FileUtil$Companion.readStreamByLine(file, iStreamListener);
    }

    @JvmStatic
    public static final void readStreamByLine(@Nullable InputStream inputStream, @Nullable IStreamListener iStreamListener) {
        com.tencent.rmonitor.common.util.FileUtil$Companion.readStreamByLine(inputStream, iStreamListener);
    }

    @JvmStatic
    @NotNull
    public static final String readOutputFromFile(@Nullable String string) {
        return com.tencent.rmonitor.common.util.FileUtil$Companion.readOutputFromFile(string);
    }

    @JvmStatic
    @Nullable
    public static final File copyFile(@NotNull File file, @NotNull File file2) {
        return com.tencent.rmonitor.common.util.FileUtil$Companion.copyFile(file, file2);
    }

    @JvmStatic
    public static final boolean zipFiles(@Nullable List<String> list, @NotNull String string, boolean bl2) {
        return com.tencent.rmonitor.common.util.FileUtil$Companion.zipFiles(list, string, bl2);
    }

    @JvmStatic
    @Nullable
    public static final List<String> getFilesInDir(@NotNull String string) {
        return com.tencent.rmonitor.common.util.FileUtil$Companion.getFilesInDir(string);
    }

    @JvmStatic
    public static final boolean zipFiles(@NotNull String string, @NotNull String string2, boolean bl2) {
        boolean bl3 = bl2;
        String string3 = string2;
        string2 = string;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"dir");
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"outputPath");
        return com.tencent.rmonitor.common.util.FileUtil$Companion.zipFiles(com.tencent.rmonitor.common.util.FileUtil$Companion.getFilesInDir(string2), string3, bl3);
    }

    @JvmStatic
    public static final boolean loadLibrary(@NotNull String string) {
        return com.tencent.rmonitor.common.util.FileUtil$Companion.loadLibrary(string);
    }

    @JvmStatic
    public static final long getLastModifiedTime(@Nullable File file) {
        return com.tencent.rmonitor.common.util.FileUtil$Companion.getLastModifiedTime(file);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u001a\u0010\t\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/tencent/rmonitor/common/util/FileUtil$MmapFile;", "", "mmapFilePath", "", "randomAccessFile", "Ljava/io/RandomAccessFile;", "byteBuffer", "Ljava/nio/MappedByteBuffer;", "(Ljava/lang/String;Ljava/io/RandomAccessFile;Ljava/nio/MappedByteBuffer;)V", "buffer", "getBuffer", "()Ljava/nio/MappedByteBuffer;", "setBuffer", "(Ljava/nio/MappedByteBuffer;)V", "file", "getFile", "()Ljava/io/RandomAccessFile;", "setFile", "(Ljava/io/RandomAccessFile;)V", "filePath", "getFilePath", "()Ljava/lang/String;", "setFilePath", "(Ljava/lang/String;)V", "bugly-pro_release"})
    public static final class MmapFile {
        @NotNull
        private String filePath;
        @NotNull
        private RandomAccessFile file;
        @NotNull
        private MappedByteBuffer buffer;

        @NotNull
        public final String getFilePath() {
            return this.filePath;
        }

        public final void setFilePath(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.filePath = string;
        }

        @NotNull
        public final RandomAccessFile getFile() {
            return this.file;
        }

        public final void setFile(@NotNull RandomAccessFile randomAccessFile) {
            Intrinsics.checkParameterIsNotNull((Object)randomAccessFile, (String)"<set-?>");
            this.file = randomAccessFile;
        }

        @NotNull
        public final MappedByteBuffer getBuffer() {
            return this.buffer;
        }

        public final void setBuffer(@NotNull MappedByteBuffer mappedByteBuffer) {
            Intrinsics.checkParameterIsNotNull((Object)mappedByteBuffer, (String)"<set-?>");
            this.buffer = mappedByteBuffer;
        }

        public MmapFile(@NotNull String string, @NotNull RandomAccessFile randomAccessFile, @NotNull MappedByteBuffer mappedByteBuffer) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"mmapFilePath");
            Intrinsics.checkParameterIsNotNull((Object)randomAccessFile, (String)"randomAccessFile");
            Intrinsics.checkParameterIsNotNull((Object)mappedByteBuffer, (String)"byteBuffer");
            this.filePath = string;
            this.file = randomAccessFile;
            this.buffer = mappedByteBuffer;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/tencent/rmonitor/common/util/FileUtil$IStreamListener;", "", "readLine", "", "line", "", "bugly-pro_release"})
    public static interface IStreamListener {
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0007J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0007J\u001c\u0010\u0011\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u000eH\u0007J\u0016\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cJ\n\u0010\u001d\u001a\u0004\u0018\u00010\u0004H\u0002J\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u00042\u0006\u0010!\u001a\u00020\u0012H\u0007J$\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010#2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00042\b\u0010$\u001a\u0004\u0018\u00010\u0004H\u0007J\u0018\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010&2\u0006\u0010\u001a\u001a\u00020\u0004H\u0007J\u0012\u0010'\u001a\u00020(2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000eH\u0007J\n\u0010)\u001a\u0004\u0018\u00010\u0004H\u0002J\b\u0010*\u001a\u00020\u0004H\u0007J\b\u0010+\u001a\u00020\u0004H\u0007J\u0010\u0010,\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u0004H\u0007J\u001c\u0010.\u001a\u00020\u00042\b\b\u0002\u0010/\u001a\u00020\u00042\b\b\u0002\u00100\u001a\u00020\u0004H\u0007J\u0012\u00101\u001a\u00020\u00042\b\u00102\u001a\u0004\u0018\u00010\u0004H\u0007J\u001a\u00103\u001a\u00020\u00042\u0006\u00104\u001a\u0002052\b\b\u0002\u00106\u001a\u00020\u001cH\u0007J\u001a\u00103\u001a\u00020\u00042\u0006\u00107\u001a\u0002082\b\b\u0002\u00106\u001a\u00020\u001cH\u0007J\u001c\u00109\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\b\u0010:\u001a\u0004\u0018\u00010;H\u0007J\u001c\u00109\u001a\u00020\u00172\b\u0010<\u001a\u0004\u0018\u0001052\b\u0010:\u001a\u0004\u0018\u00010;H\u0007J$\u0010=\u001a\u00020\u00122\b\u0010 \u001a\u0004\u0018\u00010\u00042\b\u0010>\u001a\u0004\u0018\u00010?2\u0006\u0010!\u001a\u00020\u0012H\u0007J$\u0010=\u001a\u00020\u00122\b\u0010 \u001a\u0004\u0018\u00010\u00042\b\u0010>\u001a\u0004\u0018\u00010\u00042\u0006\u0010!\u001a\u00020\u0012H\u0007J\"\u0010@\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010A\u001a\u00020\u00042\b\b\u0002\u0010B\u001a\u00020\u0012H\u0007J*\u0010@\u001a\u00020\u00122\u000e\u0010C\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010&2\u0006\u0010A\u001a\u00020\u00042\b\b\u0002\u0010B\u001a\u00020\u0012H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006D"}, d2={"Lcom/tencent/rmonitor/common/util/FileUtil$Companion;", "", "()V", "RMONITOR_ROOT", "", "SDPath", "TAG", "app", "Landroid/app/Application;", "getApp", "()Landroid/app/Application;", "setApp", "(Landroid/app/Application;)V", "copyFile", "Ljava/io/File;", "origin", "dist", "createFile", "", "filePath", "path", "fileName", "deleteFile", "", "file", "deleteOvertimeFiles", "dir", "time", "", "getExternalStorageDirectory", "getFileBufferStream", "Ljava/io/BufferedOutputStream;", "fileStr", "isAppend", "getFiles", "Ljava/util/ArrayList;", "reg", "getFilesInDir", "", "getLastModifiedTime", "", "getProcessDir", "getRootPath", "getTempPath", "loadLibrary", "soPath", "makeTempFileName", "prefix", "suffix", "readOutputFromFile", "pathToFile", "readStream", "inputStream", "Ljava/io/InputStream;", "bufferSize", "inputStreamReader", "Ljava/io/InputStreamReader;", "readStreamByLine", "listener", "Lcom/tencent/rmonitor/common/util/FileUtil$IStreamListener;", "stream", "writeFile", "text", "", "zipFiles", "outputPath", "isGzip", "allFiles", "bugly-pro_release"})
    public static final class Companion {
        public static void a(@Nullable Application application) {
            app = application;
        }

        private static String aM() {
            String string = "main";
            try {
                if (app != null) {
                    if (!ProcessUtil.Companion.isMainProcess((Context)app)) {
                        String string2;
                        app;
                        String string3 = string2 = AppInfo.Companion.gl();
                        Object object = Charsets.UTF_8;
                        String string4 = string3;
                        if (string4 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        byte[] byArray = string4.getBytes((Charset)object);
                        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                        string3 = ck.c(byArray);
                        if (string3 != null) {
                            string = string3;
                        } else if (StringsKt.contains$default((CharSequence)string2, (CharSequence)":", (boolean)false, (int)2, null)) {
                            int n2 = StringsKt.lastIndexOf$default((CharSequence)string2, (String)":", (int)0, (boolean)false, (int)6, null);
                            object = string2;
                            int n3 = n2 + 1;
                            Object object2 = object;
                            if (object2 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string5 = ((String)object2).substring(n3);
                            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                            string = string5;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                string = "main";
                Logger.INSTANCE.exception(FileUtil.TAG, throwable);
            }
            return string;
        }

        private static String aN() {
            if (!TextUtils.isEmpty((CharSequence)SDPath)) {
                return SDPath;
            }
            try {
                Application application = app;
                File file = application != null && (application = application.getApplicationContext()) != null ? application.getExternalFilesDir("/Tencent/RMonitor") : null;
                SDPath = file != null ? file.getAbsolutePath() : null;
            }
            catch (Throwable throwable) {
                Logger.INSTANCE.exception(FileUtil.TAG, throwable);
            }
            try {
                if (SDPath == null) {
                    Application application = app;
                    File file = application != null && (application = application.getApplicationContext()) != null ? application.getDir("Tencent_RMonitor", 0) : null;
                    SDPath = file != null ? file.getAbsolutePath() : null;
                }
            }
            catch (Throwable throwable) {
                Logger.INSTANCE.exception(FileUtil.TAG, throwable);
            }
            SDPath = Intrinsics.stringPlus((String)SDPath, (Object)(File.separator + com.tencent.rmonitor.common.util.FileUtil$Companion.aM()));
            app;
            String string = AppInfo.Companion.gl();
            Logger.INSTANCE.i(FileUtil.TAG, "Process: " + string + " ,SDPath: " + SDPath);
            String string2 = SDPath;
            if (string2 == null) {
                string2 = "";
            }
            return string2;
        }

        @JvmStatic
        public static boolean createFile(@Nullable String object) {
            if (object == null) {
                return false;
            }
            if (((File)(object = new File((String)object))).exists()) {
                return true;
            }
            try {
                File file = ((File)object).getParentFile();
                return file != null && (file.exists() || file.mkdirs()) && ((File)object).createNewFile();
            }
            catch (IOException iOException) {
                Logger.INSTANCE.exception(FileUtil.TAG, iOException);
                return false;
            }
        }

        @JvmStatic
        public static boolean writeFile(@Nullable String object, @Nullable String string, boolean bl2) {
            String string2 = string;
            if (string2 != null) {
                string = string2;
                String string3 = object;
                object = string;
                string = string3;
                Companion companion = Companion;
                Charset charset = Charsets.UTF_8;
                String string4 = object;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string4.getBytes(charset);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                object = byArray;
                return companion.writeFile(string, (byte[])object, bl2);
            }
            return false;
        }

        @JvmStatic
        public final synchronized boolean writeFile(@Nullable String string, @Nullable byte[] byArray, boolean bl2) {
            try {
                BufferedOutputStream bufferedOutputStream = this.getFileBufferStream(string, bl2);
                if (bufferedOutputStream != null) {
                    Closeable closeable;
                    block7: {
                        closeable = bufferedOutputStream;
                        Throwable throwable = null;
                        try {
                            BufferedOutputStream bufferedOutputStream2 = (BufferedOutputStream)closeable;
                            if (byArray == null) break block7;
                            byArray = byArray;
                            bufferedOutputStream2.write(byArray);
                        }
                        catch (Throwable throwable2) {
                            try {
                                Throwable throwable3 = throwable2;
                                throwable = throwable2;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                                throw throwable4;
                            }
                        }
                    }
                    CloseableKt.closeFinally((Closeable)closeable, null);
                }
                bl2 = true;
            }
            catch (IOException iOException) {
                Logger.INSTANCE.exception(FileUtil.TAG, "write file " + string + " error. ", iOException);
                bl2 = false;
            }
            return bl2;
        }

        @JvmStatic
        @Nullable
        public final synchronized BufferedOutputStream getFileBufferStream(@Nullable String string, boolean bl2) {
            try {
                if (string == null) {
                    return null;
                }
                File file = new File(string);
                File file2 = file.getParentFile();
                if (file2 != null && (file2.exists() || file2.mkdirs()) && file.exists() || file.createNewFile()) {
                    return new BufferedOutputStream(new FileOutputStream(string, bl2), 8192);
                }
                return null;
            }
            catch (IOException iOException) {
                Logger.INSTANCE.exception(FileUtil.TAG, "write file " + string + " error. ", iOException);
                return null;
            }
        }

        @JvmStatic
        public static void deleteFile(@Nullable File file) {
            File[] fileArray;
            if (file == null) {
                return;
            }
            if (!file.exists()) {
                return;
            }
            if (file.isFile()) {
                try {
                    file.delete();
                    return;
                }
                catch (Throwable throwable) {
                    return;
                }
            }
            try {
                fileArray = file.listFiles();
            }
            catch (Throwable throwable) {
                fileArray = null;
            }
            if (fileArray != null) {
                for (File file2 : fileArray) {
                    com.tencent.rmonitor.common.util.FileUtil$Companion.deleteFile(file2);
                }
            }
            try {
                file.delete();
                return;
            }
            catch (Throwable throwable) {
                return;
            }
        }

        @JvmStatic
        @Nullable
        public static ArrayList<File> getFiles(@Nullable String fileArray, @Nullable String string) {
            Serializable serializable = null;
            if (fileArray != null) {
                serializable = new File((String)fileArray);
            }
            if (serializable == null || !((File)serializable).exists()) {
                return null;
            }
            fileArray = ((File)serializable).listFiles();
            serializable = new ArrayList();
            if (fileArray != null) {
                fileArray = fileArray;
                if (TextUtils.isEmpty((CharSequence)string)) {
                    Collections.addAll((Collection)((Object)serializable), Arrays.copyOf(fileArray, fileArray.length));
                } else {
                    int n2 = fileArray.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        if (string == null) continue;
                        File file = fileArray[i2];
                        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"this[i]");
                        if (!Pattern.matches(string, file.getName())) continue;
                        ((ArrayList)serializable).add(fileArray[i2]);
                    }
                }
            }
            return serializable;
        }

        @JvmStatic
        @NotNull
        public static String getRootPath() {
            if (((CharSequence)RMONITOR_ROOT).length() == 0) {
                String string = com.tencent.rmonitor.common.util.FileUtil$Companion.aN();
                if (string == null) {
                    string = "";
                }
                RMONITOR_ROOT = string;
            }
            return RMONITOR_ROOT;
        }

        @JvmStatic
        @NotNull
        public static String getTempPath() {
            String string = com.tencent.rmonitor.common.util.FileUtil$Companion.getRootPath();
            String string2 = File.separator;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"File.separator");
            if (StringsKt.endsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) {
                return string + "temp" + File.separator;
            }
            return string + File.separator + "temp" + File.separator;
        }

        @JvmStatic
        @NotNull
        public static String makeTempFileName(@NotNull String string, @NotNull String string2) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"prefix");
            Intrinsics.checkParameterIsNotNull((Object)string2, (String)"suffix");
            long l2 = System.currentTimeMillis();
            int n2 = Random.Default.nextInt(0, 1000);
            return string + '_' + l2 + '_' + n2 + '.' + string2;
        }

        @JvmStatic
        @NotNull
        public static String readStream(@NotNull InputStream inputStream, int n2) {
            Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
            return com.tencent.rmonitor.common.util.FileUtil$Companion.readStream(new InputStreamReader(inputStream), n2);
        }

        @JvmStatic
        @NotNull
        public static String readStream(@NotNull InputStreamReader object, int n2) {
            Intrinsics.checkParameterIsNotNull((Object)object, (String)"inputStreamReader");
            StringBuffer stringBuffer = new StringBuffer(1024);
            object = new BufferedReader((Reader)object, n2);
            try {
                for (String string : (Iterable)TextStreamsKt.readLines((Reader)((Reader)object))) {
                    stringBuffer.append(string).append("\n");
                }
            }
            catch (Throwable throwable) {
                Logger.INSTANCE.exception(FileUtil.TAG, throwable);
            }
            String string = stringBuffer.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
            return string;
        }

        @JvmStatic
        public static void readStreamByLine(@Nullable File file, @Nullable IStreamListener iStreamListener) {
            if (file == null || iStreamListener == null || !file.exists()) {
                return;
            }
            try {
                FilesKt.forEachLine$default((File)file, null, (Function1)((Function1)new Function1<String, Unit>(iStreamListener){
                    final /* synthetic */ IStreamListener $listener;

                    public final void invoke(@NotNull String string) {
                        Intrinsics.checkParameterIsNotNull((Object)string, (String)"it");
                    }
                    {
                        this.$listener = iStreamListener;
                        super(1);
                    }
                }), (int)1, null);
                return;
            }
            catch (Throwable throwable) {
                Logger.INSTANCE.exception(FileUtil.TAG, throwable);
                return;
            }
        }

        @JvmStatic
        public static void readStreamByLine(@Nullable InputStream inputStream, @Nullable IStreamListener iStreamListener) {
            if (inputStream == null || iStreamListener == null) {
                return;
            }
            try {
                TextStreamsKt.forEachLine((Reader)new BufferedReader(new InputStreamReader(inputStream)), (Function1)((Function1)new Function1<String, Unit>(iStreamListener){
                    final /* synthetic */ IStreamListener $listener;

                    public final void invoke(@NotNull String string) {
                        Intrinsics.checkParameterIsNotNull((Object)string, (String)"it");
                    }
                    {
                        this.$listener = iStreamListener;
                        super(1);
                    }
                }));
                return;
            }
            catch (Throwable throwable) {
                Logger.INSTANCE.exception(FileUtil.TAG, throwable);
                return;
            }
        }

        @JvmStatic
        @NotNull
        public static String readOutputFromFile(@Nullable String string) {
            if (string == null) {
                return "";
            }
            Object object = new File(string);
            if (!((File)object).exists() || !((File)object).canRead()) {
                return "";
            }
            try {
                object = StringsKt.trim((String)com.tencent.rmonitor.common.util.FileUtil$Companion.readStream(new FileReader((File)object), 4096), (char[])new char[]{'\n'});
            }
            catch (FileNotFoundException fileNotFoundException) {
                Logger.INSTANCE.w(FileUtil.TAG, fileNotFoundException.getMessage() + ": file " + string + " can not read, because FileNotFoundException");
                object = "";
            }
            return object;
        }

        @JvmStatic
        @Nullable
        public static File copyFile(@NotNull File file, @NotNull File file2) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"origin");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"dist");
            try {
                file = FilesKt.copyTo$default((File)file, (File)file2, (boolean)true, (int)0, (int)4, null);
            }
            catch (Exception exception) {
                Logger.INSTANCE.exception(FileUtil.TAG, exception);
                file = null;
            }
            return file;
        }

        public static void aN(@NotNull String object) {
            Intrinsics.checkParameterIsNotNull((Object)object, (String)"dir");
            try {
                if (!TextUtils.isEmpty((CharSequence)((CharSequence)object)) && new File((String)object).exists()) {
                    long l2 = System.currentTimeMillis();
                    for (File file : SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)new File((String)object), null, (int)1, null)), (Function1)deleteOvertimeFiles.1.INSTANCE)) {
                        long l3 = file.lastModified();
                        if (l2 - l3 <= 259200000L) continue;
                        file.delete();
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Logger.INSTANCE.exception(FileUtil.TAG, throwable);
            }
        }

        @JvmStatic
        public static boolean zipFiles(@Nullable List<String> list, @NotNull String string, boolean bl2) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"outputPath");
            boolean bl3 = false;
            try {
                Object object;
                block18: {
                    block17: {
                        object = new File(string);
                        Serializable serializable = object;
                        com.tencent.rmonitor.common.util.FileUtil$Companion.createFile(serializable.getAbsolutePath());
                        object = new FileOutputStream((File)object);
                        object = bl2 ? (DeflaterOutputStream)new GZIPOutputStream(new BufferedOutputStream((OutputStream)object)) : (DeflaterOutputStream)new ZipOutputStream(new BufferedOutputStream((OutputStream)object));
                        serializable = null;
                        try {
                            Object object2;
                            Object object3;
                            DeflaterOutputStream deflaterOutputStream = (DeflaterOutputStream)object;
                            List<String> list2 = list;
                            if (list2 == null) break block17;
                            list = list2;
                            Iterator iterator = list2;
                            Object object42 = new ArrayList();
                            iterator = iterator.iterator();
                            while (iterator.hasNext()) {
                                object3 = iterator.next();
                                object2 = (String)object3;
                                if (!new File((String)object2).exists()) continue;
                                object42.add(object3);
                            }
                            for (Object object42 : (Iterable)((List)object42)) {
                                object3 = new File((String)object42);
                                if (!bl2) {
                                    DeflaterOutputStream deflaterOutputStream2 = deflaterOutputStream;
                                    if (!(deflaterOutputStream2 instanceof ZipOutputStream)) {
                                        deflaterOutputStream2 = null;
                                    }
                                    ZipOutputStream zipOutputStream = (ZipOutputStream)deflaterOutputStream2;
                                    if (zipOutputStream != null) {
                                        zipOutputStream.putNextEntry(new ZipEntry(((File)object3).getName()));
                                    }
                                }
                                object42 = new FileInputStream((File)object3);
                                object3 = null;
                                try {
                                    ByteStreamsKt.copyTo((InputStream)((FileInputStream)object42), (OutputStream)deflaterOutputStream, (int)20480);
                                }
                                catch (Throwable throwable) {
                                    try {
                                        object2 = throwable;
                                        object3 = throwable;
                                        throw object2;
                                    }
                                    catch (Throwable throwable2) {
                                        CloseableKt.closeFinally((Closeable)object42, (Throwable)object3);
                                        throw throwable2;
                                    }
                                }
                                CloseableKt.closeFinally((Closeable)object42, null);
                                deflaterOutputStream.flush();
                                if (bl2) continue;
                                DeflaterOutputStream deflaterOutputStream3 = deflaterOutputStream;
                                if (!(deflaterOutputStream3 instanceof ZipOutputStream)) {
                                    deflaterOutputStream3 = null;
                                }
                                ZipOutputStream zipOutputStream = (ZipOutputStream)deflaterOutputStream3;
                                if (zipOutputStream == null) continue;
                                zipOutputStream.closeEntry();
                            }
                            list2 = list;
                            if (list2 != null) break block18;
                        }
                        catch (Throwable throwable) {
                            try {
                                Throwable throwable3 = throwable;
                                serializable = throwable;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                CloseableKt.closeFinally((Closeable)object, (Throwable)serializable);
                                throw throwable4;
                            }
                        }
                    }
                    CloseableKt.closeFinally((Closeable)object, null);
                    return false;
                }
                CloseableKt.closeFinally((Closeable)object, null);
                bl3 = true;
            }
            catch (IOException iOException) {
                Logger.INSTANCE.exception(FileUtil.TAG, "outputPath: ".concat(String.valueOf(string)), iOException);
            }
            return bl3;
        }

        @JvmStatic
        @Nullable
        public static List<String> getFilesInDir(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"dir");
            File[] fileArray = new File(string).listFiles();
            if (fileArray != null && (fileArray = ArraysKt.asSequence((Object[])fileArray)) != null && (fileArray = SequencesKt.filter((Sequence)fileArray, (Function1)getFilesInDir.1.INSTANCE)) != null && (fileArray = SequencesKt.filter((Sequence)fileArray, (Function1)getFilesInDir.2.INSTANCE)) != null && (fileArray = SequencesKt.map((Sequence)fileArray, (Function1)getFilesInDir.3.INSTANCE)) != null) {
                return SequencesKt.toList((Sequence)fileArray);
            }
            return null;
        }

        @JvmStatic
        public static boolean loadLibrary(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"soPath");
            bm bm2 = bm.ak();
            Intrinsics.checkExpressionValueIsNotNull((Object)bm2, (String)"PrivacyInformation.getInstance()");
            if (bm2.af()) {
                return false;
            }
            try {
                System.loadLibrary(string);
            }
            catch (Throwable throwable) {
                Logger.INSTANCE.exception(FileUtil.TAG, throwable);
                return false;
            }
            return true;
        }

        @JvmStatic
        public static long getLastModifiedTime(@Nullable File file) {
            File file2 = file;
            if (file2 != null) {
                return file2.lastModified();
            }
            return -1L;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(byte by2) {
            this();
        }
    }
}

