/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bugly.traffic;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import com.tencent.bugly.common.network.INetworkStateListener;
import com.tencent.bugly.common.network.NetworkWatcher;
import com.tencent.bugly.common.thread.ThreadManager;
import com.tencent.bugly.common.utils.AndroidVersion;
import com.tencent.bugly.proguard.bg;
import com.tencent.bugly.proguard.cd;
import com.tencent.bugly.proguard.cl;
import com.tencent.bugly.proguard.gh;
import com.tencent.bugly.proguard.gi;
import com.tencent.bugly.proguard.gk;
import com.tencent.bugly.proguard.gl;
import com.tencent.bugly.proguard.gm;
import com.tencent.bugly.proguard.gn;
import com.tencent.bugly.proguard.go;
import com.tencent.bugly.proguard.hc;
import com.tencent.bugly.proguard.ib;
import com.tencent.bugly.proguard.ke;
import com.tencent.bugly.traffic.TrafficMsg;
import com.tencent.bugly.traffic.custom.CustomTrafficStatistic;
import com.tencent.bugly.traffic.custom.SocketInfo;
import com.tencent.rmonitor.base.config.ConfigProxy;
import com.tencent.rmonitor.base.db.table.TrafficInfoTable;
import com.tencent.rmonitor.base.meta.BaseInfo;
import com.tencent.rmonitor.base.meta.TrafficInfo;
import com.tencent.rmonitor.common.lifecycle.IActivityStateCallback;
import com.tencent.rmonitor.common.lifecycle.LifecycleCallback;
import com.tencent.rmonitor.common.logger.Logger;
import com.tencent.rmonitor.common.util.AppInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONObject;

public class TrafficMonitor
implements INetworkStateListener,
IActivityStateCallback {
    private long uS = 0L;
    public static String uT = "unknown";
    private final ib uR;
    private AtomicBoolean bb = new AtomicBoolean(false);
    boolean uU = false;
    boolean uV = false;
    private boolean uW = false;
    private ArrayList<TrafficMsg> uX = new ArrayList();
    private gk uY = new go();
    private gk uZ = new gn();
    private gk va = new gm();
    private gk vb = new gl();
    private List<gk> vc = new ArrayList<gk>();
    private gk vd = new go();
    private gk ve = new gn();
    private gk vf = new gm();
    private gk vg = new gl();
    private List<gk> vh = new ArrayList<gk>();
    private final Handler handler = new Handler(ThreadManager.getMonitorThreadLooper()){

        public final void handleMessage(Message object) {
            if (((Message)object).what == 1) {
                object = TrafficMonitor.this;
                ArrayList<TrafficMsg> arrayList = ((TrafficMonitor)object).ev();
                if (((TrafficMonitor)object).uU) {
                    Logger.INSTANCE.d("TrafficMonitor", "saveTrafficMsgs");
                    ((TrafficMonitor)object).e(arrayList);
                }
                if (((TrafficMonitor)object).uV) {
                    Logger.INSTANCE.d("TrafficMonitor", "reportTrafficMsgs");
                    ((TrafficMonitor)object).g(arrayList);
                }
                TrafficMonitor.ew();
                object = this.obtainMessage(1);
                this.sendMessageDelayed((Message)object, 60000L);
            }
        }
    };

    public static TrafficMonitor es() {
        return a.vj;
    }

    private static boolean et() {
        if (!AndroidVersion.isOverO()) {
            Logger.INSTANCE.i("TrafficMonitor", "below android o, could not open traffic");
            return false;
        }
        return true;
    }

    private TrafficMonitor() {
        ConfigProxy.INSTANCE.getConfig();
        String string = "traffic_detail";
        this.uR = (ib)hc.fh().getPluginConfig(string);
    }

    public final boolean u(boolean bl2) {
        this.uU = bl2;
        return this.uU;
    }

    public final boolean v(boolean bl2) {
        this.uV = bl2;
        return this.uV;
    }

    private void eu() {
        this.vc.add(this.uY);
        this.vc.add(this.uZ);
        this.vc.add(this.va);
        this.vc.add(this.vb);
        this.vh.add(this.vd);
        this.vh.add(this.ve);
        this.vh.add(this.vf);
        this.vh.add(this.vg);
        uT = NetworkWatcher.INSTANCE.getOperatorName();
        System.loadLibrary("rmonitor_base");
        String[] stringArray = new String[]{};
        if (this.uR.xx != null) {
            stringArray = this.uR.xx.toArray(new String[0]);
        }
        NetworkWatcher.INSTANCE.registerListener(this);
        if (NetworkWatcher.INSTANCE.isWiFiConnectedRealtime()) {
            TrafficMonitor.nativeSetNetworkState(1);
        } else if (NetworkWatcher.INSTANCE.isNetworkConnectedRealtime()) {
            TrafficMonitor.nativeSetNetworkState(2);
        } else {
            TrafficMonitor.nativeSetNetworkState(3);
        }
        LifecycleCallback.register(this);
        if (LifecycleCallback.INSTANCE.isCurrentForeground()) {
            TrafficMonitor.nativeSetForegroundState(1);
        } else {
            TrafficMonitor.nativeSetForegroundState(2);
        }
        TrafficMonitor.nativeInitMatrixTraffic(true, true, true, stringArray);
    }

    public final void start() {
        if (!this.uU && !this.uV) {
            return;
        }
        if (!this.bb.get() && TrafficMonitor.et()) {
            Logger.INSTANCE.i("TrafficMonitor", "traffic monitor start");
            this.bb.set(true);
            this.uS = System.currentTimeMillis();
            if (!this.uW) {
                this.eu();
                this.uW = true;
            } else {
                TrafficMonitor.nativeRestart();
            }
            this.handler.sendMessageDelayed(this.handler.obtainMessage(1), 60000L);
        }
    }

    public final void w(boolean bl2) {
        if (bl2) {
            ArrayList<TrafficMsg> arrayList = this.ev();
            this.e(arrayList);
            this.g(arrayList);
            TrafficMonitor.ew();
        }
        if (!this.uU && !this.uV) {
            Logger.INSTANCE.i("TrafficMonitor", "traffic monitor stop");
            this.bb.set(false);
            this.handler.removeMessages(1);
            TrafficMonitor.nativeReleaseMatrixTraffic();
        }
    }

    private ArrayList<TrafficMsg> d(ArrayList<TrafficMsg> object) {
        if (this.uR.xN) {
            ArrayList<TrafficMsg> arrayList = new ArrayList<TrafficMsg>();
            object = ((ArrayList)object).iterator();
            while (object.hasNext()) {
                TrafficMsg trafficMsg = (TrafficMsg)object.next();
                if (cl.B(trafficMsg.mHost)) continue;
                TrafficMsg trafficMsg2 = new TrafficMsg();
                new TrafficMsg().mCollectType = trafficMsg.mCollectType;
                trafficMsg2.mHost = trafficMsg.mHost;
                trafficMsg2.mRx = trafficMsg.mRx;
                trafficMsg2.mTx = trafficMsg.mTx;
                trafficMsg2.mFore = trafficMsg.mFore;
                trafficMsg2.mId = trafficMsg.mId;
                trafficMsg2.mNet = trafficMsg.mNet;
                trafficMsg2.mTime = trafficMsg.mTime;
                arrayList.add(trafficMsg2);
            }
            return arrayList;
        }
        return object;
    }

    public final ArrayList<TrafficMsg> ev() {
        ArrayList<TrafficMsg> arrayList = new ArrayList<TrafficMsg>();
        TrafficMonitor.nativeGetTrafficInfo(arrayList);
        for (SocketInfo socketInfo : CustomTrafficStatistic.getInstance().getHttpQueue()) {
            TrafficMsg trafficMsg = new TrafficMsg();
            new TrafficMsg().mRx = (int)socketInfo.receivedBytes;
            trafficMsg.mTx = (int)socketInfo.sendBytes;
            trafficMsg.mCollectType = "custom";
            trafficMsg.mNet = socketInfo.networkType;
            trafficMsg.mFore = socketInfo.frontState;
            trafficMsg.mHost = socketInfo.host;
            trafficMsg.mTime = socketInfo.startTimeStamp;
            arrayList.add(trafficMsg);
        }
        return this.d(arrayList);
    }

    public static void ew() {
        TrafficMonitor.nativeClearTrafficInfo();
        CustomTrafficStatistic.getInstance().getHttpQueue().clear();
        CustomTrafficStatistic.getInstance().getSocketToQueue().clear();
    }

    private static native void nativeInitMatrixTraffic(boolean var0, boolean var1, boolean var2, String[] var3);

    private static native void nativeRestart();

    private static native void nativeReleaseMatrixTraffic();

    private static native void nativeClearTrafficInfo();

    private static native void nativeSetNetworkState(int var0);

    private static native void nativeSetForegroundState(int var0);

    private static native void nativeGetTrafficInfo(ArrayList<TrafficMsg> var0);

    private static ArrayList<TrafficInfo> a(String string, TrafficMsg trafficMsg) {
        return (ArrayList)TrafficInfoTable.getInstance().query(null, "host = ? AND front_state = ? AND net_state = ? AND process_name = ? AND process_launch_id = ? AND type = ?", new String[]{string, gi.q(trafficMsg.mFore), gi.r(trafficMsg.mNet), AppInfo.obtainProcessName((Context)BaseInfo.app), cd.aC(), trafficMsg.mCollectType}, false, null, null, null, null);
    }

    private static ArrayList<TrafficMsg> a(Map<String, TrafficMsg> iterator, Map<String, TrafficMsg> map) {
        ArrayList<TrafficMsg> arrayList = new ArrayList<TrafficMsg>();
        if (iterator != null && !iterator.isEmpty()) {
            for (Map.Entry<String, TrafficMsg> entry : iterator.entrySet()) {
                arrayList.add(entry.getValue());
            }
        }
        if (map != null && !map.isEmpty()) {
            for (Map.Entry<String, TrafficMsg> entry : map.entrySet()) {
                arrayList.add(entry.getValue());
            }
        }
        return arrayList;
    }

    final void e(ArrayList<TrafficMsg> arrayList) {
        for (gk gk2 : this.vh) {
            gk2.i(arrayList);
            for (TrafficMsg trafficMsg : TrafficMonitor.a(gk2.eE(), gk2.eC())) {
                TrafficInfo trafficInfo;
                ArrayList<TrafficInfo> arrayList2 = TrafficMonitor.a(trafficMsg.mHost, trafficMsg);
                if (arrayList2.size() > 0) {
                    trafficInfo = arrayList2.get(0);
                    for (int jSONObject = 1; jSONObject < arrayList2.size(); ++jSONObject) {
                        TrafficInfo trafficInfo2 = trafficInfo;
                        trafficInfo2.setRx(trafficInfo2.getRx() + arrayList2.get(jSONObject).getRx());
                        TrafficInfo trafficInfo3 = trafficInfo;
                        trafficInfo3.setTx(trafficInfo3.getTx() + arrayList2.get(jSONObject).getTx());
                        TrafficInfoTable.getInstance().delete(arrayList2.get(jSONObject));
                    }
                    TrafficInfo trafficInfo4 = trafficInfo;
                    trafficInfo4.setRx(trafficInfo4.getRx() + trafficMsg.mRx);
                    TrafficInfo trafficInfo5 = trafficInfo;
                    trafficInfo5.setTx(trafficInfo5.getTx() + trafficMsg.mTx);
                    TrafficInfoTable.getInstance().replace(trafficInfo);
                    continue;
                }
                trafficInfo = new TrafficInfo();
                trafficInfo.setHost(trafficMsg.mHost);
                trafficInfo.setLaunchID(cd.d((Context)BaseInfo.app));
                trafficInfo.setProcessName(AppInfo.obtainProcessName((Context)BaseInfo.app));
                trafficInfo.setProcessLaunchID(cd.aC());
                trafficInfo.setFrontState(gi.q(trafficMsg.mFore));
                trafficInfo.setNetState(gi.r(trafficMsg.mNet));
                trafficInfo.setRx(trafficMsg.mRx);
                trafficInfo.setTx(trafficMsg.mTx);
                trafficInfo.setAppVersion(BaseInfo.userMeta.appVersion);
                trafficInfo.setType(trafficMsg.mCollectType);
                trafficInfo.setHotPatchNum(bg.X().Y());
                JSONObject jSONObject = ke.gw().gt();
                if (jSONObject != null) {
                    trafficInfo.setUserData(jSONObject);
                }
                TrafficInfoTable.getInstance().replace(trafficInfo);
            }
        }
    }

    private ArrayList<TrafficMsg> f(ArrayList<TrafficMsg> object) {
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            boolean bl2;
            TrafficMsg trafficMsg;
            block4: {
                TrafficMsg trafficMsg2 = trafficMsg = (TrafficMsg)object.next();
                for (TrafficMsg trafficMsg3 : this.uX) {
                    if (!trafficMsg2.mCollectType.equals(trafficMsg3.mCollectType)) continue;
                    if (trafficMsg2.mCollectType.equals("custom") && trafficMsg3.mHost.equals(trafficMsg2.mHost)) {
                        trafficMsg3.mRx += trafficMsg2.mRx;
                        trafficMsg3.mTx += trafficMsg2.mTx;
                        bl2 = true;
                    } else {
                        if (trafficMsg2.mId == -1L || trafficMsg2.mId != trafficMsg3.mId || !trafficMsg2.mCollectType.equals("auto")) continue;
                        trafficMsg3.mRx += trafficMsg2.mRx;
                        trafficMsg3.mTx += trafficMsg2.mTx;
                        bl2 = true;
                    }
                    break block4;
                }
                bl2 = false;
            }
            if (bl2) continue;
            this.uX.add(trafficMsg);
        }
        return this.uX;
    }

    private int ex() {
        int n2 = 0;
        if ((double)(this.uY.eB() + this.uZ.eB() + this.va.eB() + this.vb.eB()) > this.uR.xI * 1024.0 * 1024.0) {
            ++n2;
        }
        if ((double)(this.vb.eB() + this.uZ.eB()) > this.uR.xJ * 1024.0 * 1024.0) {
            n2 += 2;
        }
        if ((double)(this.va.eB() + this.vb.eB()) > this.uR.xK * 1024.0 * 1024.0) {
            n2 += 4;
        }
        if ((double)(this.uZ.eD() + this.uY.eD() + this.va.eD() + this.vb.eD()) > this.uR.xL * 1024.0 * 1024.0) {
            n2 += 16;
        }
        return n2;
    }

    final void g(ArrayList<TrafficMsg> object) {
        this.f((ArrayList<TrafficMsg>)object);
        long l2 = System.currentTimeMillis();
        if (l2 - this.uS >= 600000L) {
            this.uS = l2;
            object = this.vc.iterator();
            while (object.hasNext()) {
                ((gk)object.next()).i(this.uX);
            }
            int n2 = this.ex();
            if (n2 == 0 && Math.random() < this.uR.xO) {
                gh.a(n2, this.uX, this.vc);
            } else if (n2 != 0 && Math.random() < this.uR.xP) {
                gh.a(n2, this.uX, this.vc);
            }
            this.uX.clear();
        }
    }

    @Override
    public void onNetworkStateChanged(int n2) {
        TrafficMonitor.nativeSetNetworkState(n2);
    }

    @Override
    public void onForeground() {
        TrafficMonitor.nativeSetForegroundState(1);
    }

    @Override
    public void onBackground() {
        TrafficMonitor.nativeSetForegroundState(2);
    }

    @Override
    public void onCreate(@NonNull Activity activity) {
    }

    @Override
    public void onPostCreate(@NonNull Activity activity) {
    }

    @Override
    public void onStart(@NonNull Activity activity) {
    }

    @Override
    public void onResume(@NonNull Activity activity) {
    }

    @Override
    public void onPause(@NonNull Activity activity) {
    }

    @Override
    public void onStop(@NonNull Activity activity) {
    }

    @Override
    public void onDestroy(@NonNull Activity activity) {
    }

    /* synthetic */ TrafficMonitor(byte by2) {
        this();
    }

    static final class a {
        static final TrafficMonitor vj = new TrafficMonitor(0);
    }
}

