/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bugly.common.replay.video;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import androidx.annotation.RequiresApi;
import com.tencent.bugly.common.replay.video.SimpleFrameMuxer;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\bH\u0016J\b\u0010\u0012\u001a\u00020\rH\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0014H\u0016J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/tencent/bugly/common/replay/video/SimpleMp4FrameMuxer;", "Lcom/tencent/bugly/common/replay/video/SimpleFrameMuxer;", "path", "", "fps", "", "(Ljava/lang/String;F)V", "finalVideoTime", "", "frameDurationUsec", "muxer", "Landroid/media/MediaMuxer;", "started", "", "videoFrames", "", "videoTrackIndex", "getVideoTime", "isStarted", "muxVideoFrame", "", "encodedData", "Ljava/nio/ByteBuffer;", "bufferInfo", "Landroid/media/MediaCodec$BufferInfo;", "release", "start", "videoFormat", "Landroid/media/MediaFormat;", "bugly-pro_release"})
@RequiresApi(value=18)
public final class SimpleMp4FrameMuxer
implements SimpleFrameMuxer {
    private final long frameDurationUsec;
    private final MediaMuxer muxer;
    private boolean started;
    private int videoTrackIndex;
    private int videoFrames;
    private long finalVideoTime;

    public final boolean isStarted() {
        return this.started;
    }

    public final void start(@NotNull MediaFormat mediaFormat2) {
        Intrinsics.checkParameterIsNotNull((Object)mediaFormat2, (String)"videoFormat");
        this.videoTrackIndex = this.muxer.addTrack(mediaFormat2);
        this.muxer.start();
        this.started = true;
    }

    public final void muxVideoFrame(@NotNull ByteBuffer byteBuffer, @NotNull MediaCodec.BufferInfo bufferInfo) {
        Intrinsics.checkParameterIsNotNull((Object)byteBuffer, (String)"encodedData");
        Intrinsics.checkParameterIsNotNull((Object)bufferInfo, (String)"bufferInfo");
        int n2 = this.videoFrames;
        this.videoFrames = n2 + 1;
        bufferInfo.presentationTimeUs = this.finalVideoTime = this.frameDurationUsec * (long)n2;
        this.muxer.writeSampleData(this.videoTrackIndex, byteBuffer, bufferInfo);
    }

    public final void release() {
        this.muxer.stop();
        this.muxer.release();
    }

    public final long getVideoTime() {
        if (this.videoFrames == 0) {
            return 0L;
        }
        return TimeUnit.MILLISECONDS.convert(this.finalVideoTime + this.frameDurationUsec, TimeUnit.MICROSECONDS);
    }

    public SimpleMp4FrameMuxer(@NotNull String string, float f2) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"path");
        this.frameDurationUsec = (long)((float)TimeUnit.SECONDS.toMicros(1L) / f2);
        this.muxer = new MediaMuxer(string, 0);
    }
}

