/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bugly.common.replay;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.os.Handler;
import android.view.PixelCopy;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import com.tencent.bugly.common.replay.BuglyReplayOptions;
import com.tencent.bugly.common.replay.ScreenshotRecorder;
import com.tencent.bugly.common.replay.ScreenshotRecorderCallback;
import com.tencent.bugly.common.replay.ScreenshotRecorderConfig;
import com.tencent.bugly.common.replay.WindowsKt;
import com.tencent.bugly.common.replay.tool.ExecutorsKt;
import com.tencent.bugly.common.replay.tool.MainLooperHandler;
import com.tencent.bugly.common.replay.tool.ViewsKt;
import com.tencent.bugly.common.replay.viewhierarchy.ViewHierarchyNode;
import com.tencent.rmonitor.common.logger.Logger;
import java.lang.ref.WeakReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0001\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u000208J\u0016\u0010J\u001a\u00020#2\u0006\u0010K\u001a\u00020#2\u0006\u0010L\u001a\u00020MJ\u0006\u0010N\u001a\u00020HJ\b\u0010O\u001a\u00020HH\u0002J\u0006\u0010P\u001a\u00020HJ\u001e\u0010Q\u001a\u00020H2\u0006\u0010R\u001a\u00020#2\u0006\u0010S\u001a\u00020#2\u0006\u0010T\u001a\u00020UJ\u0018\u0010V\u001a\u00020\u00102\u0006\u0010W\u001a\u00020\u000e2\u0006\u0010X\u001a\u00020\u000eH\u0002J\u0018\u0010Y\u001a\u00020H2\u0006\u0010Z\u001a\u00020\u00102\u0006\u0010[\u001a\u00020\u0010H\u0002J\u0018\u0010\\\u001a\u00020\u00102\u0006\u0010]\u001a\u00020\u00102\u0006\u0010^\u001a\u00020\u000eH\u0002J\b\u0010_\u001a\u00020HH\u0016J\u0006\u0010`\u001a\u00020HJ\u0006\u0010a\u001a\u00020HJ\u0016\u0010b\u001a\u00020U2\u0006\u0010T\u001a\u00020U2\u0006\u0010c\u001a\u000200J\u0010\u0010d\u001a\u00020H2\b\u0010I\u001a\u0004\u0018\u000108J\u0014\u0010e\u001a\u00020\u0010*\u00020#2\u0006\u0010T\u001a\u00020UH\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\"\u001a\n $*\u0004\u0018\u00010#0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010&\u001a\u00020'8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b(\u0010)R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u000e\u0010.\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010/\u001a\u0002008BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b3\u0010+\u001a\u0004\b1\u00102R\u000e\u00104\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u00106\u001a\n\u0012\u0004\u0012\u000208\u0018\u000107X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u00109\u001a\n $*\u0004\u0018\u00010#0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010:\u001a\u00020#8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b=\u0010+\u001a\u0004\b;\u0010<R\u001b\u0010>\u001a\u00020?8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bB\u0010+\u001a\u0004\b@\u0010AR\u000e\u0010C\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010E\u001a\u0004\u0018\u00010FX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006f"}, d2={"Lcom/tencent/bugly/common/replay/ScreenshotRecorder;", "Landroid/view/ViewTreeObserver$OnDrawListener;", "config", "Lcom/tencent/bugly/common/replay/ScreenshotRecorderConfig;", "options", "Lcom/tencent/bugly/common/replay/BuglyReplayOptions;", "mainLooperHandler", "Lcom/tencent/bugly/common/replay/tool/MainLooperHandler;", "recorder", "Ljava/util/concurrent/ScheduledExecutorService;", "screenshotRecorderCallback", "Lcom/tencent/bugly/common/replay/ScreenshotRecorderCallback;", "(Lcom/tencent/bugly/common/replay/ScreenshotRecorderConfig;Lcom/tencent/bugly/common/replay/BuglyReplayOptions;Lcom/tencent/bugly/common/replay/tool/MainLooperHandler;Ljava/util/concurrent/ScheduledExecutorService;Lcom/tencent/bugly/common/replay/ScreenshotRecorderCallback;)V", "TAG", "", "blurProgram", "", "blurTexture", "", "getConfig", "()Lcom/tencent/bugly/common/replay/ScreenshotRecorderConfig;", "contentChanged", "Ljava/util/concurrent/atomic/AtomicBoolean;", "eglContext", "Landroid/opengl/EGLContext;", "eglDisplay", "Landroid/opengl/EGLDisplay;", "eglSurface", "Landroid/opengl/EGLSurface;", "isCapturing", "isOpenGLInitialized", "", "lastBitmapHeight", "lastBitmapWidth", "lastBlurScreenshot", "Landroid/graphics/Bitmap;", "kotlin.jvm.PlatformType", "lastCaptureSuccessful", "maskingPaint", "Landroid/graphics/Paint;", "getMaskingPaint", "()Landroid/graphics/Paint;", "maskingPaint$delegate", "Lkotlin/Lazy;", "getOptions", "()Lcom/tencent/bugly/common/replay/BuglyReplayOptions;", "positionLocation", "prescaledMatrix", "Landroid/graphics/Matrix;", "getPrescaledMatrix", "()Landroid/graphics/Matrix;", "prescaledMatrix$delegate", "radiusLocation", "resolutionLocation", "rootView", "Ljava/lang/ref/WeakReference;", "Landroid/view/View;", "screenshot", "singlePixelBitmap", "getSinglePixelBitmap", "()Landroid/graphics/Bitmap;", "singlePixelBitmap$delegate", "singlePixelBitmapCanvas", "Landroid/graphics/Canvas;", "getSinglePixelBitmapCanvas", "()Landroid/graphics/Canvas;", "singlePixelBitmapCanvas$delegate", "texCoordLocation", "textureLocation", "vertexBuffer", "Ljava/nio/FloatBuffer;", "bind", "", "root", "blurBitmap", "original", "radius", "", "capture", "cleanupOpenGLResources", "close", "copyRectPixels", "bitmapA", "bitmapB", "rect", "Landroid/graphics/Rect;", "createShaderProgram", "vertexShaderSource", "fragmentShaderSource", "initializeOpenGL", "width", "height", "loadShader", "type", "shaderCode", "onDraw", "pause", "resume", "transformRect", "matrix", "unbind", "dominantColorForRect", "bugly-pro_release"})
@TargetApi(value=26)
public final class ScreenshotRecorder
implements ViewTreeObserver.OnDrawListener {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private WeakReference<View> rootView;
    private final Lazy maskingPaint$delegate;
    private final String TAG = "ScreenshotRecorder";
    private final Lazy singlePixelBitmap$delegate;
    private final Bitmap screenshot;
    private final Bitmap lastBlurScreenshot;
    private final Lazy singlePixelBitmapCanvas$delegate;
    private final Lazy prescaledMatrix$delegate;
    private final AtomicBoolean contentChanged;
    private final AtomicBoolean isCapturing;
    private final AtomicBoolean lastCaptureSuccessful;
    private EGLDisplay eglDisplay;
    private EGLContext eglContext;
    private EGLSurface eglSurface;
    private int blurProgram;
    private int[] blurTexture;
    private FloatBuffer vertexBuffer;
    private boolean isOpenGLInitialized;
    private int lastBitmapWidth;
    private int lastBitmapHeight;
    private int radiusLocation;
    private int resolutionLocation;
    private int textureLocation;
    private int positionLocation;
    private int texCoordLocation;
    @NotNull
    private final ScreenshotRecorderConfig config;
    @NotNull
    private final BuglyReplayOptions options;
    private final MainLooperHandler mainLooperHandler;
    private final ScheduledExecutorService recorder;
    private final ScreenshotRecorderCallback screenshotRecorderCallback;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ScreenshotRecorder.class), "maskingPaint", "getMaskingPaint()Landroid/graphics/Paint;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ScreenshotRecorder.class), "singlePixelBitmap", "getSinglePixelBitmap()Landroid/graphics/Bitmap;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ScreenshotRecorder.class), "singlePixelBitmapCanvas", "getSinglePixelBitmapCanvas()Landroid/graphics/Canvas;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ScreenshotRecorder.class), "prescaledMatrix", "getPrescaledMatrix()Landroid/graphics/Matrix;"))};
    }

    private final Paint getMaskingPaint() {
        return (Paint)this.maskingPaint$delegate.getValue();
    }

    private final Bitmap getSinglePixelBitmap() {
        return (Bitmap)this.singlePixelBitmap$delegate.getValue();
    }

    private final Canvas getSinglePixelBitmapCanvas() {
        return (Canvas)this.singlePixelBitmapCanvas$delegate.getValue();
    }

    private final Matrix getPrescaledMatrix() {
        return (Matrix)this.prescaledMatrix$delegate.getValue();
    }

    @NotNull
    public final Bitmap blurBitmap(@NotNull Bitmap bitmap, float f2) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"original");
        try {
            if (!this.isOpenGLInitialized || this.lastBitmapWidth != bitmap.getWidth() || this.lastBitmapHeight != bitmap.getHeight()) {
                this.cleanupOpenGLResources();
                this.initializeOpenGL(bitmap.getWidth(), bitmap.getHeight());
                this.lastBitmapWidth = bitmap.getWidth();
                this.lastBitmapHeight = bitmap.getHeight();
            }
            if (!EGL14.eglMakeCurrent((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (EGLSurface)this.eglSurface, (EGLContext)this.eglContext)) {
                throw (Throwable)new RuntimeException("Failed to make EGL context current");
            }
            GLES20.glViewport((int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight());
            GLES20.glUseProgram((int)this.blurProgram);
            if (this.blurTexture == null) {
                Intrinsics.throwNpe();
            }
            GLES20.glBindTexture((int)3553, (int)this.blurTexture[0]);
            GLUtils.texSubImage2D((int)3553, (int)0, (int)0, (int)0, (Bitmap)bitmap);
            GLES20.glUniform1f((int)this.radiusLocation, (float)f2);
            GLES20.glUniform2f((int)this.resolutionLocation, (float)bitmap.getWidth(), (float)bitmap.getHeight());
            GLES20.glUniform1i((int)this.textureLocation, (int)0);
            GLES20.glEnableVertexAttribArray((int)this.positionLocation);
            GLES20.glEnableVertexAttribArray((int)this.texCoordLocation);
            FloatBuffer floatBuffer = this.vertexBuffer;
            if (floatBuffer == null) {
                Intrinsics.throwNpe();
            }
            floatBuffer.position(0);
            GLES20.glVertexAttribPointer((int)this.positionLocation, (int)2, (int)5126, (boolean)false, (int)16, (Buffer)this.vertexBuffer);
            FloatBuffer floatBuffer2 = this.vertexBuffer;
            if (floatBuffer2 == null) {
                Intrinsics.throwNpe();
            }
            floatBuffer2.position(2);
            GLES20.glVertexAttribPointer((int)this.texCoordLocation, (int)2, (int)5126, (boolean)false, (int)16, (Buffer)this.vertexBuffer);
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GLES20.glClear((int)16384);
            GLES20.glDrawArrays((int)5, (int)0, (int)4);
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(bitmap.getWidth() * bitmap.getHeight() * 4);
            GLES20.glReadPixels((int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (int)6408, (int)5121, (Buffer)byteBuffer);
            Bitmap bitmap2 = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap2.copyPixelsFromBuffer((Buffer)byteBuffer);
            Bitmap bitmap3 = bitmap2;
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"resultBitmap");
            return bitmap3;
        }
        catch (Throwable throwable) {
            Logger.INSTANCE.exception(this.TAG, "Failed to blur bitmap with OpenGL ES", throwable);
            this.cleanupOpenGLResources();
            Bitmap bitmap4 = bitmap;
            Bitmap bitmap5 = bitmap4.copy(bitmap4.getConfig(), false);
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap5, (String)"original.copy(original.config, false)");
            return bitmap5;
        }
    }

    private final void initializeOpenGL(int n2, int n3) {
        try {
            this.eglDisplay = EGL14.eglGetDisplay((int)0);
            if (Intrinsics.areEqual((Object)this.eglDisplay, (Object)EGL14.EGL_NO_DISPLAY)) {
                throw (Throwable)new RuntimeException("Unable to get EGL14 display");
            }
            Object object = new int[2];
            if (!EGL14.eglInitialize((EGLDisplay)this.eglDisplay, (int[])object, (int)0, (int[])object, (int)1)) {
                throw (Throwable)new RuntimeException("Unable to initialize EGL14");
            }
            object = new EGLConfig[1];
            Object object2 = new int[1];
            int[] nArray = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12321, 8, 12344};
            if (!EGL14.eglChooseConfig((EGLDisplay)this.eglDisplay, (int[])nArray, (int)0, (EGLConfig[])object, (int)0, (int)1, (int[])object2, (int)0)) {
                throw (Throwable)new RuntimeException("Unable to find a suitable EGLConfig");
            }
            int n4 = object[0];
            if (n4 == null) {
                throw (Throwable)new RuntimeException("Unable to find a suitable EGLConfig");
            }
            object = n4;
            object2 = new int[]{12440, 2, 12344};
            this.eglContext = EGL14.eglCreateContext((EGLDisplay)this.eglDisplay, (EGLConfig)object, (EGLContext)EGL14.EGL_NO_CONTEXT, (int[])object2, (int)0);
            if (Intrinsics.areEqual((Object)this.eglContext, (Object)EGL14.EGL_NO_CONTEXT)) {
                throw (Throwable)new RuntimeException("Failed to create EGL context");
            }
            object2 = new int[]{12375, n2, 12374, n3, 12344};
            this.eglSurface = EGL14.eglCreatePbufferSurface((EGLDisplay)this.eglDisplay, (EGLConfig)object, (int[])object2, (int)0);
            if (Intrinsics.areEqual((Object)this.eglSurface, (Object)EGL14.EGL_NO_SURFACE)) {
                throw (Throwable)new RuntimeException("Failed to create EGL surface");
            }
            if (!EGL14.eglMakeCurrent((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (EGLSurface)this.eglSurface, (EGLContext)this.eglContext)) {
                throw (Throwable)new RuntimeException("Failed to make EGL context current");
            }
            object = "attribute vec4 a_position;\nattribute vec2 a_texCoord;\nvarying vec2 v_texCoord;\nvoid main() {\n    gl_Position = a_position;\n    v_texCoord = a_texCoord;\n}";
            object2 = "precision mediump float;\nuniform sampler2D u_texture;\nuniform float u_radius;\nuniform vec2 u_resolution;\nvarying vec2 v_texCoord;\n\nvoid main() {\n    vec2 texelSize = 1.0 / u_resolution;\n    vec4 color = vec4(0.0);\n    float total = 0.0;\n    \n    int radius = int(u_radius);\n    for (int x = -radius; x <= radius; x++) {\n        for (int y = -radius; y <= radius; y++) {\n            vec2 offset = vec2(float(x), float(y)) * texelSize;\n            float weight = 1.0 - (length(vec2(float(x), float(y))) / u_radius);\n            weight = max(weight, 0.0);\n            color += texture2D(u_texture, v_texCoord + offset) * weight;\n            total += weight;\n        }\n    }\n    \n    gl_FragColor = color / total;\n}";
            this.blurProgram = this.createShaderProgram((String)object, (String)object2);
            this.radiusLocation = GLES20.glGetUniformLocation((int)this.blurProgram, (String)"u_radius");
            this.resolutionLocation = GLES20.glGetUniformLocation((int)this.blurProgram, (String)"u_resolution");
            this.textureLocation = GLES20.glGetUniformLocation((int)this.blurProgram, (String)"u_texture");
            this.positionLocation = GLES20.glGetAttribLocation((int)this.blurProgram, (String)"a_position");
            this.texCoordLocation = GLES20.glGetAttribLocation((int)this.blurProgram, (String)"a_texCoord");
            this.blurTexture = new int[1];
            GLES20.glGenTextures((int)1, (int[])this.blurTexture, (int)0);
            if (this.blurTexture == null) {
                Intrinsics.throwNpe();
            }
            GLES20.glBindTexture((int)3553, (int)this.blurTexture[0]);
            GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
            GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
            GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
            GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)n2, (int)n3, (int)0, (int)6408, (int)5121, null);
            float[] fArray = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 1.0f, -1.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
            Buffer buffer = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer().put(fArray).position(0);
            if (buffer == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.nio.FloatBuffer");
            }
            this.vertexBuffer = (FloatBuffer)buffer;
            this.isOpenGLInitialized = true;
            Logger.INSTANCE.d(this.TAG, "OpenGL ES environment initialized successfully");
            return;
        }
        catch (Exception exception) {
            Logger.INSTANCE.exception(this.TAG, "Failed to initialize OpenGL ES environment", exception);
            this.cleanupOpenGLResources();
            throw (Throwable)exception;
        }
    }

    private final void cleanupOpenGLResources() {
        try {
            Object object;
            if (this.blurTexture != null) {
                object = this.blurTexture;
                GLES20.glDeleteTextures((int)1, (int[])object, (int)0);
                this.blurTexture = null;
            }
            if (this.blurProgram != 0) {
                GLES20.glDeleteProgram((int)this.blurProgram);
                this.blurProgram = 0;
            }
            EGLDisplay eGLDisplay = this.eglDisplay;
            if (eGLDisplay != null) {
                EGLSurface eGLSurface;
                object = eGLDisplay;
                EGLSurface eGLSurface2 = EGL14.EGL_NO_SURFACE;
                EGL14.eglMakeCurrent((EGLDisplay)eGLDisplay, (EGLSurface)eGLSurface2, (EGLSurface)eGLSurface2, (EGLContext)EGL14.EGL_NO_CONTEXT);
                EGLSurface eGLSurface3 = this.eglSurface;
                if (eGLSurface3 != null) {
                    eGLSurface = eGLSurface3;
                    EGL14.eglDestroySurface((EGLDisplay)object, (EGLSurface)eGLSurface);
                    this.eglSurface = null;
                }
                EGLContext eGLContext = this.eglContext;
                if (eGLContext != null) {
                    eGLSurface = eGLContext;
                    EGL14.eglDestroyContext((EGLDisplay)object, (EGLContext)eGLSurface);
                    this.eglContext = null;
                }
                EGL14.eglTerminate((EGLDisplay)object);
                this.eglDisplay = null;
            }
            this.vertexBuffer = null;
            this.isOpenGLInitialized = false;
            this.lastBitmapWidth = 0;
            this.lastBitmapHeight = 0;
            this.radiusLocation = -1;
            this.resolutionLocation = -1;
            this.textureLocation = -1;
            this.positionLocation = -1;
            this.texCoordLocation = -1;
            return;
        }
        catch (Exception exception) {
            Logger.INSTANCE.exception(this.TAG, "Failed to cleanup OpenGL ES resources", exception);
            return;
        }
    }

    private final int createShaderProgram(String string, String string2) {
        int n2 = this.loadShader(35633, string);
        int n3 = this.loadShader(35632, string2);
        int n4 = GLES20.glCreateProgram();
        GLES20.glAttachShader((int)n4, (int)n2);
        GLES20.glAttachShader((int)n4, (int)n3);
        GLES20.glLinkProgram((int)n4);
        int[] nArray = new int[1];
        GLES20.glGetProgramiv((int)n4, (int)35714, (int[])nArray, (int)0);
        if (nArray[0] != 1) {
            String string3 = GLES20.glGetProgramInfoLog((int)n4);
            GLES20.glDeleteProgram((int)n4);
            throw (Throwable)new RuntimeException("Failed to link shader program: ".concat(String.valueOf(string3)));
        }
        GLES20.glDeleteShader((int)n2);
        GLES20.glDeleteShader((int)n3);
        return n4;
    }

    private final int loadShader(int n2, String object) {
        n2 = GLES20.glCreateShader((int)n2);
        GLES20.glShaderSource((int)n2, (String)object);
        GLES20.glCompileShader((int)n2);
        object = new int[1];
        GLES20.glGetShaderiv((int)n2, (int)35713, (int[])object, (int)0);
        if (object[0] != true) {
            object = GLES20.glGetShaderInfoLog((int)n2);
            GLES20.glDeleteShader((int)n2);
            throw (Throwable)new RuntimeException("Failed to compile shader: ".concat(String.valueOf(object)));
        }
        return n2;
    }

    @NotNull
    public final Rect transformRect(@NotNull Rect rect, @NotNull Matrix matrix) {
        Intrinsics.checkParameterIsNotNull((Object)rect, (String)"rect");
        Intrinsics.checkParameterIsNotNull((Object)matrix, (String)"matrix");
        rect = new RectF(rect);
        matrix.mapRect((RectF)rect);
        matrix = new Rect();
        rect.round((Rect)matrix);
        return matrix;
    }

    public final void copyRectPixels(@NotNull Bitmap bitmap, @NotNull Bitmap bitmap2, @NotNull Rect rect) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmapA");
        Intrinsics.checkParameterIsNotNull((Object)bitmap2, (String)"bitmapB");
        Intrinsics.checkParameterIsNotNull((Object)rect, (String)"rect");
        if (!bitmap.isMutable() || !bitmap2.isMutable()) {
            throw (Throwable)new IllegalArgumentException("Both bitmaps must be mutable");
        }
        int n2 = bitmap.getWidth();
        int n3 = bitmap.getHeight();
        int n4 = bitmap2.getWidth();
        int n5 = bitmap2.getHeight();
        int n6 = RangesKt.coerceAtLeast((int)rect.left, (int)0);
        int n7 = RangesKt.coerceAtLeast((int)rect.top, (int)0);
        n2 = RangesKt.coerceAtMost((int)RangesKt.coerceAtMost((int)rect.right, (int)n2), (int)n4);
        int n8 = RangesKt.coerceAtMost((int)RangesKt.coerceAtMost((int)rect.bottom, (int)n3), (int)n5);
        n3 = n2 - n6;
        n4 = n8 - n7;
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        new Canvas(bitmap2).drawBitmap(bitmap, new Rect(n6, n7, n2, n8), new Rect(n6, n7, n2, n8), null);
    }

    public final void capture() {
        if (!this.isCapturing.get()) {
            Logger.INSTANCE.d(this.TAG, "ScreenshotRecorder is paused, not capturing screenshot");
            return;
        }
        if (!this.contentChanged.get() && this.lastCaptureSuccessful.get()) {
            ScreenshotRecorderCallback screenshotRecorderCallback2 = this.screenshotRecorderCallback;
            if (screenshotRecorderCallback2 != null) {
                Bitmap bitmap = this.lastBlurScreenshot;
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"lastBlurScreenshot");
                screenshotRecorderCallback2.onScreenshotRecorded(bitmap, false);
            }
            Logger.INSTANCE.d(this.TAG, "Screenshot is unchanged, not capturing screenshot");
            return;
        }
        WeakReference<View> weakReference = this.rootView;
        Object object = weakReference != null ? (View)weakReference.get() : null;
        if (object == null || object.getWidth() <= 0 || object.getHeight() <= 0 || !object.isShown()) {
            Logger.INSTANCE.d(this.TAG, "Root view is invalid, not capturing screenshot");
            return;
        }
        Window window = WindowsKt.a(object);
        if (window == null) {
            Logger.INSTANCE.d(this.TAG, "Window is invalid, not capturing screenshot");
            return;
        }
        this.mainLooperHandler.post((Function0<Unit>)((Function0)new Function0<Unit>(this, window, object){
            final /* synthetic */ ScreenshotRecorder this$0;
            final /* synthetic */ Window $window;
            final /* synthetic */ View $root;

            public final void invoke() {
                try {
                    ScreenshotRecorder.access$getContentChanged$p(this.this$0).set(false);
                    PixelCopy.request((Window)this.$window, (Bitmap)ScreenshotRecorder.access$getScreenshot$p(this.this$0), (PixelCopy.OnPixelCopyFinishedListener)new PixelCopy.OnPixelCopyFinishedListener(this){
                        final /* synthetic */ capture.1 this$0;

                        public final void onPixelCopyFinished(int n2) {
                            if (n2 != 0) {
                                Logger.INSTANCE.i(ScreenshotRecorder.access$getTAG$p(this.this$0.this$0), "Failed to capture replay recording: ".concat(String.valueOf(n2)));
                                ScreenshotRecorder.access$getLastCaptureSuccessful$p(this.this$0.this$0).set(false);
                                return;
                            }
                            if (ScreenshotRecorder.access$getContentChanged$p(this.this$0.this$0).get()) {
                                Logger.INSTANCE.i(ScreenshotRecorder.access$getTAG$p(this.this$0.this$0), "Failed to determine view hierarchy, not capturing");
                                ScreenshotRecorder.access$getLastCaptureSuccessful$p(this.this$0.this$0).set(false);
                                return;
                            }
                            ViewHierarchyNode viewHierarchyNode = ViewHierarchyNode.Companion.a(this.this$0.$root, null, 0, this.this$0.this$0.getOptions());
                            ViewsKt.a(this.this$0.$root, viewHierarchyNode, this.this$0.this$0.getOptions());
                            ExecutorsKt.submitSafely(ScreenshotRecorder.access$getRecorder$p(this.this$0.this$0), "screenshot_recorder.mask", new Runnable(this, viewHierarchyNode){
                                final /* synthetic */ capture.1 this$0;
                                final /* synthetic */ ViewHierarchyNode $viewHierarchy;

                                public final void run() {
                                    ScreenshotRecorder screenshotRecorder = this.this$0.this$0.this$0;
                                    Bitmap bitmap = ScreenshotRecorder.access$getScreenshot$p(this.this$0.this$0.this$0);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"screenshot");
                                    Bitmap bitmap2 = screenshotRecorder.blurBitmap(bitmap, 5.0f);
                                    try {
                                        this.$viewHierarchy.traverse((Function1<? super ViewHierarchyNode, Boolean>)((Function1)new Function1<ViewHierarchyNode, Boolean>(this, bitmap2){
                                            final /* synthetic */ capture.1 this$0;
                                            final /* synthetic */ Bitmap $blurscreenshot;

                                            public final /* synthetic */ Object invoke(Object object) {
                                                return this.invoke((ViewHierarchyNode)object);
                                            }

                                            public final boolean invoke(@NotNull ViewHierarchyNode object3) {
                                                Intrinsics.checkParameterIsNotNull((Object)object3, (String)"node");
                                                if (!((ViewHierarchyNode)object3).getShouldMask() && ((ViewHierarchyNode)object3).getWidth() > 0 && ((ViewHierarchyNode)object3).getHeight() > 0) {
                                                    Pair pair;
                                                    if (((ViewHierarchyNode)object3).getVisibleRect() == null) {
                                                        return false;
                                                    }
                                                    if (object3 instanceof ViewHierarchyNode.TextViewHierarchyNode) {
                                                        Object object2 = ((ViewHierarchyNode.TextViewHierarchyNode)object3).getLayout();
                                                        if (object2 == null || (object2 = object2.getDominantTextColor()) == null) {
                                                            object2 = ((ViewHierarchyNode.TextViewHierarchyNode)object3).getDominantColor();
                                                        }
                                                        int n2 = object2 != null ? (Integer)object2 : -16777216;
                                                        pair = TuplesKt.to(ViewsKt.a(((ViewHierarchyNode.TextViewHierarchyNode)object3).getLayout(), ((ViewHierarchyNode)object3).getVisibleRect(), ((ViewHierarchyNode.TextViewHierarchyNode)object3).getPaddingLeft(), ((ViewHierarchyNode.TextViewHierarchyNode)object3).getPaddingTop()), (Object)n2);
                                                    } else {
                                                        pair = TuplesKt.to((Object)CollectionsKt.listOf((Object)((ViewHierarchyNode)object3).getVisibleRect()), (Object)-16777216);
                                                    }
                                                    Pair pair2 = pair;
                                                    object3 = (List)pair.component1();
                                                    ((Number)pair2.component2()).intValue();
                                                    for (Object object3 : (Iterable)object3) {
                                                        ScreenshotRecorder screenshotRecorder = this.this$0.this$0.this$0.this$0;
                                                        Bitmap bitmap = ScreenshotRecorder.access$getScreenshot$p(this.this$0.this$0.this$0.this$0);
                                                        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"screenshot");
                                                        screenshotRecorder.copyRectPixels(bitmap, this.$blurscreenshot, this.this$0.this$0.this$0.this$0.transformRect((Rect)object3, ScreenshotRecorder.access$getPrescaledMatrix$p(this.this$0.this$0.this$0.this$0)));
                                                    }
                                                }
                                                return true;
                                            }
                                            {
                                                this.this$0 = var1_1;
                                                this.$blurscreenshot = bitmap;
                                                super(1);
                                            }
                                        }));
                                        new Canvas(ScreenshotRecorder.access$getLastBlurScreenshot$p(this.this$0.this$0.this$0)).drawBitmap(bitmap2, 0.0f, 0.0f, null);
                                        ScreenshotRecorderCallback screenshotRecorderCallback2 = ScreenshotRecorder.access$getScreenshotRecorderCallback$p(this.this$0.this$0.this$0);
                                        if (screenshotRecorderCallback2 != null) {
                                            screenshotRecorderCallback2.onScreenshotRecorded(bitmap2, true);
                                        }
                                        ScreenshotRecorder.access$getLastCaptureSuccessful$p(this.this$0.this$0.this$0).set(true);
                                        ScreenshotRecorder.access$getContentChanged$p(this.this$0.this$0.this$0).set(false);
                                        return;
                                    }
                                    catch (Exception exception) {
                                        Logger.INSTANCE.exception(ScreenshotRecorder.access$getTAG$p(this.this$0.this$0.this$0), "Failed to process blur screenshot", exception);
                                        if (!bitmap2.isRecycled()) {
                                            bitmap2.recycle();
                                        }
                                        ScreenshotRecorder.access$getLastCaptureSuccessful$p(this.this$0.this$0.this$0).set(false);
                                        return;
                                    }
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$viewHierarchy = viewHierarchyNode;
                                }
                            });
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    }, (Handler)ScreenshotRecorder.access$getMainLooperHandler$p(this.this$0).getHandler());
                    return;
                }
                catch (Throwable throwable) {
                    Logger.INSTANCE.exception(ScreenshotRecorder.access$getTAG$p(this.this$0), "Failed to capture replay recording", throwable);
                    ScreenshotRecorder.access$getLastCaptureSuccessful$p(this.this$0).set(false);
                    return;
                }
            }
            {
                this.this$0 = screenshotRecorder;
                this.$window = window;
                this.$root = view;
                super(0);
            }
        }));
    }

    public final void onDraw() {
        WeakReference<View> weakReference = this.rootView;
        Object object = weakReference != null ? (View)weakReference.get() : null;
        if (object == null || object.getWidth() <= 0 || object.getHeight() <= 0 || !object.isShown()) {
            Logger.INSTANCE.d(this.TAG, "Root view is invalid, not capturing screenshot");
            return;
        }
        this.contentChanged.set(true);
    }

    public final void bind(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"root");
        ScreenshotRecorder screenshotRecorder = this;
        WeakReference<View> weakReference = screenshotRecorder.rootView;
        screenshotRecorder.unbind((View)(weakReference != null ? (View)weakReference.get() : null));
        WeakReference<View> weakReference2 = this.rootView;
        if (weakReference2 != null) {
            weakReference2.clear();
        }
        this.rootView = new WeakReference<View>(view);
        ViewsKt.a(view, this);
        this.contentChanged.set(true);
    }

    public final void unbind(@Nullable View view) {
        View view2 = view;
        if (view2 != null) {
            ViewsKt.b(view2, this);
            return;
        }
    }

    public final void pause() {
        this.isCapturing.set(false);
        ScreenshotRecorder screenshotRecorder = this;
        WeakReference<View> weakReference = screenshotRecorder.rootView;
        screenshotRecorder.unbind((View)(weakReference != null ? (View)weakReference.get() : null));
    }

    public final void resume() {
        View view = this.rootView;
        if (view != null && (view = (View)view.get()) != null) {
            ViewsKt.a(view, this);
        }
        this.isCapturing.set(true);
    }

    public final void close() {
        ScreenshotRecorder screenshotRecorder = this;
        WeakReference<View> weakReference = screenshotRecorder.rootView;
        screenshotRecorder.unbind((View)(weakReference != null ? (View)weakReference.get() : null));
        WeakReference<View> weakReference2 = this.rootView;
        if (weakReference2 != null) {
            weakReference2.clear();
        }
        Bitmap bitmap = this.screenshot;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"screenshot");
        if (!bitmap.isRecycled()) {
            this.screenshot.recycle();
        }
        Bitmap bitmap2 = this.lastBlurScreenshot;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"lastBlurScreenshot");
        if (!bitmap2.isRecycled()) {
            this.lastBlurScreenshot.recycle();
        }
        this.cleanupOpenGLResources();
        this.isCapturing.set(false);
    }

    private final int dominantColorForRect(@NotNull Bitmap bitmap, Rect rect) {
        rect = new Rect(rect);
        RectF rectF = new RectF(rect);
        this.getPrescaledMatrix().mapRect(rectF);
        rectF.round(rect);
        this.getSinglePixelBitmapCanvas().drawBitmap(bitmap, rect, new Rect(0, 0, 1, 1), null);
        return this.getSinglePixelBitmap().getPixel(0, 0);
    }

    @NotNull
    public final ScreenshotRecorderConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final BuglyReplayOptions getOptions() {
        return this.options;
    }

    public ScreenshotRecorder(@NotNull ScreenshotRecorderConfig screenshotRecorderConfig, @NotNull BuglyReplayOptions buglyReplayOptions, @NotNull MainLooperHandler mainLooperHandler, @NotNull ScheduledExecutorService scheduledExecutorService, @Nullable ScreenshotRecorderCallback screenshotRecorderCallback2) {
        Intrinsics.checkParameterIsNotNull((Object)screenshotRecorderConfig, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)buglyReplayOptions, (String)"options");
        Intrinsics.checkParameterIsNotNull((Object)mainLooperHandler, (String)"mainLooperHandler");
        Intrinsics.checkParameterIsNotNull((Object)scheduledExecutorService, (String)"recorder");
        this.config = screenshotRecorderConfig;
        this.options = buglyReplayOptions;
        this.mainLooperHandler = mainLooperHandler;
        this.recorder = scheduledExecutorService;
        this.screenshotRecorderCallback = screenshotRecorderCallback2;
        this.maskingPaint$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)maskingPaint.2.INSTANCE);
        this.TAG = "ScreenshotRecorder";
        this.singlePixelBitmap$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)singlePixelBitmap.2.INSTANCE);
        this.screenshot = Bitmap.createBitmap((int)this.config.getRecordingWidth(), (int)this.config.getRecordingHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.lastBlurScreenshot = Bitmap.createBitmap((int)this.config.getRecordingWidth(), (int)this.config.getRecordingHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.singlePixelBitmapCanvas$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Canvas>(this){
            final /* synthetic */ ScreenshotRecorder this$0;

            @NotNull
            public final Canvas invoke() {
                return new Canvas(ScreenshotRecorder.access$getSinglePixelBitmap$p(this.this$0));
            }
            {
                this.this$0 = screenshotRecorder;
                super(0);
            }
        }));
        this.prescaledMatrix$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Matrix>(this){
            final /* synthetic */ ScreenshotRecorder this$0;

            @NotNull
            public final Matrix invoke() {
                Matrix matrix = new Matrix();
                matrix.preScale(this.this$0.getConfig().getScaleFactorX(), this.this$0.getConfig().getScaleFactorY());
                return matrix;
            }
            {
                this.this$0 = screenshotRecorder;
                super(0);
            }
        }));
        this.contentChanged = new AtomicBoolean(false);
        this.isCapturing = new AtomicBoolean(true);
        this.lastCaptureSuccessful = new AtomicBoolean(false);
        this.radiusLocation = -1;
        this.resolutionLocation = -1;
        this.textureLocation = -1;
        this.positionLocation = -1;
        this.texCoordLocation = -1;
    }

    public static final /* synthetic */ AtomicBoolean access$getContentChanged$p(ScreenshotRecorder screenshotRecorder) {
        return screenshotRecorder.contentChanged;
    }

    public static final /* synthetic */ Bitmap access$getScreenshot$p(ScreenshotRecorder screenshotRecorder) {
        return screenshotRecorder.screenshot;
    }

    public static final /* synthetic */ String access$getTAG$p(ScreenshotRecorder screenshotRecorder) {
        return screenshotRecorder.TAG;
    }

    public static final /* synthetic */ AtomicBoolean access$getLastCaptureSuccessful$p(ScreenshotRecorder screenshotRecorder) {
        return screenshotRecorder.lastCaptureSuccessful;
    }

    public static final /* synthetic */ ScheduledExecutorService access$getRecorder$p(ScreenshotRecorder screenshotRecorder) {
        return screenshotRecorder.recorder;
    }

    public static final /* synthetic */ Matrix access$getPrescaledMatrix$p(ScreenshotRecorder screenshotRecorder) {
        return screenshotRecorder.getPrescaledMatrix();
    }

    public static final /* synthetic */ Bitmap access$getLastBlurScreenshot$p(ScreenshotRecorder screenshotRecorder) {
        return screenshotRecorder.lastBlurScreenshot;
    }

    public static final /* synthetic */ ScreenshotRecorderCallback access$getScreenshotRecorderCallback$p(ScreenshotRecorder screenshotRecorder) {
        return screenshotRecorder.screenshotRecorderCallback;
    }

    public static final /* synthetic */ MainLooperHandler access$getMainLooperHandler$p(ScreenshotRecorder screenshotRecorder) {
        return screenshotRecorder.mainLooperHandler;
    }

    public static final /* synthetic */ Bitmap access$getSinglePixelBitmap$p(ScreenshotRecorder screenshotRecorder) {
        return screenshotRecorder.getSinglePixelBitmap();
    }
}

