/*
 * Decompiled with CFR 0.152.
 */
package com.tempos21.android.commons.utils;

import android.content.Context;
import android.util.Log;
import com.tempos21.android.commons.utils.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

class FileLogger
extends Logger {
    private static final String T21_LOG_TAG = "T21Log";
    private static final String SLASH = "/";
    private static final String COLON = ":";
    private static final String DATE_TIME_FORMAT = "yyyy/MM/dd HH:mm:ss.SSS";
    private static final String LINE_SEPARATOR_PROPERTY = "line.separator";
    private static final String LOG_PATH = "logs";
    private static final String LOG_FILE_NAME = "T21Log.log";
    private static File logFile;
    private static boolean ENABLED;

    FileLogger() {
    }

    static void initialize(String tag, boolean enabled, Context context) {
        Logger.initialize(tag);
        ENABLED = enabled;
        File logsPath = new File(context.getFilesDir(), LOG_PATH);
        if (logsPath.exists() || !logsPath.exists() && logsPath.mkdir()) {
            logFile = new File(logsPath, LOG_FILE_NAME);
            try {
                if (!logFile.exists()) {
                    logFile.createNewFile();
                }
            }
            catch (IOException e) {
                ENABLED = false;
                Log.e((String)T21_LOG_TAG, (String)("Unable to create log file '" + logFile.getName() + "'. Logging to file disabled.\n" + e));
            }
        } else {
            ENABLED = false;
            Log.e((String)T21_LOG_TAG, (String)"Unable to create 'logs' directory. Logging to file disabled");
        }
    }

    static File getLogFile() {
        return logFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(LogLevel logLevel, String logTag, String message) {
        if (logFile != null) {
            FileOutputStream fileOutStream = null;
            OutputStreamWriter outStreamWriter = null;
            try {
                fileOutStream = new FileOutputStream(logFile, true);
                outStreamWriter = new OutputStreamWriter(fileOutStream);
                StringBuilder sb = new StringBuilder();
                Calendar now = Calendar.getInstance();
                SimpleDateFormat formatter = new SimpleDateFormat(DATE_TIME_FORMAT, Locale.getDefault());
                sb.append(formatter.format(now.getTime()));
                sb.append(FileLogger.getBlank());
                sb.append((Object)logLevel);
                sb.append(SLASH);
                sb.append(logTag);
                sb.append(COLON);
                sb.append(FileLogger.getBlank());
                sb.append(message);
                sb.append(System.getProperty(LINE_SEPARATOR_PROPERTY));
                outStreamWriter.append(sb.toString());
                fileOutStream.flush();
            }
            catch (IOException e) {
                Log.e((String)T21_LOG_TAG, (String)("File write failed: " + e.toString()));
            }
            finally {
                try {
                    if (outStreamWriter != null) {
                        outStreamWriter.close();
                    }
                    if (fileOutStream != null) {
                        fileOutStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    static void v(Object ... verbose) {
        if (ENABLED) {
            FileLogger.writeToFile(LogLevel.V, FileLogger.getLogTag(), FileLogger.getLog(verbose));
        }
    }

    static void d(Object ... debug) {
        if (ENABLED) {
            FileLogger.writeToFile(LogLevel.D, FileLogger.getLogTag(), FileLogger.getLog(debug));
        }
    }

    static void i(Object ... info) {
        if (ENABLED) {
            FileLogger.writeToFile(LogLevel.I, FileLogger.getLogTag(), FileLogger.getLog(info));
        }
    }

    static void w(Object ... warning) {
        if (ENABLED) {
            FileLogger.writeToFile(LogLevel.W, FileLogger.getLogTag(), FileLogger.getLog(warning));
        }
    }

    static void e(Object ... error) {
        if (ENABLED) {
            FileLogger.writeToFile(LogLevel.E, FileLogger.getLogTag(), FileLogger.getLog(error));
        }
    }

    static {
        ENABLED = false;
    }

    private static enum LogLevel {
        V,
        D,
        I,
        W,
        E;

    }
}

