/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.mcp.server.tool.execution;

import com.taobao.arthas.mcp.server.tool.execution.ToolExecutionException;
import com.taobao.arthas.mcp.server.tool.execution.ToolExecutionExceptionProcessor;
import com.taobao.arthas.mcp.server.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultToolExecutionExceptionProcessor
implements ToolExecutionExceptionProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultToolExecutionExceptionProcessor.class);
    private static final boolean DEFAULT_ALWAYS_THROW = false;
    private final boolean alwaysThrow;

    public DefaultToolExecutionExceptionProcessor(boolean alwaysThrow) {
        this.alwaysThrow = alwaysThrow;
    }

    @Override
    public String process(ToolExecutionException exception) {
        Assert.notNull(exception, "exception cannot be null");
        if (this.alwaysThrow) {
            throw exception;
        }
        logger.debug("Exception thrown by tool: {}. Message: {}", (Object)exception.getToolDefinition().getName(), (Object)exception.getMessage());
        return exception.getMessage();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean alwaysThrow = false;

        public Builder alwaysThrow(boolean alwaysThrow) {
            this.alwaysThrow = alwaysThrow;
            return this;
        }

        public DefaultToolExecutionExceptionProcessor build() {
            return new DefaultToolExecutionExceptionProcessor(this.alwaysThrow);
        }
    }
}

