/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.asm.inst.impl;

import com.alibaba.bytekit.agent.inst.InstrumentApi;
import com.alibaba.bytekit.asm.MethodProcessor;
import com.alibaba.bytekit.utils.AsmOpUtils;
import com.alibaba.bytekit.utils.AsmUtils;
import com.alibaba.deps.org.objectweb.asm.Type;
import com.alibaba.deps.org.objectweb.asm.commons.Method;
import com.alibaba.deps.org.objectweb.asm.tree.AbstractInsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.InsnList;
import com.alibaba.deps.org.objectweb.asm.tree.InsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.MethodInsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.MethodNode;
import com.alibaba.deps.org.objectweb.asm.tree.TypeInsnNode;
import java.util.List;

public class InstrumentImpl {
    public static MethodNode replaceInvokeOrigin(String originOwner, MethodNode originMethodNode, MethodNode apmMethodNode) {
        List<MethodInsnNode> methodInsnNodes = AsmUtils.findMethodInsnNode(apmMethodNode, InstrumentApi.class.getName().replace('.', '/'), "invokeOrigin", "()Ljava/lang/Object;");
        Type originReturnType = Type.getMethodType(originMethodNode.desc).getReturnType();
        for (MethodInsnNode methodInsnNode : methodInsnNodes) {
            int opcode;
            InsnList instructions = new InsnList();
            AbstractInsnNode secondInsnNode = methodInsnNode.getNext();
            boolean isStatic = AsmUtils.isStatic(originMethodNode);
            int n = opcode = isStatic ? 184 : 182;
            if (!isStatic) {
                AsmOpUtils.loadThis(instructions);
            }
            AsmOpUtils.loadArgs(instructions, originMethodNode);
            MethodInsnNode originMethodInsnNode = new MethodInsnNode(opcode, originOwner, originMethodNode.name, originMethodNode.desc, false);
            instructions.add(originMethodInsnNode);
            int sort = originReturnType.getSort();
            if (sort == 0) {
                if (secondInsnNode != null) {
                    if (secondInsnNode.getOpcode() == 87) {
                        apmMethodNode.instructions.remove(secondInsnNode);
                    } else {
                        AsmOpUtils.pushNUll(instructions);
                    }
                }
            } else if (sort >= 1 && sort <= 8) {
                if (secondInsnNode.getOpcode() == 87) {
                    if (originReturnType.getSize() == 2) {
                        apmMethodNode.instructions.insert(secondInsnNode, new InsnNode(88));
                        apmMethodNode.instructions.remove(secondInsnNode);
                    }
                } else {
                    boolean removeCheckCast = false;
                    if (secondInsnNode.getOpcode() == 192) {
                        AbstractInsnNode thridInsnNode;
                        TypeInsnNode typeInsnNode = (TypeInsnNode)secondInsnNode;
                        Type boxedType = AsmOpUtils.getBoxedType(originReturnType);
                        if (Type.getObjectType(typeInsnNode.desc).equals(boxedType) && (thridInsnNode = secondInsnNode.getNext()) != null && thridInsnNode.getOpcode() == 182) {
                            MethodInsnNode valueInsnNode = (MethodInsnNode)thridInsnNode;
                            Method unBoxMethod = AsmOpUtils.getUnBoxMethod(originReturnType);
                            if (unBoxMethod.getDescriptor().equals(valueInsnNode.desc) && valueInsnNode.owner.equals(boxedType.getInternalName())) {
                                apmMethodNode.instructions.remove(thridInsnNode);
                                apmMethodNode.instructions.remove(secondInsnNode);
                                removeCheckCast = true;
                            }
                        }
                    }
                    if (!removeCheckCast) {
                        AsmOpUtils.box(instructions, originReturnType);
                    }
                }
            } else if (secondInsnNode.getOpcode() == 192) {
                TypeInsnNode typeInsnNode = (TypeInsnNode)secondInsnNode;
                if (Type.getObjectType(typeInsnNode.desc).equals(originReturnType)) {
                    apmMethodNode.instructions.remove(secondInsnNode);
                }
            }
            apmMethodNode.instructions.insertBefore((AbstractInsnNode)methodInsnNode, instructions);
            apmMethodNode.instructions.remove(methodInsnNode);
        }
        MethodProcessor methodProcessor = new MethodProcessor(originOwner, apmMethodNode);
        methodProcessor.inline(originOwner, originMethodNode, false);
        return apmMethodNode;
    }
}

