/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.asm.matcher;

import com.alibaba.bytekit.asm.matcher.ClassMatcher;
import com.alibaba.bytekit.asm.meta.ClassMetaService;
import com.alibaba.bytekit.utils.AsmUtils;
import com.alibaba.bytekit.utils.ClassLoaderUtils;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SimpleSubclassMatcher
implements ClassMatcher {
    private Set<String> classNames = new HashSet<String>();
    private Set<String> internalClassNames = new HashSet<String>();

    public SimpleSubclassMatcher(String ... className) {
        for (String name : className) {
            this.add(name);
        }
    }

    public SimpleSubclassMatcher(Collection<String> names) {
        for (String name : names) {
            this.add(name);
        }
    }

    private void add(String name) {
        this.classNames.add(name);
        this.internalClassNames.add(AsmUtils.internalClassName(name));
    }

    @Override
    public boolean match(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        loader = ClassLoaderUtils.wrap(loader);
        if (classBeingRedefined != null) {
            return this.match(classBeingRedefined);
        }
        List<String> allSuperNames = ClassMetaService.allSuperNames(loader, className, classfileBuffer);
        for (String superName : allSuperNames) {
            if (!this.internalClassNames.contains(superName)) continue;
            return true;
        }
        return false;
    }

    private boolean match(Class<?> clazz) {
        Class<?> superclass = clazz;
        while (superclass != null && !Object.class.equals(superclass)) {
            if (this.classNames != null && this.classNames.contains(superclass.getName().replace('/', '.'))) {
                return true;
            }
            superclass = superclass.getSuperclass();
        }
        return false;
    }
}

