/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.nat.agent.core;

import com.alibaba.arthas.nat.agent.core.ArthasHomeHandler;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvmAttachmentHandler {
    private static final Logger logger = LoggerFactory.getLogger(JvmAttachmentHandler.class);
    private static final String ARTHAS_AGENT_JAR = "arthas-agent.jar";

    public static String attachJvmByPid(Integer pid) throws Exception {
        VirtualMachine vm = null;
        try {
            vm = VirtualMachine.attach(pid + "");
        }
        catch (AttachNotSupportedException e) {
            logger.error("attach pid failed");
            throw new RuntimeException("attach pid: " + pid + " failed " + e.getMessage());
        }
        if (ArthasHomeHandler.ARTHAS_HOME_DIR == null) {
            ArthasHomeHandler.findArthasHome();
        }
        if (ArthasHomeHandler.ARTHAS_HOME_DIR == null) {
            throw new RuntimeException("arthas home was not found");
        }
        String agentPath = ArthasHomeHandler.ARTHAS_HOME_DIR + File.separator + ARTHAS_AGENT_JAR;
        try {
            String args2 = ";httpPort=8563;javaPid=" + pid + ";ip=localhost";
            vm.loadAgent(agentPath, args2);
            logger.info("attach pid " + pid + " success, http server port is: " + 8563);
        }
        catch (Exception e) {
            logger.error("attach pid " + pid + " success, http server port is: " + 8563);
            throw new Exception("load agent failed, pid: " + pid + " " + e.getMessage());
        }
        finally {
            vm.detach();
        }
        return String.valueOf(8563);
    }
}

