/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.perfdata.monitor.protocol.rmi;

import java.nio.ByteBuffer;
import java.rmi.RemoteException;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.remote.RemoteVm;
import sun.jvmstat.perfdata.monitor.AbstractPerfDataBuffer;

public class PerfDataBuffer
extends AbstractPerfDataBuffer {
    private RemoteVm rvm;

    public PerfDataBuffer(RemoteVm rvm, int lvmid) throws MonitorException {
        this.rvm = rvm;
        try {
            ByteBuffer buffer = ByteBuffer.allocate(rvm.getCapacity());
            this.sample(buffer);
            this.createPerfDataBuffer(buffer, lvmid);
        }
        catch (RemoteException e) {
            throw new MonitorException("Could not read data for remote JVM " + lvmid, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sample(ByteBuffer buffer) throws RemoteException {
        assert (buffer != null);
        assert (this.rvm != null);
        ByteBuffer byteBuffer = buffer;
        synchronized (byteBuffer) {
            buffer.clear();
            buffer.put(this.rvm.getBytes());
        }
    }
}

