/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.perfdata.monitor.protocol.local;

import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.VmIdentifier;
import sun.jvmstat.monitor.event.MonitorStatusChangeEvent;
import sun.jvmstat.monitor.event.VmEvent;
import sun.jvmstat.monitor.event.VmListener;
import sun.jvmstat.perfdata.monitor.AbstractMonitoredVm;
import sun.jvmstat.perfdata.monitor.CountedTimerTask;
import sun.jvmstat.perfdata.monitor.CountedTimerTaskUtils;
import sun.jvmstat.perfdata.monitor.MonitorStatus;
import sun.jvmstat.perfdata.monitor.protocol.local.LocalEventTimer;
import sun.jvmstat.perfdata.monitor.protocol.local.PerfDataBuffer;

public class LocalMonitoredVm
extends AbstractMonitoredVm {
    private ArrayList<VmListener> listeners;
    private NotifierTask task;

    public LocalMonitoredVm(VmIdentifier vmid, int interval) throws MonitorException {
        super(vmid, interval);
        this.pdb = new PerfDataBuffer(vmid);
        this.listeners = new ArrayList();
    }

    @Override
    public void detach() {
        if (this.interval > 0 && this.task != null) {
            this.task.cancel();
            this.task = null;
        }
        super.detach();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addVmListener(VmListener l) {
        ArrayList<VmListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(l);
            if (this.task == null) {
                this.task = new NotifierTask();
                LocalEventTimer timer = LocalEventTimer.getInstance();
                timer.schedule((TimerTask)this.task, this.interval, (long)this.interval);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeVmListener(VmListener l) {
        ArrayList<VmListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(l);
            if (this.listeners.isEmpty() && this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInterval(int newInterval) {
        ArrayList<VmListener> arrayList = this.listeners;
        synchronized (arrayList) {
            if (newInterval == this.interval) {
                return;
            }
            int oldInterval = this.interval;
            super.setInterval(newInterval);
            if (this.task != null) {
                this.task.cancel();
                NotifierTask oldTask = this.task;
                this.task = new NotifierTask();
                LocalEventTimer timer = LocalEventTimer.getInstance();
                CountedTimerTaskUtils.reschedule(timer, oldTask, this.task, oldInterval, newInterval);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireMonitorStatusChangedEvents(List inserted, List removed) {
        MonitorStatusChangeEvent ev = null;
        ArrayList registered = null;
        ArrayList<VmListener> arrayList = this.listeners;
        synchronized (arrayList) {
            registered = (ArrayList)this.listeners.clone();
        }
        for (VmListener l : registered) {
            if (ev == null) {
                ev = new MonitorStatusChangeEvent(this, inserted, removed);
            }
            l.monitorStatusChanged(ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireMonitorsUpdatedEvents() {
        VmEvent ev = null;
        ArrayList registered = null;
        ArrayList<VmListener> arrayList = this.listeners;
        synchronized (arrayList) {
            registered = (ArrayList)LocalMonitoredVm.cast(this.listeners.clone());
        }
        for (VmListener l : registered) {
            if (ev == null) {
                ev = new VmEvent(this);
            }
            l.monitorsUpdated(ev);
        }
    }

    static <T> T cast(Object x) {
        return (T)x;
    }

    private class NotifierTask
    extends CountedTimerTask {
        private NotifierTask() {
        }

        @Override
        public void run() {
            super.run();
            try {
                MonitorStatus status = LocalMonitoredVm.this.getMonitorStatus();
                List inserted = status.getInserted();
                List removed = status.getRemoved();
                if (!inserted.isEmpty() || !removed.isEmpty()) {
                    LocalMonitoredVm.this.fireMonitorStatusChangedEvents(inserted, removed);
                }
                LocalMonitoredVm.this.fireMonitorsUpdatedEvents();
            }
            catch (MonitorException e) {
                System.err.println("Exception updating monitors for " + LocalMonitoredVm.this.getVmIdentifier());
                e.printStackTrace();
            }
        }
    }
}

