/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.command.internal;

import com.taobao.arthas.core.shell.cli.CliToken;
import com.taobao.arthas.core.shell.command.internal.StatisticsFunction;
import com.taobao.arthas.core.shell.command.internal.StdoutHandler;
import com.taobao.middleware.cli.CLIs;
import com.taobao.middleware.cli.CommandLine;
import com.taobao.middleware.cli.Option;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class WordCountHandler
extends StdoutHandler
implements StatisticsFunction {
    public static final String NAME = "wc";
    private boolean lineMode;
    private String result = null;
    private final AtomicInteger total = new AtomicInteger(0);

    public static StdoutHandler inject(List<CliToken> tokens) {
        List<String> args2 = StdoutHandler.parseArgs(tokens, NAME);
        CommandLine commandLine = CLIs.create(NAME).addOption(new Option().setShortName("l").setFlag(true)).parse(args2);
        boolean lineMode = commandLine.isFlagEnabled("l");
        return new WordCountHandler(lineMode);
    }

    private WordCountHandler(boolean lineMode) {
        this.lineMode = lineMode;
    }

    @Override
    public String apply(String input) {
        if (!this.lineMode) {
            this.result = "wc currently only support wc -l!\n";
        } else if (input != null && !"".equals(input.trim())) {
            this.total.getAndAdd(input.split("\n").length);
        }
        return null;
    }

    @Override
    public String result() {
        if (this.result != null) {
            return this.result;
        }
        return this.total.get() + "\n";
    }
}

