/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.List;
import ognl.ASTChain;
import ognl.ASTConst;
import ognl.ASTProperty;
import ognl.ASTRootVarRef;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlOps;
import ognl.OgnlParser;
import ognl.OgnlRuntime;
import ognl.SimpleNode;
import ognl.TypeConverter;
import ognl.enhance.ExpressionCompiler;

public class ASTCtor
extends SimpleNode {
    private static final long serialVersionUID = -218799350410195779L;
    private String className;
    private boolean isArray;

    public ASTCtor(int id) {
        super(id);
    }

    public ASTCtor(OgnlParser p, int id) {
        super(p, id);
    }

    void setClassName(String className) {
        this.className = className;
    }

    Class<?> getCreatedClass(OgnlContext context) throws ClassNotFoundException {
        return OgnlRuntime.classForName(context, this.className);
    }

    void setArray(boolean value) {
        this.isArray = value;
    }

    public boolean isArray() {
        return this.isArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Object getValueBody(OgnlContext context, Object source2) throws OgnlException {
        Object root = context.getRoot();
        int count = this.jjtGetNumChildren();
        Object[] args2 = new Object[count];
        for (int i = 0; i < count; ++i) {
            args2[i] = this.children[i].getValue(context, root);
        }
        if (!this.isArray) return OgnlRuntime.callConstructor(context, this.className, args2);
        if (args2.length != 1) throw new OgnlException("only expect array size or fixed initializer list");
        try {
            int size;
            Class componentClass = OgnlRuntime.classForName(context, this.className);
            List sourceList = null;
            if (args2[0] instanceof List) {
                sourceList = (List)args2[0];
                size = sourceList.size();
            } else {
                size = (int)OgnlOps.longValue(args2[0]);
            }
            Object result = Array.newInstance(componentClass, size);
            if (sourceList == null) return result;
            TypeConverter converter = context.getTypeConverter();
            int i = 0;
            int icount = sourceList.size();
            while (i < icount) {
                Object o = sourceList.get(i);
                if (o == null || componentClass.isInstance(o)) {
                    Array.set(result, i, o);
                } else {
                    Array.set(result, i, converter.convertValue(context, null, null, null, o, componentClass));
                }
                ++i;
            }
            return result;
        }
        catch (ClassNotFoundException ex) {
            throw new OgnlException("array component class '" + this.className + "' not found", ex);
        }
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder("new " + this.className);
        if (this.isArray) {
            if (this.children[0] instanceof ASTConst) {
                result.append("[").append(this.children[0]).append("]");
            } else {
                result.append("[] ").append(this.children[0]);
            }
        } else {
            result.append("(");
            if (this.children != null && this.children.length > 0) {
                for (int i = 0; i < this.children.length; ++i) {
                    if (i > 0) {
                        result.append(", ");
                    }
                    result.append(this.children[i]);
                }
            }
            result.append(")");
        }
        return result.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toGetSourceString(OgnlContext context, Object target) {
        Object ctorValue;
        Class clazz;
        StringBuilder result = new StringBuilder("new " + this.className);
        try {
            clazz = OgnlRuntime.classForName(context, this.className);
            ctorValue = this.getValueBody(context, target);
            context.setCurrentObject(ctorValue);
            if (ctorValue != null) {
                context.setCurrentType(ctorValue.getClass());
                context.setCurrentAccessor(ctorValue.getClass());
            }
            if (this.isArray) {
                context.put("_ctorClass", (Object)clazz);
            }
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
        try {
            if (this.isArray) {
                if (this.children[0] instanceof ASTConst) {
                    result.append("[").append(this.children[0].toGetSourceString(context, target)).append("]");
                } else if (this.children[0] instanceof ASTProperty) {
                    result.append("[").append(ExpressionCompiler.getRootExpression(this.children[0], target, context)).append(this.children[0].toGetSourceString(context, target)).append("]");
                } else if (this.children[0] instanceof ASTChain) {
                    result.append("[").append(this.children[0].toGetSourceString(context, target)).append("]");
                } else {
                    result.append("[] ").append(this.children[0].toGetSourceString(context, target));
                }
            } else {
                result.append("(");
                if (this.children != null && this.children.length > 0) {
                    void var12_22;
                    Object[] values2 = new Object[this.children.length];
                    String[] expressions = new String[this.children.length];
                    Class[] types = new Class[this.children.length];
                    for (int i = 0; i < this.children.length; ++i) {
                        void var12_18;
                        Object objValue = this.children[i].getValue(context, context.getRoot());
                        String value = this.children[i].toGetSourceString(context, target);
                        if (!(this.children[i] instanceof ASTRootVarRef)) {
                            value = ExpressionCompiler.getRootExpression(this.children[i], target, context) + value;
                        }
                        String string = "";
                        if (ExpressionCompiler.shouldCast(this.children[i])) {
                            String string2 = (String)context.remove("_preCast");
                        }
                        if (var12_18 == null) {
                            String string3 = "";
                        }
                        if (!(this.children[i] instanceof ASTConst)) {
                            void var12_15;
                            value = (String)var12_15 + value;
                        }
                        values2[i] = objValue;
                        expressions[i] = value;
                        types[i] = context.getCurrentType();
                    }
                    Constructor<?>[] cons = clazz.getConstructors();
                    Constructor<?> ctor = null;
                    Class<?>[] ctorParamTypes = null;
                    for (Constructor<?> con : cons) {
                        Class<?>[] ctorTypes = con.getParameterTypes();
                        if (!OgnlRuntime.areArgsCompatible(values2, ctorTypes) || ctor != null && !OgnlRuntime.isMoreSpecific(ctorTypes, ctorParamTypes)) continue;
                        ctor = con;
                        ctorParamTypes = ctorTypes;
                    }
                    if (ctor == null) {
                        ctor = OgnlRuntime.getConvertedConstructorAndArgs(context, clazz, OgnlRuntime.getConstructors(clazz), values2, new Object[values2.length]);
                    }
                    if (ctor == null) {
                        throw new NoSuchMethodException("Unable to find constructor appropriate for arguments in class: " + clazz);
                    }
                    ctorParamTypes = ctor.getParameterTypes();
                    boolean bl = false;
                    while (var12_22 < this.children.length) {
                        String literal;
                        if (var12_22 > 0) {
                            result.append(", ");
                        }
                        String value = expressions[var12_22];
                        if (types[var12_22].isPrimitive() && (literal = OgnlRuntime.getNumericLiteral(types[var12_22])) != null) {
                            value = value + literal;
                        }
                        if (ctorParamTypes[var12_22] != types[var12_22]) {
                            if (!(values2[var12_22] == null || types[var12_22].isPrimitive() || values2[var12_22].getClass().isArray() || this.children[var12_22] instanceof ASTConst)) {
                                value = "(" + OgnlRuntime.getCompiler().getInterfaceClass(values2[var12_22].getClass()).getName() + ")" + value;
                            } else if (!(this.children[var12_22] instanceof ASTConst) || this.children[var12_22] instanceof ASTConst && !types[var12_22].isPrimitive()) {
                                value = !types[var12_22].isArray() && types[var12_22].isPrimitive() && !ctorParamTypes[var12_22].isPrimitive() ? "new " + ExpressionCompiler.getCastString(OgnlRuntime.getPrimitiveWrapperClass(types[var12_22])) + "(" + value + ")" : " ($w) " + value;
                            }
                        }
                        result.append(value);
                        ++var12_22;
                    }
                }
                result.append(")");
            }
            context.setCurrentType(ctorValue != null ? ctorValue.getClass() : clazz);
            context.setCurrentAccessor(clazz);
            context.setCurrentObject(ctorValue);
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
        context.remove("_ctorClass");
        return result.toString();
    }

    @Override
    public String toSetSourceString(OgnlContext context, Object target) {
        return "";
    }
}

